#ifndef CONV_H
#define CONV_H

#define CNV_LOCALTOREMOTE        0
#define CNV_REMOTETOLOCAL        1

typedef struct _LRCONV *PLRCONV;

// Creates a bidirectional (Local<->Remote) conversion object.
// pszRemote - charset name (like "WINDOWS-1251").
PLRCONV cnvLRCreate(char *pcRemote);
void cnvLRDestroy(PLRCONV pLRConv);
size_t cnvLRConv(PLRCONV pLRConv, unsigned uDirection,
                   int cbStr, char *pcStr, size_t cbBuf, char *pcBuf);
char *cnvLRConvNew(PLRCONV pLRConv, unsigned uDirection,
                   int cbStr, char *pcStr, size_t *pcbLength);

char *cnvConvNew(char *pcTo, char *pcFrom, int cbStr, char *pcStr,
                 size_t *pcbLength);

#endif  // CONV_H
