
/*
 * classlst.h:
 *      header file for classlst.c, which contains the logic
 *      for displaying the WPS class tree in a container.
 *
 *      Most of this file was called "objdlgs.h" in V0.80.
 *
 *      In order to use this, you need to do the following:
 *
 *      1) #include classlst.h, but make sure you
 *         have #include'd os2.h before
 *
 *      2) set up the SELECTCLASSDATA structure below
 *         and pass this to WinDlgBox. Example:
 *
 *             SELECTCLASSDATA scd;
 *             strcpy(scd.szDlgTitle, "Select Class");
 *             strcpy(scd.szIntroText, "Select the class for which you want to change "
 *                                   "the status bar info.");
 *             strcpy(scd.szRootClass, "WPObject");
 *             strcpy(scd.szClassSelected, "WPObject");
 *             scd.ulHelpPanel = 0;
 *
 *             WinDlgBox(HWND_DESKTOP, hwndDlg,
 *                     fnwpSelectStatusBarClass,
 *                     NLS_MODULE, ID_XSD_SELECTCLASS,  // resources
 *                     &scd);
 *
 *      This also contains the logic for the "Internals"
 *      page in each object's settings notebook.
 *
 *      And don't forget to link the dlg resource for this
 *      against your executable.
 */

/*
 *      Copyright (C) 1997-99 Ulrich Mller.
 *      This file is part of the XFolder source package.
 *      XFolder is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published
 *      by the Free Software Foundation, in version 2 as it comes in the
 *      "COPYING" file of the XFolder main distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#ifndef CLASSLST_HEADER_INCLUDED
    #define CLASSLST_HEADER_INCLUDED

    /********************************************************************
     *                                                                  *
     *   "Select class" dialog                                          *
     *                                                                  *
     ********************************************************************/

    #define WM_FILLCNR   (WM_USER+100)

    /* WPS class data linked list struct; one of structs is created
       for each installed WPS class on the system */
    typedef struct _WPSLISTITEM {

        struct _WPSLISTITEM *pNext, *pPrevious;

        SOMClass            *pClassObject;
                            // pointer to class object (e.g. _WPFolder)
        SOMClass            *pParentClassObject;
                            // pointer to parent class object (e.g. _WPFileSystem)
        PSZ                 pszClassName;
                            // class name as returned by WinEnumObjectClasses
        PSZ                 pszModName;
                            // DLL name as returned by WinEnumObjectClasses
        PSZ                 pszReplacedWithClasses;
                            // contains a string list of classes which replace this
                            // this class, if applicable, or NULL
        PSZ                 pszReplacesThisClass;
                            // points to the classname which this class replaces,
                            // if applicable, or NULL
        CHAR                szParentClass[256];
                            // contains parent class
        PRECORDCORE         pRecord;
                            // corresponding record core
        BOOL                fProcessed;
                            // anti-recursion flag
        // Note: All PSZ's point into the POBJCLASS linked list in the
        // WPSCLASSESINFO structure returned by clsWpsClasses2Cnr.
    } WPSLISTITEM, *PWPSLISTITEM;

    /* extended RECORDCORE structure */
    typedef struct _CLASSRECORDCORE {
        RECORDCORE     recc;
        PWPSLISTITEM    pwps;
    } CLASSRECORDCORE, *PCLASSRECORDCORE;

    /* WPSCLASSESINFO structure */
    typedef struct _WPSCLASSESINFO {
        PWPSLISTITEM    pwpsClassList;
        POBJCLASS       pObjClass;
    } WPSCLASSESINFO, *PWPSCLASSESINFO;

    /* SELECTCLASSDATA:
       struct for passing dato the "Select class" dlg */
    typedef struct _SELECTCLASSDATA {
        PSZ     pszDlgTitle;            // dialog title
        PSZ     pszIntroText;           // intro text above container
        PSZ     pszRootClass;           // class to begin with
        PSZ     pszOrphans;             // title of "Orphans" tree; if NULL,
                                        // orphaned classes will not be shown
        CHAR    szClassSelected[256];   // in: select this class
                                        // out: class selected by user
        PFNWP   pfnwpReturnAttrForClass;
                // this callback func gets called just before a
                // record core gets inserted into the cnr.
                // Params passed to this callback func are:
                //      HWND hwnd    container wnd handle
                //      ULONG PSELECTCLASSDATA pscd
                //                   pointer to this dlg structure
                //      PWPSLISTITEM mp1  structure with class info
                //      PCLASSRECORDCORE mp2  _parent_ record core in which the
                //                        new recc will be inserted
                // This func must return the CRA_* flags for the new
                // record core which will then be inserted.

        PFNWP   pfnwpClassSelected;
                // this callback func gets called when a a class is selected in the dlg.
                // Params passed to this callback func are:
                //      HWND hwnd    container wnd handle
                //      ULONG msg    user-defined ulUserClassSelected below
                //      PWPSLISTITEM mp1  structure with class info
                //      MPARAM mp2   hwnd of info static text control below cnr
                // If this func returns TRUE, the "OK" button will be enabled.
        ULONG   ulUserClassSelected;

        PSZ     pszHelpLibrary;         // help library
        ULONG   ulHelpPanel;            // help panel; if 0, the "Help"
                                        // button is disabled

        // all the following are for internal use,
        // you don't have to set these
        HWND    hwndCnr;
        PWPSCLASSESINFO pwpsc;
        PCLASSRECORDCORE preccSelection,    // current "selection" emphasis
                         preccSource;       // current "source" emphasis
        BOOL    fSelectionValid;
        LONG    lBackground;
        LONG    lText;
        LONG    lStaticText;
        LONG    lSelBackground;
        LONG    lSelText;
        LONG    lRecurse;
        PRECORDCORE preccExpanded;
    } SELECTCLASSDATA, *PSELECTCLASSDATA;

    PWPSCLASSESINFO clsWpsClasses2Cnr(HWND hwndCnr,
                        PSZ pszRootClass,               // in: e.g. "WPObject"
                        PSELECTCLASSDATA pscd);         // in: insertion info struct

    VOID clsCleanupWpsClasses(PWPSCLASSESINFO pwpsd);

    ULONG clsSelectWpsClassDlg(HWND hwndOwner,
                HMODULE hmod, ULONG idDlg,
                PSELECTCLASSDATA pscd);

    /********************************************************************
     *                                                                  *
     *   "Register new class" dlg                                       *
     *                                                                  *
     ********************************************************************/

    typedef struct _REGISTERCLASSDATA {
        CHAR    szModName[CCHMAXPATH];
        CHAR    szClassName[256];
        PSZ     pszHelpLibrary;         // help library
        ULONG   ulHelpPanel;            // help panel; if 0, the "Help"
                                        // button is disabled
    } REGISTERCLASSDATA, *PREGISTERCLASSDATA;

    MRESULT EXPENTRY fnwpRegisterClass(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);

    /********************************************************************
     *                                                                  *
     *   "Object usage" dialog                                          *
     *                                                                  *
     ********************************************************************/

    /* extended RECORDCORE structure */
    typedef struct _OBJECTUSAGERECORDCORE {
        RECORDCORE     recc;
        CHAR           szText[500];
    } OBJECTUSAGERECORDCORE, *POBJECTUSAGERECORDCORE;

    typedef struct _OBJECTUSAGEDATA {
        WPObject *pObject;              // object to query
        CHAR    szDlgTitle[256];        // dialog title
        CHAR    szIntroText[256];       // intro text above container
        CHAR    szHelpLibrary[CCHMAXPATH]; // help library
        ULONG   ulHelpPanel;            // help panel; if 0, the "Help"
                                        // button is disabled
        HWND    hwndCnr;                // internal use, don't bother
    } OBJECTUSAGEDATA, *POBJECTUSAGEDATA;

#endif

