
/*
 * animate.h:
 *      header file for animate.c.
 *
 *      Copyright (C) 1997-99 Ulrich Mller.
 *      This file is part of the XFolder source package.
 *      XFolder is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published
 *      by the Free Software Foundation, in version 2 as it comes in the
 *      "COPYING" file of the XFolder main distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#if __cplusplus
extern "C" {
#endif

#ifndef ANIMATE_HEADER_INCLUDED
    #define ANIMATE_HEADER_INCLUDED

    typedef struct _ANIMATIONDATA {
        // ULONG       cb;                 // size of structure
        // HWND        hwndIcon;           // the static control hwnd
        ULONG       ulDelay;            // delay per animation step in ms

        RECTL       rclIcon;            // ** internal use only
        // LONG        lBkgndColor;        // ** internal use only
        HPOINTER    hptr;               // ** internal use only
        HBITMAP     hbm;                // ** internal use only
        ULONG       ulSysIconSize;      // ** internal use only
        USHORT      usAniCurrent;       // ** internal use only
        PFNWP       OldStaticProc;      // ** internal use only

        USHORT      usAniCount;         // no. of animation steps
        HPOINTER    ahptrAniIcons[1];   // array of animation steps;
                                        // there must be usAniCount items
    } ANIMATIONDATA, *PANIMATIONDATA;

    PANIMATIONDATA anmPrepareStaticIcon(HWND hwndStatic, USHORT usAnimCount);

    BOOL anmPrepareAnimation(HWND hwndStatic,   // icon hwnd
                    USHORT usAnimCount,         // no. of anim steps
                    HPOINTER *pahptr,           // array of HPOINTERs
                    ULONG ulDelay,              // delay per anim step (in ms)
                    BOOL fStartAnimation);      // TRUE: start animation now

    BOOL anmStartAnimation(HWND hwndStatic);

    BOOL anmStopAnimation(HWND hwndStatic);

    BOOL anmBlowUpBitmap(HPS hps,
                         HBITMAP hbm,
                         ULONG ulAnimationTime);

    VOID anmPowerOff(HPS hps, ULONG ulSteps);

#endif

#if __cplusplus
}
#endif

