/*
 * Install Trashcan class, object
 * (c) Henicke, Andreas 1995 Rostock
 */

dllname     ='trashcan.dll'
template    ='\os2\dll'
osver       =230
objectid    ='<TRASHCAN>'
objectname  ='Trashcan'
classid     ='WPTrashCan'

parse arg arglist .
call rxfuncadd 'sysloadfuncs','rexxutil','sysloadfuncs'
call sysloadfuncs

parse value sysos2ver() with major'.'minor

veros2=major*100+left(minor,2,0)

/* test os/2 version (os/2 warp3: 2.30) */
if veros2<osver then do
   say 'need OS version ' osver ' and above'
   exit
end

/* Prfe vorhandene Dateien */
call sysfiletree '.\'||dllname,   ll0, 'FO'
if ll0.0=0 then do
   say 'error: miss ' dllname
   exit
end

/* get [d:]\os2\dll directory */
path=''
ds=sysdrivemap(c, local)
do di=1 to ((length(ds)+1)/3)-1
   dd=word(ds, di);
   call sysfiletree dd || template, dl, 'DO'
   if dl.0<>0 then do
      path=translate(dl.1)
      leave
   end
end
if path=='' then do
   say 'error: miss ' template
   exit
end
dllpath=translate(path || '\' || dllname)
call sysfiletree dllpath, tl, 'FO'
if tl.0<>0 then do
   say 'error: found' dllpath
   exit
end

/* copy trashcan.dll in [d:]\os2\dll */
address cmd '@copy' dllname dllpath '> NUL'

/* register class and create object <TRASHCAN> */
call sysregisterobjectclass classid, dllpath
call syscreateobject classid, objectname, '<WP_DESKTOP>', 'OBJECTID='||objectid

exit

