/**********************************************************************
 *
 * Ticker/2 installation program.
 *
 * Version 1.0
 *
 * Copyright (C) 1996 by Kirchhoff & Grill Software GmbH
 * All Rights Reserved.
 *
 **********************************************************************/


"@ECHO OFF"

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

call SysCls

destinationPath = SysSearchPath('.','.')

if destinationPath = "" then
  do
    say ""
    say "Cannot determine current directory!"
  end
else
  do
    say "Installing Ticker/2 in "destinationPath"."
    rc = SysFileTree( destinationPath, "dirs", "D")
    if (dirs.0 = 0) then
      do
        rc = SysMkDir(destinationpath)
        if (rc \= 0) then
          do
            say "Couldn't create directory "destinationPath"!"
          exit
        end
      end

  /* create a new folder */
  call SysCreateObject "WPFolder", "Ticker/2", "<WP_DESKTOP>", ,
     "OBJECTID=<HWB_TICKER2FOLDER>", "fail"

  /* create the program object */
  rc =SysCreateObject("WPProgram", "Ticker/2", "<HWB_TICKER2FOLDER>", ,
     "PROGTYPE=PM;EXENAME="destinationPath"\ticker.exe;PARAMETERS=scripts/medium.cmd scripts/commerce.cmd %*;"||,
     "OBJECTID=<HWB_TICKER2>", "update")

  /* create the INF object */
  rc =SysCreateObject("WPProgram", "Ticker/2 REXX Extentions Programmers Reference", "<HWB_TICKER2FOLDER>", ,
     "PROGTYPE=PM;EXENAME=view.exe;PARAMETERS="destinationPath"\tickerp.inf;"||,
     "OBJECTID=<HWB_TICKER2PREF>", "update")

  /* create Homepage Object */
  rc = SysCreateObject("WebExplorer_Url", "KGS Homepage", "<HWB_TICKER2FOLDER>", 
    "OBJECTID=<HWB_TICKER2HP>;LOCATOR=http://ourworld.compuserve.com/homepages/hmkirchhKGS", U)

  /* create a shadow of the scripts directory */
  call SysCreateObject "WPShadow", "Ticker/2 Scripts", "<HWB_TICKER2FOLDER>", ,
     "OBJECTID=<HWB_TICKER2SCRIPTS>;SHADOWID="destinationPath"\scripts", "update"

  /* create the Registration object */
  rc =SysCreateObject("WPProgram", "Ticker/2 Registration", "<HWB_TICKER2FOLDER>", ,
     "PROGTYPE=PM;EXENAME=e.exe;PARAMETERS="destinationPath"\register.txt;"||,
     "OBJECTID=<HWB_TICKER2REG>", "update")

  /* create the Read.me object */
  rc =SysCreateObject("WPProgram", "Ticker/2 Read Me", "<HWB_TICKER2FOLDER>", ,
     "PROGTYPE=PM;EXENAME=e.exe;PARAMETERS="destinationPath"\readme.txt;"||,
     "OBJECTID=<HWB_TICKER2RME>", "update")

end

exit
