
/*
 * This file was generated by the SOM Compiler.
 * FileName: wpst.c.
 * Generated using:
 *     SOM Precompiler spc: 1.22
 *     SOM Emitter emitc: 1.24
 */

/*
 *
 *                             S Y S T R A Y / 2
 * (C) 2001-2, OS2.Ru DevTeam              http://devcenter.os2.ru/systray
 * Written by Dmitry Zaharov                                 madint@os2.ru
 */


#define WPSystray_Class_Source
#include "wpst.ih"
#include "lang\str_ids.h"

#undef SOM_CurrentClass
#define SOM_CurrentClass SOMMeta

extern HMODULE hmSystray;
extern CHAR szCommonPath[];

HMODULE   QueryModuleHandle(PSZ pszClassName) /* we are in Watcom now... */
{

APIRET rc;

   /*
    *   Make sure we already have module handle
    */

    if (hmSystray == NULLHANDLE)
    {
     zString zsPathName;
     somId id;
       /*
        *   Retrieve registered pathname of our module (DLL) and query the
        *   module handle.
        */
       id = SOM_IdFromString(pszClassName);
       zsPathName =
       _somLocateClassFile( SOMClassMgrObject, id ,
                            WPSystray_MajorVersion, WPSystray_MinorVersion);
       /* Free the som id because we don't need it anymore. */
       SOMFree( (VOID*)id);

       rc =
       DosQueryModuleHandle( zsPathName, &hmSystray);
       if (rc)
       {
          DosBeep(500, 200);
          DosBeep(1000, 150); // critcal error, so we don't initialize at all
          hmSystray = NULLHANDLE;
       }

    }   /* end if (hmod == NULLHANDLE) */

    return (hmSystray);
}


SOM_Scope ULONG   SOMLINK SystrayCls_wpclsQueryIconData(M_WPSystray *somSelf,
		PICONINFO pIconInfo)
{

    QueryModuleHandle("WPSystray");

    if(!hmSystray) return 0L;

    if(pIconInfo)
    {
        pIconInfo->fFormat = ICON_RESOURCE;
        pIconInfo->resid   = IDR_STICON;
        pIconInfo->hmod    = hmSystray;
    }

    return (sizeof(ICONINFO));
}

SOM_Scope ULONG   SOMLINK SystrayCls_wpclsQueryStyle(M_WPSystray *somSelf)
{
    /* M_WPSystrayData *somThis = M_WPSystrayGetData(somSelf);
    M_WPSystrayMethodDebug("M_WPSystray","SystrayCls_wpclsQueryStyle");*/

    return (CLSSTYLE_NEVERPRINT);
}

SOM_Scope PSZ   SOMLINK SystrayCls_wpclsQueryTitle(M_WPSystray *somSelf)
{
    /* M_WPSystrayData *somThis = M_WPSystrayGetData(somSelf);
    M_WPSystrayMethodDebug("M_WPSystray","SystrayCls_wpclsQueryTitle"); */

    return ("Systray");
}

SOM_Scope void   SOMLINK SystrayCls_wpclsInitData(M_WPSystray *somSelf)
{
    /* M_WPSystrayData *somThis = M_WPSystrayGetData(somSelf);
    M_WPSystrayMethodDebug("M_WPSystray","SystrayCls_wpclsInitData"); */

    QueryModuleHandle("WPSystray");

    if(hmSystray) GenSystrayClassInit((PVOID)somSelf);

    parent_wpclsInitData(somSelf);
}

SOM_Scope void   SOMLINK SystrayCls_wpclsUnInitData(M_WPSystray *somSelf)
{
    /* M_WPSystrayData *somThis = M_WPSystrayGetData(somSelf);
    M_WPSystrayMethodDebug("M_WPSystray","SystrayCls_wpclsUnInitData"); */

    if(hmSystray) GenSystrayClassUnInit((PVOID)somSelf);

    parent_wpclsUnInitData(somSelf);
}

#undef SOM_CurrentClass
#define SOM_CurrentClass SOMInstance
SOM_Scope HWND   SOMLINK Systray_wpOpen(WPSystray *somSelf,
		HWND hwndCnr,
		ULONG ulView,
		ULONG param)
{
    /* WPSystrayData *somThis = WPSystrayGetData(somSelf);
    WPSystrayMethodDebug("WPSystray","Systray_wpOpen"); */

    if(hmSystray)
      {
      if(ulView == STDEF_VIEWSYSTRAY)
        return GenCreateAnotherSystrayView((PVOID)somSelf);
      else
        return (parent_wpOpen(somSelf, hwndCnr,
                              ulView, param));

      }

    return (parent_wpOpen(somSelf,hwndCnr,ulView,param));
}

SOM_Scope BOOL   SOMLINK Systray_wpSwitchTo(WPSystray *somSelf,
		ULONG View)
{
    /* WPSystrayData *somThis = WPSystrayGetData(somSelf);
    WPSystrayMethodDebug("WPSystray","Systray_wpSwitchTo"); */

    if(hmSystray && (View == STDEF_VIEWSYSTRAY))
      return GenSwitchToSystrayView((PVOID)somSelf);

    return (parent_wpSwitchTo(somSelf,View));
}

SOM_Scope BOOL   SOMLINK Systray_wpRestoreState(WPSystray *somSelf,
		ULONG ulReserved)
{
    /* WPSystrayData *somThis = WPSystrayGetData(somSelf);
    WPSystrayMethodDebug("WPSystray","Systray_wpRestoreState"); */

    /*
     In Systray/2, state restored during creating new view, so here
     we just call parent method
     */

    return (parent_wpRestoreState(somSelf,ulReserved));
}

SOM_Scope BOOL   SOMLINK Systray_wpSaveState(WPSystray *somSelf)
{
BOOL rc;
    /* WPSystrayData *somThis = WPSystrayGetData(somSelf);
    WPSystrayMethodDebug("WPSystray","Systray_wpSaveState"); */

    rc = parent_wpSaveState(somSelf);

    if(hmSystray) return GenSaveView((PVOID)somSelf);

    return rc;

}

SOM_Scope void   SOMLINK Systray_wpInitData(WPSystray *somSelf)
{
    /* WPSystrayData *somThis = WPSystrayGetData(somSelf);
    WPSystrayMethodDebug("WPSystray","Systray_wpInitData"); */

    parent_wpInitData(somSelf);
}

SOM_Scope void   SOMLINK Systray_wpUnInitData(WPSystray *somSelf)
{
    /* WPSystrayData *somThis = WPSystrayGetData(somSelf);
    WPSystrayMethodDebug("WPSystray","Systray_wpUnInitData"); */

    parent_wpUnInitData(somSelf);
}

SOM_Scope BOOL   SOMLINK Systray_wpModifyPopupMenu(WPSystray *somSelf,
		HWND hwndMenu,
		HWND hwndCnr,
		ULONG iPosition)
{
    BOOL rc;
    MENUITEM mi;
    /* WPSystrayData *somThis = WPSystrayGetData(somSelf);
    WPSystrayMethodDebug("WPSystray","Systray_wpModifyPopupMenu"); */

    rc = (parent_wpModifyPopupMenu(somSelf,hwndMenu,hwndCnr,iPosition));

    if(rc)
      {
        if(WinSendMsg(hwndMenu, MM_QUERYITEM,
                       MPFROM2SHORT(WPMENUID_OPEN, TRUE), (MPARAM)&mi))
          {
          MENUITEM mi2Insert =
            {
            0,        		// Insert position
            MIS_TEXT, 		// Style
            MIA_CHECKED,	// Attribute
            STDEF_VIEWSYSTRAY,	// Id
            NULLHANDLE,		// submenu HWND
            STDEF_VIEWSYSTRAY	// Handle?
            };

          rc = (BOOL)WinSendMsg(mi.hwndSubMenu, MM_INSERTITEM,
                                MPFROMP(&mi2Insert),
                                MPFROMP(GenLoadNls(NULL, IDS_SYSTRAY, "Systray")));
          }

      }

    return rc;
}

SOM_Scope ULONG   SOMLINK Systray_wpFilterPopupMenu(WPSystray *somSelf,
		ULONG ulFlags,
		HWND hwndCnr,
		BOOL fMultiSelect)
{
    /* WPSystrayData *somThis = WPSystrayGetData(somSelf);
    WPSystrayMethodDebug("WPSystray","Systray_wpFilterPopupMenu"); */

    return (parent_wpFilterPopupMenu(somSelf,ulFlags,hwndCnr,fMultiSelect));
}

extern char szHelpPath[];

SOM_Scope BOOL   SOMLINK Systray_wpQueryDefaultHelp(WPSystray *somSelf,
		PULONG pHelpPanelId,
		PSZ HelpLibrary)
{
    /* WPSystrayData *somThis = WPSystrayGetData(somSelf);
    WPSystrayMethodDebug("WPSystray","Systray_wpQueryDefaultHelp"); */
    *pHelpPanelId = 100;
    //sprintf(HelpLibrary, "%ssystray.hlp", szCommonPath);
    strcpy(HelpLibrary, szHelpPath);

    return (TRUE);
}

SOM_Scope ULONG   SOMLINK Systray_wpQueryDefaultView(WPSystray *somSelf)
{
    /* WPSystrayData *somThis = WPSystrayGetData(somSelf);
    WPSystrayMethodDebug("WPSystray","Systray_wpQueryDefaultView"); */

    return (STDEF_VIEWSYSTRAY);
}

SOM_Scope ULONG   SOMLINK Systray_wpAddObjectWindowPage(WPSystray *somSelf,
		HWND hwndNotebook)
{
    /* WPSystrayData *somThis = WPSystrayGetData(somSelf);
    WPSystrayMethodDebug("WPSystray","Systray_wpAddObjectWindowPage"); */

    return (SETTINGS_PAGE_REMOVED);
}

SOM_Scope BOOL   SOMLINK Systray_wpAddSettingsPages(WPSystray *somSelf,
		HWND hwndNotebook)
{
    /* WPSystrayData *somThis = WPSystrayGetData(somSelf);
    WPSystrayMethodDebug("WPSystray","Systray_wpAddSettingsPages"); */

    parent_wpAddSettingsPages(somSelf,hwndNotebook);

    return NtbAddSettingsPage((PVOID)somSelf,hwndNotebook);
}
