/****************************************************************************
 *                             S Y S T R A Y / 2                            *
 *                                                                          *
 * (C) 2001-2, OS2.Ru DevTeam              http://devcenter.os2.ru/systray  *
 * Written by Dmitry Zaharov                                 madint@os2.ru  *
 ****************************************************************************/

// NOTE this file best edit in editor with 100 columns

#include "systray.h"
#include "lang\str_ids.h"

/*
 Global Data
 */

HMODULE hmSystray = NULLHANDLE, hmSystrayRes = NULLHANDLE; // International! ;=)
ULONG   ulPlugins;
PPLUGIN pPlugin;
PWCLASS pWClasses;
ULONG   ulClasses;

CHAR    szRegisterPlugin[] = "REGISTERPLUGIN";
CHAR    szDeregisterPlugin[] = "DEREGISTERPLUGIN";
CHAR    szSystrayViewClass[] = "Systray";
CHAR    szSystrayHintClass[] = "SystrayHint";
//CHAR    szSystrayLogoClass[] = "SystrayLogo";
CHAR    szObjectWindowClass[] = "SystrayObjectWindow";

CHAR    szCommonPath[CBMAXSTRING]; // common DLL path ;)
CHAR    szHelpPath[CBMAXSTRING];

BOOL    fClassesLoaded, fThreadReady = FALSE;
INT     iViews;

PVIEWDATA SystrayView[MAXVIEWS];

HWND    hwnd_Object = NULLHANDLE;
RECTL	rclWorkArea = {0, 0, 0, 0}; // UpdateWorkarea cache...

extern HWND hwndHint;

/* Undocumented API from Warp4, used by WarpCenter */

HMODULE hmPMMerge = NULLHANDLE;

P_WINSETDESKTOPWORKAREA _SetDesktopWorkarea = NULL;
P_WINQUERYDESKTOPWORKAREA _QueryDesktopWorkarea = NULL;

HPOINTER hptrGrpUp, hptrGrpDown, hptrTrack, hptrHand, hptrTrays;

/*
 NAME: void     LoadPlugins(PSZ pszSearchPath)
 DESCRIPTION:
 All plugins loading:
 Searching for *.DLL in PLUGINS\ folder (typically subfolder of SYSTRAY.DLL's folder)
 */

void    GenLoadPlugins(PSZ pszSearchPath)
{
HDIR 			fh;
static FILEFINDBUF3	fi;
ULONG			fc, i, nClass, n;
APIRET			rc;         /* Return code */
PWCLASS			pwc;
PSZ			pszPluginEnv = (PSZ)getenv("SYSTRAY_PLUGINS");
static char		szSearchMask[CBMAXSTRING];

if(pszPluginEnv)
  {
  strcpy(szSearchMask, pszPluginEnv);
  if(szSearchMask[strlen(szSearchMask)-1] != '\\') strcat(szSearchMask, "\\");
  strcat(szSearchMask, "*.dll");
  }
else sprintf(szSearchMask, "%sPLUGINS\\*.dll", pszSearchPath);

DbgPrintf("Loading plugins from %s\n", szSearchMask);

fh = 0x0001;
fc = 1;
rc = DosFindFirst(szSearchMask, /* File pattern */
                  &fh,           /* Directory search handle */
                  0x17,          /* Search attribute */
                  (PVOID) &fi,   /* Result buffer */
                  sizeof(fi),    /* Result buffer length */
                  &fc,           /* # of entries to find */
                  FIL_STANDARD); /* Return level 1 file info */

i = 0;

while(!rc)
  {
  fc = 1;
  i ++;
  //fi.achName
  rc = DosFindNext(fh,
                   (PVOID) &fi,   /* Result buffer */
                   sizeof(fi),    /* Result buffer length */
                   &fc);          /* # of entries to find */
  }

DosFindClose(fh);

DbgPrintf("%d found\n", i);

ulPlugins = i;

if(ulPlugins)
  pPlugin = (PPLUGIN)malloc(sizeof(PLUGIN)*ulPlugins);
else
  pPlugin = (PPLUGIN)malloc(sizeof(PLUGIN));

fh = 0x0001;
fc = 1;
rc = DosFindFirst(szSearchMask, /* File pattern */
                  &fh,           /* Directory search handle */
                  0x17,          /* Search attribute */
                  (PVOID) &fi,   /* Result buffer */
                  sizeof(fi),    /* Result buffer length */
                  &fc,           /* # of entries to find */
                  FIL_STANDARD); /* Return level 1 file info */

i = 0;

while(!rc)
  {
  fc = 1;
  if(pszPluginEnv)
    {
    strcpy(szSearchMask, pszPluginEnv);
    if(szSearchMask[strlen(szSearchMask)-1] != '\\') strcat(szSearchMask, "\\");
    strcat(szSearchMask, fi.achName);
    }
  else sprintf(pPlugin[i].szModule, "%sPLUGINS\\%s", pszSearchPath, fi.achName);

  DbgPrintf("%s found\n", pPlugin[i].szModule);
  i ++;
  rc = DosFindNext(fh,
                   (PVOID) &fi,   /* Result buffer */
                   sizeof(fi),    /* Result buffer length */
                   &fc);          /* # of entries to find */
  }

DosFindClose(fh);

// Okay, modules found. Now great moment to load it...

fc = 0L;

for(i=0; i<ulPlugins; i++)
  {
  // cleanup...
  pPlugin[i].RegisterPlugin = NULL;
  pPlugin[i].DeregisterPlugin = NULL;
  pPlugin[i].hmod = NULL;

  rc = DosLoadModule(szSearchMask, CBMAXSTRING, pPlugin[i].szModule, &pPlugin[i].hmod);
  if(!rc)
    {
    DbgPrintf("%s successfully loaded (hmod=%d)\n", pPlugin[i].szModule, pPlugin[i].hmod);

    DosQueryProcAddr(pPlugin[i].hmod, 0L, szRegisterPlugin,
                     (PFN*)&pPlugin[i].RegisterPlugin);

    DbgPrintf("RegisterPlugin entry is %04X, ", (int)pPlugin[i].RegisterPlugin);

    DosQueryProcAddr(pPlugin[i].hmod, 0L, szDeregisterPlugin,
                     (PFN*)&pPlugin[i].DeregisterPlugin);

    DbgPrintf("DeregisterPlugin entry is %04X\n", (int)pPlugin[i].DeregisterPlugin);

    }
  }
}

// {{{ 0.3.5 temp fix for daemon startuing problems

#define		SDSHAREDMEM	"\\SHAREMEM\\SYSTRAYD.DAT"

void	GenStartDaemon(PSZ pszCommonPath)
{
PVOID	pSystrayData;

if(DosGetNamedSharedMem((PPVOID)&pSystrayData, SDSHAREDMEM, PAG_READ | PAG_WRITE))
  {
  PROGDETAILS pDetails;
  CHAR        szBuffer[CBMAXSTRING], *t;
  PSZ	      pszSystrayDEnv = (PSZ)getenv("SYSTRAY_DAEMON");
  INT i;

  if(!pszSystrayDEnv)
    {
    strcpy(szBuffer, pszCommonPath);
    strcat(szBuffer, "systrayd.exe");
    }
  else strcpy(szBuffer, pszSystrayDEnv);

  DbgPrintf("Starting systray daemon %s\n", szBuffer);

  pDetails.Length          = sizeof(PROGDETAILS);
  pDetails.progt.progc     = PROG_DEFAULT;
  pDetails.progt.fbVisible = SHE_VISIBLE;
  pDetails.pszTitle        = NULL;
  pDetails.pszExecutable   = szBuffer;
  pDetails.pszParameters   = NULL;
  pDetails.pszStartupDir   = "";
  pDetails.pszIcon         = NULL;
  pDetails.pszEnvironment  = NULL;
  pDetails.swpInitial.fl   = 0;
  pDetails.swpInitial.cy   = pDetails.swpInitial.cx = 0;
  pDetails.swpInitial.y    = pDetails.swpInitial.x  = 0;
  pDetails.swpInitial.hwndInsertBehind = NULLHANDLE;
  pDetails.swpInitial.hwnd             = HWND_DESKTOP;
  pDetails.swpInitial.ulReserved1      = 0;
  pDetails.swpInitial.ulReserved2      = 0;
  // start SYSTRAYD.EXE daemon

  if(!WinStartApp(NULLHANDLE, &pDetails, "", NULL, 0))
    DbgPrintf("FAILED\n");
  else
    DbgPrintf("successfull\n");
  }
}

// 0.3.5 }}}

void    GenUnloadClasses(HAB hab)
{
ULONG i;

DbgPrintf("Unloading classes\n");

for(i=0L; i<ulPlugins; i++) // ###
  {
  if(pPlugin[i].DeregisterPlugin && fClassesLoaded) // load plugin classes
    {
    pPlugin[i].DeregisterPlugin(pPlugin[i].hmod, hab);
    DbgPrintf("Deregistering classes in %s\n", pPlugin[i].szModule);
    }
  }
free(pWClasses);

fClassesLoaded = FALSE;
}


/*
 NAME: void UnloadPlugins(HAB)
 DESCRIPTION:
 Plugin DLL unloading and deregistration Unit classes
 */

void    GenUnloadPlugins()
{
ULONG i;

DbgPrintf("Unloading plugins\n");

for(i=0L; i<ulPlugins; i++) // ###
  {
  DbgPrintf("Unloading %s\n", pPlugin[i].szModule);
  DosFreeModule(pPlugin[i].hmod);
  }

free(pWClasses);
}

/*
 NAME: void LoadClasses(HAB)
 DESCRIPTION:
 Unit classes loading.
 */

void    GenLoadClasses(HAB hab)
{
ULONG         fc, i, nClass, n;
PWCLASS       pwc;

DbgPrintf("Registering classes\n");

if(fClassesLoaded) return; // strange error checking?

pWClasses = pwc = (PWCLASS)malloc(sizeof(WCLASS)*MAXCLASSES);
nClass = MAXCLASSES;
fc = 0;
for(i=0; i<ulPlugins; i++)
  {
  if(pPlugin[i].RegisterPlugin) // load plugin classes
    {
    DbgPrintf("Registering classes in %s\n", pPlugin[i].szModule);
    n = nClass;
    pPlugin[i].pwc = &pwc[fc];
    pwc[fc].ulReserved = ((hmSystray == hmSystrayRes) ? 0L : hmSystrayRes);
    pPlugin[i].RegisterPlugin(pPlugin[i].hmod,
                              hab,
                              pPlugin[i].pwc,
                              (PUSHORT)&n);
    pPlugin[i].usNumClasses = n;
    DbgPrintf("%d exported\n", (int)n);
    fc += n; nClass -= n;
    }
  }

ulClasses = fc;
fClassesLoaded = TRUE;
}

/*
 NAME: void     SystrayClassInit()
 DESCRIPTION:
 Systray Class Initialization: loading plugins, allocating local memory, etc.
 */

void    GenSystrayClassInit(PVOID somSelf)
{
static char	szModuleName[CBMAXSTRING], *t;
PSZ		pszSystrayPathEnv = (PSZ)getenv("SYSTRAY_PATH");
PSZ		pszSystrayNlsEnv = (PSZ)getenv("SYSTRAY_NLS");

DbgPrintf("-- " ST_VERSION " --\n");
DbgPrintf("%s by Dmitry Zaharov (OS2.Ru DevTeam)\n", ST_COMPILED);
DbgPrintf("Initializing systray class (somSelf=%d)\n", (int)somSelf);

/*
 Initialzine undocumented desktop stuff
 */

if(!DosLoadModule(szModuleName, CBMAXSTRING, "PMMERGE", &hmPMMerge))
  {

  // load new APIs for desktop resizing (found only on Warp4+)

  DosQueryProcAddr(hmPMMerge, 5468, NULL, (PFN*)&_SetDesktopWorkarea);
  DosQueryProcAddr(hmPMMerge, 5469, NULL, (PFN*)&_QueryDesktopWorkarea);
  DbgPrintf("Warp4+ desktop resizing API: _SetDesktopWorkarea=%04X, _QueryDesktopWorkarea=%04X\n",
            (int)_SetDesktopWorkarea, (int)_QueryDesktopWorkarea);
  }

/*
 At first, we get full-qualyfied path of Systray Class DLL
 */

DosQueryModuleName(hmSystray, CBMAXSTRING, szModuleName);

DbgPrintf("Systray dll is %s (hmSystray=%d)\n", szModuleName, hmSystray);

//hmSystrayRes = hmSystray; // use now, sorry ;-)

t = strrchr(szModuleName, '\\');
if(t)
  {
  t++; *t = '\0';
  }
  else
  {
  szModuleName[0] = '\0';

  DosBeep(1000, 400); // what the Hell?
  }

if(pszSystrayPathEnv)
  {
  strcpy(szCommonPath, pszSystrayPathEnv);
  if(szCommonPath[strlen(szCommonPath)-1] != '\\') strcat(szCommonPath, "\\");
  }
else strcpy(szCommonPath, szModuleName); // fill common path
t = getenv("LANG");

if(t || pszSystrayNlsEnv)
  {
  if(pszSystrayNlsEnv) strcpy(szModuleName, pszSystrayNlsEnv);
  else  sprintf(szModuleName, "%swpst_%c%c.dll", szCommonPath, t[0], t[1]);
  // 0.3.2 NLS support still in progress...

  if(DosLoadModule(szHelpPath, CBMAXSTRING, szModuleName, &hmSystrayRes))
    {
    hmSystrayRes = hmSystray;
    DbgPrintf("no NLS (%s), using build-in language resources (english)\n", szModuleName);
    }else DbgPrintf("NLS linked: %s (hmSystrayRes=%d), language \"%s\" supported.\n",
                    szModuleName, hmSystrayRes, GenLoadNls(NULL, IDS_NLS, "unknown"));
  }

sprintf(szHelpPath, "%s%s", szCommonPath, GenLoadNls(NULL, IDS_HELPFILE, "systray.hlp"));
DbgPrintf("Common help is %s\n", szHelpPath);

/*
 Stage 1: Starting system tray daemon
 */

GenStartDaemon(szCommonPath);

/*
 Stage 2: Loading Plugins
 */
GenLoadPlugins(szCommonPath);

fClassesLoaded = FALSE;
iViews = 0;
DbgPrintf("Loading systray class done\n");
}

/*
 NAME: void SystrayClassUnInit()
 DESCRIPTION:
 Deregistration of unit classes and uloading plugin DLLs...
 */

void    GenSystrayClassUnInit(PVOID somSelf)
{

DbgPrintf("Unloading systray class (somSelf=%d)\n", (int)somSelf);

if(hwnd_Object)
  {
  WinPostMsg(hwnd_Object, WM_QUIT, (MPARAM)0L, (MPARAM)0L);

  while(hwnd_Object)
    DosSleep(200);  // sorry...
  }

GenUnloadPlugins();

if(hmPMMerge) // unload undocumented stuff
  DosFreeModule(hmPMMerge);

if(hmSystrayRes != hmSystray) // unload NLS dll
  DosFreeModule(hmSystrayRes);

DbgPrintf("Unloading systray class done\n");
//free();
}

BOOL    GenUpdateDesktopArea()
{
INT i;
RECTL rcl;

if(!_SetDesktopWorkarea) return FALSE;

WinQueryWindowRect(HWND_DESKTOP, &rcl);

for(i=0; i<iViews; i++)
  if(SystrayView[i]->viewConfig.page1.fResizeDesktop &&
     SystrayView[i]->viewConfig.page1.bOntopMethod != ONTOP_POPHIDE)
    {
    RECTL rclView;
    WinQueryWindowRect(SystrayView[i]->hwnd, &rclView);
    DbgPrintf("Updating desktop workarea (hwnd=%d), view #%d\n",SystrayView[i]->hwnd, i);
    if(SystrayView[i]->viewConfig.page1.fBottom) rcl.yBottom += rclView.yTop +
                                           WinQuerySysValue(HWND_DESKTOP,
                                                            SV_CYSIZEBORDER);
    else                                   rcl.yTop -= rclView.yTop;
    }

if(memcmp(&rcl, &rclWorkArea, sizeof(rcl)) != 0) _SetDesktopWorkarea(HWND_DESKTOP, &rcl);

rclWorkArea = rcl; // cache workarea to avoid stupid desktop flashing

return TRUE;
}

PWCLASS GenSearchClass(PSZ pszName)
{
ULONG i;
BOOL  fFound = FALSE;

for(i=0; i<ulClasses; i++)
  if(!strcmp(pWClasses[i].pszName, pszName))
    {
    fFound = TRUE;
    return &pWClasses[i];
    }

return NULL;
}

BOOL    GenSwitchToSystrayView(PVOID somSelf)
{
INT i;
BOOL fSwitched = FALSE;

for(i=0; i<iViews; i++)
  if(SystrayView[i]->somSelf == somSelf)
    {
    fSwitched = TRUE;
    DbgPrintf("Switching to view (hwnd=%d) #%d, somSelf=%d\n",SystrayView[i]->hwnd, i, (int)somSelf);
    WinPostMsg(SystrayView[i]->hwnd, VTM_POPUP, (MPARAM)0L, (MPARAM)0L);
    }

return fSwitched;
}

VOID    GenImportViewConfig(HAB hab, PVOID somSelf, PVIEWCONFIG pvc, ULONG ulPages)
{
INT i;
BOOL fFound = FALSE;
CHAR szIniFile[CBMAXSTRING], szIniApp[CBMAXSTRING];
PSZ pszSystrayIniEnv = (PSZ)getenv("SYSTRAY_INI");

for(i=0; i<iViews; i++)
  if(SystrayView[i]->somSelf == somSelf)
    {
    fFound = TRUE;
    WinSendMsg(SystrayView[i]->hwnd, VTM_IMPORTVC, MPFROMP(pvc), (MPARAM)ulPages);
    }

if(!fFound)
  {
  if(pszSystrayIniEnv) strcpy(szIniFile, pszSystrayIniEnv);
  else sprintf(szIniFile, "%ssystray.ini", szCommonPath);
  sprintf(szIniApp, "Object:0x%X", (ULONG)_wpQueryHandle(somSelf));
  DbgPrintf("Importing configuration for non-existing view (ulPages=%X)\n", ulPages);
  DbgPrintf("szIniFile=%s, szIniApp=%s\n", szIniFile, szIniApp);
  CnfViewConfigLoad(hab, szIniFile, szIniApp, pvc, ulPages);
  }
}

VOID    GenExportViewConfig(HAB hab, PVOID somSelf, PVIEWCONFIG pvc, BOOL fSave, ULONG ulPages)
{
INT i;
BOOL fFound = FALSE;
CHAR szIniFile[CBMAXSTRING], szIniApp[CBMAXSTRING];
PSZ pszSystrayIniEnv = (PSZ)getenv("SYSTRAY_INI");

for(i=0; i<iViews; i++)
  if(SystrayView[i]->somSelf == somSelf)
    {
    fFound = TRUE;
    WinSendMsg(SystrayView[i]->hwnd, VTM_EXPORTVC, MPFROMP(pvc), (MPARAM)ulPages);
    }

if(!fFound && fSave)
  {
  if(pszSystrayIniEnv) strcpy(szIniFile, pszSystrayIniEnv);
  else sprintf(szIniFile, "%ssystray.ini", szCommonPath);
  sprintf(szIniApp, "Object:0x%X", (ULONG)_wpQueryHandle(somSelf));
  DbgPrintf("Exporting configuration for non-existing view (ulPages=%X)\n", ulPages);
  DbgPrintf("szIniFile=%s, szIniApp=%s\n", szIniFile, szIniApp);
  CnfViewConfigSave(hab, szIniFile, szIniApp, pvc, ulPages);
  }
}

BOOL    GenSaveView(PVOID somSelf)
{
INT i;
BOOL fSaved = FALSE;

for(i=0; i<iViews; i++)
  if(SystrayView[i]->somSelf == somSelf)
    {
    fSaved = TRUE;
    DbgPrintf("Saving view (hwnd=%d) #%d, somSelf=%d\n",SystrayView[i]->hwnd, i, (int)somSelf);
    WinPostMsg(SystrayView[i]->hwnd, VTM_SAVECONFIG, (MPARAM)0L, (MPARAM)0L);
    }

return fSaved;
}

PVOID   pvTemp;

HWND    GenCreateAnotherSystrayView(PVOID somSelf)
{
PVIEWDATA pViewData;
PSZ pszSystrayIniEnv = (PSZ)getenv("SYSTRAY_INI");

if(iViews == (MAXVIEWS-1)) return NULLHANDLE;

pViewData = (PVIEWDATA)malloc(sizeof(VIEWDATA));

memset(pViewData, 0, sizeof(VIEWDATA));

pViewData->somSelf = somSelf;

DbgPrintf("Creating new view for object somSelf=%d\n", (int)somSelf);
if(pszSystrayIniEnv)  strcpy(pViewData->szIniFile, pszSystrayIniEnv);
else  sprintf(pViewData->szIniFile, "%ssystray.ini", szCommonPath);
sprintf(pViewData->szIniApp, "Object:0x%X", (ULONG)_wpQueryHandle(somSelf));
DbgPrintf("szIniFile=%s, szIniApp=%s\n", pViewData->szIniFile, pViewData->szIniApp);

if(DosCreateEventSem(NULL, &pViewData->hev, DC_SEM_SHARED, FALSE))
  DbgPrintf("ERROR: can't create event semaphore");

if(!fThreadReady)
  {
  pvTemp = (PVOID)pViewData;
  //DosBeep(1000, 1000);
  _beginthread(GenMainViewThread, NULL, VIEWTHREADSTACK, (PVOID)pViewData);
  //DosCreateThread((PTID)(&pViewData->tid), (PFNTHREAD)GenMainViewThread, (ULONG)pViewData, 0L, VIEWTHREADSTACK);
  }
  else
  {
  WinPostMsg(hwnd_Object, VTM_CREATEVIEW, (MPARAM)pViewData, (MPARAM)NULL);
  }

// 0.3.6
//if(DosWaitEventSem(pViewData->hev, 1000L) != 640)
//  {
//  SystrayView[iViews] = pViewData;
//  iViews++;
//  }

//DbgPrintf("Waiting for frame done (hwnd=%d, hev=%d)\n",
//          (int)pViewData->hwnd_Frame, pViewData->hev);

DosCloseEventSem(pViewData->hev);

return pViewData->hwnd_Frame;
}

void GenMainViewThread(PVOID pv)
{
HAB        hab;
HMQ        hmq;
HPS        hps;
QMSG       qmsg;
INT        i;
ULONG      ulFrame = 0L, ul;
PVIEWDATA  pViewData;
PSZ        pszPrioEnv = (PSZ)getenv("SYSTRAY_PRIORITY");

fThreadReady = TRUE;

DosEnterMustComplete(&ul); // super safe?

//DosBeep(500, 300);
if(!pvTemp) return;

pViewData = (PVIEWDATA)pvTemp;

hab = WinInitialize(0);
hmq = WinCreateMsgQueue(hab, 0);

DbgPrintf("Interface thread initialized (hab=%d, hmq=%d, pvTemp=%p, pv=%p)\n",
          hab, hmq, pvTemp, pv);

if(pszPrioEnv)
  {
  int _delta = 0, _class = 0; // no change by default

  sscanf(pszPrioEnv, "%d,%d", &_delta, &_class);

  DosSetPriority(2, _class, _delta, 0);
  DbgPrintf("Thread priority set to %d (%d)\n", _delta, _class);
  }

// view window class
WinRegisterClass(hab, szSystrayViewClass, (PFNWP)ViewWindowProc, CS_SIZEREDRAW, sizeof(PVOID));

// object monitor class
WinRegisterClass(hab, szObjectWindowClass, (PFNWP)ObjectWindowProc, 0, sizeof(PVOID));

// hint window class
WinRegisterClass(hab, szSystrayHintClass, (PFNWP)HintWindowProc, CS_SIZEREDRAW | CS_HITTEST, 0L);

// logo window class
//WinRegisterClass(hab, szSystrayLogoClass, (PFNWP)LogoWindowProc, CS_SIZEREDRAW, 0L);

WinCreateStdWindow(HWND_DESKTOP, 0, &ulFrame, szObjectWindowClass,
                   szObjectWindowClass, 0, hmSystray, 0L, &hwnd_Object);

DbgPrintf("Object window=%d\n", hwnd_Object);

if(!hwnd_Object)
  {
  WinDestroyMsgQueue(hmq);
  WinTerminate(hab);

//  DosBeep(1000, 1000);
  DbgPrintf("ERROR: can't create object window, terminating\n");
  DosExitMustComplete(&ul);
  return;
  }

//DosBeep(1000, 300);

GenLoadClasses(hab);

DosExitMustComplete(&ul);

//DosBeep(500, 300);

pViewData->hab = hab;
pViewData->hmq = hmq;

CnfConfigLoad(pViewData->szIniFile,pViewData->szIniApp, pViewData);

//DosBeep(1000, 300);

// Load resources

DbgPrintf("Loading icon resources\n");

hptrGrpUp = WinLoadPointer(HWND_DESKTOP, hmSystray, IDR_GRPUP); // 0.3.2 hmSystrayRes -> hmSystray
hptrGrpDown = WinLoadPointer(HWND_DESKTOP, hmSystray, IDR_GRPDOWN);
hptrTrack = WinLoadPointer(HWND_DESKTOP, hmSystray, IDR_TRACKPOINTER);
hptrHand = WinLoadPointer(HWND_DESKTOP, hmSystray, IDR_HANDPOINTER);
hptrTrays = WinLoadPointer(HWND_DESKTOP, hmSystray, IDR_TRAYSICON);

ViewNewView(pViewData);

//DosBeep(500, 300);

DbgPrintf("Starting message loop\n");

while(WinGetMsg(hab, &qmsg, NULLHANDLE, 0, 0))
  WinDispatchMsg(hab, &qmsg);

DbgPrintf("Terminating message loop\n");

while(iViews) // force remove
  if(SystrayView[0])
    {
    DbgPrintf("Removing frame window=%d\n", SystrayView[0]->hwnd_Frame);
    WinDestroyWindow(SystrayView[0]->hwnd_Frame);
    }

fThreadReady = FALSE;

GenUnloadClasses(hab);

DbgPrintf("Destroing icon resources\n");

WinDestroyPointer(hptrGrpUp);
WinDestroyPointer(hptrGrpDown);
WinDestroyPointer(hptrTrack);
WinDestroyPointer(hptrHand);
WinDestroyPointer(hptrTrays);

if(hwndHint) WinDestroyWindow(hwndHint);

WinDestroyMsgQueue(hmq);
WinTerminate(hab);

hwnd_Object = NULLHANDLE;
DbgPrintf("Thread going to exit...\n");

}

// Small view server window ;_)

MPARAM  EXPENTRY ObjectWindowProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{

switch(msg)
  {
  case WM_CREATE:
  DbgPrintf("WM_CREATE in object window\n");
  break;

  case VTM_CREATEVIEW:
    {
    PVIEWDATA pViewData = (PVIEWDATA) mp1;

    DbgPrintf("VTM_CREATEVIEW requested (mp1=%04X,mp2=04%X)\n",(int)mp1,(int)mp2);
    CnfConfigLoad(pViewData->szIniFile, pViewData->szIniApp, pViewData);
    ViewNewView(pViewData);

    return (MRESULT)0L;
    }
  }

return WinDefWindowProc(hwnd, msg, mp1, mp2);
}

// Debug (0.3.2)

char    DbgBuffer[2048];

void    DbgPrintf(char *fmt, ...)
{
#ifndef NO_DEBUG_SYSTRAY_RELEASE
char    *DbgPath = getenv("SYSTRAY_DEBUG");
va_list arglist;
va_start (arglist, fmt);
vsprintf (DbgBuffer, fmt, arglist);

if(DbgPath)
  {
//  struct stat s;
  FILE *f;
//  long limit;
//  char *DbgLimit = getenv("SYSTRAY_DEBUG_LIMIT");

//  if(DbgLimit)
//    {
//    sscanf(DbgLimit, "%ld", &limit);
//    stat(DbgPath, &s);
//    if(s.st_size < limit) f = fopen(DbgPath, "a");
//    else f = fopen(DbgPath, "w"); // truncate file
//    }
/*  else*/ f = fopen(DbgPath, "a");

  if(f)
    {
    DATETIME dt;
    char     timebuf[32];

    DosGetDateTime(&dt);

    sprintf(timebuf, "%2d/%02d/%02d|%2d:%02d:%02d.%02d|",
            dt.day, dt.month, (dt.year-1900)%100,
            dt.hours, dt.minutes, dt.seconds, dt.hundredths);

    fwrite(timebuf, strlen(timebuf), 1, f);
    fwrite(DbgBuffer, strlen(DbgBuffer), 1, f);
    fclose(f);
    }
  }
#endif
}

char	NlsBuffer[CBMAXSTRING+1]; // suxx... very very nice...

char	*GenLoadNls(char *dest, int id, char *def)
{
if(!dest) dest=NlsBuffer; 
if(WinLoadString(WinQueryAnchorBlock(HWND_DESKTOP), hmSystrayRes, id, CBMAXSTRING, dest))
  DbgPrintf("NLS call for %s (id=%d)\n", dest, id);
else 
  return def;

return dest;
}
