// NOTE this file best edit in editor with 100 columns

#include "sampplug.h"

// Globals

HMODULE	hmod;
HAB	hab;

LONG GetItemTextColor(HWND hwnd) // Get window foreground (text) color
{
ULONG ulTemp, ulfg;
WinQueryPresParam(hwnd, PP_FOREGROUNDCOLOR, NULL, &ulTemp, sizeof(LONG),
                  &ulfg, QPF_PURERGBCOLOR);

return (LONG)ulfg;
}

LONG GetItemBackColor(HWND hwnd) // Get window background (fill) color
{
ULONG ulTemp, ulbg;
WinQueryPresParam(hwnd, PP_BACKGROUNDCOLOR, NULL, &ulTemp, sizeof(LONG),
                  &ulbg, QPF_PURERGBCOLOR);

return (LONG)ulbg;
}

LONG GetItemFont(HWND hwnd, PSZ pszFont) // Get window font (text)
{
ULONG ulTemp;
WinQueryPresParam(hwnd, PP_FONTNAMESIZE, NULL, &ulTemp, 56, pszFont, 0);

return (LONG)strlen(pszFont);
}

VOID SetItemTextColor(HWND hwnd, LONG lColor)
{
WinSetPresParam(hwnd, PP_FOREGROUNDCOLOR, sizeof(LONG), &lColor);
}

VOID SetItemBackColor(HWND hwnd, LONG lColor)
{
WinSetPresParam(hwnd, PP_BACKGROUNDCOLOR, sizeof(LONG), &lColor);
}

VOID SetItemFont(HWND hwnd, PSZ pszFont)
{
WinSetPresParam(hwnd, PP_FONTNAMESIZE, 56, pszFont);
}

void DrawFence(HPS hps, PRECTL prcl, ULONG ulRadius) // Draw nice border
{
POINTL ptl;

GpiSetLineType(hps, LINETYPE_DOT); // dotted style

GpiSetColor(hps, 0x00000000); // always black (need to be turned on RGB mode)

ptl.x = prcl->xLeft; ptl.y = prcl->yBottom;

GpiMove(hps ,&ptl);

ptl.x = prcl->xRight-1; ptl.y = prcl->yTop-1;

GpiBox(hps, DRO_OUTLINE, &ptl, (LONG)ulRadius, (LONG)ulRadius);

GpiSetLineType(hps, LINETYPE_SOLID); // default style
}

HWND DublicateMenu(HWND hwndSourceMenu, HWND hwndParentMenu) // Copy one menu
{                                                            // to another...
CHAR buf[CBMAXSTRING];
MENUITEM miCopy = {MIT_END, MIS_SEPARATOR, 0, 0, 0, 0};
INT iItemCount, i;

HWND hwndNewMenu = WinCreateMenu(hwndParentMenu, NULL); // new emptu menu...

if(!hwndNewMenu) return NULLHANDLE;

iItemCount = (INT)WinSendMsg(hwndSourceMenu, MM_QUERYITEMCOUNT, 0, 0);

if(iItemCount <= 0)
  {
  WinDestroyWindow(hwndNewMenu);
  return NULLHANDLE;
  }

for(i = 0; i < iItemCount; i++)
  {
  MENUITEM mi;
  INT iID = (INT)WinSendMsg(hwndSourceMenu, MM_ITEMIDFROMPOSITION, (MPARAM)i, 0);

  WinSendMsg(hwndSourceMenu, MM_QUERYITEM, MPFROM2SHORT(iID, TRUE), MPFROMP(&mi));

  WinSendMsg(hwndSourceMenu, MM_QUERYITEMTEXT, MPFROM2SHORT(iID, CBMAXSTRING),
             MPFROMP(buf));

  mi.iPosition = i; // Hei, thats Great!

  if(mi.hwndSubMenu) mi.hwndSubMenu = DublicateMenu(mi.hwndSubMenu, hwndNewMenu);

  WinSendMsg(hwndNewMenu, MM_INSERTITEM, MPFROMP(&mi), MPFROMP(buf));
  }

return hwndNewMenu; // new menu same as old
}

// Exported procedure: called by Systray

BOOL EXPENTRY RegisterPlugin(HMODULE hm, HAB habSystray, PWCLASS pwc, PUSHORT n)
{

if(!*n) return FALSE;

hmod = hm;
hab = habSystray;

*n = 1;

DigitalClockRegister(hab, hm, pwc); // pwc++;

return TRUE;
}

// Exported procedure: called by Systray

BOOL EXPENTRY DeRegisterPlugin(HMODULE hm, HAB habSystray)
{

DigitalClockDeregister(hab, hm);
return TRUE;
}
