#define INCL_WIN
#define INCL_GPI
#define INCL_DOS
#define __IMPLEMENTATION__
#include <os2.h>
#include "..\trayapi\trayex.c\sources\trayapi.h"
#include "ptt.h"
#include <process.h>
#include <string.h>

#define ERR_INIT_FAILED                 -100
#define ERR_CREATEMSGQUEUE_FAILED       -101
#define ERR_REGISTER_FAILED             -102
#define ERR_CREATEWIN_FAILED            -103
#define ERR_LOADMENU_FAILED             -104
#define ERR_LOADPTR_FAILED              -105

LHANDLE Handle;
HEV Semaphore;
char Stack[8192];

//-----------------   뭥  䨣
char *ConfigPipe = "\\PIPE\\KBDLAY2";
char *ConfigSemaphore = "\\SEM32\\PIPE\\KBDLAY2";
char *ConfigIconValue[] = {"DEFAULT","LATIN","RU441"};
char *ConfigIconFile[] = {"PTT.ICO","EN.ICO","RU.ICO"};
int  ConfigBeepOnChange[][2] = {{0,0},{0,0},{0,0}/*{300,10},{200,10}*/};
int ConfigIcons=3;
int ConfigShowDefault=1;
//----------------- ᤥ 㧪   䠩...
int inTray=0;
HPOINTER hIcon[] = {0,0,0};

HAB hab = 0;
HWND hwndFrame  = 0;
HWND hwndClient = 0;
HWND hwndMenu   = 0;
CHAR szClass [] = "PipeToTray" ;

APIRET kOpen(void)
{
APIRET rc;
if (rc = DosCreateEventSem(ConfigSemaphore, &Semaphore, 0L, 0L))
  return rc;
if (rc = DosCreateNPipe(ConfigPipe, &Handle, NP_ACCESS_INBOUND, NP_NOWAIT | NP_TYPE_BYTE | NP_READMODE_BYTE | 1, 128, 128, 0))
  {
  DosCloseEventSem(Semaphore);
  return rc;
  }
DosSetNPipeSem(Handle, (HSEM)Semaphore, 0);
DosConnectNPipe(Handle);
return 0;
}

APIRET kClose(void)
{
DosCloseEventSem(Semaphore);
DosDisConnectNPipe(Handle);
DosClose(Handle);
return 0;
}

APIRET kStep(void)
{
int i,j;
char Buffer[32];
APIRET rc;
ULONG Readed;
PIPESEMSTATE State[32];
DosResetEventSem( Semaphore, &Readed );
if (rc = DosWaitEventSem(Semaphore, SEM_INDEFINITE_WAIT))
    return rc;
DosQueryNPipeSemState((HSEM)Semaphore, &State[0], sizeof(PIPESEMSTATE)*32);
for (i=0;i<32;i++)
  if (State[i].fStatus == NPSS_RDATA)
    {
    DosRead(Handle, Buffer, 32, &Readed );
    if (Readed)
      {
      Buffer[Readed]=0;
      for (j=0;j<ConfigIcons;j++)
        if (strnicmp(Buffer,ConfigIconValue[j],strlen(ConfigIconValue[j]))==0)
          WinPostMsg(hwndFrame, WM_COMMAND, MPFROMSHORT(ID_CMD_CHANGEICON), MPFROMSHORT(j));
      }
    }
DosDisConnectNPipe(Handle);
DosConnectNPipe(Handle);
return 0;
}

void FAR ListenPipe( void FAR *Param )
{
if (!kOpen())
  {
  while (!kStep());
  kClose();
  }
WinPostMsg(hwndFrame, WM_CLOSE, 0, 0);
_endthread();
}


MRESULT EXPENTRY PttWindowProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
static int inited=0;
POINTL ptl;
switch(msg)
  {
  case WM_BUTTON1CLICK | 0x2000:
  case WM_BUTTON2CLICK | 0x2000:
    WinQueryPointerPos(HWND_DESKTOP, &ptl);
    WinMapWindowPoints(HWND_DESKTOP, hwnd , &ptl, 1);
    WinPopupMenu(hwnd, hwnd, hwndMenu, ptl.x, ptl.y, 0, PU_HCONSTRAIN | PU_VCONSTRAIN | PU_MOUSEBUTTON1 | PU_MOUSEBUTTON2 | PU_KEYBOARD);
    break;
  case WM_COMMAND:
    switch(SHORT1FROMMP(mp1))
      {
      case ID_MENU_PROPERTIES:
        WinMessageBox(HWND_DESKTOP, hwndFrame, "Not implemented yet", "Configure Pipe-To-Tray", 0, MB_INFORMATION | MB_OK | MB_MOVEABLE);
        break;
      case ID_MENU_ABOUT:
        WinMessageBox(HWND_DESKTOP, hwndFrame, "Pipe to Tray forwarder.\nAsk me for details ;)", "About Pipe-To-Tray", 0, MB_INFORMATION | MB_OK | MB_MOVEABLE);
        break;
      case ID_MENU_EXIT:
        WinPostMsg(hwnd, WM_QUIT, 0, 0);
        break;
      case ID_CMD_CHANGEICON:
//ChangeTrayIcon(hwnd, hIcon[SHORT1FROMMP(mp2)]); //Doesn't work 祬-

        WinSendMsg(hwndFrame, WM_SETICON, (MPARAM)hIcon[SHORT1FROMMP(mp2)], 0);
        if (!inTray)
          inTray = AddTrayIcon(hwnd, 0);
        else
          ChangeTrayIcon(hwnd, 0);
        if (ConfigBeepOnChange[SHORT1FROMMP(mp2)][0]+ConfigBeepOnChange[SHORT1FROMMP(mp2)][1])
          DosBeep(ConfigBeepOnChange[SHORT1FROMMP(mp2)][0],ConfigBeepOnChange[SHORT1FROMMP(mp2)][1]);
        break;
      }
    break;
  case WM_TIMER:			//when ptt start before systray
    InitializeTrayApi(hwnd);
    break;
  case WM_CREATE:
    WinStartTimer(hab, hwnd, 1, 500);
//    InitializeTrayApi(hwnd);
    break;
  case WM_DDE_INITIATEACK:
    inited=1;
    WinStopTimer(hab, hwnd, 1);
    _beginthread( ListenPipe, Stack, sizeof(Stack), NULL );
    AnswerTrayApiDdeAck(mp1);
    if (ConfigShowDefault)
      inTray = AddTrayIcon(hwnd, (HPOINTER)WinSendMsg(hwndFrame, WM_QUERYICON, 0, 0));
    return 0;
  case WM_DESTROY:
    if (inTray)
      inTray = !DeleteTrayIcon(hwnd);
    return 0;
  }
return WinDefWindowProc(hwnd, msg, mp1, mp2);
}





int main()
{
ULONG fl = FCF_ICON;
HMQ hmq = 0;
QMSG qmsg;
LONG i;
int rc = 0;
do
  {
  hab = WinInitialize(0);
  if(!hab)
    {
    rc = ERR_INIT_FAILED;
    break;
    }
  hmq = WinCreateMsgQueue(hab, 0);
  if(!hmq)
    {
    rc = ERR_CREATEMSGQUEUE_FAILED;
    break;
    }
  rc = WinRegisterClass(hab, (PSZ)szClass, (PFNWP)PttWindowProc, CS_SIZEREDRAW, 0);
  if(rc != TRUE)
    {
    rc = ERR_REGISTER_FAILED;
    break;
    }
  rc = 0;
  hwndFrame = WinCreateStdWindow(HWND_DESKTOP, WS_VISIBLE, &fl, (PSZ)szClass, (PSZ)szClass, 0, 0, ID_PTT, &hwndClient);
  if(!hwndFrame)
    {
    rc = ERR_CREATEWIN_FAILED;
    break;
    }
  hwndMenu = WinLoadMenu(hwndFrame, 0, ID_MENU);
  if(!hwndMenu)
    {
    rc = ERR_LOADMENU_FAILED;
    break;
    }
  for(i=0;i<ConfigIcons;i++)
    {
    hIcon[i] = WinLoadPointer(HWND_DESKTOP, 0, ID_ICON+i);
    if(!hIcon[i])
      {
      rc = ERR_LOADPTR_FAILED;
      break;
      }
    }
//  DosBeep(1000, 100);
  while(WinGetMsg (hab, &qmsg, 0, 0, 0))
    WinDispatchMsg (hab, &qmsg);
  }while(0);
WinDestroyWindow(hwndFrame);
WinDestroyMsgQueue (hmq);
WinTerminate (hab);
return rc;
}
