/****************************** Module Header ******************************\
* Module Name: _PMWIN.H
*
* @(#) PowerDesktop extensions for the standard PMWIN library
*
* (c) Sinergetix software, 2000-2001. All rights reserved.
*
\***************************************************************************/

#if !defined( ___PMWIN_H )
#define ___PMWIN_H   /* mutex definition */

/* XLATOFF */
#if defined( __cpluspplus )
   extern "C" {
#endif /* __cplusplus */
/* XLATON */



/*** some undocumented messages ********************************************/

/*-( u_WM_MOVEALONGWINDOW )-------------------------------------( notify )---
 * Called when mouse pointer moves along window.
 *
 * Parameters: unknown
 *
 * Returns: unknown
 */
#define u_WM_MOVEALONGWINDOW      0x041E

/*-( u_WM_MOVEACROSSWINDOW )------------------------------------( notify )---
 * Called when mouse pointer moves across window.
 *
 * Parameters: unknown
 *
 * Returns: unknown
 */
#define u_WM_MOVEACROSSWINDOW     0x041F


#if defined( INCL_WINMENUS )
   
  /**** Menu Manager Subsection */

  /*-( u_MM_FNEEDACTIVATE )-----------------------------------( control )---
   * Called when menu is need to be activated.
   *
   * Parameters:
   *    param1 - pointer to RECTL structure which contains coordinates
   *             of menu item currently selected
   *    param2
   *       SHORT1 of second parameter contains an item ID if PU_SELECTITEM
   *          and/or PU_POSITIONONITEM flags is specified for menu
   *
   *       SHORT2 of second parameter contains some u_PU_* flags combination
   *          (see below)
   *
   * Returns TRUE if no errors, FALSE otherwise.
   */
   #define u_MM_FNEEDACTIVATE        0x0196

  /*-( u_MM_DISMISS )-----------------------------------------( control )---
   * Called when menu is need to be deactivated.
   *
   * Parameters: unknown
   *
   * Returns: unknown
   */
   #define u_MM_DISMISS              0x0197


  /*** some undocumented constants for some undocumented messages *********/

   #define u_PU_NONE                 0x0000 /* If invoked by keyboard */
   /*? #define u_PU_SELECTITEM           0x0010 / * Set selected item (use with kbd) */
   #define u_PU_POSITIONONITEM       0x0020 /* Need idItem parameter */
   #define u_PU_KEYBOARD             0x0100 /* If keyboard use allowed */
   #define u_PU_MOUSEBUTTON3         0x0200 /* If button3 use allowed */
   #define u_PU_MOUSEBUTTON2         0x0400 /* If button2 use allowed */
   #define u_PU_MOUSEBUTTON1         0x0800 /* If button1 use allowed */
   #define u_PU_MOUSEBUTTON1DOWN     0x1000 /* If invoked by button 1 */
   #define u_PU_MOUSEBUTTON2DOWN     0x2000 /* If invoked by button 2 */
   #define u_PU_MOUSEBUTTON3DOWN     0x3000 /* If invoked by button 3 */
   #define u_PU_VCONSTRAIN           0x4000 /* Keep menu on top and bottom edge */
   #define u_PU_HCONSTRAIN           0x8000 /* Keep menu on left and right edge */

#endif /* INCL_WINMENUS */


/* undocumented WinDrawBorder() flags */

#define u_DB_RAISED      0x0400
#define u_DB_DEPRESSED   0x0800
#define u_DB_TROUGH      0x1000
#define u_DB_FENCE       0x2000
#define u_DB_FIELD       0x4000


/* XLATOFF */
#if defined( __cplusplus )
   }
#endif /* __cplusplus */
/* XLATON */

#endif /* !___PMWIN_H */

/**************************** end of file **********************************/
