{ _______________________________________________________________________

                              S Y S T R A Y / 2
  _______________________________________________________________________

  (C) 2001-2, OS2.Ru DevTeam              http://devcenter.os2.ru/systray
  Written by Dmitry Zaharov                                 madint@os2.ru
  _______________________________________________________________________
}

library uptime;
{&OrgName-}
{&Use32+}

{$Linker
DESCRIPTION 'Sample SysTray/WPS VP-plugin DLL'}

{$R uptime.res}


uses os2def, os2base, os2pmapi, systray;

const
  UPF_SHOWDAYS = $00000001;

type
  PUNITUPTIME = ^_UNITUPTIME;
  _UNITUPTIME = record
  unitRec     : _UNIT;
  fcInfo      : _FNTCLRINFO;
  { ^ is better place for color and font information ;-) }
  ulFlags     : LONGINT;
  end;

var
  anchor        : HAB;
  hmodNls, hmod : HMODULE;
  szUptime      : array [1..80] of char;
  upgInfo       : _UNITPGINFO;
  ppszfcInfo    : array[1..2] of PCHAR;

function LengthSZ (text : PCHAR) : integer;

  var
    i : integer;
  begin
    i := 0;
    while text^ <> #0 do
      begin
        inc (i);
        inc (text);
      end;

    LengthSZ := i;
  end;

procedure StoreSZ (psz : PCHAR; s : string);
  var
    i : integer;
  begin
    for i := 1 to length(s) do
      begin
        psz^ := s[i];
        inc(psz);
      end;

    psz^ := #0;
  end;

function LeadZero(s : string; size : integer) : string;
  begin
    while length(s) < size do
      s := '0' + s;

    LeadZero := s;
  end;

function ULong2Str(L: ULONG): String; { SysUtils is very large... and useless ;-) }
  var
    S: String;
  begin
    Str(L, S);
    ULong2Str:=S;
  end;

procedure FormatUptime(text : PCHAR; uptime : ULONG);
  var
    s : string;
  begin
    s := LeadZero(ULong2Str(uptime div 3600), 2) + ':';
    s := s + LeadZero(ULong2Str((uptime div 60) mod 60), 2) + ':';
    s := s + LeadZero(ULong2Str(uptime mod 60), 2);

    StoreSZ(text, s);
  end;

function QueryTextWidth (wnd : HWND; text : PCHAR) : integer;
  var
    ps : HPS;
    txp: array [0..TXTBOX_COUNT] of POINTL;
  begin

    ps := WinGetPS(wnd);
    GpiQueryTextBox(ps, LengthSZ(text), text, TXTBOX_COUNT, txp[0]);
    WinReleasePS(ps);

    QueryTextWidth := abs(txp[TXTBOX_TOPRIGHT].x - txp[TXTBOX_TOPLEFT].x);
  end;

{  _______________________________________________________________________

                        Settings page #1 procedure
   _______________________________________________________________________
}

function UptimeDlgProc (wnd : HWND  ; msg : ULONG ;
                        mp1 : MPARAM; mp2 : MPARAM): MRESULT; cdecl;
  var
    punitRec  : PUNITUPTIME;
  begin
    punitRec := PUNITUPTIME(WinQueryWindowULong(wnd, QWL_USER));

    case msg of
      WM_INITDLG:
        begin
        { get unit pointer from pCreateParam }
        punitRec := PUNITUPTIME(mp2);
        WinSetWindowULong(wnd, QWL_USER, ULONG(punitRec));
        { check "Show days" button if setting flag present }
        WinCheckButton(wnd, 101, ULONG((punitRec^.ulFlags and UPF_SHOWDAYS) = UPF_SHOWDAYS));
        end;

      WM_DESTROY:
        begin
        { reset unit flags }
        punitRec^.ulFlags := 0;
        { get button check state }
        if WinQueryButtonCheckstate(wnd, 101) <> 0 then
        { ...and update unit flags }
          punitRec^.ulFlags := punitRec^.ulFlags or UPF_SHOWDAYS;
        end;

    end;

    UptimeDlgProc := WinDefDlgProc (wnd, msg, mp1, mp2);
  end;

{  _______________________________________________________________________

                           Main window procedure
   _______________________________________________________________________
}

function UptimeWndProc (wnd : HWND  ; msg : ULONG ;
                        mp1 : MPARAM; mp2 : MPARAM): MRESULT; cdecl;
  var
    punitRec  : PUNITUPTIME;
    pszTemp   : PCHAR;
    ps        : HPS;
    rcl       : RECTL;
    i         : ULONG;
    punbInfo  : PUNITNBINFO;
  begin
    punitRec := PUNITUPTIME(WinQueryWindowULong(wnd, 0));

    case msg of
      WM_CREATE:
        begin
        { get unit pointer created by Systray/WPS unit manager }
        punitRec := PUNITUPTIME(mp1);
        { setup instance data to unit pointer }
        WinSetWindowULong(wnd, 0, ULONG(punitRec));
        { set timer to 1 second }
        punitRec^.unitRec.ulRefresh := 1;
        punitRec^.unitRec.ulCounter := 0;
        { check for "new unit" created by user }
        if punitRec^.unitRec.fJustCreated = 1 then { new unit }
          begin
        { set default settings }
            punitRec^.fcInfo.lTextColor := 0;
            punitRec^.fcInfo.lBackColor := $00CCCCCC;
            punitRec^.ulFlags := 0;
            StoreSZ(@punitRec^.fcInfo.szFont, '9.WarpSans');
          end;

        { query uptime from OS/2 }
        DosQuerySysInfo(14, 14, i, sizeof (ULONG)); i := i div 1000;
        FormatUptime(@szUptime, i);

        { set unit presentation colros }
        SetUnitTextColor(wnd, punitRec^.fcInfo.lTextColor);
        SetUnitBackColor(wnd, punitRec^.fcInfo.lBackColor);
        SetUnitFont(wnd, @punitRec^.fcInfo.szFont);
        end;

      WM_DESTROY:
        begin
        { destroy unit resources... none ;-) }
        end;

      WM_PRESPARAMCHANGED:
        begin
        i := LONGINT(mp1);
        { check for new presentation parameters dropped on us }
        if i = PP_FOREGROUNDCOLOR then
          begin
          punitRec^.fcInfo.lTextColor := GetUnitTextColor(wnd);
          WinQueryWindowRect(wnd, rcl);
          WinInvalidateRect(wnd, @rcl, true);
          exit;
          end;

        if i = PP_BACKGROUNDCOLOR then
          begin
          punitRec^.fcInfo.lBackColor := GetUnitBackColor(wnd);
          WinQueryWindowRect(wnd, rcl);
          WinInvalidateRect(wnd, @rcl, true);
          exit;
          end;

        if i = PP_FONTNAMESIZE then
          begin
          GetUnitFont(wnd, @punitRec^.fcInfo.szFont);
          WinSendMsg(wnd, USTM_RESIZE, MPARAM(QueryTextWidth(wnd, 'XX:XX:XX')), 0);
          WinQueryWindowRect(wnd, rcl);
          WinInvalidateRect(wnd, @rcl, true);
          exit;
          end;
        end;

      USTM_REFRESHTIMER:
        begin;
        { SysTray/WPS timer (we set it to 1 second) }

        { get uptime from OS/2 }
        DosQuerySysInfo(14, 14, i, sizeof (ULONG)); i := i div 1000;
        FormatUptime(@szUptime, i);

        WinQueryWindowRect(wnd, rcl);
        WinInvalidateRect(wnd, @rcl, true); exit;
        end;

      USTM_QUERYNBINFO:
        begin;
        { SysTray/WPS wanna to get notebook pages from us... }
        punbInfo := PUNITNBINFO(mp1);
        upgInfo.pszTabText := 'Uptime';
        upgInfo.pszStatusText := 'Monitor';
        upgInfo.res := hmod;
        upgInfo.id := 100;
        upgInfo.mp2InsertFlags := MPFROM2SHORT((BKA_STATUSTEXTON or
                                                BKA_AUTOPAGESIZE or
                                                BKA_MAJOR), BKA_FIRST);
        upgInfo.pfnDlgProc := @UptimeDlgProc;
        upgInfo.pCreateParams := pointer(pUnitRec);
        upgInfo._hwnd := NULLHANDLE;
        upgInfo.pupgInfoNext := nil; { single page - trivial }
        upgInfo.ulPageFlags := 0; { no available buttons ;-) }

        punbInfo^.sNumfcInfo := 1; { only one unit presentation }
        ppszfcInfo[1] := 'Uptime text'; { presentation title }
        punbInfo^.ppszfcInfo := pointer(@ppszfcInfo);
        punbInfo^.pfcInfo := @pUnitRec^.fcInfo; { presentation data }
        punbInfo^.pupgInfo := @upgInfo;
        punbInfo^.idTurnTo := 100;
        punbInfo^.hptrWindowIcon := 0; { no icon }
        UptimeWndProc := 1; { success, we have notebook pages to export }
        exit;
        end;

      USTM_QUERYWIDTH:
        begin
        { SysTray/WPS wanna to know our width }
        UptimeWndProc := MRESULT(QueryTextWidth(wnd, 'XX:XX:XX'));
        exit;
        end;

      WM_PAINT:
        begin
        { paint yourself !? }
        WinQueryWindowRect(wnd, rcl);

        ps := WinBeginPaint(wnd, 0, nil);
        { RGB mode rulez }
        GpiCreateLogColorTable(ps, 0, LCOLF_RGB, 0, 0, nil);

        { only text... no graph, unfortunately }
        WinDrawText(ps, -1, @szUptime, rcl,
                    punitRec^.fcInfo.lTextColor,
                    punitRec^.fcInfo.lBackColor,
                    DT_CENTER or DT_VCENTER or DT_ERASERECT);

        WinEndPaint(ps);

        UptimeWndProc := 0; exit;
        end;
    end;

    UptimeWndProc := WinDefWindowProc (wnd, msg, mp1, mp2);
  end;

{  _______________________________________________________________________

                           Plugin entry procedure
   _______________________________________________________________________
}

function RegisterPlugin (hm  : HMODULE; _hab       : HAB;
                         pwc : PWCLASS; pusClasses : PUSHORT):longint;cdecl;
  begin
  hmod := hm;
  anchor := _hab;
  if pusClasses^ > 0 then
    begin
      pusClasses^ := 1; { number classes exported by plugin }
      pwc^.pszName := 'UptimeClass';
      pwc^.pszViewName := 'System uptime';
      pwc^.pszHelpFileName := 'uptime.hlp'; { help file }
      pwc^.ulHelpPanelID := 100; { help panel }
      pwc^.usMaxUnits := 1;
      pwc^.usFlags := STUF_FIXED or STUF_STATIC;
      pwc^.ulFix := sizeof (_UNITUPTIME);
      pwc^.ulSafeAlloc := sizeof (_UNITUPTIME);
      WinRegisterClass(_hab,                   { Anchor block handler        }
                       pwc^.pszName,           { Class name being registered }
                       UptimeWndProc,          { Procedure window class      }
                       CS_SIZEREDRAW,          { Class style                 }
                       4);                     { Extra bytes to reserve      }
    end;
  RegisterPlugin := 1; { TODO: check class registration success }
  end;

function DeRegisterPlugin (hm : HMODULE; _hab : HAB):longint;cdecl;
  begin
  DeRegisterPlugin := 1; { we have no any resources to free here }
  end;

exports
  RegisterPlugin name 'REGISTERPLUGIN',
  DeRegisterPlugin name 'DEREGISTERPLUGIN';

initialization
  { no initialization code }
end.
