(****************************************************************************
 *                             S Y S T R A Y / 2                            *
 *                                                                          *
 * (C) 2001-2, OS2.Ru DevTeam              http://devcenter.os2.ru/systray  *
 * Written by Dmitry Zaharov                                 madint@os2.ru  *
 ****************************************************************************)

unit systray;
{&Use32+}

interface

uses Os2Def, os2base, os2pmapi;

{ Public declarations }

function GetUnitTextColor(window:HWND):longint;
function GetUnitBackColor(window:HWND):longint;
procedure GetUnitFont(window:HWND;font:pchar);
procedure SetUnitTextColor(window:HWND;color:LONGINT);
procedure SetUnitBackColor(window:HWND;color:LONGINT);
procedure SetUnitFont(window:HWND;font:PCHAR);

{ Constant & Msg definitions }

const
  CBMAXSTRING = 250;
  CBRESERVE = 32;

  { page flags }

  NPF_UNDO       = $00000001;
  NPF_DEFAULT    = $00000002;
  NPF_HELP       = $00000004;
  NPF_BYPASSHELP = $00000008;

  { unit style flags }

  STUF_FIXED     = $0001;
  STUF_STATIC    = $0002;
  STUF_MANUAL    = $0004;
  STUF_FRAMED    = $0008;
  STUF_FULLWIDTH = $0010;
  STUF_NOHINT    = $0020;

  { Unit messages }

  USTM_REFRESHTIMER  = (WM_USER + $1000);
  USTM_QUERYNBINFO   = (WM_USER + $1001);
  USTM_QUERYHINT     = (WM_USER + $1002);
  USTM_QUERYWIDTH    = (WM_USER + $1003);
  USTM_MOVED         = (WM_USER + $1004); // STILL unimplemented
  USTM_GROUPED       = (WM_USER + $1005); // ^^^^
  USTM_SAVING        = (WM_USER + $1006); // ^^
  USTM_REMOVED       = (WM_USER + $1007);
  USTM_SELFCONTROLMENU = (WM_USER + $1008);
  USTM_FORCEHINT     = (WM_USER + $1009);
  USTM_RESIZE        = (WM_USER + $100A);
  USTM_FILLGROUPTITLE = (WM_USER + $100B);
  USTM_QUERYICON     = (WM_USER + $100C);
  USTM_NEXTUNIT      = (WM_USER + $100D);
  USTM_NEXTUNITNOTIFY = (WM_USER + $100E);
  USTM_MENUSHOWING   = (WM_USER + $100F);

  { Menu IDs }

  WPMENUID_USER      = $6500;
  STIDC_USER         = (WPMENUID_USER + $1000);

  { NLS String IDs }

  IDS_SYSTRAY        = $10; // "Systray"
  IDS_CLOSE          = $11; // "Close"
  IDS_MAINHINT       = $12; // "Click right mouse button for popup menu"
  IDS_ADDUNIT        = $13; // "Add unit"
  IDS_XSETTINGS      = $14; // "%s - settings"
  IDS_PRESENTATION   = $15; // "Presentation"
  IDS_FONTSNCOLORS   = $16; // "Fonts & colors"
  IDS_HEADER         = $17; // "Header"
  IDS_UNITHEADER     = $18; // "Unit header"
  IDS_VIEW           = $19; // "View"
  IDS_UNITERROR1     = $1A;
  IDS_UNITERROR2     = $1B;
  IDS_ERROR          = $1C;
  IDS_WARNING        = $1D;
  IDS_UNITERROR3     = $1E;
  IDS_PRODINFO       = $1F; // "Product information"
  IDS_NLS            = $20; // "XX,yyy,Z,language,DD/MM/YYYY", where:
                            // XX = 2-byte country ID
                            // yyy = 3-byte country ID
                            // Z = country code
  IDS_HELPFILE       = $21; // "systr_XX.hlp"

type
  PWCLASS = ^_WCLASS;
  _WCLASS = record
  pszName        : PCHAR; { Window class name }
  pszViewName    : PCHAR; { Class title name }
  pszHelpFileName: PCHAR; { Help FILE NAME }
  ulHelpPanelId  : ULONG;
  usMaxUnits,
  usFlags,
  usAlignWord    : USHORT; { for some compatibility reasons }
  ulReserved     , { actually, this is NLS library handle (on input) }
  ulFix          , { fixed unit structure size }
  ulSafeAlloc    : ULONG; { memory allocation for unit }
  end;

  PUNIT = ^_UNIT;
  _UNIT = record
  cbFix          : ULONG;
  _hwnd, hwndMenu: HWND;
  szClass        : array[1..150] of char;
  szUnitTitle    : array[1..100] of char;
  usFlags        : USHORT;
  iWidth, iRow,
  fGrpNext,
  fJustCreated,
  ulRefresh,
  ulCounter      : ULONG;
  pViewData,
  pfnSubclUnitProc,
  pfnOldUnitProc : pointer;
  ulReserved     : array[1..8] of ULONG;
  end;

  PFNTCLRINFO = ^_FNTCLRINFO;
  _FNTCLRINFO = record
  lTextColor,
  lBackColor     : LONGINT;
  szFont         : array[1..56] of char;
  end;

  PUNITPGINFO = ^_UNITPGINFO;
  _UNITPGINFO = record
  pszTabText,
  pszStatusText  : PCHAR;
  res            : HMODULE;
  id             : LONGINT;
  mp2InsertFlags : MPARAM;
  pfnDlgProc,
  pCreateParams  : pointer;
  _hwnd          : HWND;
  ulNBPageID,
  ulPageFlags    : LONGINT;
  pupgInfoNext   : PUNITPGINFO;
  end;

  PUNITNBINFO = ^_UNITNBINFO;
  _UNITNBINFO = record
  _pUnit         : PUNIT;
  pUserdata      : pointer;
  pfcInfo        : PFNTCLRINFO;
  ppszfcInfo     : pointer;
  sNumFcInfo     : USHORT;
  pupgInfo       : PUNITPGINFO;
  idTurnTo       : LONGINT;
  hptrWindowIcon : HPOINTER;
  pvd            : pointer;
  pupgCurrent    : PUNITPGINFO;
  end;

implementation

function GetUnitTextColor(window:HWND):longint;
  var
    color, tmp:longint;
  begin
    WinQueryPresParam(window, PP_FOREGROUNDCOLOR, 0, @tmp, sizeof(longint),
                      @color, QPF_PURERGBCOLOR);

    GetUnitTextColor := color;
  end;

function GetUnitBackColor(window:HWND):longint;
  var
    color, tmp:longint;
  begin
    WinQueryPresParam(window, PP_BACKGROUNDCOLOR, 0, @tmp, sizeof(longint),
                      @color, QPF_PURERGBCOLOR);

    GetUnitBackColor := color;
  end;

procedure GetUnitFont(window:HWND; font:pchar);
  var
    tmp:longint;
  begin
    WinQueryPresParam(window, PP_FONTNAMESIZE, 0, @tmp, 56, font, 0);
  end;

procedure SetUnitTextColor(window:HWND; color:LONGINT);
  begin
    WinSetPresParam(window, PP_FOREGROUNDCOLOR, sizeof(LONGINT), @color);
  end;

procedure SetUnitBackColor(window:HWND; color:LONGINT);
  begin
    WinSetPresParam(window, PP_BACKGROUNDCOLOR, sizeof(LONGINT), @color);
  end;

procedure SetUnitFont(window:HWND; font:PCHAR);
  begin
    WinSetPresParam(window, PP_FONTNAMESIZE, 56, font);
  end;

end.
