/****************************************************************************
 *                             S Y S T R A Y / 2                            *
 *                                                                          *
 * (C) 2001-2, OS2.Ru DevTeam              http://devcenter.os2.ru/systray  *
 * Written by Dmitry Zaharov                                 madint@os2.ru  *
 ****************************************************************************/

/* Profile library */

#include "systray.h"

HINI    hIni = HINI_USERPROFILE;

char    inifile[]="systray2.ini";
char    iniapp[CBMAXSTRING];

void    profile_setapp(char *app)
{
strcpy(iniapp,app);
}

void    profile_open(HAB hab, char *inifile)
{
hIni = PrfOpenProfile(hab,inifile);
}

void    profile_close()
{
PrfCloseProfile(hIni);
}

void    profile_loadint(char *key,int *i)
{
ULONG ul = sizeof(int);
PrfQueryProfileData(hIni,iniapp,key,(PVOID)i,&ul);
}

void    profile_loadushort(char *key,PUSHORT u)
{
ULONG ul = sizeof(USHORT);
PrfQueryProfileData(hIni,iniapp,key,(PVOID)u,&ul);
}

void    profile_loadbyte(char *key,PBYTE b)
{
ULONG ul = sizeof(BYTE);
PrfQueryProfileData(hIni,iniapp,key,(PVOID)b,&ul);
}

void    profile_loadblob(char *key,PVOID blob,ULONG ulSize)
{
PrfQueryProfileData(hIni,iniapp,key,blob,&ulSize);
}

void    profile_loadstring(char *key,PSZ pszData)
{
ULONG ul = 65535L;
PrfQueryProfileString(hIni,iniapp,key,NULL,pszData,ul);
}

/**/

void    profile_saveint(char *key,int *i)
{
ULONG ul = sizeof(int);
PrfWriteProfileData(hIni,iniapp,key,(PVOID)i,ul);
}

void    profile_saveushort(char *key,PUSHORT u)
{
ULONG ul = sizeof(USHORT);
PrfWriteProfileData(hIni,iniapp,key,(PVOID)u,ul);
}

void    profile_savebyte(char *key,PBYTE b)
{
ULONG ul = sizeof(BYTE);
PrfWriteProfileData(hIni,iniapp,key,(PVOID)b,ul);
}

void    profile_saveblob(char *key,PVOID blob,ULONG ulSize)
{
PrfWriteProfileData(hIni,iniapp,key,blob,ulSize);
}

void    profile_savestring(char *key,PSZ pszData)
{
PrfWriteProfileString(hIni,iniapp,key,pszData);
}
