// ____________________________________________________________________________
//
// IP traffic monitor (C) Dmitry Zaharov 2001
// ____________________________________________________________________________

#include "inetplug.h"

#include <time.h>

#include <netdb.h>		// NOTE: use headers from OS/2 Warp 4.0 MPTN
#include <netinet/in.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <net/if.h>

//int _System soclose (int);

void traffscanthread(void FAR* pv);

extern HMODULE hmod;
extern HAB hab;

HPOINTER hptrTraffic;

void    FillInterfaces(HWND hwndListbox, PSZ pszInterface)
{
int s;
struct ifmib *pifm;

pifm = (struct ifmib*)malloc(sizeof(*pifm));

if(pifm)
  {
  memset(pifm, 0, sizeof(*pifm));
  // create PF_INET socket for ioctl call
  s = socket(PF_INET, SOCK_STREAM, 0);

  if(s != -1)
    {
    if(ioctl(s, SIOSTATIF, (caddr_t)pifm, sizeof(*pifm)) == 0)
      {
      INT sel = 0, i = 0;

      while(i < IFMIB_ENTRIES)
        {
        if(pifm->iftable[i].ifDescr[0])
          {
          char buf[250];
          sprintf (buf, "%s,%d", pifm->iftable[i].ifDescr, (int)pifm->iftable[i].ifIndex);

          WinSendMsg(hwndListbox, LM_INSERTITEM,
                     MPFROMSHORT(LIT_END), MPFROMP(buf));

          if(!strncmp(buf, pszInterface, strlen(pszInterface)))
            {
//            DosBeep(1000, 100);
            WinSendMsg(hwndListbox, LM_SELECTITEM, MPFROMSHORT(sel), MPFROMSHORT(TRUE));
            }
          sel++;
          }
        i++;
        }
//      WinSendMsg(hwndListbox, LM_SELECTITEM, (MPARAM)sel, MPFROMSHORT(TRUE));
      }
    soclose(s);
    }

  free(pifm);
  }
}

MRESULT	EXPENTRY TraffMonDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
//FILE *f;
INT i;
PUNITTM pUnit = (PUNITTM)WinQueryWindowULong(hwnd, QWL_USER);

switch(msg)
  {
  case WM_INITDLG:
  pUnit = (PUNITTM)mp2; // mmmmm....
  WinSetWindowULong(hwnd, QWL_USER, (ULONG)pUnit);

//  f = fopen("\\traflog","a");
//  fprintf(f, "r: %s", pUnit->szInterface);
//  fclose(f);

  if(pUnit->ulFlags & TMF_INCOMING) WinCheckButton(hwnd, IDR_TRAFFINCOMING, TRUE);
  else WinCheckButton(hwnd, IDR_TRAFOUTGOING, TRUE);

  if(pUnit->ulFlags & TMF_MAXCPS) WinCheckButton(hwnd, IDR_TRAFFMAXIMUM, TRUE);
  if(pUnit->ulFlags & TMF_APPROXCPS) WinCheckButton(hwnd, IDR_TRAFFAVERAGE, TRUE);

  FillInterfaces(WinWindowFromID(hwnd, IDR_TRAFFINTERFACE), pUnit->szInterface);
  break;

  case WM_CONTROL:
  break;

  case WM_COMMAND:
  return (MRESULT)0L;

  case WM_DESTROY:

  pUnit->ulFlags = 0L;

  if(WinQueryButtonCheckstate(hwnd, IDR_TRAFFINCOMING))
    pUnit->ulFlags |= TMF_INCOMING;

  if(WinQueryButtonCheckstate(hwnd, IDR_TRAFFMAXIMUM))
    pUnit->ulFlags |= TMF_MAXCPS;

  if(WinQueryButtonCheckstate(hwnd, IDR_TRAFFAVERAGE))
    pUnit->ulFlags |= TMF_APPROXCPS;

  i = (INT)WinSendDlgItemMsg(hwnd, IDR_TRAFFINTERFACE, LM_QUERYSELECTION,
                             MPFROMSHORT(LIT_FIRST), MPFROMLONG(0));

  if(i != LIT_NONE)
    {
    char buf[256];
//    DosBeep(1000, 100);
    WinSendDlgItemMsg(hwnd, IDR_TRAFFINTERFACE, LM_QUERYITEMTEXT,
                      MPFROM2SHORT(i, CBMAXSTRING), MPFROMP(buf /*pUnit->szInterface*/ ));
//    f = fopen("\\traflog","a");
//    fprintf(f, "w: %s", pUnit->szInterface);
//    fclose(f);
    if(strcmp(pUnit->szInterface, buf) != 0)
      {
      strcpy(pUnit->szInterface, buf);
      pUnit->priv.fFirst = TRUE;
      pUnit->priv.fTerminate = FALSE;
      }
    }

  break;
  }

return WinDefDlgProc(hwnd, msg, mp1, mp2);
}

VOID TraffMonPaint(HWND hwnd, PUNITTM pUnit, BOOL fForced)
{
HPS hps;
RECTL rcl, rclReg, rclPaint;
CHAR szText[40];
//HPOINTER hptrIcon;
POINTL ptl;
INT x, i, cxIcon = WinQuerySysValue(HWND_DESKTOP, SV_CXICON)/2;

WinQueryWindowRect(hwnd, &rcl);

sprintf(szText, "%lu", pUnit->priv.ulCPS);

if(pUnit->ulFlags & TMF_MAXCPS)
  sprintf(szText, "%s/%lu", szText, pUnit->priv.ulMaxCPS);

if(pUnit->ulFlags & TMF_APPROXCPS)
  sprintf(szText, "%s/%lu", szText, pUnit->priv.ulApproxCPS);

rclReg = rcl; rclReg.xRight = cxIcon + 2;
//rcl.xLeft += cxIcon + 2;

hps = /*fForced ? WinGetPS(hwnd) :*/ WinBeginPaint(hwnd, 0L, &rclPaint);

GpiCreateLogColorTable(hps, 0L, LCOLF_RGB, 0L, 0L, (PLONG) NULL);

//if(!pUnit->priv.hpsBuffer)
//  CreateGraphicsBuffer(&rcl, hps, &pUnit->priv.hpsBuffer, &pUnit->priv.hdcBuffer);

//WinFillRect(hps, &rclReg, pUnit->fcInfo[0].lBackColor);
WinFillRect(pUnit->priv.hpsBuffer, &rcl, pUnit->fcInfo[0].lBackColor);
rcl.xLeft += cxIcon + 2;

GpiSetColor(pUnit->priv.hpsBuffer, pUnit->fcInfo[1].lBackColor);

if(pUnit->priv.ulGraphIndex > (rcl.xRight - rcl.xLeft))
  x = pUnit->priv.ulGraphIndex - (rcl.xRight - rcl.xLeft);
else
  x = 0;

//ptl.x = rcl.xLeft;
//ptl.y = (pUnit->priv.ulGraph[x] * (rcl.yTop - 1)) /
//        (pUnit->priv.ulMaxCPS ? pUnit->priv.ulMaxCPS : 1);
//GpiMove(pUnit->priv.hpsBuffer, &ptl);

for(i = (rcl.xLeft + 0);
    (i < rcl.xRight) && (x < pUnit->priv.ulGraphIndex);
    i ++, x ++)
  {

  ptl.x = i; ptl.y = 0;

  GpiMove(pUnit->priv.hpsBuffer, &ptl);

  // no traffic, set to 1 manually
  //if(pUnit->priv.ulMaxCPS == 0) pUnit->priv.ulMaxCPS = 1; 

  ptl.x = i;
  ptl.y = (pUnit->priv.ulGraph[x] * (rcl.yTop - 1)) /
          (pUnit->priv.ulMaxCPS ? pUnit->priv.ulMaxCPS : 1);

  GpiLine(pUnit->priv.hpsBuffer, &ptl);
  }

WinDrawPointer(pUnit->priv.hpsBuffer, rclReg.xLeft + (rclReg.yTop - cxIcon)/2,
                    rclReg.yBottom + (rclReg.yTop - cxIcon)/2, hptrTraffic, DP_MINI);

WinDrawText(pUnit->priv.hpsBuffer, -1, szText, &rcl,
            pUnit->fcInfo[0].lTextColor,
            pUnit->fcInfo[0].lBackColor,
            DT_CENTER | DT_VCENTER/* | DT_ERASERECT*/);

//WinFillRect(hps, &rcl, pUnit->fcInfo[0].lBackColor);
BlitGraphicsBuffer(hps, pUnit->priv.hpsBuffer, &rclPaint);

//if(fForced) WinReleasePS(hps);
/*else       */ WinEndPaint(hps);
}

void timesync(PULONG pulVal, ULONG ulDiv)
{
double d = (double)(*pulVal)*1000;

*pulVal = ulDiv ? (ULONG)(d/(double)ulDiv) : 0;
}

void traffscanthread(PVOID pv)
{
PUNITTM punit;
ULONG ulTemp;
int s;
struct ifmib *pifm;
ULONG ulLastTime = 0L, ulTime = 0L ;
//BOOL fFirst = TRUE;

pifm = (struct ifmib*)malloc(sizeof(*pifm));

if(pifm)
  {
  memset(pifm, 0, sizeof(*pifm));
  punit = (PUNITTM)pv; // EAX. We in watcom :)

  punit->priv.fTerminate = FALSE;

  // create PF_INET socket for ioctl call
  s = socket(PF_INET, SOCK_STREAM, 0);
  punit->priv.fFirst = TRUE;

  while((punit->priv.fTerminate == FALSE) && (s != -1))
    {
    // now, get all IP interfaces statistics
    memset(pifm, 0, sizeof(*pifm));

    // 0.3.6
    DosQuerySysInfo(QSV_MS_COUNT, QSV_MS_COUNT, (PVOID)&ulTime, sizeof(ulTime));

    if(ioctl(s, SIOSTATIF, (caddr_t)pifm, sizeof(*pifm)) == 0)
      {
      INT i = 0;

      for(i = 0; i < IFMIB_ENTRIES; i++)
        {
        char buf[250];
        sprintf (buf, "%s,%d", pifm->iftable[i].ifDescr, (int)pifm->iftable[i].ifIndex);

        if(!strncmp(buf, punit->szInterface, 
                    strlen(punit->szInterface)))
          {
          //DosBeep(1000, 10);

          if(punit->priv.fFirst)
            {
            punit->priv.ulGraphIndex = 0L;
            punit->priv.ulCPS = punit->priv.ulMaxCPS = punit->priv.ulApproxCPS = 0L;
            punit->priv.ulLastBytes = (punit->ulFlags & TMF_INCOMING) ?
                                  pifm->iftable[i].ifInOctets     :
                                  pifm->iftable[i].ifOutOctets    ;
            //punit->priv.ulLastBytes = punit->priv.ulBytes;
            punit->priv.fFirst = FALSE;
            }
          else
            {
            //punit->priv.ulLastBytes = punit->priv.ulBytes;
            punit->priv.ulBytes = (punit->ulFlags & TMF_INCOMING) ?
                                  pifm->iftable[i].ifInOctets     :
                                  pifm->iftable[i].ifOutOctets    ;

            if((punit->priv.ulBytes >= punit->priv.ulLastBytes) &&  // overflow traffic check (>4GB)
               (ulTime > ulLastTime))                              // division check
              {
              punit->priv.ulCPS = (punit->priv.ulBytes - 
                                   punit->priv.ulLastBytes);

              timesync(&punit->priv.ulCPS, ulTime - ulLastTime);

              if(punit->priv.ulCPS > punit->priv.ulMaxCPS)
                punit->priv.ulMaxCPS = punit->priv.ulCPS;

              if(punit->priv.ulApproxCPS)
                {
                punit->priv.ulApproxCPS += punit->priv.ulCPS;
                punit->priv.ulApproxCPS >>= 1;
                }
              else
                punit->priv.ulApproxCPS = punit->priv.ulCPS;

              if(punit->priv.ulGraphIndex < MAXGRAPH)
                punit->priv.ulGraph[punit->priv.ulGraphIndex ++] = punit->priv.ulCPS;
              else
                {
                memcpy(&punit->priv.ulGraph[0], &punit->priv.ulGraph[1],
                       (MAXGRAPH-1)*sizeof(ULONG));

                punit->priv.ulGraph[MAXGRAPH-1] = punit->priv.ulCPS;
                }
              }

            punit->priv.ulLastBytes = punit->priv.ulBytes;
            }

          WinPostMsg(punit->Unit.hwnd, WM_USER, NULL, NULL);
          break;
          }
        }
      }

    ulLastTime = ulTime;

    DosWaitEventSem(punit->priv.hSem, -1L);
    DosResetEventSem(punit->priv.hSem, &ulTemp);
    }

  if(s != -1) soclose(s); // close socket

  free(pifm);
  }

DosCloseEventSem(punit->priv.hSem);
_endthread();
}

MRESULT	TraffMonPresParam(HWND hwnd, INT idAttr, PUNITTM pUnit)
{
BOOL fRepaint = TRUE;
HPS hps;

switch(idAttr)
  {
  case 0: // Scheme palette dropped
  GetItemFont(hwnd, pUnit->fcInfo[0].szFont);
  pUnit->fcInfo[0].lTextColor = GetItemTextColor(hwnd);
  pUnit->fcInfo[0].lBackColor = GetItemBackColor(hwnd);
  break;

  case PP_FOREGROUNDCOLOR:
  pUnit->fcInfo[0].lTextColor = GetItemTextColor(hwnd);
  break;

  case PP_BACKGROUNDCOLOR:
  pUnit->fcInfo[0].lBackColor = GetItemBackColor(hwnd);
  break;

  case PP_FONTNAMESIZE:
  GetItemFont(hwnd, pUnit->fcInfo[0].szFont);

  hps = WinGetPS(hwnd);
  CopyFontSettings(hps, pUnit->priv.hpsBuffer);
  WinReleasePS(hps);
  break;

  default: fRepaint = FALSE;
  }

if(fRepaint)
  {
  RECTL rcl;
  WinQueryWindowRect(hwnd, &rcl);
  WinInvalidateRect(hwnd, &rcl, FALSE);
  }

return (MRESULT)fRepaint;
}

MRESULT	EXPENTRY TraffMonWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
RECTL rcl;
HPS hps;
PUNITTM pUnit;
pUnit = (PUNITTM)WinQueryWindowULong(hwnd, 0L);

switch(msg)
  {
  case WM_CREATE:
  // Setup Unit instance data
  pUnit = (PUNITTM)mp1;
  pUnit->Unit.ulCounter = 0L;
  WinSetWindowULong(hwnd, 0L, (ULONG)pUnit);

  if(pUnit->Unit.fJustCreated)
    {
    pUnit->fcInfo[0].lTextColor = WinQuerySysColor(HWND_DESKTOP, SYSCLR_WINDOWSTATICTEXT, 0L);
    pUnit->fcInfo[0].lBackColor = WinQuerySysColor(HWND_DESKTOP, SYSCLR_BUTTONMIDDLE, 0L);
    strcpy(pUnit->fcInfo[0].szFont, "9.WarpSans");
    pUnit->fcInfo[1].szFont[0] = '\0';
    pUnit->fcInfo[1].lTextColor = 
    pUnit->fcInfo[1].lBackColor = WinQuerySysColor(HWND_DESKTOP, SYSCLR_MENUHILITEBGND, 0L);
    pUnit->szInterface[0] = '\0';
    WinPostMsg(hwnd, WM_COMMAND, (MPARAM)STIDC_UNITSETTINGS, (MPARAM)0L);
    }
  pUnit->Unit.ulRefresh = 1L;
  memset(&pUnit->priv, 0, sizeof(TRAFPRIVATE));
  SetItemFont(hwnd, pUnit->fcInfo[0].szFont);
  SetItemTextColor(hwnd, pUnit->fcInfo[0].lTextColor);
  SetItemBackColor(hwnd, pUnit->fcInfo[0].lBackColor);

/*  WinQueryWindowRect(hwnd, &rcl);
  hps = WinGetPS(hwnd);
  CreateGraphicsBuffer(&rcl, hps, &pUnit->priv.hpsBuffer, &pUnit->priv.hdcBuffer);
  WinReleasePS(hps);*/

  if(!DosCreateEventSem(NULL, &pUnit->priv.hSem, NULL, TRUE))
    _beginthread(traffscanthread, NULL, 32768, (PVOID)pUnit);
  break;

  case WM_SIZE: // recreate graphics buffer
//  if(pUnit->priv.hpsBuffer && pUnit->priv.hdcBuffer)
//    {
    DestroyGraphicsBuffer(pUnit->priv.hpsBuffer, pUnit->priv.hdcBuffer);

    WinQueryWindowRect(hwnd, &rcl);
    hps = WinGetPS(hwnd);
    CreateGraphicsBuffer(&rcl, hps, &pUnit->priv.hpsBuffer, &pUnit->priv.hdcBuffer);
    WinReleasePS(hps);
//    }
  break;

  case USTM_FILLGROUPTITLE:
    {
    PSZ pszTitle = (PSZ)mp1;
    sprintf(pszTitle, "%s (%s)", pUnit->szInterface,
            (pUnit->ulFlags & TMF_INCOMING) ? "Incoming" : "Outgoing");

    return (MRESULT)TRUE;
    }

  case u_WM_MOVEALONGWINDOW:
    {
    static CHAR buf[200];
    sprintf(buf, "Bytes: %ld  CPS: %ld\nMax: %ld  Ave: %ld",
            pUnit->priv.ulBytes,
            pUnit->priv.ulCPS,
            pUnit->priv.ulMaxCPS,
            pUnit->priv.ulApproxCPS);

    WinSendMsg(hwnd, USTM_FORCEHINT, (MPARAM)hwnd, MPFROMP(buf));
    break;
    }

  case USTM_REFRESHTIMER:
  pUnit->priv.fTerminate = FALSE;
  DosPostEventSem(pUnit->priv.hSem);
  break;

  case USTM_QUERYWIDTH:
  // Return default unit width
  return (MRESULT) 150L; // 150 pixels wide (default)

  case USTM_QUERYNBINFO:
    {
    PUNITNBINFO punbInfo = (PUNITNBINFO)mp1;
    static PSZ ppszfcInfo[] = {"Normal text", "Traffic graph"};
    static UNITPGINFO upgInfo;
    upgInfo.pszTabText = "Monitor";
    upgInfo.pszStatusText = "IP Traffic";
    upgInfo.res = hmod;
    upgInfo.id = IDR_TRAFFDLG;
    upgInfo.mp2InsertFlags =  MPFROM2SHORT((BKA_STATUSTEXTON |
                                            BKA_AUTOPAGESIZE |
                                            BKA_MAJOR), BKA_FIRST);
    upgInfo.pfnDlgProc = (PFNWP)TraffMonDlgProc;
    upgInfo.pCreateParams = (PVOID)pUnit;
    upgInfo.hwnd = NULLHANDLE;
    upgInfo.pupgInfoNext = NULL;
    punbInfo->sNumfcInfo = 2;
    punbInfo->ppszfcInfo = (PSZ*)ppszfcInfo;
    punbInfo->pfcInfo = &pUnit->fcInfo;
    punbInfo->pupgInfo = &upgInfo;
    punbInfo->idTurnTo = IDR_TRAFFDLG;
    punbInfo->hptrWindowIcon = hptrTraffic;
    return (MRESULT) TRUE;
    }

  case WM_USER: // thread signal
//  WinQueryWindowRect(hwnd, &rcl);
  WinInvalidateRect(hwnd, NULL, FALSE);
  break;

  case WM_PAINT:
  TraffMonPaint(hwnd, pUnit, FALSE);
  return (MRESULT)TRUE;

  case WM_PRESPARAMCHANGED:
  return TraffMonPresParam(hwnd, (INT)mp1, pUnit);
// 0.3.5
//  WinQueryWindowRect(hwnd, &rcl);
//  WinInvalidateRect(hwnd, &rcl, FALSE);
//  break;

  case WM_DESTROY:
  DestroyGraphicsBuffer(pUnit->priv.hpsBuffer, pUnit->priv.hdcBuffer);
  memset(&pUnit->priv, 0, sizeof(pUnit->priv));
  pUnit->priv.fTerminate = TRUE;
  DosPostEventSem(pUnit->priv.hSem);
  break;
  }

return WinDefWindowProc(hwnd, msg, mp1, mp2);
}

BOOL	TraffMonRegister(HAB _hab, HMODULE _hmod, PWCLASS _pwc)
{
_pwc->pszName = "IPLG_TraffClass";
_pwc->pszViewName = "IP Traffic";
_pwc->pszHelpFileName = "inetplug.hlp";
_pwc->ulHelpPanelID = 101;

_pwc->usMaxUnits = 0;
_pwc->usFlags = STUF_MANUAL | STUF_STATIC | STUF_NOHINT;

_pwc->ulFix = sizeof(UNITTM) - sizeof(TRAFPRIVATE);
_pwc->ulSafeAlloc = sizeof(UNITTM);

WinRegisterClass(_hab, _pwc->pszName, (PFNWP)TraffMonWndProc, CS_SIZEREDRAW, sizeof(PVOID));

hptrTraffic = WinLoadPointer(HWND_DESKTOP, _hmod, IDR_TRAFFIC);

return TRUE;
}

BOOL	TraffMonDeregister(HAB _hab, HMODULE _hmod)
{
if(hptrTraffic) WinDestroyPointer(hptrTraffic);

return TRUE;
}
