/* Rexx */
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'; Call SysLoadFuncs

/*  뢮  */
Address CMD '@Echo off'

/* * */

/* ࠥ ࠬ */
Parse Arg Parameters
If Pos( '--action=', Parameters ) = 0 then Exit

Language = 'En'; If Pos( '--language=russian', Parameters ) \= 0 then Language = 'Ru'
Uninstall = 0;   If Pos( '--action=uninstall', Parameters ) \= 0 then Uninstall = 1

/*  ⥪騩 ⠫ */
Parse Source OS2 Type Path

Last_slash = Lastpos( '\', Path ); Path = Substr( Path, 1, Last_slash - 1 )
Last_slash = Lastpos( '\', Path ); Path = Substr( Path, 1, Last_slash - 1 )

/* * */

/* ⠭ ⥫: */
If Uninstall = 0 then do
 Call CreateWPSIcons Path, Language
 Call StopEnhancer Path
 Call StartInspector Path

 Call ModifyConfigSys Path, Language
End
/* 塞 ⥫: */
Else do
 Call DeleteWPSIcons Path
 Call StopEnhancer Path
 Call UnlockFiles Path

 Call CleanConfigSys Path
End

/* 室 */
Exit

/* * */

/*   窨  ࠡ祬 ⮫  */

CreateWPSIcons: procedure 
Parse Arg Path, Language

/*    ⠢騬 ⥫ */
Path_to_Enhancer = Path || '\Enhancer'

/* / */

/*   ࠡ祬 ⮫ 䮫  窮 */
Background = Stream( Path || '\Install\Notes.bmp', 'C', 'Query Exists' )
If Background \= '' then Background = 'Background=' || Background

Icon_name = 'Nice Enhancer'

Icon = Stream( Path || '\Install\Nice-os2.ico', 'C', 'Query Exists' )
If Icon \= '' then Icon = 'IconFile=' || Icon

Call SysCreateObject 'WPFolder', Icon_name, '<WP_DESKTOP>', 'ObjectID=<WP_NICE>;' || Icon || ';' || Background, 'Replace'

/* / */

/*  窨 */
If Language = 'Ru' then Icon_name = 'Nice Enhancer^()'
Else Icon_name = 'Nice Enhancer^(daemon)'

Call SysCreateObject 'WPProgram', Icon_name, '<WP_NICE>', 'ExeName=' || Path || '\Install\StrtNice.exe', 'Replace'

If Language = 'Ru' then Icon_name = '⠭^'
Else Icon_name = 'Shutdown^daemon'

Call SysCreateObject 'WPProgram', Icon_name, '<WP_NICE>', 'ExeName=' || Path || '\Install\StopNice.exe', 'Replace'

If Language = 'Ru' then Icon_name = 'ன'
Else Icon_name = 'Control Center'

Icon = Stream( Path || '\Install\Nice-os2.ico', 'C', 'Query Exists' )
If Icon \= '' then Icon = 'IconFile=' || Icon

Call SysCreateObject 'WPFolder', Icon_name, '<WP_NICE>', 'ObjectID=<WP_NICE_OS2>;' || Icon || ';' || Background, 'Replace'

If Language = 'Ru' then do
 Icon_name = '㪮⢮'
 Help_name = Path_to_Enhancer || '\Nice-os2.inf ᯮ짮'
End
Else do
 Icon_name = 'About Nice Enhancer'
 Help_name = Path_to_Enhancer || '\Nice-os2.inf Using'
End

Icon = Stream( Path || '\Install\Text.ico', 'C', 'Query Exists' )
If Icon \= '' then Icon = 'IconFile=' || Icon

Call SysCreateObject 'WPProgram', Icon_name, '<WP_NICE>', 'ExeName=' || 'View.exe;Parameters=' || Help_name || ';' || Icon, 'Replace'

If Language = 'Ru' then Icon_name = ''
Else Icon_name = 'Rooms'

Icon = Stream( Path || '\Install\Rooms.ico', 'C', 'Query Exists' )
If Icon \= '' then Icon = 'IconFile=' || Icon

Call SysCreateObject 'WPFolder', Icon_name, '<WP_NICE>', 'ObjectID=<WP_ROOMS_FOLDER>;' || Icon || ';' || Background, 'Replace'

If Language = 'Ru' then Icon_name = ''
Else Icon_name = 'Utilites'

Icon = Stream( Path || '\Install\Utilites.ico', 'C', 'Query Exists' )
If Icon \= '' then Icon = 'IconFile=' || Icon

Call SysCreateObject 'WPFolder', Icon_name, '<WP_NICE>', 'ObjectID=<WP_ENHANCER_UTILITES>;' || Icon || ';' || Background, 'Replace'

If Language = 'Ru' then Icon_name = ' 䠩'
Else Icon_name = 'File names'

Call SysCreateObject 'WPProgram', Icon_name, '<WP_ENHANCER_UTILITES>', 'ObjectID=<WP_NAMES>;ExeName=' || Path || '\Utilites\Names\Names.exe', 'Replace'

If Language = 'Ru' then do
 Icon_name = ' ^⥪⮢ ०'
 Help_name = Path || '\Utilites\VIOFont\VIOFont.inf '
 Icon = Stream( Path || '\Install\Font.ico', 'C', 'Query Exists' )
 If Icon \= '' then Icon = 'IconFile=' || Icon
 Call SysCreateObject 'WPProgram', Icon_name, '<WP_ENHANCER_UTILITES>', 'ExeName=' || 'View.exe;Parameters=' || Help_name || ';' || Icon, 'Replace'
End

/* / */

/*  窨  䮫 "ன" */
If Language = 'Ru' then Icon_name = '।^ࠦ'
Else Icon_name = 'Advanced scrolling'

Icon = Stream( Path || '\Install\Scr_page.ico', 'C', 'Query Exists' )
If Icon \= '' then Icon = 'IconFile=' || Icon

Call SysCreateObject 'WPProgram', Icon_name, '<WP_NICE_OS2>', 'ExeName=' || Path_to_Enhancer || '\Nice-aos.exe;Parameters=ControlCenter_Scrolling;' || Icon, 'Replace'

If Language = 'Ru' then Icon_name = '譨  '
Else Icon_name = 'Window frames'

Icon = Stream( Path || '\Install\Drw_page.ico', 'C', 'Query Exists' )
If Icon \= '' then Icon = 'IconFile=' || Icon

Call SysCreateObject 'WPProgram', Icon_name, '<WP_NICE_OS2>', 'ExeName=' || Path_to_Enhancer || '\Nice-aos.exe;Parameters=ControlCenter_Drawing;' || Icon, 'Replace'

If Language = 'Ru' then Icon_name = ''
Else Icon_name = 'Rooms'

Icon = Stream( Path || '\Install\Rms_page.ico', 'C', 'Query Exists' )
If Icon \= '' then Icon = 'IconFile=' || Icon

Call SysCreateObject 'WPProgram', Icon_name, '<WP_NICE_OS2>', 'ExeName=' || Path_to_Enhancer || '\Nice-aos.exe;Parameters=ControlCenter_Rooms;' || Icon, 'Replace'

If Language = 'Ru' then Icon_name = '⮢ '
Else Icon_name = 'VIO windows'

Icon = Stream( Path || '\Install\Vio_page.ico', 'C', 'Query Exists' )
If Icon \= '' then Icon = 'IconFile=' || Icon

Call SysCreateObject 'WPProgram', Icon_name, '<WP_NICE_OS2>', 'ExeName=' || Path_to_Enhancer || '\Nice-aos.exe;Parameters=ControlCenter_VIO;' || Icon, 'Replace'

If Language = 'Ru' then Icon_name = ''
Else Icon_name = 'Keyboard'

Icon = Stream( Path || '\Install\Kbd_page.ico', 'C', 'Query Exists' )
If Icon \= '' then Icon = 'IconFile=' || Icon

Call SysCreateObject 'WPProgram', Icon_name, '<WP_NICE_OS2>', 'ExeName=' || Path_to_Enhancer || '\Nice-aos.exe;Parameters=ControlCenter_Keyboard;' || Icon, 'Replace'

If Language = 'Ru' then Icon_name = ''
Else Icon_name = 'Mouse'

Icon = Stream( Path || '\Install\Mse_page.ico', 'C', 'Query Exists' )
If Icon \= '' then Icon = 'IconFile=' || Icon

Call SysCreateObject 'WPProgram', Icon_name, '<WP_NICE_OS2>', 'ExeName=' || Path_to_Enhancer || '\Nice-aos.exe;Parameters=ControlCenter_Mouse;' || Icon, 'Replace'

If Language = 'Ru' then Icon_name = 'ᯮ^'
Else Icon_name = 'Window placement'

Icon = Stream( Path || '\Install\Wnd_page.ico', 'C', 'Query Exists' )
If Icon \= '' then Icon = 'IconFile=' || Icon

Call SysCreateObject 'WPProgram', Icon_name, '<WP_NICE_OS2>', 'ExeName=' || Path_to_Enhancer || '\Nice-aos.exe;Parameters=ControlCenter_WindowPlacement;' || Icon, 'Replace'

If Language = 'Ru' then Icon_name = ''
Else Icon_name = 'Dialog boxes'

Icon = Stream( Path || '\Install\Dlg_page.ico', 'C', 'Query Exists' )
If Icon \= '' then Icon = 'IconFile=' || Icon

Call SysCreateObject 'WPProgram', Icon_name, '<WP_NICE_OS2>', 'ExeName=' || Path_to_Enhancer || '\Nice-aos.exe;Parameters=ControlCenter_DialogBoxes;' || Icon, 'Replace'

If Language = 'Ru' then Icon_name = 'ਮ'
Else Icon_name = 'Priority'

Icon = Stream( Path || '\Install\Pty_page.ico', 'C', 'Query Exists' )
If Icon \= '' then Icon = 'IconFile=' || Icon

Call SysCreateObject 'WPProgram', Icon_name, '<WP_NICE_OS2>', 'ExeName=' || Path_to_Enhancer || '\Nice-aos.exe;Parameters=ControlCenter_Priority;' || Icon, 'Replace'

If Language = 'Ru' then Icon_name = '᮪ '
Else Icon_name = 'Window list'

Icon = Stream( Path || '\Install\Lst_page.ico', 'C', 'Query Exists' )
If Icon \= '' then Icon = 'IconFile=' || Icon

Call SysCreateObject 'WPProgram', Icon_name, '<WP_NICE_OS2>', 'ExeName=' || Path_to_Enhancer || '\Nice-aos.exe;Parameters=ControlCenter_WinList;' || Icon, 'Replace'

If Language = 'Ru' then Icon_name = '⪨'
Else Icon_name = 'System patches'

Icon = Stream( Path || '\Install\Dsk_page.ico', 'C', 'Query Exists' )
If Icon \= '' then Icon = 'IconFile=' || Icon

Call SysCreateObject 'WPProgram', Icon_name, '<WP_NICE_OS2>', 'ExeName=' || Path_to_Enhancer || '\Nice-aos.exe;Parameters=ControlCenter_SysPatches;' || Icon, 'Replace'

/* / */

/*  窨  䮫 "" */
If Language = 'Ru' then Icon_name = '1.  '
Else Icon_name = '1. Western room'

Icon = Stream( Path || '\Install\Western.ico', 'C', 'Query Exists' )
If Icon \= '' then Icon = 'IconFile=' || Icon

Call SysCreateObject 'WPProgram', Icon_name, '<WP_ROOMS_FOLDER>', 'ObjectID=<WP_WESTERN_ROOM>;ExeName=' || Path || '\Enhancer\Control\Room.exe' || ';Parameters=Western;' || Icon, 'Replace'

If Language = 'Ru' then Icon_name = '2. ୠ '
Else Icon_name = '2. Northern room'

Icon = Stream( Path || '\Install\Northern.ico', 'C', 'Query Exists' )
If Icon \= '' then Icon = 'IconFile=' || Icon

Call SysCreateObject 'WPProgram', Icon_name, '<WP_ROOMS_FOLDER>', 'ObjectID=<WP_NORTHERN_ROOM>;ExeName=' || Path || '\Enhancer\Control\Room.exe' || ';Parameters=Northern;' || Icon, 'Replace'

If Language = 'Ru' then Icon_name = '3. 稩 ⮫'
Else Icon_name = '3. Desktop'

Icon = Stream( Path || '\Install\Desktop.ico', 'C', 'Query Exists' )
If Icon \= '' then Icon = 'IconFile=' || Icon

Call SysCreateObject 'WPProgram', Icon_name, '<WP_ROOMS_FOLDER>', 'ObjectID=<WP_DESKTOP_ROOM>;ExeName=' || Path || '\Enhancer\Control\Room.exe' || ';Parameters=Desktop;' || Icon, 'Replace'

If Language = 'Ru' then Icon_name = '4.  '
Else Icon_name = '4. Southern room'

Icon = Stream( Path || '\Install\Southern.ico', 'C', 'Query Exists' )
If Icon \= '' then Icon = 'IconFile=' || Icon

Call SysCreateObject 'WPProgram', Icon_name, '<WP_ROOMS_FOLDER>', 'ObjectID=<WP_SOUTHERN_ROOM>;ExeName=' || Path || '\Enhancer\Control\Room.exe' || ';Parameters=Southern;' || Icon, 'Replace'

If Language = 'Ru' then Icon_name = '5. 筠 '
Else Icon_name = '5. Eastern room'

Icon = Stream( Path || '\Install\Eastern.ico', 'C', 'Query Exists' )
If Icon \= '' then Icon = 'IconFile=' || Icon

Call SysCreateObject 'WPProgram', Icon_name, '<WP_ROOMS_FOLDER>', 'ObjectID=<WP_EASTERN_ROOM>;ExeName=' || Path || '\Enhancer\Control\Room.exe' || ';Parameters=Eastern;' || Icon, 'Replace'

/* / */

/*  ⥭  䮫 "OS/2 System" */
Call SysCreateShadow '<WP_NICE>', '<WP_CONFIG>'

/*  */
Return

/* * */

/*   窨  ࠡ祬 ⮫  */

DeleteWPSIcons: procedure
Parse Arg Path

/* 塞 窨 */
Call SysDestroyObject '<WP_NICE>'

/*  */
Return

/* * */

/*  ᪠  ਫ  */

StartInspector: procedure 
Parse Arg Path

/* ᪠  ਫ */
Address CMD '' || Path || '\Enhancer\Inspectr\Inspectr.exe'

/*  */
Return

/* * */

/*  ⠭ ⥫  */

StopEnhancer: procedure 
Parse Arg Path

/* ⠭ ⥫, ᫨   饭 */
Address CMD '' || Path || '\Install\StopNice.exe'

/*  ஥ ६ */
Call SysSleep 1

/*  */
Return

/* * */

/*  ᢮ 䠩  */

UnlockFiles: procedure 
Parse Arg Path

/* ᢮ 䠩 */
Address CMD 'Call ' || Path || '\Install\Unlock.exe "' || Path || '\Enhancer\Nice-os2.exe"'
Address CMD 'Call ' || Path || '\Install\Unlock.exe "' || Path || '\Enhancer\Nice-os2.dll"'
Address CMD 'Call ' || Path || '\Install\Unlock.exe "' || Path || '\Enhancer\Nice-aos.exe"'

/*  */
Return

/* * */

/*   ப  䠩 "Config.sys"  */

ModifyConfigSys: procedure 
Parse Arg Path, Language

/*  ६ */
Line_break = X2C( '0D' ) || X2C( '0A' )

Path_to_Enhancer = Path || '\Enhancer'
Parse Upper Var Path_to_Enhancer Path_to_Enhancer
Drive = Left( Value( 'Comspec', , 'OS2Environment' ), 1 )

/* / */

/* ⠥ Config.sys */
Content = ReadConfigSys( Drive ); If Content = '' then Exit

/* ᫨  ६ 㤥 祭 - 䠩 㤥  */
Modify_Config_sys = 0

/* / */

/* 室  ⥪ ப "LIBPATH", 室 "REM ..." */
Libpath_string = Line_break || 'LIBPATH'
Position = Pos( Libpath_string, Content )

If Position \= 0 then do
 /* 뤥塞  ப */
 First_part = Left( Content, Position + 1 )
 Second_part = Right( Content, Length( Content ) - Position )

 End_of_line = Pos( Line_break, Second_part ) - 1
 Libpath = Substr( Second_part, 1, End_of_line )
 Second_part = Substr( Second_part, End_of_line + 1 )

 Parse Var Libpath Setting_name '=' Libpath
 Libpath = Strip( Libpath )

 /* ᫨  ப  ᮤন 뫪  ⥪騩 ⠫ - 塞  */
 Save_settings = 0

 If Pos( '.;', Libpath ) = 0 then do
  Libpath = '.;' || Libpath

  Save_settings = 1
 End

 /* ᫨  ப  ᮤন   ⥫ - 塞  */
 If Pos( Path_to_Enhancer, Libpath ) = 0 then do
  /* ப  ᮤঠ ।騩  -      */
  Previous_path = ''

  Parse Var Libpath Before '\Enhancer' After

  If Before = Libpath then
   Parse Var Libpath Before '\ENHANCER' After

  If Before = Libpath then
   Parse Var Libpath Before '\enhancer' After

  If Before = Libpath then
   Before = ''

  If Before \= '' | After \= '' then do
   /* 頥 ப */
   Count = Length( Before )

   Do While Count > 0
    Previous_path = Right( Before, 1 ) || Previous_path
    Before = Left( Before, Length( Before ) - 1 )

    If Right( Before, 1 ) = ';' then Leave
    Count = Count - 1
   End

   /* 塞 ப */
   If Left( After, 1 ) = ';' then After = Substr( After, 2, Length( After ) - 1 )
   Libpath = Before || After
  End

  /* 塞  ப   ⥫ */
  Config_Path_string = Path_to_Enhancer

  If Right( Libpath, 1 ) \= ';' then Config_Path_string = ';' || Config_Path_string
  Libpath = Libpath || Config_Path_string

  Save_settings = 1
 End

 /* ன  㤥 ࠭ */
 If Save_settings then do
  /* ⠢ ன */
  Content = First_part || 'LIBPATH=' || Libpath || Second_part

  If Right( Content, 2 ) = Line_break then
   Content = Substr( Content, 1, Length( Content ) - 2 )

  /* ,     ᠭ */
  Modify_Config_sys = 1
 End
End

/* / */

/* 塞 ப ᪠ MMKbd  MPTSINI */
Patch_name = ''
Patch_name.MC = 'MMKbd.exe'
Patch_name.UC = 'MMKBD.EXE'
Patch_name.LC = 'mmkbd.exe'

Position_1 = Pos( Patch_name.MC, Content )
Position_2 = Pos( Patch_name.UC, Content )
Position_3 = Pos( Patch_name.LC, Content )

If Position_1 = 0 & Position_2 = 0 & Position_3 = 0 then do
 /* 塞 ப */
 String = 'RUN=' || Path_to_Enhancer || '\SysPatch\' || Patch_name.MC
 Parse Upper Var String String
 Inserted = 0

 If Inserted = 0 & Pos( 'REM [ Executables ]', Content ) = 0 & ,
                   Pos( 'REM [ EXECUTABLES ]', Content ) = 0 then do
  Content = Content || Line_break
  Content = Content || String
  Inserted = 1
 End

 If Inserted = 0 & Pos( 'REM [ Executables ]', Content ) \= 0 then do
  Parse Var Content Before 'REM [ Executables ]' After

  Content = Before || 'REM [ Executables ]' || Line_break
  Content = Content || String
  Content = Content || After
  Inserted = 1
 End

 If Inserted = 0 & Pos( 'REM [ EXECUTABLES ]', Content ) \= 0 then do
  Parse Var Content Before 'REM [ EXECUTABLES ]' After

  Content = Before || 'REM [ EXECUTABLES ]' || Line_break
  Content = Content || String
  Content = Content || After
  Inserted = 1
 End

 /* ,  ன   ᠭ */
 Modify_Config_sys = 1
End

/* / */

/* 뢠 ன, ᫨  ॡ */
If Modify_Config_sys then do
 Call WriteConfigSys Drive, Content
 Call SayAboutConfigSys Language
End

/*  */
Return

/* * */

/*   ப  䠩 "Config.sys"  */

CleanConfigSys: procedure 
Parse Arg Path

/*  ६ */
Line_break = X2C( '0D' ) || X2C( '0A' )

Path_to_Enhancer = Path || '\Enhancer'
Parse Upper Var Path_to_Enhancer Path_to_Enhancer
Drive = Left( Value( 'Comspec', , 'OS2Environment' ), 1 )

/* / */

/* ⠥ Config.sys */
Content = ReadConfigSys( Drive ); If Content = '' then Exit

/* ᫨  ६ 㤥 祭 - 䠩 㤥  */
Modify_Config_sys = 0

/* / */

/* 塞 ப */
Do Count = 1 to 3
 /* 롨ࠥ ப  㤠 */
 String = ''
 If Count = 1 then String = Path_to_Enhancer || ';'
 If Count = 2 then String = Path_to_Enhancer
 If Count = 3 then String = 'RUN=' || Path_to_Enhancer || '\SYSPATCH\MMKBD.EXE' || Line_break

 /* 塞  */
 Position = Pos( String, Content )

 If Position \= 0 then do
  Content = Substr( Content, 1, Position - 1 ) || Substr( Content, Position + Length( String ) )

  Modify_Config_sys = 1
 End
End

/* / */

/* 뢠 ன, ᫨  ॡ */
If Modify_Config_sys then do
 Call WriteConfigSys Drive, Content
End

/*  */
Return

/* * */

/*  ⠥ 䠩 "Config.sys"  */

ReadConfigSys: procedure 
Parse Arg Drive

/* 뢠 䠩 */
Config_file = Drive || ':\Config.sys'
Content = CharIn( Config_file, , Chars( Config_file ) )
Call Stream Config_file, 'C', 'Close'

/* 塞  ப   䠩 */
Do 12
 Text = Content
 Content = Strip( Content, 'B', X2C( '0A' ) )
 Content = Strip( Content, 'B', X2C( '0D' ) )

 If Content = Text then Leave
End

/*  */
Return Content

/* * */

/*   䠩 "Config.sys"  */

WriteConfigSys: procedure 
Parse Arg Drive, Content

/* २뢠 䠩 "Config.sys" */
Config_file = Drive || ':\Config.sys'

Address CMD 'Del /F ' Drive || ':\Config.nic' || ' >NUL 2>NUL'
Address CMD 'Attrib -R -H -S ' || Config_file || ' >NUL 2>NUL'
Address CMD 'Ren ' || Config_file || ' Config.nic' || ' >NUL 2>NUL'

/* ࠭塞 ன */
Call LineOut Config_file, Content, 1
Call Stream Config_file, 'C', 'Close'

/*  */
Return

/* * */

/*  頥 짮⥫  ⮬,  㦭 १㧪  */

SayAboutConfigSys: procedure 
Parse Arg Language

/* 뢠 㭪  ⮡ࠦ ᮮ饭 */
If Language = 'Ru' then do
 Call RxMessageBox '⠭ 襭.  믮 १㧪 ', 'Nice Enhancer', 'OK', 'Information'
 Call RxMessageBox '१㧪 㦭  ⮣, ⮡ ਬ ன  "Config.sys"', 'Nice Enhancer', 'OK', 'Warning'
End
Else do
 Call RxMessageBox 'Installation complete. Now reboot your computer', 'Nice Enhancer', 'OK', 'Information'
 Call RxMessageBox 'Reboot is necessary to apply new settings in "Config.sys"', 'Nice Enhancer', 'OK', 'Warning'
End

/*  */
Return

