/* Makes a WPS object out of the filepath it receives as an argument. */

/* GNU GENERAL PUBLIC LICENSE */

/* TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION */

/*  0. This License applies to any program or other work which contains */
/* a notice placed by the copyright holder saying it may be distributed */
/* under the terms of this General Public License.  The "Program", below, */
/* refers to any such program or work, and a "work based on the Program" */
/* means either the Program or any derivative work under copyright law:  */
/* that is to say, a work containing the Program or a portion of it, */
/* either verbatim or with modifications and/or translated into another */
/* language.  (Hereinafter, translation is included without limitation in */
/* the term "modification".)  Each licensee is addressed as "you". */

/* Activities other than copying, distribution and modification are not */
/* covered by this License; they are outside its scope.  The act of */
/* running the Program is not restricted, and the output from the Program */
/* is covered only if its contents constitute a work based on the */
/* Program (independent of having been made by running the Program).  */
/* Whether that is true depends on what the Program does. */

/*  1. You may copy and distribute verbatim copies of the Program's */
/* source code as you receive it, in any medium, provided that you */
/* conspicuously and appropriately publish on each copy an appropriate */
/* copyright notice and disclaimer of warranty; keep intact all the */
/* notices that refer to this License and to the absence of any warranty; */
/* and give any other recipients of the Program a copy of this License */
/* along with the Program.  */

/* You may charge a fee for the physical act of transferring a copy, and */
/* you may at your option offer warranty protection in exchange for a */
/* fee.  */

/*  2. You may modify your copy or copies of the Program or any portion */
/* of it, thus forming a work based on the Program, and copy and */
/* distribute such modifications or work under the terms of Section 1 */
/* above, provided that you also meet all of these conditions:  */

/*    a) You must cause the modified files to carry prominent notices */
/*    stating that you changed the files and the date of any change. */

/*    b) You must cause any work that you distribute or publish, that in */
/*    whole or in part contains or is derived from the Program or any */
/*    part thereof, to be licensed as a whole at no charge to all third */
/*    parties under the terms of this License.  */

/*    c) If the modified program normally reads commands interactively */
/*    when run, you must cause it, when started running for such */
/*    interactive use in the most ordinary way, to print or display an */
/*    announcement including an appropriate copyright notice and a */
/*    notice that there is no warranty (or else, saying that you provide */
/*    a warranty) and that users may redistribute the program under */
/*    these conditions, and telling the user how to view a copy of this */
/*    License.  (Exception: if the Program itself is interactive but */
/*    does not normally print such an announcement, your work based on */
/*    the Program is not required to print an announcement.)  */

/* These requirements apply to the modified work as a whole.  If */
/* identifiable sections of that work are not derived from the Program, */
/* and can be reasonably considered independent and separate works in */
/* themselves, then this License, and its terms, do not apply to those */
/* sections when you distribute them as separate works.  But when you */
/* distribute the same sections as part of a whole which is a work based */
/* on the Program, the distribution of the whole must be on the terms of */
/* this License, whose permissions for other licensees extend to the */
/* entire whole, and thus to each and every part regardless of who wrote */
/* it.  */


/* Thus, it is not the intent of this section to claim rights or contest */
/* your rights to work written entirely by you; rather, the intent is to */
/* exercise the right to control the distribution of derivative or */
/* collective works based on the Program.  */

/* In addition, mere aggregation of another work not based on the Program */
/* with the Program (or with a work based on the Program) on a volume of */
/* a storage or distribution medium does not bring the other work under */
/* the scope of this License.    */

/*  3. You may copy and distribute the Program (or a work based on it, */
/* under Section 2) in object code or executable form under the terms of */
/* Sections 1 and 2 above provided that you also do one of the following: */

/*    a) Accompany it with the complete corresponding machine-readable */
/*    source code, which must be distributed under the terms of Sections */
/*    1 and 2 above on a medium customarily used for software inter- */
/*    change; or, */

/*    b) Accompany it with a written offer, valid for at least three */
/*    years, to give any third party, for a charge no more than your */
/*    cost of physically performing source distribution, a complete */
/*    machine-readable copy of the corresponding source code, to be */
/*    distributed under the terms of Sections 1 and 2 above on a medium */
/*    customarily used for software interchange; or, */

/*    c) Accompany it with the information you received as to the offer */
/*    to distribute corresponding source code.  (This alternative is */
/*    allowed only for noncommercial distribution and only if you */
/*    received the program in object code or executable form with such */
/*    an offer, in accord with Subsection b above.)  */

/* The source code for a work means the preferred form of the work for */
/* making modifications to it.  For an executable work, complete source */
/* code means all the source code for all modules it contains, plus any */
/* associated interface definition files, plus the scripts used to */
/* control compilation and installation of the executable.  However, as a */
/* special exception, the source code distributed need not include */
/* anything that is normally distributed (in either source or binary */
/* form) with the major components (compiler, kernel, and so on) of the */
/* operating system on which the executable runs, unless that component */
/* itself accompanies the executable.    */

/* If distribution of executable or object code is made by offering */
/* access to copy from a designated place, then offering equivalent */
/* access to copy the source code from the same place counts as */
/* distribution of the source code, even though third parties are not */
/* compelled to copy the source along with the object code.  */

/*  4. You may not copy, modify, sublicense, or distribute the Program */
/* except as expressly provided under this License.  Any attempt */
/* otherwise to copy, modify, sublicense or distribute the Program is */
/* void, and will automatically terminate your rights under this License.  */
/* However, parties who have received copies, or rights, from you under */
/* this License will not have their licenses terminated so long as such */
/* parties remain in full compliance.    */

/*  5. You are not required to accept this License, since you have not */
/* signed it.    However, nothing else grants you permission to modify or */
/* distribute the Program or its derivative works.  These actions are */
/* prohibited by law if you do not accept this License.  Therefore, by */
/* modifying or distributing the Program (or any work based on the */
/* Program), you indicate your acceptance of this License to do so, and */
/* all its terms and conditions for copying, distributing or modifying */
/* the Program or works based on it.  */

/*  6. Each time you redistribute the Program (or any work based on the */
/* Program), the recipient automatically receives a license from the */
/* original licensor to copy, distribute or modify the Program subject to */
/* these terms and conditions.  You may not impose any further */
/* restrictions on the recipients' exercise of the rights granted herein.  */
/* You are not responsible for enforcing compliance by third parties to */
/* this License.  */

/*  7. If, as a consequence of a court judgment or allegation of patent */
/* infringement or for any other reason (not limited to patent issues), */
/* conditions are imposed on you (whether by court order, agreement or */
/* otherwise) that contradict the conditions of this License, they do not */
/* excuse you from the conditions of this License.  If you cannot */
/* distribute so as to satisfy simultaneously your obligations under this */
/* License and any other pertinent obligations, then as a consequence you */
/* may not distribute the Program at all.  For example, if a patent */
/* license would not permit royalty-free redistribution of the Program by */
/* all those who receive copies directly or indirectly through you, then */
/* the only way you could satisfy both it and this License would be to */
/* refrain entirely from distribution of the Program.    */

/* If any portion of this section is held invalid or unenforceable under */
/* any particular circumstance, the balance of the section is intended to */
/* apply and the section as a whole is intended to apply in other */
/* circumstances.  */

/* It is not the purpose of this section to induce you to infringe any */
/* patents or other property right claims or to contest validity of any */
/* such claims; this section has the sole purpose of protecting the */
/* integrity of the free software distribution system, which is */
/* implemented by public license practices.  Many people have made */
/* generous contributions to the wide range of software distributed */
/* through that system in reliance on consistent application of that */
/* system; it is up to the author/donor to decide if he or she is willing */
/* to distribute software through any other system and a licensee cannot */
/* impose that choice.  */

/* This section is intended to make thoroughly clear what is believed to */
/* be a consequence of the rest of this License.  */

/*  8. If the distribution and/or use of the Program is restricted in */
/* certain countries either by patents or by copyrighted interfaces, the */
/* original copyright holder who places the Program under this License */
/* may add an explicit geographical distribution limitation excluding */
/* those countries, so that distribution is permitted only in or among */
/* countries not thus excluded.  In such case, this License incorporates */
/* the limitation as if written in the body of this License.  */

/*  9. The Free Software Foundation may publish revised and/or new */
/* versions of the General Public License from time to time.  Such new */
/* versions will be similar in spirit to the present version, but may */
/* differ in detail to address new problems or concerns.  */

/* Each version is given a distinguishing version number.  If the Program */
/* specifies a version number of this License which applies to it and */
/* "any later version", you have the option of following the terms and */
/* conditions either of that version or of any later version published by */
/* the Free Software Foundation.  If the Program does not specify a */
/* version number of this License, you may choose any version ever pub- */
/* lished by the Free Software Foundation.  */

/*  10. If you wish to incorporate parts of the Program into other free */
/* programs whose distribution conditions are different, write to the */
/* author to ask for permission.  For software which is copyrighted by */
/* the Free Software Foundation, write to the Free Software Foundation; */
/* we sometimes make exceptions for this.  Our decision will be guided by */
/* the two goals of preserving the free status of all derivatives of our */
/* free software and of promoting the sharing and reuse of software */
/* generally.   */

/* NO WARRANTY */

/*  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO */
/* WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  */
/* EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR */
/* OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY */
/* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR */
/* PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE */
/* PROGRAM IS WITH YOU.   SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME */
/* THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.   */

/*  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN */
/* WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY */
/* AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU */
/* FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUEN-*/
/* TIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM */
/* (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED IN- */
/* ACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF */
/* THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER */
/* OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  */

/* END OF TERMS AND CONDITIONS */

/* MAIN                                          */

/* Initialize */
call on ERROR
call on FAILURE
call on HALT
call on NOTREADY
signal on NOVALUE
signal on SYNTAX

parse source OS Call_Mode My_Name
version = '1.05'
description = "Make Object"
copyright = "Copyright (C) 1999 by John Merryweather Cooper.  All rights reserved."
contact = 'jmcoopr@webmail.bmi.net'
freeware = "is free software.  The source includes the General Public License."
call LOAD_UTIL_FUNC 'SysLoadFuncs'
call SysLoadFuncs
program_filename = translate(filespec('NAME', My_Name))
program_name = BASENAME(My_Name)
call LOAD_UTIL_FUNC 'SysOS2Ver'
say "REXX <" || Call_Mode || "> " || BASENAME(My_Name) || " on " || OS || " v." || SysOS2Ver() || ".  " || description || " v." || version || "."
say copyright
say contact
say
say program_name || ' ' || freeware
say

/* This program allows Unix-style path separator '/' */
arg path_name
path_name = translate(path_name, '\', '/')
if path_name = '' | path_name = '-?' | path_name = '--HELP' | arg() = 0 then
    call USAGE
else
do
    call LOAD_UTIL_FUNC 'SysFileTree'
    call SysFileTree path_name, 'treelist', 'FO', '**-*-'
    if treelist.0 > 1 then
    do I = 1 to treelist.0
     call MAIN_MAKEOBJECT treelist.I
    end I
    else
     call MAIN_MAKEOBJECT path_name
end  /* main program block */
exit

/* MAIN exit                                             */
exit

/* MAIN_MAKEOBJECT start */
MAIN_MAKEOBJECT:  procedure expose program_name
arg path_name
    if PATHNAME_EXISTS(path_name) \= '' then
    do
     ext = GET_TYPE(path_name)
     select
         when ext = 'EXE' then call MAKEPRG path_name
         when ext = 'INF' then call MAKEBOOK path_name
         when ext = 'HLP' then call MAKEHELP path_name
         when ext = 'PS' then call MAKEPS path_name
         when ext = 'PDF' then call MAKEPDF path_name
         when ext = 'HTML' then call MAKEHTML path_name
     otherwise call MAKESHADOW path_name
     end     /* select */
    end     /* if */
    else
    do
     say "Can't find "path_name"."
     say program_name || " <no argument>, -?, or --help for usage."
    end     /* else */
    return ""
/* MAIN_MAKEOBJECT end */

/* Error handling start */
ERROR:
return SAY_TRAP(sigl, "OS/2 program reports error.")

FAILURE:
return SAY_TRAP(sigl, "OS/2 program could not execute.")

HALT:
    rc = SAY_TRAP('', "User Abort Request.")
    say "Terminate " || BASENAME(program_name) || '?  Y/N'
    reply = translate(KEYPRESS())
    if left(reply,1) = 'Y' then exit rc; else return rc

NOTREADY:
return SAY_TRAP(sigl, "File system permission/exists error.")

NOVALUE:
    SAY_TRAP_EXIT(sigl, "Undefined variable(s).")

SYNTAX:
    SAY_TRAP_EXIT(sigl, errortext(rc))

/* User Trap */
FATAL_ERROR:
exit '1'

/* Error handling end */

/***************************************************************************/
/* Firewall:  END OF MAIN                                    */
say "Error:  Firewall breached--this message should never display!"
exit '1'
/* Firewall:  END OF MAIN                                    */
/***************************************************************************/

/* Procedure GET_TYPE start */
GET_TYPE:  procedure
arg path_name
    path_name = translate(path_name, '\', '/')
    if IS_EXECUTABLE(path_name) \= '' then
     return 'EXE'
    else if IS_ACROBAT(path_name) \= '' then
     return 'PDF'
    else if IS_HTML(path_name) \= '' then
     return 'HTML'
    else if IS_BOOK(path_name) \= '' then
     return 'INF'
    else if IS_HELP(path_name) \= '' then
     return 'HLP'
    else if IS_POSTSCRIPT(path_name) \= '' then
     return 'PS'
    else
     return ''
/* Procedure GET_TYPE end */

/* Procedure GET_TYPE_EA start */
GET_TYPE_EA:  procedure
arg path_name
    path_name = translate(path_name, '\', '/')
    call LOAD_UTIL_FUNC 'SysGetEA'
    type = ''
    if SysGetEA(path_name, '.TYPE', 'typeinfo') = 0 then
     parse var typeinfo 11 type
return type
/* Procedure GET_TYPE_EA end */

/* Procedure TEST_TYPE start */
TEST_TYPE:  procedure
parse arg type, test_type
return wordpos(test_type, type)
/* Procedure TEST_TYPE end */

/* Procedure GET_EXT start */
GET_EXT:  procedure
arg path_name
    path_name = translate(path_name, '\', '/')
    file_name = filespec('NAME', path_name)
return right(file_name, length(file_name) - lastpos(".", file_name))
/* Procedure GET_EXT end */

/* Procedure IS_EXECUTABLE start */
IS_EXECUTABLE:  procedure
arg path_name
    path_name = translate(path_name, '\', '/')
    type_string = GET_TYPE_EA(path_name)
    if TEST_TYPE(type_string, 'DOS Command File') \= 0 then
     return 'EXE'
    else if TEST_TYPE(type_string, 'Executable') \= 0 then
     return 'EXE'
    else if TEST_TYPE(type_string, 'OS/2 Command File') \= 0 then
     return 'EXE'
    else
    do
     extension = GET_EXT(path_name)
     select
         when extension = 'BAT' then return 'EXE'
         when extension = 'CMD' then return 'EXE'
         when extension = 'COM' then return 'EXE'
         when extension = 'EXE' then return 'EXE'
         otherwise return ''
     end /* select */
    end /* else */
/* Procedure IS_EXECUTABLE end */

/* Procedure IS_ACROBAT start */
IS_ACROBAT:  procedure
arg path_name
    path_name = translate(path_name, '\', '/')
    type_string = GET_TYPE_EA(path_name)
    if TEST_TYPE(type_string, 'Acrobat Document') \= 0 then
     return 'PDF'
    else
    do
     extension = GET_EXT(path_name)
     select
         when extension = 'PDF' then return 'PDF'
         otherwise return ''
     end /* select */
    end /* else */
/* Procedure IS_ACROBAT end */

/* Procedure IS_HTML start */
IS_HTML:  procedure
arg path_name
    path_name = translate(path_name, '\', '/')
    type_string = GET_TYPE_EA(path_name)
    if TEST_TYPE(type_string, 'HTML') \= 0 then
     return 'HTML'
    else if TEST_TYPE(type_string, 'text/html') \= 0 then
     return 'HTML'
    else
    do
     extension = GET_EXT(path_name)
     select
         when extension = 'HTM' then return 'HTML'
         when extension = 'HTML' then return 'HTML'
         otherwise return ''
     end /* select */
    end /* else */
/* Procedure IS_HTML end */

/* Procedure IS_BOOK start */
IS_BOOK:  procedure
arg path_name
    path_name = translate(path_name, '\', '/')
    extension = GET_EXT(path_name)
    select
     when extension = 'INF' then return 'INF'
     otherwise return ''
    end /* select */
/* Procedure IS_BOOK end */

/* Procedure IS_HELP start */
IS_HELP:  procedure
arg path_name
    path_name = translate(path_name, '\', '/')
    extension = GET_EXT(path_name)
    select
     when extension = 'HLP' then return 'HLP'
     otherwise return ''
    end /* select */
/* Procedure IS_HELP end */

/* Procedure IS_POSTSCRIPT start */
IS_POSTSCRIPT:  procedure
arg path_name
    path_name = translate(path_name, '\', '/')
    extension = GET_EXT(path_name)
    select
     when extension = 'PS' then return 'PS'
     when extension = 'EPS' then return 'PS'
     otherwise return ''
    end /* select */
/* Procedure IS_POSTSCRIPT end */

/* Procedure KEYPRESS start */
KEYPRESS:  procedure
    LOAD_UTIL_FUNC 'SysGetKey'

    /* Need to consume NUL byte of extended key codes */
    key = 0
    do while key = 0
     key = SysGetKey('NOECHO')
    end /* do */
return key
/* Procedure KEYPRESS end */

/* Procedure SAY_TRAP start */
SAY_TRAP:  procedure expose rc
parse arg error_line, message
    parse source os cm Prog_name

    trap_error = condition('C')
    say 'TRAP:  ' || BASENAME(Prog_name) || '(' || error_line || ') ' || message
    if (trap_error = 'ERROR') | (trap_error = 'FAILURE') then
     say condition('D') || ' is in ' || trap_error || ' with Return Code = ' || rc
    else if trap_error = 'NOVALUE' then
     say condition('D') || ' has ' || trap_error
    else if trap_error = 'HALT' then
     say BASENAME(Prog_name) || ' has ' || trap_error || 'ed'
    else if trap_error = 'SYNTAX' then
     say condition('D') || ' has ' || trap_error || ' error(s)'
    else if trap_error = 'NOTREADY' then
     say condition('D') || ' is ' || trap_error
    else
     say condition('D') || ' is in ' || trap_error
    say
    if (trap_error \= 'NOVALUE') & (trap_error \= 'SYNTAX') then say "Continuing . . ."
    say
return rc
/* Procedure SAY_TRAP end */

/* Procedure SAY_TRAP_EXIT start */
SAY_TRAP_EXIT:  procedure expose rc
parse arg fatal_line, message
    call SAY_FATAL 'Fatal Trap', '<---Trap Dump Follows--->'
    call SAY_TRAP fatal_line, message
    say '********** (' || fatal_line - 1 || ') **********'
    say sourceline(fatal_line - 1)
    say ""
    say 'VVVVVVVVVV (' || fatal_line || ') VVVVVVVVVV'
    say '>>' || sourceline(fatal_line)
    say 'AAAAAAAAAA (' || fatal_line || ') AAAAAAAAAA'
    say ""
    say sourceline(fatal_line + 1)
    say '********** (' || fatal_line + 1 || ') **********'
exit rc
/* Procedure SAY_TRAP_EXIT end */

/* Procedure SAY_FATAL start */
SAY_FATAL:  procedure
parse arg func_name, message
    parse source os cm Prg_Name
    say BASENAME(Prg_Name) || ":  " || func_name || " " || message
    say "Exiting . . ."
return ''
/* Procedure SAY_FATAL end */

/* Procedure LOAD_UTIL_FUNC  start */
LOAD_UTIL_FUNC:  procedure
parse arg func_name

    /* already loaded? */
    rc_query = RxFuncQuery(func_name)

    /* if SysLoadFuncs exists, then we'll assume that it has been called . . . loading all funcs */
    if func_name \= 'SysLoadFuncs' then rc_query = RxFuncQuery('SysLoadFuncs')
    if rc_query = 0 then return '0'

    /* attempt to load */
    rc_add = RxFuncAdd(func_name, 'RexxUtil', func_name)
    rc_query = RxFuncQuery(func_name)
    if (rc_add \= 0) | (rc_query \= 0) then
    do
     call SAY_FATAL func_name, "in RexxUtil.DLL failed to load.  Check LIBPATH."
     signal FATAL_ERROR
    end /* if do */
return '0'
/* Procedure LOAD_UTIL_FUNC end */

/* Procedure BASENAME start */
BASENAME:  procedure
arg path_name
    path_name = translate(path_name, '\', '/')
    /* take a filename or filepath and remove the last extension */
    path_name = filespec('NAME', path_name)
    if lastpos(".", path_name) \= 0 then
    do
     temp = left(path_name, lastpos(".", path_name) - 1)
     if temp \= '' then
         path_name = temp
     else  /* to handle files that only have an "extension" */
         path_name = '.'
    end     /* if */
return path_name
/* Procedure BASENAME end */

/* Procedure MAKEOBJECT start */
MAKEOBJECT:  procedure
parse arg obj_setup, obj_type, obj_raw_title

    call LOAD_UTIL_FUNC 'SysCreateObject'

    /* Create desktop objects based on "obj_setup" and "obj_type" with a */
    /* if raw_title is a filepath then chop to BASENAME */
    if stream(obj_raw_title, 'C', 'QUERY EXISTS') \= '' then
     title = BASENAME(obj_raw_title)
    else
    title = obj_raw_title

    /* try to create object */
    call SysCreateObject obj_type, title, '<WP_DESKTOP>', obj_setup, 'f'

    /* handle error created by pre-existing object with title clash */
    do while result = 0
     call INCREMENT_TITLE obj_type, title, obj_setup
   end      /* do until */
return result
/* Procedure MAKEOBJECT end */

/* Procedure MAKEPRG start */
MAKEPRG:  procedure
parse arg prog_name
    setup = ''
    /* create program objects for programs */
    setup = 'EXENAME='prog_name';PARAMETERS=%*'
    type = 'WPProgram'
    call MAKEOBJECT setup, type, prog_name
return result
/* Procedure MAKEPRG end */

/* Procedure MAKEBOOK start */
MAKEBOOK:  procedure
parse arg book_name
    setup = ''
    title = BOOK_TITLE(book_name)
    /* create view objects for books */
    setup = 'EXENAME=view.exe;PARAMETERS='book_name
    type = 'WPProgram'
    call MAKEOBJECT setup, type, title
return result
/* Procedure MAKEBOOK end */

/* Procedure MAKEHELP start */
MAKEHELP:  procedure
parse arg help_name
    setup = ''
    title = BOOK_TITLE(help_name)
    /* create view objects for help files */
    /* On Warp 4, you can find viewhelp.exe in your \mptn\bin path */
    /* Substitute your favorite browser as necessary */

    browser = 'viewhelp.exe'
    setup = 'EXENAME=' || browser || ';PARAMETERS=' || help_name
    type = 'WPProgram'
    call MAKEOBJECT setup, type, title
return result
/* Procedure MAKEHELP end */

/* Procedure MAKEPS start */
MAKEPS:  procedure
parse arg ps_name
    setup = ''
    /* create view objects for PostScript */
    /* GhostView needs to be in PATH or else you'll need to fully */
    /* qualify the executable below */

    browser = 'e:\gstools\gsview\gvpm.exe'

    setup = 'EXENAME=' || browser || ';PARAMETERS=' || ps_name
    type = 'WPProgram'
    call MAKEOBJECT setup, type, ps_name
return result
/* Procedure MAKEPS end */

/* Procedure MAKEPDF start */
MAKEPDF:  procedure
parse arg pdf_name
    setup = ''
    /* create view objects for Adobe Acrobat */
    /* Adobe Acrobat for OS/2 needs to be in the PATH */
    /* Alternately, one could use GhostView (see above) */

    browser = 'd:\acrobat3\reados2\acroread.exe'

    setup = 'EXENAME=' || browser || ';PARAMETERS=' || pdf_name
    type = 'WPProgram'
    call MAKEOBJECT setup, type, pdf_name
return result
/* Procedure MAKEPDF end */

/* Procedure MAKEHTML start */
MAKEHTML:  procedure
parse arg html_name
    setup = ''
    /* create view objects for html programming documents on my local drives */
    /* I prefer the Kiosk mode (-k option) for files */
    /* You may need to modify this option if netscape is not your default browser */

    browser_option = '-k'

    html_name = MAKE_ABSOLUTE(html_name)
    setup = 'URL=file:///' || html_name || ';PARAMETERS=' || browser_option
    type = 'WPUrl'
    title = HTML_TITLE(html_name)
    call MAKEOBJECT setup, type, title
return result
/* Procedure MAKEHTML end */

/* Procedure MAKESHADOW start */
MAKESHADOW:  procedure
parse arg shadow_name

    call LOAD_UTIL_FUNC 'SysCreateShadow'
    /* With Warp 4, SysCreateShadow "mechanizes" shadow creation and */
    /* it's therefore a better choice now than SysCreateObject */
    /* shadow_name must be an absolute path */
    shadow_name = MAKE_ABSOLUTE(shadow_name)
    call SysCreateShadow shadow_name, '<WP_DESKTOP>'
return result
/* Procedure MAKESHADOW end */

/* Procedure MAKE_ABSOLUTE start */
MAKE_ABSOLUTE:  procedure
arg path_name
    path_name = translate(path_name, '\', '/')
    cw_dir = directory()     /* push current working directory */

    /* check if directory/subdirectory */
    is_directory = directory(path_name)
    if is_directory = -1 | is_directory = 'X' then
     return path_name

    /* parse path_name */
    drive = filespec('DRIVE', path_name)
    path = filespec('PATH', path_name)
    name = filespec('NAME', path_name)

    /* substitute for missing parts--should only happen from command line */
    if drive = '' & path = '' then
    do
     drive = '.'
     path = '\'
    end /* if */

    if drive \= '' & path = '' then
    do
     new_drive_path = directory(drive)
     new_drive_path = new_drive_path || '\'
     path = filespec('PATH', new_drive_path)
    end /* if */

    if drive = '' & path \= '' then
     drive = filespec('DRIVE', cw_dir)
    abs_name = drive || path || name
    call directory cw_dir   /* pop current working directory */
return abs_name
/* Procedure MAKE_ABSOLUTE end */

/* Procedure TAB start */
TAB_REL:  procedure
parse arg tab_cnt, in_string
    in_string = copies('    ', tab_cnt) || in_string
return in_string
/* Procedure TAB end */

/* Procedure USAGE start */
USAGE:  procedure
    parse source OS Call_Mode My_Name
    program_filename = translate(filespec('NAME', My_Name))
    program_name = BASENAME(My_Name)
    say 'Usage:  ' || program_name || ' pathname'
    say
    say TAB_REL(1, '"pathname" may specify a file or a folder.')
    say TAB_REL(1, 'Wildcards are allowed in filespecs.')
    say
    say TAB_REL(1, 'Creates a WPS object on the desktop for pathname.')
    say TAB_REL(1, 'Excellent for drag and drop operation.')
    say
    say TAB_REL(1, 'Recognizes the following extensions:  ')
    say
    say TAB_REL(2, '.EXE    .COM    .CMD    .BAT')
    say TAB_REL(2, '.INF    .HLP    .PS     .PDF')
    say TAB_REL(2, '.HTM    .HTML   .EPS')
    say
    say TAB_REL(1, 'Original file taken from FM/2 utilities by M. Kimes')
    say TAB_REL(1, 'Extensively modified by John Merryweather Cooper :-)')
return ''
/* Procedure USAGE end */

/* Procedure BOOK_TITLE start */
BOOK_TITLE:  procedure
arg path_name
    path_name = translate(path_name, '\', '/')
    title_length = 0
    offset = 108
    title = 'Untitled:'

    /* title starts at 108 in INF file */
    /* determine length of title */
    do while chars(path_name) > 0
     c = charin(path_name, title_length + offset, 1)
     if c2d(c) = 0 then
         leave
     else
         title_length = title_length + 1
    end /* do */

    if title_length \= 0 then
     title = strip(charin(path_name, offset, title_length))
    else
     title = title || '  ' || BASENAME(path_name)
return MAP_OBJECT_TITLE(title)
/* Procedure BOOK_TITLE end */

/* Procedure MAP_OBJECT_TITLE start */
MAP_OBJECT_TITLE:  procedure
parse arg title
     /* translate ':./\' to '_' so title is not truncated */
     title = translate(title, '____', ':./\')
return title
/* Procedure MAP_OBJECT_TITLE end */

/* Procedure MAP_HTML_TITLE start */
MAP_HTML_TITLE:  procedure
parse arg title

    /* defined HTML special codes from the HTML 4.0 Reference */
    special_code.1 = '&reg;'
    special_code.2 = '&quot;  "'
    special_code.3 = '&lt;  <'
    special_code.4 = '&gt;  >'
    special_code.5 = '&OElig;'
    special_code.6 = '&oelig;'
    special_code.7 = '&Scaron;'
    special_code.8 = '&scaron;'
    special_code.9 = '&Yuml;  Y'
    special_code.10 = '&circ;'

    special_code.11 = '&tilde;  ~'
    special_code.12 = '&ensp;'
    special_code.13 = '&emsp;'
    special_code.14 = '&thinsp;'
    special_code.15 = '&zwnj;'
    special_code.16 = '&zwj;'
    special_code.17 = '&lrm;'
    special_code.18 = '&rlm;'
    special_code.19 = '&ndash;  -'
    special_code.20 = '&mdash;  --'

    special_code.21 = '&lsquo;  `'
    special_code.22 = "&rsquo;  '"
    special_code.23 = '&sbquo;'
    special_code.24 = '&ldquo;  "'
    special_code.25 = '&rdquo;  "'
    special_code.26 = '&bdquo;'
    special_code.27 = '&dagger;'
    special_code.28 = '&Dagger;'
    special_code.29 = '&permil;'
    special_code.30 = '&lsaquo;'

    special_code.31 = '&rsaquo;'
    special_code.32 = '&euro;'
    special_code.33 = '&nbsp;'
    special_code.34 = '&iexcl;'
    special_code.35 = '&cent;'
    special_code.36 = '&pound;'
    special_code.37 = '&curren;'
    special_code.38 = '&yen;'
    special_code.39 = '&brvbar;'
    special_code.40 = '&sect;'

    special_code.41 = '&uml;'
    special_code.42 = '&copy;'
    special_code.43 = '&ordf;'
    special_code.44 = '&laquo;'
    special_code.45 = '&not;'
    special_code.46 = '&shy;  -'
    special_code.47 = '&macr;'
    special_code.48 = '&deg;'
    special_code.49 = '&plusmn;'
    special_code.50 = '&sup2;';

    special_code.51 = '&sup3;'
    special_code.52 = '&acute;'
    special_code.53 = '&micro;'
    special_code.54 = '&para;'
    special_code.55 = '&middot;'
    special_code.56 = '&cedil;'
    special_code.57 = '&sup1;'
    special_code.58 = '&ordm;'
    special_code.59 = '&raquo;'
    special_code.60 = '&frac14;'

    special_code.61 = '&frac12;'
    special_code.62 = '&frac34;'
    special_code.63 = '&iquest;'
    special_code.64 = '&Agrave;  A'
    special_code.65 = '&AElig;'
    special_code.66 = '&Ccedil;  C'
    special_code.67 = '&Egrave;  E'
    special_code.68 = '&Eacute;  E'
    special_code.69 = '&Ecirc;  E'
    special_code.70 = '&Euml;  E'

    special_code.71 = '&Igrave;  I'
    special_code.72 = '&Iacute;  I'
    special_code.73 = '&Aacute;  A'
    special_code.74 = '&Acirc;  A'
    special_code.75 = '&Atilde;  A'
    special_code.76 = '&Auml;  A'
    special_code.77 = '&Icirc;  I'
    special_code.78 = '&Iuml;  I'
    special_code.79 = '&ETH;  D'
    special_code.80 = '&Ntiled;  N'

    special_code.81 = '&Ograve;  O'
    special_code.82 = '&Oacute;  O'
    special_code.83 = '&Ocirc;  O'
    special_code.84 = '&Otilde;  O'
    special_code.85 = '&Ouml;  O'
    special_code.86 = '&times;  O'
    special_code.87 = '&Oslash;  O'
    special_code.88 = '&Ugrave;  U'
    special_code.89 = '&Uacute;  U'
    special_code.90 = '&Ucirc;  U'

    special_code.91 = '&Uuml;  U'
    special_code.92 = '&Yacute;  Y'
    special_code.93 = '&THORN;  P'
    special_code.94 = '&szlig;  ss'
    special_code.95 = '&agrave;  a'
    special_code.96 = '&aacute;  a'
    special_code.97 = '&acirc;  a'
    special_code.98 = '&atilde;  a'
    special_code.99 = '&auml;  a'
    special_code.100 = '&aring;  a'

    special_code.101 = '&aelig;'
    special_code.102 = '&ccedil;  c'
    special_code.103 = '&egrave;  e'
    special_code.104 = '&eacute;  e'
    special_code.105 = '&ecirc;  e'
    special_code.106 = '&euml;  e'
    special_code.107 = '&igrave;  i'
    special_code.108 = '&iacute;  i'
    special_code.109 = '&icirc;  i'
    special_code.110 = '&iuml;  i'

    special_code.111 = '&eth;  d'
    special_code.112 = '&ntilde;  n'
    special_code.113 = '&ograve;  o'
    special_code.114 = '&oacute;  o'
    special_code.115 = '&ocirc;  o'
    special_code.116 = '&otilde;  o'
    special_code.117 = '&ouml;  o'
    special_code.118 = '&divide;'
    special_code.119 = '&oslash;  o'
    special_code.120 = '&ugrave;  u'

    special_code.121 = '&uacute;  u'
    special_code.122 = '&ucirc;  u'
    special_code.123 = '&uuml;  u'
    special_code.124 = '&yacute; y'
    special_code.125 = '&thorn;  p'
    special_code.126 = '&yuml;  y'
    special_code.0 = 126

    /* scan for special character codes listed in stem special code and delete */
    do index = 1 to special_code.0
     parse var special_code.index HTML_code replaces
     if pos(HTML_code, translate(title)) \= 0 then
         title = changestr(HTML_code, title, replaces)
    end /* do */
return MAP_OBJECT_TITLE(title)
/* Procedure MAP_HTML_TITLE end */

/* Procedure HTML_TITLE start */
HTML_TITLE:  procedure
arg path_name
    path_name = translate(path_name, '\', '/')
    title = 'Untitled:'
    title_start_line = 1
    title_end_line = 1

    /* find line for <TITLE> */
    do while lines(path_name) > 0
     line_buffer = linein(path_name, title_start_line, 1)
     if pos('<TITLE>', translate(line_buffer), 1) \= 0 then
         leave
     else
         title_start_line = title_start_line + 1
    end /* do */

    /* find line for </TITLE> */
    title_end_line = title_start_line
    ln = 1
    if pos('</TITLE>', translate(line_buffer), 1) \= 0 then
     raw_title = line_buffer
    else
    do while lines(path_name) > 0
     title_buffer.ln = linein(path_name, title_end_line, 1)
     if pos('</TITLE>', title_buffer.ln, 1) \= 0 then
         leave
     else
     do
         title_end_line = title_end_line + 1
         ln = ln + 1
     end /* do */

     /* concat raw title, if needed */
     if title_buffer.0 > 1 then
     do I = 1 to ln
         raw_title = raw_title || title_buffer.ln
     end I
    end /* do */

    /* strip TITLE HTML codes and spaces */
    parse var raw_title junk_before '>' title '<' junk_after
    title = strip(title)
    title_length = length(title)

    if title_length = 0 then
     title = 'Untitled:  ' || BASENAME(path_name)
return MAP_HTML_TITLE(title)
/* Procedure HTML_TITLE end */

/* Procedure PATHNAME_EXISTS start */
PATHNAME_EXISTS:  procedure
arg path_name
    path_name = translate(path_name, '\', '/')
    it_exists = ''

    path_name = MAKE_ABSOLUTE(path_name)

    /* if path_name is a filepath then it_exists */
    if stream(path_name, 'C', 'QUERY EXISTS') \= '' then
     it_exists = path_name
    /* else if path_name is a directory then it_exists */
    else
    do
    cw_dir = directory()     /* push current working directory */
    dir_flag = directory(path_name)

    if dir_flag \= -1 & dir_flag \= 'X' & dir_flag \= '' then
     it_exists = path_name
   /* else path_name does not exist */
    else
     it_exists = ''

    call directory cw_dir   /* pop current working directory */
    end /* else */

return it_exists
/* Procedure PATHNAME_EXISTS end */

/* Procedure INCREMENT_TITLE start */
INCREMENT_TITLE:  procedure
parse arg type, title, setup
    /* handle error created by pre-existing object with title clash */
    suffix = c2x('1')
    do forever
     new_title = title || ':' || x2c(suffix)
     call SysCreateObject type, new_title, '<WP_DESKTOP>', setup, 'f'
     if result \= 0 then
         leave
     else
         suffix = suffix + 1
   end      /* do */
return title
/* Procedure INCREMENT_TITLE end */

/*******************************************************************/
/*  HISTORY */
/*******************************************************************/

/* Version History */

/* 1.00:  original version */
/* 1.01:  Added ability to search INF files for titles--06/01/1999 */
/* 1.02:  Added ability to search HTML files for titles--06/02/1999 */
/* 1.03:  Added improved error checking--06/05/1999 */
/* 1.04:  Added wildcard support; fixed HTML title bug; added support */
/*     for titles with *.HLP files--06/27/1999 */
/* 1.05:  Added support the EA .TYPE in addition to extensions for */
/*     standard extensions--06/27/1999 */
