#define ID_RESOURCE             1
#define ID_ICON                 ID_RESOURCE
#define ID_BITMAP_JCLOGO        2
#define ID_BITMAP_SWITCH        3

#define ID_MENUMENU             1000
#define ID_MENUTASK             2000
#define ID_MENUCLOCK            3000

#define IDM_MNU_DESKTOP         1010
#define IDM_MNU_CONNECTIONS     1020
#define IDM_MNU_SETUP           1030
#define IDM_MNU_PRINTER         1040
#define IDM_CLOSE               1050
#define IDM_ABOUT               1060
#define IDM_MNU_SHUTDOWN        1070

#define IDM_APP_RESTORE         2010
#define IDM_APP_MINIMIZE        2020
#define IDM_APP_MAXIMIZE        2030
#define IDM_APP_CLOSE           2040
#define IDM_MINIMIZEALL         2050

#define IDM_SETCLOCK            3010

#define IDT_TBTIMER             115
#define IDT_TUPDATE             116
#define TB_TIMEOUT              1000

#define TB_FONT_APPLICATION             "9.WarpSans"
#define TB_FONT_HOVER                   "9.WarpSans"
#define TB_COLOR_HOVERFOREGROUND        CLR_BLACK
#define TB_COLOR_HOVERBACKGROUND        CLR_YELLOW
#define TB_BORDERSPACE                  2

#define TB_COLOR_FOREGROUND             CLR_BLACK
#define TB_COLOR_BACKGROUND             CLR_PALEGRAY

#define STR_DLLFILE			"jcdll.dll"
#define STR_DLLSHAREMEM                 "\\SHAREMEM\\JCDLL\\SHARED.DAT"

#define WM_TASKBARSELECT                WM_USER + 1131L

/******************************************************************/
typedef struct _STTASKBARITEM    /* sttaskbaritem */
        {
        int             iItemId;
        HWND            hwndButton;
        HWND            hwndItem;
        PID             pidItem;
        HSWITCH         hswitch;
        ULONG           ulProgType;
        char            szSwitchTitle[128];
        VOID            *pstOwner;
        } STTASKBARITEM;
typedef STTASKBARITEM FAR *PSTTASKBARITEM;

typedef struct _STTASKBAR    /* sttaskbar */
        {
        HWND            hwndOwner;
        HWND            hwndTaskBar;
        STHOVERBOX      hb;
        USHORT          usItemCount;
        BOOL            bShow;
        int             iHeight;
        HWND            hwndBtnCurrent;
        PSTTASKBARITEM  pTaskItems;
        } STTASKBAR;
typedef STTASKBAR *PSTTASKBAR;

typedef struct _APPSETTINGS
        {
        int                 iNumIgnoreTitle;
        char                szIgnoreTitle[100][40];
        } APPSETTINGS;

typedef struct _APPLICATION
        {
        HAB                 hab;
        HWND                hwndFrame;
        HWND                hwndClient;
        HWND                hwndMenu;
        HWND                hwndTaskBar;
        HBITMAP             hbmLogo;
        HBITMAP             hbmSwitch;
        STTASKBAR           tb;
        STBTN               btn;
        STBTN               btnSwitch1;
        STBTN               btnSwitch2;
        STBTN               btnDT;
        unsigned long       tid;
        HWND                hwndWC;
        HWND                hwndDesktop;
        APPSETTINGS         aset;
        } APPLICATION;

/*-------------------------------------------------------------------*/
MRESULT EXPENTRY ClientWndProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY AboutDlgProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);

void SizeControls(HWND hwnd);
BOOL IsWindowExcluded(char *szWndTitle);
int DrawBarMenu(HPS hps, BOOL bDraw, RECTL rclClient);
int DrawBarApps(HPS hps, BOOL bDraw, RECTL rclClient);
int DrawBarTask(HPS hps, BOOL bDraw, RECTL rclClient);
int DrawBarClock(HPS hps, BOOL bDraw, RECTL rclClient);
void ReadSwitchList(void);
void ReadSettings(char *szIniFile);
void LogMsg(char *szMessage);
void DebugLog(char *szData);

/*-------------------------------------------------------------------*/
MRESULT EXPENTRY TaskBarWndProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY TaskBarSubClassTaskWndProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
PFNWP DefaultTaskProc;

HWND TaskBarCreate(HWND hwndOwner, PSTTASKBAR pTaskBar, int iHeight);
BOOL TaskBarDestroy(PSTTASKBAR pTaskBar);
int TaskBarItemAdd(PSTTASKBAR pTaskBar, HWND hwndItem, PID pid, HSWITCH hswitch, ULONG ulProgType, char *szSwitchTitle);
BOOL TaskBarItemRemove(PSTTASKBAR pTaskBar, int iItemId);
BOOL TaskBarItemRemoveAll(PSTTASKBAR pTaskBar);
int TaskBarPosFromItem(PSTTASKBAR pTaskBar, int iItemId);
BOOL TaskBarIsMouseOnHwnd(HWND hwndHit);
void TaskBarDrawSwitchIcon(PSTTASKBARITEM pBtnItem, HPS hps);
MRESULT EXPENTRY TaskBarSubClassTaskWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
PSTTASKBARITEM TaskBarItemFromHwnd(PSTTASKBAR pTaskBar, HWND hwndItem);
ULONG TaskBarRedraw(PSTTASKBAR pTaskBar, int xStart, int xStop);
void TaskBar3D (HPS hps, RECTL rcl, int iType, BOOL bFill);
void WinDrawBox(HPS hps, int xLeft, int yBottom, int xRight, int yTop, int iColor);
void MyDrawBox(HPS hps, int xLeft, int yBottom, int xRight, int yTop, int iColor);

/*-------------------------------------------------------------------*/
BOOL EXPENTRY JCSetDLL(HWND hwnd);
void EXPENTRY JCSetMaxFrame(BOOL bPosition, int iHeight);
BOOL EXPENTRY JCSendMsgHook(HAB hab, PSMHSTRUCT psmh, BOOL fInterTask);
BOOL EXPENTRY JCInputHook(HAB hab, PQMSG pQmsg, ULONG fs);
	
