/*************/
/*           */
/* banners.h */
/*           */
/*************/

#ifndef _BANNERS_H_
#define _BANNERS_H_

#include <os2.h>

#define BWM_CLICKED (WM_USER+130)   /* Banner was clicked message */
#define BWM_CLOSED (WM_USER+135)    /* Banner was closed message */

/* bsAddBanner() options */
#define BF_FRAME           0x03 /* Banner has a frame(border) bitmask: use to check, if banner has a frame. */
#define BF_NO_FRAME        0x00 /* Banner has no frame(border) */
#define BF_FRAME_SOLID     0x01 /* Banner has a solid frame(border) */
#define BF_FRAME_RAISED    0x02 /* Banner has a raised frame(border) */
#define BF_FRAME_INSET     0x03 /* Banner has an inset frame(border) */
#define BF_CLOSEBUTTON     0x04 /* Banner has a close button */
#define BF_QUEUE           0x08 /* If set, the first parameter (hOwner) is a message queue handle (HMQ), otherwwise - it's a window handle (HWND) */
#define BF_COLORINDEX      0x10 /* If set, the color parameters (lBackCOlor, lForeColor) are color indexes (CLR_* values are acceptable), otherwise - RGB values */
#define BF_THICKFRAME      0x20 /* Banner has thick (2 pixel) frame. If banner has no frame, this flag is ignored */

/* bsAddBanner() alarm style */
#define WA_NONE            -1   /* No alarm */
/*
 * Values, defined in pmvin.h
 *
#define WA_WARNING         0      * Warning *
#define WA_NOTE            1      * Information *
#define WA_ERROR           2      * Error *
*/
#define WA_WND_OPEN        3     /* Opening window */
#define WA_WND_CLOSE       4     /* Closing window */
#define WA_DRG_BEGIN       5     /* Begin drag     */
#define WA_DRG_END         6     /* End drag       */
#define WA_SYS_STARTUP     7     /* System startup */
#define WA_SYS_SHUTDOWN    8     /* System shutdow */
#define WA_SHRED           9     /* Shred          */
#define WA_LOCKUP          10    /* Lockup         */
#define WA_ALARM           11    /* Alarm clock    */
#define WA_PRT_ERROR       12    /* Printer error  */

/* Used to determine Banner System version
 * Parameters:
 * PUSHORT pusMajor - Pointer to an USHORT, where major version number will be placed
 * PUSHORT pusMinor - Pointer to an USHORT, where minor version number will be placed
 * PUSHORT pusSob -Pointer to an USHORT, where sub version number will be placed
 */
VOID APIENTRY bsVersion(PUSHORT pusMajor, PUSHORT pusMinor, PUSHORT pusSub);

/*
 * Used to check, if Banner System is ready. An attempt to add a banner, when the banner system is not ready, will produce no effect!
 */
APIRET APIENTRY bsIsReady(VOID);

/* Used to add a banner to the list of displayed banners
 * Parameters:
 * HWND hOwner - Handle of the banner's owner. It's either a message queue handle (if BF_QUEUE flag is set or a window handle, otherwise).
 *               The owner window or queue may receive BWM_CLICKEDand SWM_CLOSED messages. If ths parameter is NULLHANDLE, no messages will be sent by the banner.
 * USHORT cx - Width of the banner to be created.
 * USHORT cy - Height of the banner to be created.
 * USHORT id - Unique banner id, which can be used to check, which banner sent a message and to replace an existing banner with a new one.
 *             If this parameter is 0, the banner is unidentified - it cannot be replaced with another one,
 *             and you cannot determine, which of those unidentified banners sent a message.
 * ULONG flOptions - A set of flags (see above) which determine properties of a banner to be created.
 * LONG  lTimeout - A timeout, after which banner will be automatically closed.
 *                  If this parameter is 0, banner will be displayed until user will close it manually.
 * HMODULE hMod - Handle of the module (DLL) used to load an image to be displayed in the banner.
 *                If this parameter is NULLHANDLE, a resource will be loaded from the executable, which invokes this function.
 * USHORT  usId - Identity of the PNG resource (RT_PNG resource type) in the module, which contains the image to be displayed in the banner.
 *                If this parameter is 0, banner won't load the image from the module.
 * PSZ pszTitle - Banner title. If NULL, banner will have no title.
 * PSZ pszText  - Banner text. If NULL, banner will have no text.
 * PSZ pszFontNameSize - A null-terminated string, which describes font, used to display banner text and title.
 *                       E. g. "9.Times New Roman Italic". If this value is NULL, default font is used.
 * LONG lForeColor - Banner foreground color (used to display text, frame (only for BF_FRAME_SOLID style) and close button (if any).
 * LONG lBackColor - Banner background color.
 * LONG flAlarmStyle - Alarm style: system sound identifier (see above) to play, when alarm is displayed.
 *                     A value WA_NONE means, that no sound will be played.
 *
 * Returns:
 * TRUE  - if banner was successfuly added.
 * FALSE - if an error uccured.
 */
APIRET APIENTRY bsAddBanner(HWND hOwner, USHORT cx, USHORT cy, USHORT id, ULONG flOptions, LONG lTimeout, HMODULE hMod, USHORT usId, PSZ pszTitle, PSZ pszText, PSZ pszFontNameSize, LONG lForeColor, LONG lBackColor, LONG flAlarmStyle);

#endif /* _BANNERS_H_ */
