/* Load REXXUTIL functions */
call rxfuncadd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
call sysloadfuncs

/* Find boot drive */
BootDrive=left(value('SYSTEM_INI',,'OS2ENVIRONMENT'),2)

dest=directory() || "\SwapMon.exe"
if \SysCreateObject("WPProgram", "SwapMon", "<WP_DESKTOP>", "EXENAME=" dest, "UPDATE"),
    then say "Failed to create object"

InFile=BootDrive || "\CONFIG.SYS"
OutFile=BootDrive || "\CONFIG.SWB"

/* Delete any previous backup file called CONFIG.SWB */
If Stream(OutFile, 'C', 'Query Exists') <> '' Then Do
    Call SysFileDelete(OutFile)
End

/* We now backup CONFIG.SYS and check if there's already an
   entry for SWAPMON.SYS
   */

AlreadyThere = 0

Do While Lines(InFile) > 0
    Data = LineIn(InFile)
    /* Store the infile data because... */
    OrigData = Data
    /* ...we want to write in the same case */
    Data = Translate(Data)
    /* If this line is REMmed then skip it */
    Place = Pos("REM ", Data)
    If Place = 0 Then Do
        Place = Pos("SWAPMON.SYS", Data)
        If Place \= 0 Then Do
            AlreadyThere = 1
        End
    End
    Call LineOut OutFile, OrigData
End

If AlreadyThere = 0 Then Do
    DeviceLine = "DEVICE=" || directory() || "\SWAPMON.SYS"
    OutFile=BootDrive || "\CONFIG.SYS"
    Call LineOut OutFile, DeviceLine
End
