/* MAGYAR.CMD: A MEMSIZE teleptse magyar nyelven. */

'@Echo Off'
'CHCP 852'

/* A REXXUTIL betltse */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs


/* Inicializls */

Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Call SysCls
Say 'A MEMSIZE teleptse...'
Say ''


/* sszetevfjlok ltezsnek vizsglata */

Language = 'MAGYAR'

Result = SysFileTree( 'MEMSIZE2.EXE', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'HIBA: A MEMSIZE2.EXE nem tallhat!'
  Signal DONE
  End

Result = SysFileTree( "OBJECTS.OS2\"Language".DLL", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'Hiba: 'Language'.DLL nem tallhat!'
  Signal DONE
  End

Result = SysFileTree( "OBJECTS.OS2\"Language".HLP", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'Hiba: 'Language'.HLP nem tallhat!'
  Signal DONE
  End

/* A clalknyvtr nevnek bekrse */

BootDrive = Filespec('Drive',Value('SYSTEM_INI',,'OS2ENVIRONMENT'))
Default = SysIni('USER', 'MEMSIZE', 'INIPATH' )
If Default = 'ERROR:'
  Then Default = BootDrive'\OS2\Apps'
If SUBSTR(Default,LENGTH(Default),1) <= ' '
  Then Default = SUBSTR(Default,1,LENGTH(Default)-1)

Say 'Add meg az alknyvtr teljes nevt, amelybe a MEMSIZE-ot'
Say '  telepteni akarod (alaprtelmezs: 'Default')! '
Parse Pull Directory
If Directory = "" Then Directory = Default


/* A clalknyvtr ltrehozsa, ha szksges */

Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'HIBA: A clalknyvtr nem hozhat ltre.'
    Signal DONE
    End
  End
Say ''


/* A clalknyvtr mentse */

SysIni( "USER", "MEMSIZE", "INIPATH", Directory )
SysIni( Directory"\MEMSIZE2.INI", "MEMSIZE", "INIPATH", Directory )


/* A clgyjt nevnek bekrse */

Say 'Akarod az Indts gyjtbe telepteni? (I/N)'
Pull YesNo
If YesNo = "I" Then
  Do
  Folder = '<WP_START>'
  Say 'Az objektum az Indts gyjtbe kerl.'
  End
Else
  Do
  Folder = '<WP_DESKTOP>'
  Say 'Az objektum a Munkaasztalra kerl.'
  End
Say ''


/* A rgi objektum trlse, ha ltezik */

Call SysDestroyObject( '<MEMSIZE>' )
Call SysSleep( 5 )


/* Telepts elvgzse */

Say 'MEMSIZE msolsa a(z) ' Directory 'alknyvtrba...'
Copy MEMSIZE2.EXE Directory                  '1>NUL'
Copy "OBJECTS.OS2\"Language".DLL" Directory"\MEMSIZE2.DLL" '1>NUL'
Copy "OBJECTS.OS2\"Language".HLP" Directory"\MEMSIZE2.HLP" '1>NUL'
Copy Language".DOC" Directory"\MEMSIZE2.DOC" "1>NUL"

Result = SysFileTree( "HLP2INF.EXE", 'Files', 'F' )
If Files.0 > 0 Then
   Do
   Result = SysFileTree( Directory"\MEMSIZE2.INF", 'Files', 'F' )
   If Files.0 > 0 Then
      Do
      "Erase" Directory"\MEMSIZE2.INF"
      End
   "HLP2INF" Directory"\MEMSIZE2.HLP"
   End

Result = SysFileTree( "SNPSHOT2.EXE", 'Files', 'F' )
If Files.0 > 0 Then
   Do
   Copy "SNPSHOT2.EXE" Directory"\SNPSHOT2.EXE"  '1>NUL'
   End

Say 'Programobjektum ltrehozsa...'
Type = 'WPProgram'
Title = 'System Resources'
Parms = 'OPEN=DEFAULT;MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\MEMSIZE2.EXE;STARTUPDIR='Directory';OBJECTID=<MEMSIZE>;NOPRINT=YES;'
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )

If Result = 1 Then
  Say 'Objektum ltrehozva!  Ksz.'
Else
  Say 'HIBA: Az objektum nem jtt ltre.'

Signal DONE

FAILURE:
Say 'REXX hiba.'
Signal DONE

HALT:
Say 'REXX lells.'
Signal DONE

SYNTAX:
Say 'REXX szintaktikai hiba.'
Signal DONE

DONE:
Exit
