/* REXX command file CASSKEL1 */

/*****************************************************/
/*         DO NOT MODIFY THE NEXT EIGHT LINES        */
/*****************************************************/

parse ARG client logfile additional

QUEUE_REBOOT = 0
CALL_AGAIN = 0

Call AddDLLFunctions

x.0.instprog = ''
x.0.rspdir   = ''
x.0.statevar = 'CAS_STATE'
x.0.default  = ''
 
bootdrive = 'C:' 
exepath = 'x:\EXE\OS2V20' 
dllpath = 'X:\DLL\OS2V20;X:\IMG\LCU' 
configsys = bootdrive || '\CONFIG.SYS' 

x.seinst = 1
x.1.name='OS/2 2.0' 
x.1.statevar = 'CAS_' || x.1.name
x.1.instprog = exepath || '\seinst                    ',
             ' /b:' || bootdrive || '                ',
              ' /s:X:\IMG\OS2V20                      ',
               ' /t:a:\                                           ',
               '/l1:Y:\OS2V20\'client'.log ',
               ' /r:' 
x.1.rspdir   = 'X:\RSP\OS2V20' 
x.1.default  = 'SAMPLE.RSP'  
 
x.semaint = 2
x.2.name='OS/2 2.0 Maintenance'
x.2.statevar = 'CAS_' || x.2.name
x.2.instprog = exepath || '\semaint                    ',
              ' /s:X:\IMG\OS2V20                      ',
                ' /t:' || bootdrive || '\service                        ',
                ' /b:' || bootdrive || '               ',
               '/l1:Y:\OS2V20\'client'.mnt' 
x.2.rspdir   = ''
x.2.default  = ''

x.laps = 3
x.3.name='LAPS' 
x.3.statevar = 'CAS_' || x.3.name
x.3.instprog = 'x:\img\laps\laps                     ',
               ' /e:maint                            ',
               ' /s:x:\img\laps                      ',
               ' /t:' || bootdrive || '\             ',
              '/l1:y:\laps\'client'.log ',
              ' /r:' 
x.3.rspdir   = 'X:\RSP\LAPS\'client
x.3.default  = 'laps.rsp' 

/**   IMPORTANT  Please change SRVNAME to the name of your server ******/
/**   Also change CIDDIR to the first alias defined, */
/**   Finally, change the x in /d:x to the drive this alias points to. */
x.thinifs = 4
x.4.name='SRVIFS Requester'
x.4.statevar = ''
x.4.instprog = 'x:\img\srvifs\thinifs                   ',
               '  /s:x:\img\srvifs                      ',
              '  /t:' || bootdrive || '\srvifsrq       ',
               ' /tu:' || bootdrive || '\               ', 
               ' /l1:y:\srvifs\'client'.l1 ',
               '/req:' || client || '                   ',
               '/srv:\\srvname\CIDDIR                           ',
               '/d:x'
x.4.rspdir   = ''
x.4.default  = ''

/**   IMPORTANT  Please change SRVNAME to the name of your server ******/
/**   Also change LOGS to the second alias defined, */
/**   Finally, change the y in /d:y to the drive this alias points to. */
x.thinifs2 = 5
x.5.name='SRVIFS Requester'
x.5.statevar = ''
x.5.instprog = 'x:\img\srvifs\thinifs                   ',
               '  /s:x:\img\srvifs                      ',
              '  /t:' || bootdrive || '\srvifsrq       ',
               ' /tu:' || bootdrive || '\               ', 
               ' /l1:y:\srvifs\'client'.l2 ',
               '/req:' || client || '                   ',
               '/srv:\\srvname\\LOGS                           ',
               '/d:y'
x.5.rspdir   = ''
x.5.default  = ''

x.casinstl = 6
x.6.name='LAN CID Utility'
x.6.statevar = ''
x.6.instprog = 'x:\img\lcu\casinstl                 ',
               '/cmd:X:\CLIENT                      ',
               ' /tu:' || bootdrive || '             ',
               ' /pl:' || dllpath || '               ',
               ' /pa:x:\img\lcu                      ',
               '/D                      ',
              ' /l1:y:\lcu\'client'.L1 ',
               ' /l2:y:\lcu\'client'.L2' 
x.6.rspdir   = ''
x.6.default  = ''
 
x.laps_prep = 7
x.7.name='LAPS Maintenance'
x.7.statevar = 'CAS_' || x.7.name
x.7.instprog = 'x:\img\laps\laps                      ',
                ' /e:prep                             ',
                ' /s:x:\img\laps                      ',
                ' /t:' || bootdrive || '\service                        ',
                '/tu:' || bootdrive || '              ',
              '/l1:y:\laps\'client'.mnt',
              ' /r:' 
x.7.rspdir   = 'X:\LOGS\LAPS' 
x.7.default  = 'lapsprep.rsp' 
  
x.fservice = 8
x.8.name='OS/2 Service Pack' 
x.8.statevar = 'CAS_' || x.8.name
x.8.instprog = "x:\csd\os2v20\WR6055\fservice                ", 
                "/s:x:\csd\os2v20\WR6055               ",
                ' /t:' || bootdrive || '\service                        ',
               '/l1:Y:\CSD\OS2V20\WR6055\'client'.log ',
                " /r:" 
x.8.rspdir   = "X:\RSP\OS2V20\WR6055" 
x.8.default  = "OS2SVC.rsp" 

x.db2su = 9
x.9.name='DB/2 Single User' 
x.9.statevar = 'CAS_' || x.9.name
x.9.instprog = 'x:\img\DB22\db2su\dbcid                 ',
             ' /s:x:\img\DB22\db2su                    ',
               '/l1:y:\db22\'client'.l1 ',
               '/l2:y:\db22\'client'.l2 ',
              '/l3:y:\db22\'client'.l3 ',
               '/l4:y:\db22\'client'.ZIP ',
               ' /r:' 
x.9.rspdir   = 'X:\RSP\DB22\'client
x.9.default  = 'db2.rsp' 
 
x.CM2 = 10
x.10.name='CM/2' 
x.10.statevar = 'CAS_' || x.10.name
x.10.instprog = 'x:\img\CM101\CMSETUP                 ',
             ' /s:x:\img\CM101                    ',
               '/l1:y:\CM10\'client'.l1 ',
               '/l2:y:\CM10\'client'.l2 ',
               ' /r:' 
x.10.rspdir   = 'X:\RSP\CM101\'client
x.10.default  = 'CM2.rsp' 

 
x.laninstr = 11
x.11.name='LAN Services 3.0' 
x.11.statevar = 'CAS_' || x.11.name
x.11.instprog = 'x:\img\ls30\laninstr                ',
               ' /req                               ',
               '/l1:y:\ls30\'client'.L1 ',
               '/l2:y:\ls30\'client'.L2 ',
               ' /r:'  
x.11.rspdir   = 'X:\RSP\LS30\'client
x.11.default  = 'LS30.RSP' 
 
x.ifsdel = 12
x.12.name='SRVIFS Delete'
x.12.statevar = ''
x.12.instprog = 'x:\img\srvifs\ifsdel             ',
               ' /t:' || bootdrive || '\srvifsrq ',
              '/tu:' || bootdrive
x.12.rspdir   = ''
x.12.default  = ''
 
x.casdelet = 13
x.13.name='LAN CID Utility Delete'
x.13.statevar = ''
x.13.instprog = 'x:\img\lcu\casdelet   ', 
                '/pl:' || dllpath || '   ',
                '/tu:' || bootdrive
x.13.rspdir   = ''
x.13.default  = ''
 
NUM_INSTALL_PROGS = 13
 
OVERALL_STATE = GetEnvironmentVars()
 
Do Forever
  Select
    when OVERALL_STATE = 0 then do
     if RunInstall(x.seinst)   == BAD_RC then exit             /* Install operating system     */
     if RunInstall(x.laps)     == BAD_RC then exit             /* Install LAPS                 */
     if RunInstall(x.thinifs)  == BAD_RC then exit             /* Install SRVIFS requester     */
     if RunInstall(x.thinifs2) == BAD_RC then exit
     if RunInstall(x.casinstl) == BAD_RC then exit             /* Install LCU                  */
     Call CheckBoot                                                            /* Reboot if it was requested   */
    end
    
    when OVERALL_STATE = 1 then do
       if RunInstall(x.semaint)   == BAD_RC then exit            /* Install maintenance system   */
       if RunInstall(x.laps_prep) == BAD_RC then exit            /* Install LAPS prep system     */
       if RunInstall(x.thinifs)   == BAD_RC then exit            /* Install SRVIFS requester     */
       if RunInstall(x.thinifs2)   == BAD_RC then exit            /* Install SRVIFS requester     */
       if RunInstall(x.casinstl)  == BAD_RC then exit            /* Install LCU                  */
       Call CheckBoot                                            /* Reboot if it was requested   */
     end
     when OVERALL_STATE = 2 then do
       if RunInstall(x.fservice)  == BAD_RC then exit            /* Install OS/2 Service Pak     */
       Call CheckBoot                                            /* Reboot if it was requested   */
     end
    
    when OVERALL_STATE = 3 then do
      if RunInstall(x.db2su)  == BAD_RC then exit             /* Install DB2                   */
      Call CheckBoot                                                             /* Reboot if it was requested   */
    end
    
    when OVERALL_STATE = 4 then do
      if RunInstall(x.CM2)  == BAD_RC then exit             /* Install ES                   */
      Call CheckBoot                                                             /* Reboot if it was requested   */
    end
    
    when OVERALL_STATE = 5 then do
      if RunInstall(x.laninstr) == BAD_RC then exit             /* Install LS                   */
      Call CheckBoot                                                            /* Reboot if it was requested   */
    end
    
    when OVERALL_STATE = 6 then do
      if RunInstall(x.ifsdel)   == BAD_RC then exit             /*  Delete SRVIFS requester      */
      if RunInstall(x.casdelet) == BAD_RC then exit             /* Delete LCU                   */
      Call Reboot                                                                   /* Reboot                       */
    end
  end
end
exit
/*************************************************************/
/*         DO NOT MODIFY ANY CODE BELOW THIS LINE !!!        */
/*************************************************************/

RunInstall: procedure expose x. queue_reboot call_again configsys logfile client OVERALL_STATE
  parse arg index, new_state, other
  install = SetEnvironmentVar(x.index.statevar)
  if install == YES then do
    rc2 = LogMessage(72, x.index.name, '', logfile)             /* log an install starting msg  */
    install_prog = 'CMD /C ' || strip(x.index.instprog)         /* build the command string     */

                                                /* If automatic responst file selection was     */
                                                /* indicated, then get the response file name   */
                                                /* and append it to the command string.         */
    if x.index.default <> '' then do
      response_file = DetermineResponseFile(x.index.rspdir, client,
                                            , x.index.default, x.index.name,
                                            , logfile)
      if response_file == '' then exit
      install_prog = install_prog || response_file
    end

    install_prog                                                /* Execute the install program  */

    state = value(x.index.statevar,,'OS2ENVIRONMENT')           /* Get the current install state*/
                                                                /* for this install program from*/
                                                                /* the environment.             */

                                                /* Check the return code and set the global     */
                                                /* variables accordingly.                       */

    parse value ProcessReturnCode(rc, state, QUEUE_REBOOT, CALL_AGAIN, logfile),
           with rc ',' state ',' QUEUE_REBOOT ',' CALL_AGAIN

    rc2 = value(x.index.statevar, state, 'OS2ENVIRONMENT')      /* Set the new install state for*/
                                                                /* this install program.        */

                                                /* Put the install state into the CONFIG.SYS,   */
                                                /* if this action was unsuccessful, then exit.  */

    if PutStateVar(x.index.statevar, state, configsys, logfile) <> 0 then exit

    if rc == GOOD_RC then do
      if pos('\SEMAINT', translate(install_prog)) <> 0 then     /* If the install program was   */
        Call PreserveStartupCmd(install_prog)                   /* SEMAINT, then make sure      */
                                                                /* STARTUP.CMD won't be copied  */
                                                                /* over when SEINST runs.       */

      rc2 = LogMessage(70, x.index.name, '', logfile)           /* log an install successful msg*/
      return GOOD_RC                                            /* return a good return code    */
    end

    else do
      rc2 = LogMessage(71, x.index.name, '', logfile)           /* log an install failed msg    */
      if (new_state <> '') then                                 /* If a new state was requested,*/
                                                                /* then set OVERALL_STATE to the*/
        rc2 = SetState(new_state, 'RunInstall', 2)              /* new state.                   */

      return BAD_RC                                             /* return a bad return code     */
    end
  end
  return GOOD_RC


/*************************************************************/
PreserveStartupCmd: procedure

  parse upper arg string, other

  if pos('/T:', string) <> 0 then                               /* Determine if there is a      */
    findvalue = '/T:'                                           /* target parameter.  If there  */
  else                                                          /* is none, return.             */
    if pos('-T:',string) <> 0 then
      findvalue = '-T:'
    else
      return 0

  remain = substr(string, pos(findvalue, string) + 3)           /* Get the value of the target  */
                                                                /* parameter.                   */
  blank = pos(' ', remain)

  if (blank <> 0) then
    param = substr(remain, 1, blank-1)
  else
    param = remain
                                                /* Erase startup.lcu in the target directory,  */
                                                /* then rename startup.s13 to startup.lcu      */

  'if exist ' param || '\startup.lcu erase  ' param || '\startup.lcu'
  'if exist ' param || '\startup.s13 rename ' param || '\startup.s13 *.lcu'

  return 0

/*************************************************************/
GetEnvironmentVars: procedure expose X. NUM_INSTALL_PROGS


  OVERALL_STATE = value(x.0.statevar,,'OS2ENVIRONMENT')         /* Get the overall install state */
                                                                /* from the environment.         */

  if OVERALL_STATE == '' then do                                /* If the overall install state  */
    OVERALL_STATE = 0                                           /* has not been set yet, reset   */
    do I=0 to NUM_INSTALL_PROGS by 1                            /* all the state vars to 0.      */
      if x.I.statevar <> '' then
        rc = value(x.I.statevar,'0','OS2ENVIRONMENT')
    end
  end

  return OVERALL_STATE


/*************************************************************/
SetEnvironmentVar: procedure
  parse arg env_string, other
  if env_string == '' then do                                   /* If the install program has   */
                                                                /* no state variable, then ...  */

    rc = value('REMOTE_INSTALL_STATE','0','OS2ENVIRONMENT')     /* Set the REMOTE_INSTALL_STATE */
                                                                /* to 0 so that the program     */
                                                                /* being run can know that is   */
                                                                /* being run in an unattended   */
                                                                /* environment.                 */

    return YES                                                  /* return install=yes           */

  end

  state = value(env_string,,'OS2ENVIRONMENT')                   /* Otherwise, get the value of  */
                                                                /* the state variable from the  */
                                                                /* environment.                 */

  if state <> '' then do                                        /* If the state variable exists */

    rc = value('REMOTE_INSTALL_STATE',state,'OS2ENVIRONMENT')   /* Set the REMOTE_INSTALL_STATE */
                                                                /* environment variable to the  */
                                                                /* value of the state variable. */

    return YES                                                  /* return install=yes           */
  end
  else                                                          /* Otherwise,                   */
    return NO                                                   /* return install=no            */


/*************************************************************/
BootDriveIsDiskette:

  if IsBootDriveRemovable() == 1 then do                        /* If the drive booted from is  */
                                                                /* a diskette drive, then set   */
    rc2 = SetState(OVERALL_STATE+1)                             /* the OVERALL_STATE to the     */
                                                                /* requested value.             */
    return 'YES'

  end

  else                                                          /* else the machine was booted  */
                                                                /* from the hardfile.           */
    return 'NO'

/*************************************************************/
BootDriveIsFixedDisk:

  if IsBootDriveRemovable() == 0 then do                        /* If the drive booted from is  */
                                                                /* a fixed disk, then set       */
    rc2 = SetState(OVERALL_STATE+1)                             /* the OVERALL_STATE to the     */
                                                                /* requested value.             */
    return 'YES'

  end

  else                                                          /* else the machine was booted  */
                                                                /* from a diskette.             */
    return 'NO'

/*************************************************************/
SetState:
  parse arg new_state, proc_name, param_num, other

    if datatype(new_state, number) <> 1 then do                 /* If the new state requested is*/
                                                                /* not numeric, then log an     */
      if proc_name <> '' then                                   /* error.                       */
        LogMessage(63, proc_name, param_num, logfile)
      else
        LogMessage(63, 'SetState', 1, logfile)

      exit
    end

    OVERALL_STATE = new_state                                   /* Set the OVERALL_STATE to the */
                                                                /* new state requested.         */

    rc = value(x.0.statevar, new_state, 'OS2ENVIRONMENT')       /* Save the OVERALL_STATE in the*/
                                                                /* environment.                 */
    return 'NO_ERROR'


/*************************************************************/
SaveStates:

  do I=0 to NUM_INSTALL_PROGS by 1            /* Put the install states into the CONFIG.SYS,  */
    if x.I.statevar <> '' then                /* if this action was unsuccessful, then exit.  */

      if PutStateVar(x.I.statevar, value(x.I.statevar,,'OS2ENVIRONMENT'),
                     , configsys, logfile) <> 0 then exit
  end

  return

/*************************************************************/
RebootAndGotoState:
  parse arg new_state, other

  rc2 = SetState(new_state, 'RebootAndGotoState', 1)           /* Set the state to go to in    */
                                                               /* OVERALL_STATE.               */

  Call SaveStates                                              /* Save the environment vars    */

  Call Reboot                                                  /* Reboot the machine           */

  return


/*************************************************************/
CheckBoot:
  if QUEUE_REBOOT <> 0 then do                                  /* If a reboot has been queued  */
                                                                /* by an install program ...    */

    if CALL_AGAIN == 0 then                                     /* If no install programs want  */
                                                                /* to be recalled ...           */

      rc = SetState(OVERALL_STATE+1)                            /* Increment the overall state  */
                                                                /* variable.                    */

    Call SaveStates                                             /* Save the environment vars    */

    Call Reboot                                                 /* Reboot the machine           */

  end

  else                                                          /* Otherwise, increment the     */
    rc = SetState(OVERALL_STATE+1)                              /* state variable and go on.    */

  return


/*************************************************************/
Reboot:
  bootdrive

  rc = value('OS2_SHELL', bootdrive || '\OS2\CMD.EXE', 'OS2ENVIRONMENT')
  rc = value('COMSPEC',   bootdrive || '\OS2\CMD.EXE', 'OS2ENVIRONMENT')

  'cls'
  /*rc = AskRemoveDiskIfFloppy()*/

  pathlen = length(exepath)                                     /* Get length of exepath        */
  posslash = lastpos("\",strip(exepath))                        /* Determine the last occurcnce */
                                                                /*   of '\' in exepath          */

  if posslash = pathlen then                                    /* If '\' is the last character */

    cmdline = exepath || 'SETBOOT /IBD:' || bootdrive           /* Then append 'SETBOOT'        */

  else

    cmdline = exepath || '\SETBOOT /IBD:' || bootdrive          /* Else append '\SETBOOT'       */

  LogMessage(74, '', '', logfile)                               /* Log a message indicating     */
                                                                /* reboot.                      */
  cmdline

  LogMessage(73, 'SETBOOT', '', logfile)                        /* If the code gets to here, the*/
                                                                /* reboot failed.  Log a message*/
  exit                                                          /* and exit.                    */

  return


/*************************************************************/
AddDLLFunctions:
  Call RxFuncAdd 'ProcessReturnCode',     'CASAGENT', 'PROCESSRETURNCODE'
  Call RxFuncAdd 'DetermineResponseFile', 'CASAGENT', 'DETERMINERESPONSEFILE'
  Call RxFuncAdd 'PutStateVar',           'CASAGENT', 'PUTSTATEVAR'
  Call RxFuncAdd 'LogMessage',            'CASAGENT', 'GETANDLOGMESSAGE'
  Call RxFuncAdd 'AskRemoveDiskIfFloppy', 'CASAGENT', 'ASKREMOVEDISKIFFLOPPY'
  Call RxFuncAdd 'IsBootDriveRemovable',  'CASAGENT', 'ISBOOTDRIVEREMOVABLE'

  return
