/**********************************************************************/
/*                                                                    */
/* Install program for Internet applications starter: Version 1.0     */
/*                                                                    */
/* Author: Michel Such, msuch@free.fr                                 */
/**********************************************************************/

  call init_prog
  call install_dll
  call make_folder
  say "All objects created."
exit


init_prog:

   if rxfuncquery('sysloadfuncs') <> 0 then do
      call rxfuncadd 'sysloadfuncs', 'rexxutil', 'sysloadfuncs'
      call sysloadfuncs
   end
   parse source . . prog .
   mydir = filespec('d', prog) || filespec('p', prog)
return /* init_prog */


install_dll:
  irc = SysIni( "BOTH","FolderWorkareaRunningObjects","ALL:","Objects" );
  BootDrive = left( Objects.1,2 );
  "@copy" mydir"wptools.dll" bootdrive"\os2\dll >nul 2>nul"
  call RxFuncAdd 'WPToolsLoadFuncs', 'WPTOOLS', 'WPToolsLoadFuncs'
  call WPToolsLoadFuncs
return /* install_dll */


make_folder:

  Ret = WPToolsFolderContent("<INET_STARTUP>", "list.")
  if ret = 1 then do
    say "Internet applications starter already installed."
    say "Press 'Y' to replace it, any other key to stop."
    key = sysgetkey()
    say
    if translate(key) <> 'Y' then do
      say "Installation cancelled."
      exit
    end
  end
  rc = sysdestroyobject("<INET_STARTER>")
  rc = sysdestroyobject("<INET_STARTUP>")
  rc = sysdestroyobject("<ISTART_FOLDER>")
  apptitle = "Internet applications starter"
  rc = SysCreateObject( 'WPFolder',  AppTitle,          '<WP_DESKTOP>',      'CCVIEW=NO;OBJECTID=<ISTART_FOLDER>;', 'U');
  call check "folder" apptitle
  apptitle = "Internet startup folder"
  rc = SysCreateObject( 'WPFolder',  AppTitle,          '<ISTART_FOLDER>',      'CCVIEW=NO;OBJECTID=<INET_STARTUP>;', 'U');
  call check "folder" apptitle
  apptitle = "Internet applications starter"
    rc = SysCreateObject( 'WPProgram', appTitle,         '<ISTART_FOLDER>', 'CCVIEW=NO;PROGTYPE=PM;EXENAME='mydir'istart.exe;OBJECTID=<ISTART_PROGRAM>;', 'U');
  call check "program" apptitle
    ret = syscreateshadow("<ISTART_PROGRAM>", "<WP_START>")
    if ret = 0 then do
      say "Error creating shadow of Internet applications starter in the startup folder."
    end
return /* make_folder */


check:

  parse arg object apptitle
  if rc = 0 then do
     say "Error creating" object apptitle
     exit
  end
return /* check */
