/*
 *  ************************************************************************
 *                      	32-bit Command Interpreter
 *  (c) Copyright 1991-2001 Jonathan de Boyne Pollard.  All Rights Reserved.
 *  ************************************************************************
 */

/* "@(#)MAKEOBJ.CMD version 1.0.1" */

'@echo off'

call RxFuncAdd 'SysGetMessage','RexxUtil','SysGetMessage'
call RxFuncAdd 'SysCreateObject','RexxUtil','SysCreateObject'
call RxFuncAdd 'SysOpenObject','RexxUtil','SysOpenObject'
call RxFuncAdd 'SysCreateShadow','RexxUtil','SysCreateShadow'

parse source opsys mode script
ApplicationDir = filespec('Drive',script)||filespec('Path',script)||"..\"
ReadMeDir = left(ApplicationDir,length(ApplicationDir)-15)||"ReadMe\"

startupdir = "STARTUPDIR="||ApplicationDir||"..\"
fullscreen = "PROGTYPE=FULLSCREEN;"
FolderID = "<WP_32BIT_CMD>"

ContainingFolder = "<WP_PROGRAMSFOLDER>"
If 0 == SysOpenObject(ContainingFolder, "DEFAULT", 0) Then do
	Say "Unable to open the Programs folder"
	ContainingFolder = "<WP_DESKTOP>"
end

If 0 == SysCreateObject("WPFolder", "32-bit Command Interpreter", ContainingFolder, "OBJECTID=<WP_32BIT_CMD>", "Update") Then do
	Say "Unable to create folder for 32-bit command interpreter"
end

If 0 == SysCreateShadow(FolderID, "<WP_DESKTOP>") Then do
	Say "Unable to create shadow of the folder for 32-bit command interpreter"
end

If 0 == SysCreateShadow(FolderID, "<WP_PROMPTS>") Then do
	Say "Unable to create shadow of the folder for 32-bit command interpreter"
end

If 0 == SysCreateObject("WPProgram", "Windowed Standard I/O"||"0A"x||"Command Interpreter", FolderID,
					   ,"EXENAME="ApplicationDir||"CMD.EXE;"||startupdir, "Update") Then do
	Say "Unable to create program object for 32-bit command interpreter"
end

If 0 == SysCreateObject("WPProgram", "Full-Screen Standard I/O"||"0A"x||"Command Interpreter", FolderID,
					   ,fullscreen||"EXENAME="ApplicationDir||"CMD.EXE;"||startupdir,
					   ,"Update") Then do
	Say "Unable to create program object for 32-bit command interpreter"
end

If 0 == SysCreateObject("WPProgram", "Windowed Textual"||"0A"x||"Command Interpreter", FolderID,
					   ,"EXENAME="ApplicationDir||"TextCMD.EXE;"||startupdir, "Update") Then do
	Say "Unable to create program object for 32-bit command interpreter"
end

If 0 == SysCreateObject("WPProgram", "Full-Screen Textual"||"0A"x||"Command Interpreter", FolderID,
					   ,fullscreen||"EXENAME="ApplicationDir||"TextCMD.EXE;"||startupdir,
					   ,"Update") Then do
	Say "Unable to create program object for 32-bit command interpreter"
end

If 0 == SysCreateObject("WPProgram", "Graphical"||"0A"x||"Command Interpreter", FolderID,
					   ,"EXENAME="ApplicationDir||"PMCMD.EXE;"||startupdir, "Update") Then do
	Say "Unable to create program object for 32-bit command interpreter"
end

If 0 == SysCreateObject("WPShadow", "ReadMe.TXT", FolderID,
					   ,"SHADOWID="||ReadMeDir||"ReadMe.TXT", "Update") Then do
	Say "Unable to create program object for 32-bit command interpreter"
end

If 0 == SysCreateObject("WPProgram", "Documentation", FolderID,
					   ,"EXENAME=VIEW.EXE;PARAMETERS=Book\CMD.INF;"||startupdir, "Update") Then do
	Say "Unable to create program object for 32-bit command interpreter"
end

If 0 == SysCreateObject("WPUrl", "Web Page", FolderID,
					   ,"LOCATOR=http://homepages.tesco.net./~J.deBoynePollard/Softwares/cmd.html;"||startupdir,"Update") Then do
	Say "Unable to create program object for 32-bit command interpreter"
end

If 0 == SysCreateObject("WPUrl", "Blurb", FolderID,
					   ,"LOCATOR=file:///"||ReadMeDir||"Blurb.HTML;"||startupdir,"Update") Then do
	Say "Unable to create program object for 32-bit command interpreter"
end

If 0 == SysOpenObject(FolderID, "DEFAULT", 0) Then do
	Say "Unable to open the 32-bit command interpreter folder"
end
