/* SMODEM for ZOC installer */

parse arg parm
parm = strip(parm)

/* Introduction */

say 'SMODEM for ZOC installer powered by REXX POWER!!'
say 'This installer uses and includes freeware Info-ZIP UNZIP 5.x'
say

if (parm = '' | pos('?',parm) > 0) then do
   say 'Usage:  INSTALL <ZOC directory>'
   say 'ie:  install g:\ZOC'
   exit
end

/* Remove trailing backslash */
if lastpos('\',parm) = length(parm) then parm = left(parm,length(parm) - 1)

/* Load necessary RexxUtil functions */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

say 'Creating' parm'\SMODEM'
rc = SysMkDir(parm'\SMODEM')
if rc > 0 then do
  say 'Failed creating' parm'\SMODEM'
  if rc = 5 then say 'Please remove the existing directory first'
  exit
end

say 'Searching ZOC script path'
if sysfilesearch('SCRIPT',parm'\options\standard.zpa',scriptpath) = 2 then do
   say 'Error opening' parm'\options\standard.zpa'
   exit
end
scriptpath = parm||'\'||substr(scriptpath.1,pos('="',scriptpath.1) + 2,lastpos('"',scriptpath.1) - pos('="',scriptpath.1) - 2)

/* unzip */
'unzip -o sp103.zip -d 'parm'\smodem'
'unzip -o ostsr12i.zip -d 'parm'\smodem'
'unzip -o smodem10.zip -d 'parm'\smodem'
'copy smodemdl.rx' scriptpath
'copy smodemul.rx' scriptpath

say 'Adding ZOC keys'
call SysFileSearch '62|0C|-1|-1|0|0|^RUN=smodemul.rx', parm'\options\standard.zky', dump
if dump.0 = 0 then
   call lineout parm'\options\standard.zky','62|0C|-1|-1|0|0|^RUN=smodemul.rx'

call SysFileSearch '67|0C|-1|-1|0|0|^RUN=smodemdl.rx', parm'\options\standard.zky', dump
if dump.0 = 0 then
   call lineout parm'\options\standard.zky','67|0C|-1|-1|0|0|^RUN=smodemdl.rx'

call lineout parm'\options\standard.zky'

/* find bootdrive */
irc = SysIni( "BOTH","FolderWorkareaRunningObjects","ALL:","Objects" )
BootDrive = left(Objects.1,2)

/* stick VDOSPRIO.SYS */
found = 0
if SysFileSearch('VDOSPRIO.SYS', bootdrive'\CONFIG.SYS', dump) = 3 then do
   say 'Boot drive not detect proprely.  Edit INSTALL.CMD, find '
   say '"BootDrive = left(Objects.1,2)" and replace with'
   say '"BootDrive = <your boot drive>" ex.: "BootDrive = C:"'
   exit
end

i = 1
do while i <= dump.0
   if pos('DEVICE=', translate(strip(dump.i))) = 1 then found = 1
   i = i + 1
end

if found = 0 then do
   say 'Adding VDOSPRIO.SYS to CONFIG.SYS'
   i = 0
   do until file.0 = 0
	  i = i + 1
      call sysfiletree bootdrive'\CONFIG.'i,file
   end
   'copy' bootdrive'\CONFIG.SYS' bootdrive'\CONFIG.'i
   call lineout bootdrive'\CONFIG.SYS','DEVICE='parm'\SMODEM\VDOSPRIO.SYS'
   call lineout bootdrive'\CONFIG.SYS'
end

/* stick OSTSR.COM */
found = 0
call SysFileSearch 'OSTSR', bootdrive'\AUTOEXEC.BAT', dump
i = 1
do while i <= dump.0
   if pos('REM', translate(strip(dump.i))) <> 1 then found = 1
   i = i + 1
end

if found = 0 then do
   say 'Adding OSTSR.COM to AUTOEXEC.BAT'
   i = 0
   do until file.0 = 0
	  i = i + 1
      call sysfiletree bootdrive'\AUTOEXEC.'i,file
   end
   'copy' bootdrive'\AUTOEXEC.BAT' bootdrive'\AUTOEXEC.'i
   call lineout bootdrive'\AUTOEXEC.BAT','LH' parm'\SMODEM\OSTSR'
   call lineout bootdrive'\AUTOEXEC.BAT'
end

Say 'Finished!'

exit
