/*
 * vncserver - wrapper script to start an X VNC server
 *      v1.00 1999/03/26, akira@sra.co.jp
 *      v1.01 1999/07/26, 
 *              applied patch from 
 *                  OKUNISHI Fujikazu <fuji0924@mbox.kyoto-inet.or.jp>
 *              append '-noauth' option for authentication problems
 */

IF RxFuncQuery('SysLoadFuncs') THEN DO
   CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
   CALL SysLoadFuncs
END
IF RxFuncQuery('SockLoadFuncs') THEN DO
   CALL RxFuncAdd 'SockLoadFuncs', 'rxSock', 'SockLoadFuncs'
   CALL SockLoadFuncs
END

'@echo off'

/*
 * Some specific directory & files for VNC server
 */

env  = 'OS2ENVIRONMENT'
xdrv = VALUE('X11ROOT',,env)
home = VALUE('HOME',,env)
host = VALUE('HOSTNAME',,env)

xroot = xdrv'/XFree86'
xlibdir = xroot'/lib/X11'
fontdir = xlibdir'/fonts'

IF home = '' THEN
    home = xroot

/*
 * Default Parameters - Configure for your env.
 */

desktopName = 'X'
geometry    = '800x600'
depth       = '32'
pixelformat = ''

vncClasses     = home'/lib/vnc'
vncUserDir     = home'/.vnc'
xauthorityFile = home'/.Xauthority'
fontpath = fontdir'/misc/,'fontdir'/75dpi'
rgbfile  = xlibdir'/rgb'
xstartup = vncUserDir'/xstartup.cmd'

/*
 * Parse Command Line Arguments
 */

doWhat = ''             /* Start Server or Help or Kill */
doLocal = 'YES'         /* Also start local Xapps       */
doView =  'NO'          /* Also start VNC viewer        */
noAuth =  'NO'          /* Disable authentication       */

displayNumber = ''
vncPort       = ''
otherArgs     = ''

PARSE SOURCE zz zz prog
prog = SUBSTR(prog, LASTPOS('\', prog) + 1)
prog = SUBSTR(prog, 1, LASTPOS('.', prog) - 1)

PARSE ARG key remain
DO WHILE key <> ''
    IF SUBSTR(key,1,1) = ':' THEN DO
        displayNumber  = SUBSTR(key,2)
	PARSE VAR remain key remain
	ITERATE
    END
    IF SUBSTR(key,1,1) <> '-' THEN DO
        otherArgs = otherArgs || ' ' || key
	PARSE VAR remain key remain
	ITERATE
    END
    SELECT
        WHEN key = '-help' THEN DO
            doWhat = 'HELP'
        END
	WHEN key = '-kill' THEN DO
	    doWhat = 'KILL'
        END
	WHEN key = '-view' THEN DO
	    doView = 'YES'
        END
	WHEN key = '-noauth' THEN DO
	    noAuth = 'YES' 
        END
	WHEN key = '-broadcast' THEN DO
	    doLocal = 'NO'
	    otherArgs = otherArgs || ' -broadcast'
        END
	WHEN key = '-query' THEN DO
	    doLocal = 'NO'
	    otherArgs = otherArgs || ' -query'
	    PARSE VAR remain val remain
	    otherArgs = otherArgs || ' ' || val
        END
	WHEN key = '-indirect' THEN DO
	    doLocal = 'NO'
	    otherArgs = otherArgs || ' -indirect'
	    PARSE VAR remain val remain
	    otherArgs = otherArgs || ' ' || val
        END
    OTHERWISE
        otherArgs = otherArgs || ' ' || key
    END
    PARSE VAR remain key remain
END

/*
 * HELP / KILL
 */

IF doWhat = 'HELP' THEN DO
    CALL vncHelp prog
    EXIT
END
IF doWhat = 'KILL' THEN DO
    CALL vncKill host':'displayNumber
    EXIT
END

/*
 * Create User's VNC directory if necessary
 */

IF existsDir(vncUserDir) = 0 THEN DO
    CALL SysMkDir TRANSLATE(vncUserDir, '\', '/')
    IF existsDir(vncUserDir) = 0 THEN DO
        SAY 'Could not create 'vncUserDir
	EXIT
    END
END

/*
 * Make sure the user has a password
 */

IF exists(vncUserDir'/passwd') = 0 THEN DO
    SAY 'You will require password to access your desktops.'
    'vncpasswd 'vncUserDir'/passwd'
END
IF exists(vncUserDir'/passwd') = 0 THEN DO
    SAY 'failed to create password file'
    EXIT
END

/*
 * Find display number
 */

IF displayNumber = '' THEN DO
    displayNumber = GetDisplayNumber()
END

sv = CheckDisplayNumber(displayNumber)

IF sv <> '' THEN DO
    SAY sv' server is already running on :'displayNumber
    EXIT
END
IF displayNumber = '' THEN DO
    SAY 'No Display Number for Xvnc'
    EXIT
END

vncPort = 5900 + displayNumber
desktopLog = vncUserDir'/'host'.'displayNumber'.log'
CALL SysFileDelete desktopLog

/*
 * Make an X server cookie 
 */

IF doLocal = 'YES' THEN DO
    cookie = ''
    junk = RANDOM(0,255,TIME('S'))

    DO i = 1 TO 16
        cookie = cookie || D2X(RANDOM(0,255),2)
    END

    IF noAuth = 'NO' THEN
        '@xauth  -f 'xauthorityFile' add 'host':'displayNumber' . 'cookie
    ELSE
        CALL SysFileDelete xauthorityFile
END

/*
 * Start Xvnc
 */

cmd = 'Xvnc :'displayNumber
cmd = cmd || ' -rfbwait 120000'
cmd = cmd || ' -rfbauth 'vncUserDir'/passwd'
cmd = cmd || ' -rfbport 'vncPort

IF desktopName <> '' THEN
    cmd = cmd || ' -desktop 'desktopName
IF geometry <> '' THEN 
    cmd = cmd || ' -geometry 'geometry
IF depth <> '' THEN
    cmd = cmd || ' -depth 'depth
IF pixelformat <> '' THEN
    cmd = cmd || ' -pixelformat 'pixelformat
IF fontpath <> '' THEN
    cmd = cmd || ' -fp 'fontpath
IF rgbfile <> '' THEN
    cmd = cmd || ' -co 'rgbfile
IF existsDir(vncClasses) THEN
    cmd = cmd || ' -httpd 'vncClasses
IF exists(xauthorityFile) THEN
    cmd = cmd || ' -auth 'xauthorityFile
IF otherArgs <> '' THEN
    cmd = cmd || ' ' || otherArgs

SAY cmd

cmd = cmd ' > 'desktopLog' 2>&1'                /* log messages */

SAY 'Start Xvnc Server on 'host':'displayNumber
SAY ''
'@start /MIN /C "Xvnc 'host':'displayNumber'" ' cmd

SAY 'Wait Xvnc to startup'
SAY ''
CALL SysSleep 5

/*
 * start initial programs on Xvnc (if LOCAL)
 */

IF doLocal = 'YES' THEN DO
    IF exists(xstartup) THEN DO
        disp = host':'displayNumber
	junk = VALUE('DISPLAY',disp,env)
	junk = VALUE('VNCDESKTOP',desktopName,env)
        SAY 'Start Xapps in 'xstartup' with'
	SAY '    display 'disp
	SAY '    desktop 'desktopName
        '@start /C /MIN ' TRANSLATE(xstartup, '\', '/')
    END
END

/*
 * also start viewer if requested
 */

IF doView = 'YES' THEN DO
    vv = SysSearchPath('PATH', 'vncview.exe')
    IF vv = '' THEN DO
        SAY 'No VNC viewer on your PATH'
	EXIT
    END
    cmd = 'vncview 'host':'displayNumber' '
    IF depth = 32 THEN
        cmd = cmd || ' -true'
    ELSE
        cmd = cmd || ' -bgr233'
    cmd = cmd || ' -passwd 'vncUserDir'/passwd'
    '@start 'cmd
END
    
EXIT

/*
 * exists - check if file exists
 */

exists: PROCEDURE
    IF STREAM(ARG(1), 'C', 'QUERY EXISTS') = '' THEN
        RETURN 0
    ELSE
        RETURN 1

/*
 * existsDir - check if directory exists
 */

existsDir: PROCEDURE
    CALL SysFileTree TRANSLATE(ARG(1), '\', '/'), 'dir.', 'DO'
    IF dir.0 = 0 THEN
        ret = 0
    ELSE
	ret = 1
    RETURN ret

/*
 * CheckDisplayNumber - check if given display number is available
 */

CheckDisplayNumber: PROCEDURE
    n = ARG(1)

    s = SockSocket('AF_INET', 'SOCK_STREAM', 0)
    h.family = 'AF_INET'
    h.port   = 5900 + n
    h.addr   = 'INADDR_ANY'
    IF SockBind(s, 'h.') <> 0 THEN DO
        junk = SockClose(s)
        RETURN 'VNC'
    END
    junk = SockClose(s)

    s = SockSocket('AF_INET', 'SOCK_STREAM', 0)
    h.family = 'AF_INET'
    h.port   = 6000 + n
    h.addr   = 'INADDR_ANY'
    IF SockBind(s, 'h.') <> 0 THEN DO
        junk = SockClose(s)
        RETURN 'X'
    END
    junk = SockClose(s)
    
    RETURN ''

/*
 * GetDisplayNumber - get lowest avaiable display number
 */

GetDisplayNumber: PROCEDURE
    DO i = 0 TO 99
        IF CheckDisplayNumber(i) = '' THEN DO
	    RETURN i
        END
    END
    RETURN ''

/*
 * vncHelp - help for vncserver
 */

vncHelp: PROCEDURE
    SAY 'usage: 'ARG(1)' [:<number>] [-name <desktop-name>] [-depth <depth>]'
    SAY '                 [-geometry <width>x<height>]'
    SAY '                 [-pixelformat rgbNNN|bgrNNN]'
    SAY '                 <Xvnc-options>...'
    SAY '       'ARG(1)' -kill :<number>'
    RETURN

/*
 * vncKill - Kill VNC server
 */

vncKill: PROCEDURE
    SAY 'To stop VNC server for 'ARG(1)','
    SAY 'select Xvnc for 'ARG(1)' from Task List and close it.'
    RETURN
