/*
 * capture - support raw capturing and file sending
 *	Only supports RAW mode transfer.
 *	o When uplodaing, syncrhonize with CR code.
 *	o When downloading, capturing income characters.
 */

#define	INCL_BASE

#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "shifty.h"

/*
 * Buffer for Up/Dn loading File
 */

static	UCHAR	filename[80] ;
static	UCHAR	databuff[128] ;

/*
 * c h e c k k e y 
 *	Check and Send Key Input.  But returns TRUE if
 *	encountered ATTN key, which means Abort FTP.
 */

static	BOOL    checkkey(void)
{
    KBDKEYINFO	key   ;
    UCHAR	buff  ;
	
    KbdCharIn(&key, 1, 0) ;
	
    if (key.fbStatus == 0) {
	return(FALSE) ;
    }
    if ((buff = key.chChar) == KeyAttn) {
	return(TRUE) ;
    }
    (*comDevice->comSend) (&buff, 1) ;

    return(FALSE) ;	
}

/*
 * r a w S e n d  -  Send File Data
 */

void rawSend(void)
{
    UCHAR   *fname    ;
    FILE    *fp       ;
    INT	    c, cnt    ;
    UCHAR   buff      ;
    UCHAR   rbuf[64]  ;

    scrSave() ;

    prompt("Sending from file < ") ;
    fname = getlin(filename, 64) ;

    scrRest() ;
	
    if (*fname == '\0') {
	return ;
    }
    if ((fp = fopen(fname, "r")) == NULL) {
	sprintf(databuff, "cannot open %s", fname) ;
	scrSave() ;
	prompt(databuff) ;
	keywait() ;
	scrRest() ;
	return ;
    }
	
    while ((c = getc(fp)) != EOF) {
	if ((buff = (UCHAR) c) != '\n') {
	    (*comDevice->comSend) (&buff, 1) ;
	    continue ;
	}
	buff = '\r' ;
	(*comDevice->comSend) (&buff, 1) ;
	
	while (1) {
            if (checkkey()) {
		goto aborted ;
	    }
	    if ((cnt = queGet(rbuf, 64)) == 0) {
		continue ;
	    }
	    (*emuDevice->emuScr) (rbuf, cnt) ;
	    scrShow() ;
	    if (strchr(rbuf, '\r') != NULL) {
		break ;
	    }
	}
    }

aborted:
    fclose(fp) ;
	
    scrSave() ;
    prompt("Sending Done - any key to continue") ;
    keywait() ;
    scrRest() ;
}

/*
 * r a w R e c v - Capture Recieved Data
 */

void    rawRecv(void)
{
    UCHAR   *fname ;
    FILE    *fp    ;
    INT	    i, cnt ;
    UCHAR   *p     ;
	
    scrSave() ;
    prompt("Capturing to file > ") ;
    fname = getlin(filename, 64) ;
    scrRest() ;

    if (*fname == '\0') {
	return ;
    }
    if ((fp = fopen(fname, "ab")) == NULL) {
	sprintf(databuff, "cannot create %s", fname) ;
	scrSave() ;
	prompt(databuff) ;
	keywait() ;
	scrRest() ;
	return ;
    }

    while (1) {
	if (checkkey()) {
	    goto aborted ;
	}
	if ((cnt = queGet(databuff, 128)) == 0) {
	    continue ;
	}
	for (i = 0, p = databuff ; i < cnt ; i++, p++) {
	    if (*p != '\0') {
		putc(*p, fp) ;
	    }
	}
	(*emuDevice->emuScr) (databuff, cnt) ;
	scrShow() ;
    }
aborted:
    fclose(fp) ;

    scrSave() ;
    prompt("Capturing Done - any key to continue") ;
    keywait() ;
    scrRest() ;
}
