--- Makefile.org	Thu Mar 27 14:08:10 2003
+++ Makefile	Mon Apr 21 12:16:04 2003
@@ -13,6 +13,9 @@
 datadir     = $(prefix)/share/rdesktop
 
 KEYMAP_PATH = $(datadir)/keymaps/
+OS2EXE   = 
+OS2EXE   = rdesktop.exe rdp2vnc.exe
+OS2BIND  = emxbind -b -w
 
 RDPOBJ   = rdesktop.o tcp.o iso.o mcs.o secure.o licence.o rdp.o orders.o bitmap.o cache.o xwin.o xkeymap.o ewmhints.o rdp5.o
 RDP2VNCOBJ   = vnc/rdp2vnc.o tcp.o iso.o mcs.o secure.o licence.o rdp.o orders.o bitmap.o cache.o vnc/vnc.o vnc/xkeymap.o vnc/x11stubs.o rdp5.o
@@ -24,6 +27,7 @@
 
 rdesktop: $(RDPOBJ) $(CRYPTOBJ)
 	$(CC) $(CFLAGS) -o rdesktop $(RDPOBJ) $(CRYPTOBJ) $(LDFLAGS) -lX11
+	$(OS2BIND) rdesktop
 
 rdp2vnc: $(RDP2VNCOBJ) $(CRYPTOBJ)
 	$(CCLD) $(CFLAGS) -o rdp2vnc $(RDP2VNCOBJ) $(CRYPTOBJ) $(LDFLAGS) $(LDVNC)
@@ -68,7 +72,7 @@
 	cproto -DMAKE_PROTO -o proto.h *.c
 
 clean:
-	rm -f *.o crypto/*.o *~ vnc/*.o vnc/*~ rdesktop rdp2vnc
+	rm -f *.o crypto/*.o *~ vnc/*.o vnc/*~ rdesktop rdp2vnc $(OS2EXE)
 
 dist:
 	mkdir -p /tmp/rdesktop-make-dist-dir
--- rdesktop.h.org	Thu Mar  6 16:36:28 2003
+++ rdesktop.h	Sun Apr 20 23:31:54 2003
@@ -51,3 +51,8 @@
 #ifndef MAKE_PROTO
 #include "proto.h"
 #endif
+
+#ifdef __EMX__
+#include <sys/select.h>
+unsigned long DosError (unsigned long ulError);
+#endif
--- rdesktop.c.org	Wed Apr 16 15:04:16 2003
+++ rdesktop.c	Mon Apr 21 10:28:16 2003
@@ -22,6 +22,10 @@
 #include <unistd.h>		/* read close getuid getgid getpid getppid gethostname */
 #include <fcntl.h>		/* open */
 #include <pwd.h>		/* getpwuid */
+#ifdef __EMX__
+#include <sys/types.h>		/* required by stat.h */
+#include <netdb.h>		/* gethostname */
+#endif
 #include <termios.h>		/* tcgetattr tcsetattr */
 #include <sys/stat.h>		/* stat */
 #include <sys/time.h>		/* gettimeofday */
@@ -156,6 +160,9 @@
 	int c;
 	int username_option = 0;
 
+#ifdef __EMX__
+	DosError(0L); /* Suppress annoying popup error windows. */
+#endif
 	flags = RDP_LOGON_NORMAL;
 	prompt_password = False;
 	domain[0] = password[0] = shell[0] = directory[0] = 0;
@@ -610,7 +617,7 @@
 save_licence(unsigned char *data, int length)
 {
 	char *home, *path, *tmppath;
-	int fd;
+	int fd, n;
 
 	home = getenv("HOME");
 	if (home == NULL)
@@ -639,7 +646,9 @@
 		return;
 	}
 
-	if (write(fd, data, length) != length)
+	n = write(fd, data, length);
+	close(fd);
+	if (n != length)
 	{
 		perror(tmppath);
 		unlink(tmppath);
@@ -650,7 +659,6 @@
 		unlink(tmppath);
 	}
 
-	close(fd);
 	xfree(tmppath);
 	xfree(path);
 }
--- tcp.c.org	Thu Jan 30 14:38:48 2003
+++ tcp.c	Sun Apr 20 16:51:56 2003
@@ -19,6 +19,9 @@
 */
 
 #include <unistd.h>		/* select read write close */
+#ifdef __EMX__
+#include <sys/types.h>		/* required by socket.h */
+#endif
 #include <sys/socket.h>		/* socket connect setsockopt */
 #include <sys/time.h>		/* timeval */
 #include <netdb.h>		/* gethostbyname */
--- xkeymap.c.org	Thu Feb 20 13:14:14 2003
+++ xkeymap.c	Mon Apr 21 11:38:56 2003
@@ -35,6 +35,22 @@
 #define KEYMAP_MASK 0xffff
 #define KEYMAP_MAX_LINE_LENGTH 80
 
+#ifndef PATH_MAX
+#  ifdef MAXPATHLEN
+#    define PATH_MAX MAXPATHLEN		/* in <sys/param.h> on some systems */
+#  else
+#    ifdef _MAX_PATH
+#      define PATH_MAX _MAX_PATH
+#    else
+#      if FILENAME_MAX > 255
+#        define PATH_MAX FILENAME_MAX	/* used like PATH_MAX on some systems */
+#      else
+#        define PATH_MAX 1024
+#      endif
+#    endif /* ?_MAX_PATH */
+#  endif /* ?MAXPATHLEN */
+#endif /* !PATH_MAX */
+
 extern Display *display;
 extern char keymapname[16];
 extern int keylayout;
--- xwin.c.org	Wed Apr 16 15:48:18 2003
+++ xwin.c	Mon Apr 21 13:04:14 2003
@@ -1330,6 +1330,8 @@
 		colmap = map;
 	else
 		XSetWindowColormap(display, wnd, (Colormap) map);
+		if (fullscreen)
+			XInstallColormap(display, (Colormap) map);
 }
 
 void
