/*****************************************************************************/
/* runHelpDesk.cmd
 *
 * HelpDesk for OS/2
 * Copyright 2018 OS/2 VOICE      - all rights reserved
 * Copyright 2018 Richard L Walsh - all rights reserved
 *
 */
/*****************************************************************************/

/* SSH Port Number(s):
 * change this if port 22 is already in use;
 * be sure your clients also use this port.
 * You can enter multiple port numbers separated by spaces.
 */

portNbr = 22

/*****************************************************************************/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

call SetLocal

/* get the directory we're in; make its 'host' subdirectory the CWD */
parse source . . nameIn
path = Filespec('drive', nameIn) || Filespec('path', nameIn)
path = Strip(path, 'trailing', '\') || '\host'
oldpath = Directory()
call Directory path

/* construct an 'ETC\passwd' file for user "helpdesk'
 * whose 'HOME' directory is the CWD and whose shell
 * is valid on this system
 */
home = '$' || Left(path, 1) || Substr(path, 3)
shell = SysSearchPath('PATH', 'CMD.EXE')
if shell = '' then
    shell = Value('COMSPEC',, 'OS2ENVIRONMENT')
shell = '$' || Left(shell, 1) || Substr(shell, 3)
'@echo helpdesk::100:100::' || home || ':' || shell '>' path || '\etc\passwd'

/* set UNIXROOT so 'sshd.exe' can find our ETC directory */
'@SET UNIXROOT=' || Translate(path, '/', '\')

/* (re)create 'vncview.ini' - make it read-only
 * because we don't want it to store anything
 */
'@attrib -R -S -H vncview.ini > nul 2>&1'
'@echo 2> vncview.ini > nul'
'@attrib +R vncview.ini > nul 2>&1'

/* set up the Port argument(s) */
port = ''
cnt = Words(portNbr)
if cnt = 0 then do
    portNbr = 22
    cnt = 1
end
do i = 1 to cnt
    nbr = Word(portNbr, i)
    if Datatype(nbr) = 'NUM' then
        port = port '-p' nbr
end

/* sshd needs a f/q path to find this file */
banner = '-o Banner=' || path || '\banner.txt'

/* start the daemon then exit */
say 'Starting SSHD on port' portNbr
'@start "HelpDesk Daemon" /min sshd' port banner
call Directory oldpath
exit
