/*
 *  Project: NICE/2
 *
 *  By Sharon Dagan, idagan@il.ibm.com
 *
 *  $Date: 1998/07/25 18:47:16 $
 *  $Id: cl.c,v 1.4 1998/07/25 18:47:16 idagan Exp idagan $
 *
 **/

#define INCL_DOS
#define INCL_WIN
#include <os2.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "..\engine\dosqss.h"


#define MEMPOOL 262144


CHAR * aPriorityClass[ 5 ] =
{
    "",
	"IDLE",
	"REG",
	"TC",
	"FGS"
};


ULONG ps( ULONG ulPid )
{
    APIRET		 rc;
	 PVOID		 pvBase;
	 PQPROCESS	 pqProcess;
	 PQTHREAD    pqThread;
	
    ULONG       cbItems    = 0,
                ulBufSize  = 0;
    PSWBLOCK    pswblk     = NULL;
    PVOID       pvSwList   = NULL;
	

	rc = DosAllocMem( &pvBase, MEMPOOL, PAG_COMMIT | PAG_READ | PAG_WRITE );
	if( rc )
		return rc;
	
	rc = DosQuerySysState( 0x01, 0L, ulPid, 0L, ( PCHAR ) pvBase, MEMPOOL );
	
	if( rc )
		return rc;
	
    rc = DosAllocMem( &pvSwList, MEMPOOL, PAG_READ | PAG_WRITE );
    rc = DosSubSetMem( pvSwList, DOSSUB_INIT | DOSSUB_SPARSE_OBJ, MEMPOOL );

    cbItems = WinQuerySwitchList( 0, NULL, 0 );
    ulBufSize = ( cbItems * sizeof( SWENTRY ) ) + sizeof( HSWITCH );

    rc = DosSubAllocMem( pvSwList, ( PVOID ) &pswblk, ulBufSize );
    cbItems = WinQuerySwitchList( 0, pswblk, ulBufSize );
		
	printf( "    PID   PPID  THRDS  TYPE  COMMAND\n" );
	
	pqProcess = ( ( PQTOPLEVEL ) pvBase )->procdata;	
    while( pqProcess && pqProcess->pid != 0 )
    {
	   	int i, j;
	   	char pszModuleName[ 256 ];

		if( pqProcess->type == 0x01 )
		{
		    for( i = 0; i < cbItems; i++ )
		    	if( pswblk->aswentry[ i ].swctl.idProcess == pqProcess->pid )
		    	{
	             	strcpy( pszModuleName, "VDM (" );
	             	strcat( pszModuleName, pswblk->aswentry[ i ].swctl.szSwtitle );
	             	strcat( pszModuleName, ")" );
	             	break;
	            }
	    }
		else
			rc = DosQueryModuleName( pqProcess->hndmod, sizeof( pszModuleName ), pszModuleName );

		printf( "  %5d   %4d   %4d  %4d  %s\n",
				pqProcess->pid,
				pqProcess->ppid,
				pqProcess->threadcnt,
				pqProcess->type,
				pszModuleName );
				
		if( ulPid )
			printf( "    TID  CLASS  DELTA\n" );				
			
		pqThread = pqProcess->threads;
		for( j = 0; j < pqProcess->threadcnt; j++, pqThread++ )
			if( ulPid )
				printf( "  %5d   %4s   %4d\n",
				        pqThread->threadid,
				        aPriorityClass[ ( pqThread->priority >> 8 ) & 0x00FF ],
				        pqThread->priority & 0x001F );
		
		pqProcess = ( PQPROCESS ) pqThread;
	};			
	
	rc = DosFreeMem( pvSwList );
	rc = DosFreeMem( pvBase );
	
	return 0;
};


int main( int argc, char ** argv )
{
	if( argc == 1 )
		return ps( 0 );
	
	if( argc == 2 )
		if( !strcmp( argv[ 1 ], "-?" ) )
		{
			printf( "NICE/2 by Sharon Dagan <idagan@il.ibm.com>\n" \
			        "usage: niceps.exe [-p PID]\n" );
			return 0;
		};
		
	if( argc == 3 )
		if( !strcmp( argv[ 1 ], "-p" ) )
			return ps( atoi( argv[ 2 ] ) );
		
	return 0;
};
