/*PYRxUtil demo*/
/*  ᮢ .
   Kill 'em all ... */
/*trace i*/

NUMERIC DIGITS 10

call RxFuncAdd 'PYRxInit', 'PYRxUtil', 'PYRxInit'
call PYRxInit
call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
call SysLoadFuncs

parse source . . eP

short_title = "Kill 'em all..."
full_title = short_title" (c)PYzone 2001"

call set_icon

my_pid = PYRxGo("p",full_title) ; s_pid = my_pid
do i=1 to 2 until ymx >= 25 & xmx >= 80
  parse value PYRxShow(0,0,0) with . . ymx xmx .
  if ymx < 5 | xmx < 80 then
    do
      if i > 1 then
        exit
      call PYRxMsg ,,,short_title,'Ooops..'||'0'x||'Select window size','!',,'25x80','50x80'
      if result = 11 then
        '@mode co80 25'
      if result = 12 then
        '@mode co80 50'
     end
 end

SLICE = 32 ; SCAN_DT = 1000
LEFT_SIZE = 40 ; RIGHT_SIZE = xmx - LEFT_SIZE

P_I_FG = '7'x ;    P_I_SEL = '3e'x
ACT_BG = '50'x ;   IDLE_BG = '10'x
PATH_ATTR = '7'x ; HEAD_ATTR = '72'x
SUM_ATTR = '70'x ; KEY_ATTR = '71'x
REG_U_BG = '40'x ; REG_S_BG = '60'x
IDL_U_BG = '50'x ; IDL_S_BG = '10'x ; THR_ATTR = 'b'x
CPU_B_BG = '40'x ; CPU_I_BG = '60'x ; CPU_ATTR = 'b'x
INFO_BG = '7'x ;   INFO_TXT_ATTR = '7'x ; INFO_DATA_ATTR = 'b'x
HELP_BG = '70'x ; HLP_KEY_ATTR = '71'x ; HLP_TXT_ATTR = '70'x

LEFT_HEAD = ' PID  PPID  Type   Time used     Peak'
EXE_HEAD = 'Exe Name' ; WIN_HEAD = 'TaskList record' 
THR_HEAD.0 = ' TID Slot Priort State  SleepID  Peak '
if xmx < 95 then
  THR_HEAD.0 = THR_HEAD.0||'1a'x
 else
  THR_HEAD.0 = THR_HEAD.0||'     Time used'
THR_HEAD.1 = ' TID Priort State  Peak    Time used  '||'1b'x
CPU_HEAD = '  N   Busy    Intr    Idle    Freq'
INFO_HEAD = '  System brief info'
HELP_HEAD = '  Control keys'
right_head = EXE_HEAD

INFO.L = "' '||'18'x||' '||'19'x||' <PgUp><PgDn><Home><End>          <C>PU <I>nfo <P>ath <T>hread <W>task <F1>'"
INFO.LR= "'('||'18'x||' '||'19'x||' <PgUp><PgDn><Home><End>)+<Ctrl>  <C>PU <I>nfo <P>ath <T>hread <W>task <F1>'"
INFO.0 = INFO.L
INFO.1 = "'  Kill process (ID='s_pid') Y/N ?'"
INFO.2 = "'  Kill -9 process (ID='s_pid') Y/N ?'"
INFO.3 = "'  <0>reboot  <1>standby  <2>suspend  <3>power_off  <4>shutdown'"

help_txt_info = 1||'0'x||'<Up>'||'0'x||7||'0'x||'Marker Up'||'0'x
help_txt_info = help_txt_info||2||'0'x||'<Down>'||'0'x||7||'0'x||'Marker Down'||'0'x
help_txt_info = help_txt_info||3||'0'x||'<PgUp>'||'0'x||7||'0'x||'Marker Page Up'||'0'x
help_txt_info = help_txt_info||4||'0'x||'<PgDn>'||'0'x||7||'0'x||'Marker Page Down'||'0'x
help_txt_info = help_txt_info||5||'0'x||'<Home>'||'0'x||7||'0'x||'Marker Page Top'||'0'x
help_txt_info = help_txt_info||6||'0'x||'<End>'||'0'x||7||'0'x||'Marker Page Bottom'||'0'x
help_txt_info = help_txt_info||8||'0'x||'<Ctrl><Marker Key>'||'0'x||19||'0'x||'Move right list'||'0'x
help_txt_info = help_txt_info||9||'0'x||'<Left>,<Right>'||'0'x||15||'0'x||'Thread info contents'||'0'x
help_txt_info = help_txt_info||11||'0'x||'<C>'||'0'x||4||'0'x||'CPU Info on right panel'||'0'x
help_txt_info = help_txt_info||12||'0'x||'<I>'||'0'x||4||'0'x||'System Info on right panel'||'0'x
help_txt_info = help_txt_info||13||'0'x||'<P>'||'0'x||4||'0'x||'Processes Paths on right panel'||'0'x
help_txt_info = help_txt_info||14||'0'x||'<T>'||'0'x||4||'0'x||'Sel.Process threads on right panel'||'0'x
help_txt_info = help_txt_info||15||'0'x||'<W>'||'0'x||4||'0'x||'TaskList records on right panel'||'0'x
help_txt_info = help_txt_info||17||'0'x||'<Enter>'||'0'x||8||'0'x||'Switch to selected process'||'0'x
help_txt_info = help_txt_info||18||'0'x||'<Tab>'||'0'x||8||'0'x||'Minimize own window'||'0'x
help_txt_info = help_txt_info||19||'0'x||'<Esc>'||'0'x||8||'0'x||'Quit program'||'0'x
help_txt_info = help_txt_info||20||'0'x||'<Del>[+<Ctrl>]'||'0'x||15||'0'x||'Kill [-9] for Sel.Process'||'0'x
help_txt_info = help_txt_info||21||'0'x||' '||'0'x||10||'0'x||'or Stop System if kill PID<=15'||'0'x

DeskTop = PYRxGo('i') ; call get_version
F_coeff = 1000 ; rt_view = PATH

call PYRxShow 0,0,ymx*xmx,' ',PATH_ATTR
INF_LINES = ymx - 3
call PYRxShow ,,0,left(LEFT_HEAD,LEFT_SIZE),HEAD_ATTR
sys_time = 0 ; s_off = 1 ; draw_time = 0 ; q_kill = 0

do forever
  if right_head \= '' then
    call PYRxShow 0,LEFT_SIZE,0,left(right_head,RIGHT_SIZE),HEAD_ATTR
  timer = info_tx
  interpret "info_tx = "||INFO.q_kill
  if info_tx \= timer then
    call PYRxShow ymx-1,0,0,left(info_tx,xmx),KEY_ATTR
  timer = PYRxGo('i','.............?')
  s_thn = 0
  if timer - sys_time >= SCAN_DT - draw_time then
    do
      drop pl. pid. ppid. p_thn.
      sys_time = timer 
      wait = SCAN_DT
      call PYRxGo 'P','*','*','pl'
      do i=1 to pl.0  
        parse var pl.i pid.i ppid.i . . p_thn.i .
        s_thn = s_thn + p_thn.i
        if pid.i = s_pid then
          s_idx = i
       end
      sum_txt = left('Summary: 'pl.0' processes with 's_thn' threads',LEFT_SIZE)
      call PYRxShow ymx-2,0,0,sum_txt,SUM_ATTR
      if rt_view = TITLE then
        do
          vis.1 = 0 ; vis.2 = 0 ; vis.4 = 0
          call PYRxGO 't','....?','*','wl'
          do i=1 to wl.0
            interpret "vis."||wl.i||"=vis."||wl.i||"+1"
           end
          call PYRxShow ymx-2,LEFT_SIZE,0,left('  TaskList: Vis.'||vis.4||'  Gray.'||vis.2||'  Invis.'||vis.1,RIGHT_SIZE),SUM_ATTR
         end
      call get_cpu
      if rt_view = CPU then
        call show_cpu_info
      if rt_view = INFO then
        call show_sys_info
     end
  do while s_idx > pl.0
    s_idx = pl.0 ; s_pid = pid.s_idx ; s_off = 0
   end
  if wordpos(rt_view,'PATH INFO HELP') \= 0 then
    call PYRxShow ymx-2,LEFT_SIZE,0,left('  Process 's_pid' have 'p_thn.s_idx' thread(s)',RIGHT_SIZE),SUM_ATTR
  y_prc = 1
  do i=1 to pl.0 + INF_LINES while y_prc <= INF_LINES
    mask = ' '||ppid.i||' '
    parse var chain chain (mask) +1 alive .
    if alive = '' then chain = ''
    chain = ' 'chain' 'alive' 'pid.i' '
    if i < s_idx - s_off then
      iterate
    if i <= pl.0 then
      call show_p_info
     else
      call PYRxShow y_prc,0,LEFT_SIZE+RIGHT_SIZE*(rt_view=PATH | rt_view=TITLE),' ',PATH_ATTR
    y_prc = y_prc + 1
   end
  if rt_view = THREAD.0 | rt_view = THREAD.1 then
    do
      y_thr = 1 ; chain = '' ; drop tl.    
      call PYRxGo 'P',,s_pid,'tl'
      do while s_pid \= t_pid
        call drop_slots
        t_pid = s_pid ; t_mem = 0
       end
      call PYRxShow ymx-2,LEFT_SIZE,0,left('  Process 't_pid' have 'tl.0' thread(s)',RIGHT_SIZE),SUM_ATTR
      if tl.0 > INF_LINES then
        INFO.0 = INFO.LR
       else
        INFO.0 = INFO.L
      do i=1 to tl.0 + INF_LINES
        if i <= tl.0 then
          call show_t_info
         else
          if y_thr <= INF_LINES then
            do
              call PYRxShow y_thr,LEFT_SIZE,RIGHT_SIZE,' ',PATH_ATTR
              y_thr = y_thr + 1
             end
       end
     end
  if rt_view = HELP then
    call show_help
  
  call drop_slots
  draw_time = PYRxGo('i','.............?') - timer
  wait = wait - draw_time
  if wait <= draw_time then
    iterate
  parse value PYRxKey(wait) with char scan state right_head
  parse upper value x2c(char) with char
  select
    when scan = '00' & char = '0'x then
      if q_kill \= 0 then
        do
          attr = bitor(KEY_ATTR,d2c(7*((timer%SCAN_DT)//2)))
          call PYRxShow ymx-1,2,length(info_tx),,attr
         end
    when scan='01' then	/*Esc*/
      exit
    when q_kill \= 0 then
      do
        if q_kill = 3 then
          do
            if pos(char,'0123') \= 0 then
              call PYRxGo 'p','-',char
            if char = 4 then
              call PYRxGo 't','-'
           end
         else
          if char = 'y' | char = 'Y' then
            if q_kill = 1 then
              call PYRxGo 'p','-',s_pid
             else
              call PYRxGo 'P','-',s_pid
        q_kill = 0
       end
    when scan='0F' then	/*Tab*/
      call PYRxGo 't','.'
    when scan='1C' then	/*Enter*/
      call PYRxGo 'p','!',s_pid
    when scan = 48 then	/*Up*/
      if s_idx > 1 then
        do
	  s_idx = s_idx-1
	  s_off = s_off - (s_off > 0)
	 end
    when scan = 50 then	/*Down*/
      if s_idx < pl.0 then
        do
          s_idx = s_idx+1
	  s_off = s_off + (s_off < INF_LINES-1)
	 end
    when scan = 49 then	/*PgUp*/
      do
        s_idx = s_idx - INF_LINES
        if s_idx < 1 then s_idx = 1
        if s_idx - s_off < 1 then s_off = s_idx - 1
       end
    when scan = 51 then	/*PgDn*/
      do
        s_idx = s_idx + INF_LINES - 1
        do while s_idx > pl.0
          s_idx = pl.0
          s_off = (INF_LINES-1)*(pl.0 > INF_LINES)
         end
        if s_idx - s_off < 1 then s_off = 0
       end
    when scan = 47 then /* Home */
      do
        s_idx = s_idx - s_off
        s_off = 0
       end
    when scan = '4F' then /*End*/
      do  
        s_idx = s_idx + INF_LINES - s_off - 1
        if s_idx > pl.0 then s_idx = pl.0
        s_off = INF_LINES - 1
        if s_off > pl.0 then s_off = pl.0 - 1
       end
    when scan = 53 then	/* Del */
      if s_pid \= my_pid then
        q_kill = 1 + 2*(s_pid <= 15)
       else
        call beep 4000,100
    when scan = 93 then	/* Ctrl-Del */
      if s_pid \= my_pid then
        q_kill = 2 + (s_pid <= 15)
       else
        call beep 4000,100
    when char = 'T' then /* Threads view */
      if rt_view \= THREAD.0 & rt_view \= THREAD.1 then
        do
          INFO.0 = INFO.L ; rt_view = THREAD.0 ; right_head = THR_HEAD.0
          drop t_pid ; t_idx = 1
         end
    when char = 'C' then /* CPU view */
      if rt_view \= CPU then
        do
          INFO.0 = INFO.L ; rt_view = CPU ; right_head = CPU_HEAD
          t_idx = 1 
         end
    when char = 'P' then /* Exe Path names */
      if rt_view \= PATH then
        do
          rt_view = PATH ; INFO.0 = INFO.L ; right_head = EXE_HEAD
         end
    when char = 'W' then /* Task titles */
      if rt_view \= TITLE then
        do
          rt_view = TITLE ; INFO.0 = INFO.L ; right_head = WIN_HEAD
         end
    when char = 'I' then /* System&Program info */
      if rt_view \= INFO then
        do
          rt_view = INFO ; INFO.0 = INFO.L ; right_head = INFO_HEAD
          start_info = ''
         end
    when scan = '3B' then /*F1 - control keys info*/
      if rt_view \= HELP then
        do
          rt_view = HELP ; INFO.0 = INFO.L ; right_head = HELP_HEAD
          start_help = ''
         end
    when wordpos(rt_view,'PATH TITLE INFO HELP') \= 0 then
      nop
    when scan = '8D' then /*Ctrl-Up*/
      if t_idx > 1 then
        t_idx = t_idx-1
    when scan = 91 then	/*Ctrl-Down*/
      if t_idx <= tl.0 - INF_LINES then
        t_idx = t_idx+1
    when scan = 84 then /*Ctrl-PgUp*/
      do
        t_idx = t_idx - INF_LINES
        if t_idx < 1 then
          t_idx = 1
       end
    when scan = 76 then /*Ctrl-PgDn*/
      if t_idx <= tl.0 - INF_LINES then
        t_idx = t_idx + INF_LINES
    when scan = 77 then /* Ctrl-Home */
      t_idx = 1
    when scan = 75 then /*Ctrl-End*/
      if tl.0 > INF_LINES then
        t_idx = tl.0 - INF_LINES + 1
    when rt_view = CPU then
      nop
    when wordpos(scan,'4B 4D 73 74') \= 0 then /*Left\Right (+Ctrl)*/
      if xmx < 95 then
        do
          rt_view = 1 - right(rt_view,1)
          call PYRxShow 0,LEFT_SIZE,0,left(THR_HEAD.rt_view,RIGHT_SIZE),HEAD_ATTR
          rt_view = THREAD.rt_view
         end
    otherwise
      nop
   end /*select*/
  s_pid = pid.s_idx
  if wordpos(rt_view,'HELP INFO CPU') \= 0 then
    if wordpos(scan,'48 50 49 51 47 4F 53 93') \= 0 then
      rt_view = PATH
 end
exit

/**/

show_p_info:
  parse var pl.i . . p_typ p_ses p_thn p_st p_time ,
                  '"' p_pth '" ' p_ttl '01'x dt_sys dt_usr dt_idle p_dt
  p_time = t_conv(p_time*SLICE)
  peak = ((SLICE*(dt_sys+dt_usr))/p_dt)*100
  if peak >= 100.0 then
    peak = ' --.-- '
   else
    peak = format(peak,3,2)||'%' ; d_sign = '  '
  if s_idx = i then 
    if (y_prc = 1 & s_idx > 1) | s_idx = pl.0 then 
      d_sign = '2018'x
     else
      if (s_off = INF_LINES-1 & s_idx < pl.0) | s_idx = 1 then d_sign = '2019'x
  view_str = right(pid.i,5)||right(ppid.i,6)||right(p_typ,4)||p_time||peak||d_sign
  act  = format(((dt_sys+dt_usr-dt_idle)*LEFT_SIZE*SLICE)/p_dt,,0)
  idle = format((dt_idle*LEFT_SIZE*SLICE)/p_dt,,0)
  attr = P_I_FG ; lf_p_attr = PATH_ATTR
  if i = s_idx then
    do
      attr = P_I_SEL ; lf_p_attr = P_I_SEL
     end
  lt_attr = ACT_BG ; dk_attr = IDLE_BG
  y_view = y_prc ; x_view = 0 ; sz_view = LEFT_SIZE
  call stripe_show
  if rt_view = PATH then
    do
      ch_x = 2*(words(chain)-1)
      v_text = strip(right(p_pth,RIGHT_SIZE-ch_x-2))
      if v_text \= p_pth then
        v_text = '..'v_text
      v_text = left(left("",ch_x)||v_text,RIGHT_SIZE)
      call PYRxShow ,LEFT_SIZE,0,v_text,lf_p_attr
     end
  if rt_view = TITLE then
    do
      if datatype(p_ttl,'w') & p_ttl \= 0 then
        p_ttl = strip(PYRxGo('t','.........?',p_ttl),,'"')
       else 
        p_ttl = ''
      v_text = left(p_ttl,RIGHT_SIZE - 2)
      if length(p_ttl) > RIGHT_SIZE - 2 then
        v_text = v_text'..'
      call PYRxShow ,LEFT_SIZE,0,left(v_text,RIGHT_SIZE),lf_p_attr
     end
  return
  
t_conv: procedure
  parse arg tim
  rsec = tim%1000 ; rmsec = right(tim//1000,3,'0')
  rmin = rsec % 60 ;  rsec = right(rsec//60,2,'0')
  rhour = rmin % 60 ; rmin = right(rmin//60,2,'0')
  rday = rhour%24 ; rhour = right(rhour//24,2,'0')
  if rday > 99 then
    return ' --:--:--:--.---'
  return right(rday,3)||':'rhour':'rmin':'rsec'.'rmsec
  
drop_slots:
  do while t_slots \= ''
    parse var t_slots slot t_slots
    drop ut.slot st.slot
   end
  t_slots = chain
  return
  
show_t_info:
  parse var tl.i . tid slot sleep prio state t_st t_ut t_tim
  mask = ' 'slot' ' ;  chain = ' 'chain||mask
  parse var t_slots t_slots (mask) +1 alive mask ; t_slots = t_slots||mask
  if alive \= '' & t_st >= st.slot & t_ut >= ut.slot
  then
    do
      dt_sys =  t_st - st.slot ; dt_usr = t_ut - ut.slot
     end
   else
    do
      dt_sys =  t_st ; dt_usr = t_ut
     end
  st.slot = t_st ; ut.slot = t_ut
  if tid = 1 then
    t_dt = t_tim - t_mem 
  t_mem = t_tim ;
  if i < t_idx | y_thr > INF_LINES then 
    return
  peak = ((SLICE*(dt_sys+dt_usr))/t_dt)*100
  if peak >= 100.0 then
    peak = ' --.-- '
   else
    peak = format(peak,3,2)||'%'
  if rt_view = THREAD.0 then
    do
      view_str = right(tid,4)||right(slot,6)||' '||left(prio,6),
               ||right(state,4)||right(sleep,11)||peak
      if xmx >= 95 then
        view_str = view_str||t_conv(SLICE*(t_st+t_ut))
     end
   else
    view_str = right(tid,4)||' '||left(prio,6)||right(state,5)||peak,
             ||t_conv(SLICE*(t_st+t_ut))
  idle = format((dt_sys*RIGHT_SIZE*SLICE)/t_dt,,0)
  act = format((dt_usr*RIGHT_SIZE*SLICE)/t_dt,,0)
  lt_attr = REG_U_BG ; dk_attr = REG_S_BG
  if pos("IDL",prio) = 1 then
    do
      lt_attr = IDL_U_BG ; dk_attr = IDL_S_BG
     end
  y_view = y_thr ; x_view = LEFT_SIZE ; sz_view = RIGHT_SIZE ; attr = THR_ATTR
  call stripe_show
  y_thr = y_thr + 1
  return

get_cpu:
  drop tl.    
  call PYRxGo "i",,"tl"
  if \datatype(tl.0,'w') then
    do
      CPU_TXT = "Not supported OS level"
      tl.0 = 0
     end
   else 
    if tl.0 = 0 then
      CPU_TXT = "Not supported CPU type"
     else
      CPU_TXT = tl.0||" CPU(s) onboard"
  CPU_TXT = "   CPU info: "CPU_TXT
  do i=1 to tl.0
    parse var tl.i ts_l ts_h idle_l idle_h busy_l busy_h int_l int_h dt
      ts_cur = 4294967296*ts_h   + ts_l
    idle_cur = 4294967296*idle_h + idle_l
    busy_cur = 4294967296*busy_h + busy_l
     int_cur = 4294967296*int_h  + int_l
    if ts_prev.i \= 'TS_PREV.'||i then
      do
	ts = ts_cur - ts_prev.i
	busy = right(format(((busy_cur - busy_prev.i)*100)/ts,,2),7)
	int = right(format(((int_cur - int_prev.i)*100)/ts,,2),7)
	idle = right(format(((idle_cur - idle_prev.i)*100)/ts,,2),7)
	freq = format(ts/(dt*F_coeff),,0)
	tl.i = left('  'i||busy"%"int"%"idle"%  ~"freq" MGz.",RIGHT_SIZE)
       end
      else
       tl.i = ""
    ts_prev.i = ts_cur ;     idle_prev.i = idle_cur
    busy_prev.i = busy_cur ; int_prev.i = int_cur
   end
  return

show_cpu_info:
  y_thr = 1
  if tl.0 > INF_LINES then
    INFO.0 = INFO.LR
   else
    INFO.0 = INFO.L
  do i=1 to tl.0 + INF_LINES while y_thr <= INF_LINES
    sz_view = RIGHT_SIZE
    if i <= tl.0 & tl.i \= '' then
      do
        if i < t_idx then
          iterate
        parse var tl.i view_str 1 . busy '%' int '%' .
        act = format((busy*sz_view)/100,,0)
        idle = format((int*sz_view)/100,,0)
        if act >= sz_view then
          do
            act = sz_view; idle = 0
           end
         else
          if idle >= sz_view then
            do
              idle = sz_view; act = 0
             end
        lt_attr = CPU_B_BG ; dk_attr = CPU_I_BG
        y_view = y_thr ; x_view = LEFT_SIZE
        attr = CPU_ATTR
        call stripe_show
        y_thr = y_thr + 1
       end
     else
      do
        call PYRxShow y_thr,LEFT_SIZE,RIGHT_SIZE,' ',PATH_ATTR
        y_thr = y_thr + 1
       end
   end
  call PYRxShow ymx-2,LEFT_SIZE,0,left(CPU_TXT,RIGHT_SIZE),SUM_ATTR
  return

show_help:
  do while start_help = ''
    start_help = help_txt_info
    do i=1 to INF_LINES
      call PYRxShow i,LEFT_SIZE,RIGHT_SIZE,' ',HELP_BG
     end
    do until start_help = ''
      parse var start_help h_y '0'x h_key '0'x h_x '0'x h_text '0'x start_help
      call PYRxShow h_y,LEFT_SIZE,0,h_key,HLP_KEY_ATTR
      call PYRxShow ,'+'h_x,0,h_text,HLP_TXT_ATTR
     end
    drop start_help
   end
  return

get_version:
  version = ''
  call PYRxShow 0,0,ymx*xmx,' ',PATH_ATTR
  '@ver /r'
  parse value PYRxShow(0,0,'-'||(4*xmx)) with wl.1 +(xmx) wl.2 +(xmx) wl.3 +(xmx) wl.4
  do i=1 to 4
    call strip(wl.i)
    version = version||result
    if result \= '' then
      version = version||'0'x
   end
  return

show_sys_info:
  call PYRxGo "i","....?????.???...???....??","wl"
  do while start_info = ''
    drop start_info
    do i=1 to INF_LINES
      call PYRxShow i,LEFT_SIZE,RIGHT_SIZE,' ',INFO_BG
     end
    parse var version wl.14 '0'x wl.15
    call PYRxShow 4,LEFT_SIZE+1,0,left(wl.14,RIGHT_SIZE-1),INFO_DATA_ATTR
    call PYRxShow '+'1,,0,left(wl.15,RIGHT_SIZE-1),INFO_DATA_ATTR
    call PYRxShow '+'1,,0,'(Maj.'||wl.6||'  Min.'||wl.7||'  Rev.'||wl.8||')',INFO_DATA_ATTR
    call PYRxShow '+'2,,0,'Boot drive ',INFO_TXT_ATTR
    call PYRxShow ,'+'11,0,substr(xrange('41'x,'58'x),wl.1,1)||':',INFO_DATA_ATTR
    call PYRxShow 10,LEFT_SIZE+1,0,'Memory available:',INFO_TXT_ATTR
    call pyrxshow '+1',,0,"Physical",INFO_TXT_ATTR
    call pyrxshow '+1',,0,"Resident",INFO_TXT_ATTR
    call pyrxshow '+1',,0,"Total",INFO_TXT_ATTR
    call PYRxShow '+2',,0,'Priority variation :',INFO_TXT_ATTR
    call PYRxShow '+1',,0,"Maximum wait",INFO_TXT_ATTR
    call PYRxShow '+1',,0,"TimeSlice : Min.",INFO_TXT_ATTR
    call PYRxShow '+2',,0,'FG PID        FG FS SID ',INFO_TXT_ATTR
    if DeskTop \= '' then
      do
        call PYRxShow '+2',,0,' DeskTop folder -',INFO_TXT_ATTR
        call PYRxShow '+1',,0,left(DeskTop,RIGHT_SIZE-1),INFO_DATA_ATTR
       end
   end
  call PYRxShow 1,LEFT_SIZE+1,0,date()||'  'time(),INFO_DATA_ATTR
  call PYRxShow '+'1,,0,'System timer:',INFO_TXT_ATTR
  attr = INFO_DATA_ATTR
  if sys_time > 4208567295 then
    attr = bitor(INFO_BG,'e'x)
  if sys_time > 4291367295 then
    attr = bitor(INFO_BG,'c'x)
  call PYRxShow ,'+'13,0,t_conv(sys_time),attr
  call pyrxshow 11,LEFT_SIZE+10,0,left(wl.9||" Bytes",RIGHT_SIZE-10),INFO_DATA_ATTR
  call pyrxshow '+1',,0,left(wl.10||" Bytes",RIGHT_SIZE-10),INFO_DATA_ATTR
  call pyrxshow '+1',,0,left(wl.11||" Bytes",RIGHT_SIZE-10),INFO_DATA_ATTR
  call PYRxShow '+2',LEFT_SIZE+22,0,word('absolute dynamic',wl.2+1)||'   ',INFO_DATA_ATTR
  call pyrxshow '+1',LEFT_SIZE+14,0,wl.3||' sec.  ',INFO_DATA_ATTR
  call pyrxshow '+1',LEFT_SIZE+17,0,wl.4||" msec.",INFO_DATA_ATTR
  call pyrxshow ,'+'||(length(wl.4)+7),0,"Max.",INFO_TXT_ATTR
  call pyrxshow ,'+4',0,wl.5||' msec.    ',INFO_DATA_ATTR
  call PYRxShow '+2',LEFT_SIZE+8,0,wl.13,INFO_DATA_ATTR
  call PYRxShow ,'+17',0,wl.12,INFO_DATA_ATTR
  return

stripe_show:
  attr_str = ""
  if datatype(act,'w') then
    do
      if act > 0 then
        attr_str = left("",act,bitor(lt_attr,bitand(attr,'f'x)))
       else
        act = 0
     end
   else
    act = 0
  if datatype(idle,'w') then
    do
      if idle > 0 then
        attr_str = attr_str||left("",idle,bitor(dk_attr,bitand(attr,'f'x)))
       else
        idle = 0
     end
   else
    idle = 0
  sz_attr = sz_view-act-idle
  if sz_attr > 0 then
    attr_str = attr_str||left("",sz_attr,attr)
  view_str = left(view_str,sz_view)
  v_str = ''
  do j=1 to sz_view
    v_str = v_str||substr(view_str,j,1)||substr(attr_str,j,1)
   end
  call PYRxShow y_view,x_view,-1,v_str
  return

set_icon : procedure expose eP short_title

  if SysGetEA(eP,'.ICON','ic') = 0 then
    if length(ic) = 6948 then
      return
  restart = length(ic) = 0

  parse value charin(eP,,50000) with '2f2a7e'x i64 '2a2f'x
  call stream eP,'c','close'
  i64 = translate(i64,'0000'x,'0d0a'x)
  
  d_code = xrange('0'x,'3f'x) ; s_code = xrange('A','Z')||xrange('a','z')||'0123456789+/'
  ji = 1 ; ic = ''
  call pos '0'x,i64
  do while result \= 0
    tmp_s = ''
    if result > ji then
      tmp_s = x2b(c2x(translate(substr(i64,ji,result-ji),d_code,s_code)))
    ji = result+1
    do while tmp_s \= ''
      parse var tmp_s +2 ic.0 +6 +2 ic.1 +6 +2 ic.2 +6 +2 ic.3 +6 +2 ic.4 +6 +2 ic.5 +6 ,
                  +2 ic.6 +6 +2 ic.7 +6 +2 ic.8 +6 +2 ic.9 +6 +2 ic.10 +6 +2 ic.11 +6 tmp_s
      result = ic.0||ic.1||ic.2||ic.3||ic.4||ic.5||ic.6||ic.7||ic.8||ic.9||ic.10||ic.11
      if result \= '' then
        ic = ic||x2c(b2x(left(result,length(result)%8*8)))
     end
    call pos '0'x,i64,ji
   end

  if length(ic) \= 6944 then
    return
  ic = 'F9FF'x||translate('12',d2c(length(ic),2),'21')||ic
  if SysPutEA(eP,'.ICON',ic) \= 0 then
    return
  if restart then
    do
      tmp_s = SysTempFileName(left(eP,lastpos("\",eP))||'TMP?????.ICO')
      call charout tmp_s,substr(ic,5)
      call charout tmp_s
      if PYRxMsg(,,,short_title,'Ready to use .',tmp_s,,'Ok','Make WPS object') = 12 then
        call SysCreateObject "WPProgram",short_title,"<WP_DESKTOP>","EXENAME="eP,"REPLACE"
      '@del 'tmp_s
      '@start /c /f /pgm "'eP'"'
     end
  exit

/*~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*/
