#include <string.h>

#define INCL_DEV
#define INCL_GPILCIDS
#define INCL_WINFRAMEMGR
#define INCL_WINSHELLDATA
#include <os2.h>

#include "printsup.h"


/* ----------------------------------------------------------------- */

VOID PrintLinesAt (HPS hps, POINTL ptl,
    PSZ pszBuf, LONG lMaxBaselineExt)
{
    /*
     *  Print the lines of text in a buffer, starting at the indicated
     *  position.  The lines must be separated by either carriage
     *  returns, or carriage return/line feed pairs.
     */

    PSZ     pszLine;

    pszLine = strtok (pszBuf, "\r");

    while (pszLine)
    {
        if (*pszLine == '\n')       /* Skip over line feed if present */
            ++pszLine;

        GpiCharStringAt (hps, &ptl,
            (LONG) strlen (pszLine), pszLine);
        ptl.y -= lMaxBaselineExt;

        pszLine = strtok (0, "\r");
    }
}



/* ----------------------------------------------------------------- */

VOID PrintString (HDC hdcPrint, PSZ psz)
{
    /*
     *  Print a zero-terminated string by sending as raw data.
     */

    DevEscape (hdcPrint, DEVESC_RAWDATA, (LONG) strlen (psz),
        psz, 0L, 0);
}



/* ----------------------------------------------------------------- */

USHORT OpenDefaultPrinterDC (HAB hab, PHDC phdcPrint,
    PSZ pszDataType)
{
    CHAR            achPrnData[256];
    DRIVDATA        driv;
    CHAR            achDefPrnName[34], *pchDelimiter;
    DEVOPENSTRUC    dop;



    PrfQueryProfileString (HINI_PROFILE,
	"PM_SPOOLER", "PRINTER",
	";", achDefPrnName, sizeof achDefPrnName);

    if ((pchDelimiter = strchr (achDefPrnName, ';')) != NULL)
	*pchDelimiter = '\0';

    if (achDefPrnName[0] == '\0')
	return DEV_ERROR;

    //Obtain information on default printer

    PrfQueryProfileString (HINI_PROFILE,
	"PM_SPOOLER_PRINTER", achDefPrnName,
	";;;;", achPrnData, (ULONG) sizeof achPrnData);

    //Parse printer information string

    if ((pchDelimiter = strchr (achPrnData, ';')) == NULL)
	return DEV_ERROR;

    dop.pszDriverName = pchDelimiter + 1;

    if ((pchDelimiter = strchr (dop.pszDriverName, ';')) == NULL)
	return DEV_ERROR;

    dop.pszLogAddress = pchDelimiter + 1;

    *(dop.pszLogAddress + strcspn (dop.pszLogAddress, ",;")) = '\0';
    *(dop.pszDriverName + strcspn (dop.pszDriverName, ",;")) = '\0';

    //Fill DRIVDATA structure if necessary

    if ((pchDelimiter = strchr (dop.pszDriverName, '.')) != NULL)
    {
        *pchDelimiter = '\0';
        memset (&driv, 0, sizeof driv);
        driv.cb = sizeof driv;
        strncpy (driv.szDeviceName, pchDelimiter + 1,
            sizeof (driv.szDeviceName));
        dop.pdriv = &driv;
    }
    else
        dop.pdriv = NULL;

    //Set data type

    dop.pszDataType = pszDataType;

    //Open printer device context

    *phdcPrint = DevOpenDC (hab, OD_QUEUED, "*", 4L,
	(PDEVOPENDATA) & dop, 0);

    return 1;
}
