/* Create WebWilly for OS/2 bookmarks from OS/2 WPS URL objects */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
signal on syntax name NoREXX
call SysLoadFuncs
signal on syntax name Syntax
'@ECHO OFF'
parse arg indir outfolder
if outfolder='' then do
   say ""
   say "Parameters:"
   say "-----------"
   say "1.  The directory which contains the URL objects from which the"
   say "    bookmarks are to be created."
   say ""
   say "2.  The folder in which the bookmarks are to be created.  Can be the"
   say "    relative pathname of an existing folder; or, if the current"
   say "    directory is the BOOKS subdirectory of your WebWilly directory,"
   say "    then it can be the title or subdirectory name of an existing"
   say "    folder in the BOOKS subdirectory, or the subdirectory name of a"
   say "    folder to create in the BOOKS subdirectory."
   exit
end
call sysfiletree outfolder,'folder','DO'
if folder.0>1 then do
   say ""
   do i=1 to folder.0
      say folder.i
   end
   say ""
   say "Parameter ("outfolder") not understood:"
   say "More than one directory exists with that name."
   exit
end
if folder.0=0 then do
   call sysfiletree '..\LOG','check','DO'
   if translate(right(directory(),6))='\BOOKS' & check.0=1 & pos('\',outfolder)=0 then do
      oldtitle=outfolder
      outfolder=strip(left(translate(outfolder,'',' \|,./<>?;'':"[]{}`-=~!@#$%^&*()+','_'),8))
      outfolder=translate(outfolder,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')
      call sysfiletree outfolder,'check','DO'
      if check.0=1 then outfolder=check.1
      else do
         say ""
         say "Please enter a title for the new folder ("outfolder"):"
         say "(default: " oldtitle")...."
         parse pull title
         if strip(title)='' then title=oldtitle
         rc=sysmkdir(outfolder)
         if rc>0 then do
            say ""
            say "Unable to create" outfolder "directory."
            exit
         end
         if SysPutEA(outfolder,'WEBEXFOLDERNAME',title)>0 then do
            say ""
            say "Unable to apply title ("title")"
            say "to the new folder ("outfolder")...."
            exit
         end
      end
   end
   else do
      say ""
      say "Folder ("outfolder") not found."
      say "Please use WebWilly to create it first."
      exit
   end
end
if folder.0=1 then outfolder=folder.1
title=''
rc=SysGetEA(outfolder,'WEBEXFOLDERNAME','title')
if rc>0 | strip(title)='' then do
   say ""
   say outfolder "is not a WebWilly folder."
   exit
end
say ""
say "Adding bookmarks from" indir
say "to" title "folder"
say "(directory" outfolder")...."
say ""
call sysfiletree indir'\*.*','urls','FT'
do i=1 to urls.0
   parse var urls.i y '/' mo '/' d '/' h '/' min size attribs name
   name=strip(name)
   url=linein(name)
   call lineout name
   if wordpos(y,"96 97 98 99")>0 then y="19"||y
   else y="20"||y
   date=y'/'mo'/'d
   if h<12 then noon='am'
   else noon='pm'
   if h>12 then h=h-12
   time=h':'min||noon
   title=''
   rc=SysGetEA(name,'.TYPE','title')
   if rc>0 | (pos('UniformResourceLocator',title)=0 & pos('WebExplorer_Url',title)=0) then do
      say ""
      say "The" name
      say "file does not seem to be a URL object."
      say ""
      iterate
   end
   title=''
   rc=SysGetEA(name,'.SUBJECT','title')
   if rc>0 | title='' then rc=SysGetEA(name,'.LONGNAME','title')
   if rc>0 | title='' then do
      say ""
      say "The" name
      say "file does not seem to be a URL object."
      say ""
      iterate
   end
   title=substr(title,5)
   string='17'x||title||'09'x||url||'09'x||date||'09'x||time||'09'x||'20'x||'09'x||'09'x
   filename=GetPopName(outfolder,'URL')
   if filename='error' then exit
   filename=outfolder'\'filename'.URL'
   call lineout filename
   call lineout filename
   if SysPutEA(filename,'URLFILEBUFFER',string)=0 then say "Created bookmark" filename "for" name
   else say "Error on" name
end
exit
/* Copyright (c)1996 Kari Jackson for InnoVal Systems Solutions, Inc. */
/* Subroutine to produce a *.POP-style filename */
/* Returns 8-character name or "error" */
GetPopName:procedure
parse arg directory,extension
characters='0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'
parse value date("O") with . 2 year "/" month "/" day
parse value time() with hour ":" minute ":" second
month=substr(characters,month+1,1)
day=substr(characters,day+1,1)
hour=substr(characters,hour+1,1)
fifth=minute%36
sixth=substr(characters,minute//36+1,1)
test=second//36
string=year||month||day||hour||fifth||sixth
do j=1 to 36
   test2=(test+j)//36
   if test2=0 then seventh=substr(characters,36,1)
   else seventh=substr(characters,test2,1)
   do i=1 to 36
      tryit=string||seventh||substr(characters,i,1)
      filename=directory||"\"||tryit||'.'||extension
      if stream(filename,'c','query exists')='' then return tryit
   end
end
say ""
say "There have already been 1296 files created in the" directory
say "directory during this minute.  Please wait until the clock"
say "changes and try again."
return 'error'
Syntax:
  say 'Error' rc 'in line' sigl':' errortext(rc)
  say sigl':' sourceline(sigl)
  exit
return
NoREXX:
   say 'Unable to load the REXXUtil functions.  Either the REXXUTIL.DLL file'
   say 'is not on the LIBPATH or REXX support is not installed on this system.'
   exit
return
