/*  Installation ES-WEB-Slide Show */

'@Echo Off'

/* REXXUTIL laden */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs


/* Initialisieren */

Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Call SysCls
Say ''
Say '  Installation ES-WEB-Slide-Show 1.x'
Say ''


/* Sprach-Auswahl */

 
Language = 'DEUTSCH'

 Icon = 1
 

/* Check for the files */

Result = SysFileTree( 'ESWSLIDE.EX_', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say '  Fehler: ESWSLIDE.EX_ nicht gefunden !'
  Signal DONE
  End

Result = SysFileTree( 'Readme.txt', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say '  Fehler: Readme.txt nicht gefunden!'
  Signal DONE
  End

Result = SysFileTree( 'start.htm', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say '  Fehler: Start.htm nicht gefunden!'
  Signal DONE
  End

Result = SysFileTree( 'eswhaupt.htm', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say '  Fehler: ESWHaupt.htm nicht gefunden!'
  Signal DONE
  End

Result = SysFileTree( 'eswedit.htm', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say '  Fehler: ESWEdit.htm nicht gefunden!'
  Signal DONE
  End

Result = SysFileTree( 'eswsetup.htm', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say '  Fehler: ESWSetup.htm nicht gefunden!'
  Signal DONE
  End

Result = SysFileTree( 'ESWSLIDE.ESW', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say '  Fehler: ESWSLIDE.ESW nicht gefunden!'
  Signal DONE
  End

/* Get target directory */

    Say '  Bitte geben Sie den vollen Verzeichnisnamen ein, wohin die'
    Say '  ES-WEB-Slide-Show installiert werden soll' 
    Say ''
    Say '  oder drcken Sie Enter, um in das Standard-Verzeichnis'
    Say '  C:\ESWSLIDE zu installieren'
    Say ''
    Say '  Wenn Sie NICHT intallieren wollen, tippen Sie bitte N und Enter'
    Say '  '
Pull Directory
If Directory = "" Then Directory = 'C:\ESWSLIDE'
if Directory ="N" then 'Exit'
Say ''

/* Create the target directory if necessary. */

Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say '  FEHLER: Kann das Zielverzeichnis nicht anlegen.'
    Signal DONE
    End
  End
Say '';


/* Do the installation */

Say '  Installiere ES-WEB-SLIDE-Show in Verzeichnis ' Directory '...'
Copy "ESWSLIDE.EX_" Directory"\ESWSLIDE.EXE"   '1>NUL'
Copy 'Readme.TXT' Directory"\Readme.txt" '1>NUL'
Copy 'start.htm' Directory"\start.htm" '1>NUL'
Copy 'eswhaupt.htm' Directory"\eswhaupt.htm" '1>NUL'
Copy 'eswedit.htm' Directory"\eswedit.htm" '1>NUL'
Copy 'eswsetup.htm' Directory"\eswsetup.htm" '1>NUL'
Copy 'ESWSLIDE.ESW' Directory"\ESWSLIDE.ESW" '1>NUL'

Result = SysFileTree( "ESWSLIDE.ICO", 'Files', 'F' )
If Files.0 > 0 Then
  Do
   Copy "ESWSLIDE.ICO" Directory"\ESWSLIDE.ICO"  '1>NUL'
  End

If Icon = 1 Then
  Do
   Say ''
   Say '  Erstelle Icon...'
   Folder = '<WP_DESKTOP>'
   Type = 'WPProgram'
   Title = 'ES-Web-Slide-Show'
   Parms = 'MINWIN=DESKTOP;PROGTYPE=WP;EXENAME='Directory'\ESWSLIDE.EXE;STARTUPDIR='Directory';OBJECTID=<ES-WEB-SLIDE-SHOW>;NOPRINT=YES;'
   Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )

   If Result = 1 Then
     Say '  Icon erstellt!'
   Else
     Say '  Fehler : Das Icon wurde nicht erstellt!'
  End

Say '  Installation beendet'
Say ''
 
Say '  Sie knnen weitere Informationen im Redme.txt '
Say '  und in der Web-Datei Start.htm lesen.'
Say ''
Say '  Das Programm befindet sich jetzt auf Ihrer Arbeitsoberflche'
Say '  Viel Vergngen mit diesem Produkt'
Signal DONE

FAILURE:
Say 'REXX failure.'
Signal DONE

HALT:
Say 'REXX halt.'
Signal DONE

SYNTAX:
Say 'REXX syntax error.'
Signal DONE

DONE:
Say ''
say '  Bitte drcken Sie Enter'
pull 

Exit
