/* REXX */

/*
 *  File     : TS_SNIFF
 *  Purpose  :
 *
 *
 *  Modification History:
 *
 *  --Date--- --By-- --Reason------------------------------------------------
 *  1997.06.17     TAB   Created script
 *
 */


/* ----- */

app      = 'TS_SNIFF'
hostname = VALUE('HOSTNAME',, 'OS2ENVIRONMENT')
temp     = getTemp()
link     = ''


/* load the REXX utility package */

CALL RXFuncAdd SysLoadFuncs, RexxUtil, SysLoadFuncs
CALL SysLoadfuncs


/* see if we know where the InJoy code is */

profile = SysIni('USER', 'TS', 'PROFILE')
IF profile = 'ERROR:' THEN DO
   rc = status(app, 'INFO', 'Searching for the tunnel slave')
   EXIT 2
END


/* test to insure that InJoy is running */

IF \ isrun('in-joy') THEN DO
   rc = status(app, 'ERROR', 'InJoy must be connected for dynamic tunnel configuration')
   EXIT 2
END
ELSE DO

   /* dynamic slave grab */

   rc = status(app, 'INFO', 'Looking up slave details in the DNS')

   slave = SysIni(profile, 'TS', 'HOSTNAME')
   IF slave = 'ERROR:' THEN master = SysIni(profile, 'TS', 'HOSTNAME', hostname)
   DO QUEUED() ; PULL message ; END
   '@nslookup -q=any -timeout=3' hostname '| rxqueue 2>' temp||'\nslookup.err'

   IF rc > 0 THEN DO
      rc = status(app, 'ERROR', 'RC =' RC 'connecting to DNS')
      IF exist(profile) THEN DO
         rc = status(app, 'WARNING', 'Using previous slave configuration')
      END
      ELSE DO
         rc = status(app, 'ERROR', 'No previous slave configuration available')
         EXIT 2
      END
   END
   ELSE DO
      DO QUEUED()

         PARSE PULL host protocol '=' data
         PARSE UPPER VAR host host

         IF host = 'SERVER:'  THEN rc = SysIni(profile, 'DNS', 'HOSTNAME', STRIP(protocol))

         data     = STRIP(data)
         protocol = TRANSLATE(STRIP(protocol))
         IF LENGTH(data) > 3 THEN DO

            /* Strip off any delimiters */

            data = undelimit(data)
            data = TRANSLATE(data, ' ', ':')
            data = TRANSLATE(data, ' ', '=')


/*          SAY '|'||host||'|'||protocol||'|'||data||'|' */


            /* Check for any key words */

            IF TRANSLATE(WORD(data, 1)) = 'LINK'    THEN link = WORD(data, 2)
            IF protocol = 'ADDRESS' & SUBSTR(host, 1, LENGTH(hostname)) = TRANSLATE(hostname)
                                                    THEN rc = SysIni(profile, 'TS',    'ADDRESS',   data)
            IF TRANSLATE(WORD(data, 1)) = 'NETMASK' THEN rc = SysIni(profile, 'TS',    'NETMASK',   WORD(data, 2))
            IF TRANSLATE(WORD(data, 1)) = 'MASTER'  THEN rc = SysIni(profile, 'TM',    'HOSTNAME',  WORD(data, 2))
            IF TRANSLATE(WORD(data, 1)) = 'CIRCUIT' THEN rc = SysIni(profile, 'MODEM', 'PHONE_NO',  WORD(data, 2))
         END
      END
   END


   /* Make sure that we are the correct link type */

   IF link \ = 'INJOY' THEN DO
      rc = status(app, 'ERROR', 'The DNS lists this station as link type "'||link||'".')
      EXIT 2
   END


   /* dynamic master grab */

   rc = status(app, 'INFO', 'Looking up master details in the DNS')

   master = SysIni(profile, 'TM', 'HOSTNAME')
   IF master = 'ERROR:' THEN DO
      master = 'tm'
      rc = SysIni(profile, 'TM', 'HOSTNAME', master)
   END
   DO QUEUED() ; PULL message ; END
   '@nslookup -q=any' master '| rxqueue 2>' temp||'\nslookup.err'

   IF RC THEN DO
      rc = status(app, 'ERROR', 'RC =' RC 'connecting to DNS')
      IF exist(profile) THEN DO
         rc = status(app, 'WARNING', 'Using previous master configuration')
      END
      ELSE DO
         rc = status(app, 'ERROR', 'No previous master configuration available')
         EXIT 2
      END
   END
   ELSE DO
      DO QUEUED()

         PARSE PULL host protocol '=' data
         PARSE UPPER VAR host host

         data     = STRIP(data)
         protocol = TRANSLATE(STRIP(protocol))
         IF LENGTH(data) > 3 THEN DO

            data = undelimit(data)
            data = TRANSLATE(data, ' ', ':')
            data = TRANSLATE(data, ' ', '=')


            /* Check for any key words */

            IF protocol = 'ADDRESS' & SUBSTR(host, 1, LENGTH(master)) = TRANSLATE(master)
                                                      THEN rc = SysIni(profile, 'TM', 'ADDRESS',   data)
            IF TRANSLATE(WORD(data, 1)) = 'INTERFACE' THEN rc = SysIni(profile, 'TM', 'INTERFACE', WORD(data, 2))
            IF TRANSLATE(WORD(data, 1)) = 'NETMASK'   THEN rc = SysIni(profile, 'TM', 'NETMASK',   WORD(data, 2))
            IF TRANSLATE(WORD(data, 1)) = 'PASSWORD'  THEN rc = SysIni(profile, 'TM', 'PASSWORD',  WORD(data, 2))
         END
      END
   END
   '@DEL' temp||'\nslookup.err'

END


RETURN 0
