/* REXX */

/*
 *  File     : TS_ROUTE3
 *  Purpose  :
 *
 *
 *  Modification History:
 *
 *  --Date--- --By-- --Reason------------------------------------------------
 *  1997.06.17     TAB   Created script
 *
 */


/* ----- */

app = 'TS_ROUTE3'


/* load the REXX utility package */

CALL RXFuncAdd SysIni,   RexxUtil, SysIni
CALL RXFuncAdd SysSleep, RexxUtil, SysSleep


/* see if we know where the InJoy code is */

profile = SysIni('USER', 'TS', 'PROFILE')
IF profile = 'ERROR:' THEN DO
   rc = status(app, 'ERROR', 'Tunnel configuration not found')
   EXIT 2
END


/* strip out any bad routes */

rc = status(app, 'INFO', 'Repairing routing table')

slave.address = SysIni(profile, 'TS', 'ADDRESS')
IF slave.address = 'ERROR:' THEN DO
   rc = status(app, 'ERROR', 'Slave interface address unknown'
   EXIT 2
END

rc = SysSleep(2)
'@route delete default' slave.address '> nul'
'@route add    default' slave.address '0 > nul'


RETURN 0
