/************************************************************************/
/*                                                                      */
/*              REXX script for aDialIn package                         */
/*         Calculate total on-line time of last month                   */
/*                                                                      */
/* (C) 1996, Axel Mueller (amueller@stargate.rz.fh-offenburg.de)        */
/*     Version 1.1     10/01/96                                         */
/************************************************************************/

/* INI file for settings */
INIFile = 'userctrl.ini'

/**************/
/* Path setup */
/**************/

Path			= value('USERCTRLDIR',,'OS2ENVIRONMENT')
INIFile		= Path'\'INIFile


/* Get number of modems installed */
FirstModemCOM		= read_from_INI(FirstModemCOM)
LastModemCOM			= read_from_INI(LastModemCOM)

/* Path to log files */
LogPath		= read_from_INI(LogPath)

OnlineLOG		= LogPath'\ONLINE.LOG'



/**************************/
/* calculate on-line time */
/**************************/

Month = substr(date(european),4,2) - 1
Year  = substr(date(european),7,2)
if Month == 0 then
	do
		Month = 12
		Year = Year - 1
	end
if Month < 10 then
	Month = '0'Month



TotHours = 0
TotMin = 0
TotSec = 0
do ModemIndex = FirstModemCOM to LastModemCOM
	LogFile = LogPath'\'Month||Year'_'ModemIndex'.log'

	Hrs = 0
	Min = 0
	Sec = 0
	Finished = False
	do while Finished = False

		Line = linein(LogFile)
		if length(Line) > 0 then
			do
				parse value Line with User SDate STime ETime
				ETime = strip(ETime)

				SHrs = substr(STime,1,2)
				SMin = substr(STime,4,2)
				SSec = substr(STime,7,2)
				EHrs = substr(ETime,1,2)
				EMin = substr(ETime,4,2)
				ESec = substr(ETime,7,2)

				ZHrs = 0
				ZMin = 0
				ZSec = 0

				do while (SHrs<>EHrs) | (SMin<>EMin) | (SSec<>ESec)
					ZSec  = ZSec + 1
					SSec = SSec + 1
					if SSec = 60 then
						do
							SSec = 0
							SMin = SMin + 1
						end
					if SMin = 60 then
						do
							SMin = 0
							SHrs = SHrs + 1
						end
					if SHrs = 24 then
						SHrs = 0			
				end

				ZHrs = ZSec % 3600
				ZMin = (ZSec - ZHrs*3600) % 60
				ZSec = ZSec - ZHrs*3600 - ZMin*60

				Sec = Sec + ZSec
				Min = Min + ZMin
				Hrs = Hrs + ZHrs
				if Sec >= 60 then
					do
						Min = Min + Sec % 60
						Sec = Sec // 60
					end
				if Min >= 60 then
					do
						Hrs = Hrs + Min % 60
						Min = Min // 60
					end

				say SDate' 'STime' - 'ETime'   'ZHrs':'ZMin':'ZSec'   'Hrs':'Min':'Sec
			end

		else
			Finished = True

	end

	if Min < 10 then
		Min = '0'Min
	if Sec < 10 then
		Sec = '0'Sec
	TotalLine.ModemIndex = Hrs':'Min':'Sec

	TotHours = TotHours + Hrs
	TotMin = TotMin + Min
	TotSec = TotSec + Sec
          
end

if TotSec >= 60 then
	do
		TotMin = TotMin + TotSec % 60
		TotSec = TotSec // 60
	end
if TotMin >= 60 then
	do
		TotHours = TotHours + TotMin % 60
		TotMin = TotMin // 60
	end
if TotMin < 10 then
	TotMin = '0'TotMin
if TotSec < 10 then
	TotSec = '0'TotSec
TotalAllLines = TotHours':'TotMin':'TotSec

LogLine = Month||Year
ModemIndex = 1
do ModemIndex = FirstModemCOM to LastModemCOM
	LogLine = LogLine||copies(' ', 13-length(TotalLine.ModemIndex))||TotalLine.ModemIndex
end
LogLine = LogLine||copies(' ', 18-length(TotalAllLines))||TotalAllLines

rc = lineout(OnlineLOG, LogLine)
rc = lineout(OnlineLOG )

exit



/************************************************************************/
/* read_from_INI(Parameter)                                             */
/*                                                                      */
/* Reads settings from INI file                                         */
/************************************************************************/


read_from_INI:
	parse arg Parameter

	if length(stream(INIFile, 'c', 'query exists')) > 0 then
		do
			Finished = FALSE
			do while Finished == FALSE
				Line = linein(INIFile)
				parse upper value Line with Parm . ParmValue
				if length(Line) > 0 then
					do
						if Parm == Parameter then
							do
								ParameterValue = ParmValue
								Finished = TRUE
							end
					end
				else
					do
						say 'ERROR: Paramter 'Parameter' could not be found in 'INIFile'!'
						exit
					end
			end
		end
	else
		do
			say 'ERROR: 'INIFile' not found!'
			exit
		end

	rc = lineout(INIFile)

	return ParameterValue


