/* ========================================== */
/* REXX    MOUNTFS.CMD        MHP   5/95      */
/* Unmount and remount all NFS drives that    */
/* are listed in the FSTAB file.              */
/* Uses the ETC environment variable to find  */
/* the FSTAB file.                            */
/* ------------------------------------------ */
/* Mike Prager   mikep@aurora.tib.nmfs.gov    */
/* ========================================== */
call RxFuncAdd SysLoadFuncs,RexxUtil,SysLoadFuncs
call SysLoadFuncs

/*---Get the name of FSTAB in a standard format---*/
env='OS2ENVIRONMENT'
temp= value('etc',,env)
len = length(temp)
if substr(temp,len) = "\" then temp = temp || "\"
filename = temp || "fstab"
say "*** MOUNTFS    MHP   May 1995"
say "*** Examining" filename "..."

index = 1

/*---Load the FSTAB entries into an array (entry)---*/
do forever
   if lines(filename) = 0 then leave
   line = linein(filename)
   hash = substr(line,1,1)
   if hash = "#" then do
      entry.index = line
      index = index + 1
   end /* do */
end

entry.0 = index - 1

say "*** There are" entry.0 "drives to be mounted."

/*---Unmount everything now mounted---*/
"@umount *"

/*---Mount the drives---*/
do index = 1 to entry.0
   entry.index
end

say "*** MOUNTFS done."
/*==================End of Program===================*/
