/******************************************************************************/
/*                                                                            */
/* gettunnelip.cmd      V 1.01                                                */
/*                                                                            */
/* DialScript fr ISDNPM PPTP Tunnelverbindungen auf Server mit dynmischer IP */
/*                                                                            */
/*  Untersttzt: a. Dynamische IP mit dyndns.org                              */
/*               b. Dynamische IP hinterlegt auf WebServer                    */
/*                                                                            */
/*   Tunnelparameter in user.out:                                             */
/*               a. DomainName  z.B. KamelTreiber.dyndns.Org                  */
/*               b. DomainName/Pfad  z.B.  www.sonstwer.de/ipupload.txt       */
/*                                                                            */
/*   Einschrnkungen fr b.:                                                  */
/*       Format von ipupload.txt :                                            */
/*       "Start UpLoadip  19 Jan 2003 15:01:09 IP: 99.999.999.99  "           */
/*       Andere Formate men angepasst werden                                */
/*                                                                            */
/* Author: M.Vlkel 1/2003                                                    */
/*    Keine Garantie usw.....                                                 */
/******************************************************************************/

call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
call SysLoadFuncs

/* load socket-lib: */

If RxFuncQuery("SockLoadFuncs") Then
Do
  Call RxFuncAdd "SockLoadFuncs","RXSOCK","SockLoadFuncs"
  Call SockLoadFuncs
End

  parse arg name tunnel .

  HostName = ""
  FileName = ""

  parse var tunnel HostName "/" FileName

  IPAddr = ""
  if FileName <> "" then IPAddr = GetIpFromWeb(HostName,FileName)
  else                   IPAddr = GetIpFromDNS(HostName)

  if IPAddr == "" then return "NODIAL"

/* 
   WICHTIG: Die Verbindung wird nur aufgebaut 
   wenn "DIAL" als Exit-Code uebergeben wird.
*/

return "DIAL "||IPAddr

/******************************************************************************/

GetIpFromWeb: procedure 
  HostName = arg(1)
  FileName = arg(2)

  CRLF = "0D0A"x

  Socket = SockSocket("AF_INET", "SOCK_STREAM", "0")
  
  rc = SockGetHostByName(HostName,"Host.!")

  if rc == 0 then return ""

  Host.!family = "AF_INET"
  Host.!port   = 80

  rc=SockConnect( Socket, "Host.!")
  if( rc < 0 ) then do    
    Call SockClose Socket
    return ""
  end

  wdata = "GET /"||FileName||" HTTP/1.0"||CRLF
  wdata = wdata||"Host: "||HostName||CRLF
  wdata = wdata||"Connection: close"||CRLF
  wdata = wdata||CRLF
  wdata = wdata||CRLF

  rc = SockSend(Socket,wdata)

  rc = SockRecv(Socket,"rdata",1400)

  call SockClose Socket

  parse var rdata . rcode .

  if rcode <> "200" then return ""

  i = pos(CRLF||CRLF,rdata)
  line = substr(rdata,i+4)
  line = translate(line,"",CRLF)

  say line
  parse var line . . . . . . . ipaddr .
 
  return ipaddr

/******************************************************************************/
/* External Call to Host.exe to avoid DNS caching problems with dyndns.org    */

GetIpFromDNS: procedure 
  HostName = arg(1)

  queue = 'GETIP'
  rc = rxqueue('delete',queue)
  rc = rxqueue('create',queue)
  rc = rxqueue('set',queue)
  Address Cmd '@ECHO off'
  Address CMD 'host '||HostName||' | RXQUEUE' queue

  parse pull response 
  rc = rxqueue('delete',queue)

  parse var response Name "=" IPAddr .
  say response

  return IPAddr

