/*--------------------------------------------------------------------------

                                  TONLINE.fnc         
   Version 30.7.96                                    
     - mit Korrektur nach Senden der Gateway-Seite
       call WAITFOR "ER-Verb" und WAITFOR "SH"         
       nun vor WAITFOR prompt_string beim Warten auf Gebuehren-Info 
       (ein Tip von Jupp Chudzinski)

  --------------------------------------------------------------------------*/

call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
call SysLoadFuncs

ARG Channel LocalIp HostIp Netmask DefaultIp

cr   = '0d'x
crlf = '0d0a'x
remain_buffer  = ''
waitfor_buffer = ''
prompt_vt100='[?25h'
prompt_cept='1A'x
prompt_string=prompt_cept
prompt_string=prompt_vt100

say 'Line       ' Channel
say 'LocalIp    ' LocalIp
say 'HostIp     ' HostIp
say 'Netmask    ' Netmask
say 'DefaultIp  ' HostIp

/*--------------------------------------------------------------------------*/
/*  tragen Sie hier Ihre ID und Ihr Password ein                            */
/*  falls Ihr Password erfragt werden soll : password = ""                  */
/*--------------------------------------------------------------------------*/

username="000111112222"
password="33334444"

/*--------------------------------------------------------------------------*/
/*                   Initialization and Main Script Code                    */
/*--------------------------------------------------------------------------*/


say ''
say 'TONLINE - SLIP TONLINE login script (channel' channel')'

say ""
say "Warten auf 1.Zeichen..."
call waitfor '80'x ,20
if RC = 1 then signal failure
call send "."||cr
say ""
say "Umgeschaltet in VT100. Anmeldung..."
/* Handle login. */
call waitfor prompt_string,20
if RC = 1 then signal failure
call flush_receive 'echo'
say ''
say '********* Anschlusskennung(=Username)...'
say ''
call send username
call waitfor prompt_string,20
if RC = 1 then signal failure
call flush_receive 'echo'
say ''
say '********* Mitbenutzernr....'
say ''
call send '0001'
call waitfor prompt_string,20
if RC = 1 then signal failure
call flush_receive 'echo'
say ''
say 'Kennwort...'
say ''
if password="" then
  password=READPASSWORD(channel)
call send password
call send cr
call waitfor prompt_string,20
if RC = 1 then signal failure
if Pos('Falsches Kennwort',remain_buffer)>0 then do
  say ''
  say 'Fehlerhafte Anmeldung: Falsches Kennwort!'
  signal failure
end
call flush_receive 'echo'

if prompt_string=prompt_cept then do
  say ''
  say '********* Switching to VT100 Mode'
  call send "*707#"
  call waitfor prompt_string,20
  if RC = 1 then signal failure
  call flush_receive 'echo'
  call send "j"
  call waitfor prompt_string,20
  if RC = 1 then signal failure
  call flush_receive 'echo'
  call send "."||cr
  prompt_string=prompt_vt100
  call waitfor prompt_string,20
  if RC = 1 then signal failure
  call flush_receive 'echo'
  call send "n"
  call waitfor prompt_string,20
  if RC = 1 then signal failure
  call flush_receive 'echo'
end


say ''
say 'Gateway-Seite...'
say ''

call send "*190144100#"

say ''
say 'Warte auf Gebuehren-Info...'
say ''
call waitfor "ER-Verb.",20
if rc=1 then signal failure
call waitfor "SH",20
if rc=1 then signal failure
call waitfor prompt_string,20
if rc=1 then signal failure
say ""
say "Gebuehren-Besttigung..."
say ""
call send "19"
call waitfor "STATUS OK",100
if rc=1 then signal failure
call waitfor crlf
say "LIN..."
call send "LIN"||cr
do forever
  call waitfor crlf
  parse var waitfor_buffer a " " b "0d0a"x
  if a="." ||"0d0a"x then leave
  select
    when a="YOURIP" then yourip=b
    when a="DESTIP" then destip=b
    when a="NETMASK" then netmask=b
    when a="DNS" then dns=b
    when a="DOMAIN_NAME" then domain_name=b
    otherwise /* ignorieren */
  end
end

do forever
  call waitfor crlf
  parse var waitfor_buffer a " " b "0d0a"x
  if a="." ||"0d0a"x then leave
end
call send "OK"||cr

/* Aus DNS und DOMAIN_NAME die RESOLV-Datei erstellen */
resolv=Value('ETC',,'OS2ENVIRONMENT')'\resolv'
resolv_sik=resolv'.~'
if stream(resolv,'c','query exists')<>'' then do
  if stream(resolv_sik,'c','query exists')<>'' then do
    'cmd /c del' resolv_sik
  end
  'cmd /c ren' resolv FileSpec("name",resolv_sik)
  if rc=0 then do
    call lineout resolv,'domain' domain_name
    call lineout resolv,'nameserver' dns
    call stream resolv,'c','close'
  end
  else do
    say 'Kann keine Sicherungskopie von %etc%\resolv-Datei erzeugen'
  end
end
else do
  call lineout resolv,'domain' domain_name
  call lineout resolv,'nameserver' dns
  call stream resolv,'c','close'
end

"ifconfig" "sl0" yourip destip "netmask" netmask "mtu 296"
"route add" "default" destip "1"

/* must not be changed ! */

say 'REXX DATAMODE'
rc = ISDNDATAMODE(Channel)
say 'REXX DATAMODE END'


/* alte RESOLV-Datei restaurieren */
if stream(resolv_sik,'c','query exists')<>'' then do
  if stream(resolv,'c','query exists')<>'' then do
    'cmd /c del' resolv
  end
  'cmd /c ren' resolv_sik FileSpec("name",resolv)
  if rc<>0 then do
    say 'Kann Sicherungskopie von %etc%\resolv-Datei nicht restaurieren'
  end
end

"route delete" destip yourip
"route delete" "default" destip



exit 0

failure:
say "Mist! Schiefgegangen!"
  call ISDNDISCONNECT Channel
  exit 1


/*--------------------------------------------------------------------------*/
/*                            send ( sendstring)                            */
/*..........................................................................*/
/*                                                                          */
/* Routine to send a character string off to the modem.                     */
/*                                                                          */
/*--------------------------------------------------------------------------*/

send:

   parse arg sendstring
   call ISDNWRITE channel , sendstring

   return


/*----------------------------------------------------------------------*/
/*  waitfor( waitforstring , [timeout] )                                */
/*......................................................................*/
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*----------------------------------------------------------------------*/

waitfor:

    parse arg waitstring , timeout
    if timeout = '' then
        timeout = 20        /* wait 20 sec */

    timeout = timeout * 10 ;    /* ISDNREAD returns after 1/10 Sek */

    waitfor_buffer = '' ; done = -1 ; curpos = 1
    do while (( done = -1) & (timeout > 0))
        if (remain_buffer \= '') then do
            line = remain_buffer
            remain_buffer = ''
        end
        else do
            line = ISDNREAD(Channel)
            if Substr(line,1,1)<>'00'x then do
              say 'ISDNREAD-Fehler'
              signal failure
            end
            line=Substr(line,2)
        end
        waitfor_buffer = waitfor_buffer || line
        if waitstring>='80'x then
          index=1
        else
          index = pos(waitstring,waitfor_buffer)
        if (index > 0 ) then do
            remain_buffer = substr(waitfor_buffer,index+length(waitstring))
            waitfor_buffer = delstr(waitfor_buffer,index+length(waitstring))
            done = 0
        end
        call charout,substr(waitfor_buffer,curpos)
        curpos = length(waitfor_buffer)+1
        timeout = timeout - 1
        call SysSleep 0
    end
    if (timeout = 0 ) then do
        say 'WAITFOR : timed out '
        done = 1
    end
    RC = done
return RC
/*----------------------------------------------------------------------*/
/*  flush_receive()                                                     */
/*......................................................................*/
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*----------------------------------------------------------------------*/
flush_receive:

    parse arg echo
    /* if echoing the flush - take care of waitfor remainig buffer */
    if( echo \= '' ) && (length(remain_buffer) > 0 ) then do
        call charout, remain_buffer
    end
    cx = 20
    line = ''
    do while (line \= '') & (cx > 0 )
        line = ISDNREAD(Channel)
        if Substr(line,1,1)<>'00'x then do
          say 'ISDNREAD-Fehler'
          signal failure
        end
        line=Substr(line,2)
        if echo \= '' then
            call charout,line
        cx = cx - 1
    end
    return

