/*
 *      INSTDIAL.CMD - V1.0 C.Langanke 2000 fr Team OS/2 Deutschland e.V.
 *
 *      Syntax: INSTDIAL.CMD NOREGUSER|REGUSER <Providerid> <Providername>
 *
 *      Dieses Programm installiert Einwahldaten fr
 *       - IBM Dialer (SLIPPM)
 *       - ISDNPM V2.9
 *
 *
 *      REGUSER        - installiert Konfiguration fr registrierten Benutzer
 *      NOREGUSER      - installiert Konfiguration fr micht-registrierten Benutzer
 *      <Providerid>   - entpsricht dem Verzeichnisnamen fr Provider und
 *                       der SLIPPM Kennung
 *      <Providername> - beschreibender Name des Providers, entspricht der
 *                       ISDNPM Kennung
 *
 *
 */
/* Der erste Kommentar wird als Hilfetext benutzt. */

 SIGNAL ON HALT

 TitleLine = STRIP(SUBSTR(SourceLine(2), 3));
 PARSE VAR TitleLine CmdName'.CMD 'Info
 Title     = CmdName Info

 env          = 'OS2ENVIRONMENT';
 TRUE         = (1 = 1);
 FALSE        = (0 = 1);
 CrLf         = '0d0a'x;
 Redirection  = '> NUL 2>&1';
 '@ECHO OFF'

 /* OS/2 Fehlercodes */
 ERROR.NO_ERROR           =   0;
 ERROR.INVALID_FUNCTION   =   1;
 ERROR.FILE_NOT_FOUND     =   2;
 ERROR.PATH_NOT_FOUND     =   3;
 ERROR.ACCESS_DENIED      =   5;
 ERROR.NOT_ENOUGH_MEMORY  =   8;
 ERROR.INVALID_FORMAT     =  11;
 ERROR.INVALID_DATA       =  13;
 ERROR.NO_MORE_FILES      =  18;
 ERROR.WRITE_FAULT        =  29;
 ERROR.READ_FAULT         =  30;
 ERROR.GEN_FAILURE        =  31;
 ERROR.INVALID_PARAMETER  =  87;
 ERROR.ENVVAR_NOT_FOUND   = 203;

 GlobalVars = 'Title CmdName CrLf env TRUE FALSE Redirection ERROR.';
 SAY;

 /* ggfs. Hilfe anzeigen */
 ARG Parm .
 IF ((Parm = '') | (POS('?', Parm) > 0)) THEN
 DO
    rc = ShowHelp();
    EXIT(ERROR.INVALID_PARAMETER);
 END;

 /* Vorgabewerte */
 call RxFuncAdd    'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
 call SysLoadFuncs
 GlobalVars        = GlobalVars '';
 rc                = ERROR.NO_ERROR;
 EtcDir            = VALUE('ETC',,env);
 TmpDir            = VALUE('TMP',,env);
 BaseDir           = EtcDir'\'ProviderId
 CallDir           = GetCallDir();
 fRegisteredUser   = FALSE;
 fDeleteUser       = FALSE;
 fPause            = TRUE;
 fError            = FALSE;
 fInstalled        = FALSE;

 /* Dateien */
 Config._SLIPPM_File = EtcDir'\tcpos2.ini';
 Config._ISDNPM_File = EtcDir'\ISDNUSER.CFG';
 Exec._SLIPPM_File   = 'SLIPPM.EXE';
 Exec._ISDNPM_File   = 'ISDNPM.EXE';

 DO UNTIL (TRUE)

    SAY;
    SAY Title;
    SAY;

    /* Umgebung prfen */
    IF (EtcDir = '') THEN
    DO
       SAY CmdName': Fehler: Umgebungsvariable ETC nicht gesetzt.';
       rc = ERROR.ENVVAR_NOT_FOUND;
       LEAVE;
    END;

    /* Parameter holen */
    PARSE ARG usertype providerid providername
    IF (providerid = '') THEN
    DO
       SAY CmdName': Fehler: Keine Providerid angegeben.';
       rc = ERROR.INVALID_PARAMETER;
       LEAVE;
    END;
    IF (providername = '') THEN
    DO
       SAY CmdName': Fehler: Keinen Providernamen angegeben.';
       rc = ERROR.INVALID_PARAMETER;
       LEAVE;
    END;

    /* Umgebungsvariablen setzen */
    rcx = VALUE('PROVIDERID',   providerid,   env);
    rcx = VALUE('PROVIDERNAME', providername, env);
    rcx = VALUE('USERID',       providerid,   env); /* fr SLIPPM, unregistrierten Benutzer */

    SELECT

       WHEN (usertype = 'REGUSER') THEN
       DO
          SAY 'Installiere Einwahlinformationen fr'
          SAY;
          SAY '   ' ProviderName;
          SAY;
          SAY 'fr registrierten Benutzer.';
          New._SLIPPM_File = STREAM( CallDir'\..\'providerid'\reg.ini',   'C', 'QUERY EXISTS');
          New._ISDNPM_File = STREAM( CallDir'\..\'providerid'\reg.txt',   'C', 'QUERY EXISTS');
          New._VAR_File    = STREAM( CallDir'\..\'providerid'\reg.var',   'C', 'QUERY EXISTS');
       END;

       WHEN (usertype = 'NOREGUSER') THEN
       DO
          SAY 'Installiere Einwahlinformationen fr'
          SAY;
          SAY '   ' ProviderName;
          SAY;
          SAY 'fr nicht-registrierten Benutzer.';
          New._SLIPPM_File = STREAM( CallDir'\..\'providerid'\noreg.ini',   'C', 'QUERY EXISTS');
          New._ISDNPM_File = STREAM( CallDir'\..\'providerid'\noreg.txt',   'C', 'QUERY EXISTS');
          New._VAR_File    = STREAM( CallDir'\..\'providerid'\noreg.var',   'C', 'QUERY EXISTS');
       END;

       WHEN (usertype = 'DELUSER') THEN
       DO
          fDeleteUser = TRUE;
          fPause      = FALSE;
       END;

       OTHERWISE
       DO
          SAY CmdName': Fehler: Ungltigen Benutzertyp angegeben.';
          rc = ERROR.INVALID_PARAMETER;
          LEAVE;
       END;

    END;
    SAY;

    /* Benutzer lschen ? */
    IF (fDeleteUser) THEN
    DO
       SAY 'Deinstalliere Einwahlinformationen fr' ProviderName'.';
       IF (IsProgramActive( Exec._SLIPPM_File, 'analoge Einwahl per Modem (SLIPPM)')) THEN
          rc = ERROR.INVALID_FUNCTION;
       ELSE
          rcx = RemoveSLIPPMUser( Config._SLIPPM_File, Providerid);

       IF (IsProgramActive( Exec._ISDNPM_File, 'digitale Einwahl (ISDNPM)')) THEN
          rc = ERROR.INVALID_FUNCTION;
       ELSE
          rcx = RemoveISDNPMUser( Config._ISDNPM_File, Providername);
       LEAVE;
    END;

    SAY;
    'PAUSE';
    /* ggfs. Variablen laden */
    IF (New._VAR_File \=  '') THEN
    DO
       LoadEnvVars( New._VAR_File);
    END;

    /* Update fr IBM Dialer durchfhren */
    'CLS';
    SAY;
    IF (ProceedWith( 'Einwahlinformationen fr analoge Einwahl per Modem (SLIPPM) installieren')) THEN
    DO

       /* comport abfragen */
       ComPort = 1;
       DO WHILE (TRUE)
          'CLS'
          SAY;
          SAY 'Bitte geben Sie die Nummer der seriellen Schnittstelle an,';
          SAY '(COM-Port) an der Ihr Modem angschlossen ist.';
          ComPort = PullVariable( '1', '(Nummer von 1-4)');
          rcx = VALUE( 'COMPORT', 'com'ComPort, env);
          IF ((DATATYPE( ComPort) \= NUM) | (Comport = 0) | (ComPort > 4)) THEN
          DO
             SAY;
             SAY 'Die angegebene Nummer fr die serielle Schnitstelle ist ungltig.';
             SAY 'Bitte wiederholen Sie die Eingabe !';
             SAY;
             'PAUSE';
             SAY;
             ITERATE;
          END;
          ELSE
             LEAVE;
       END;
       SAY;

       fUpdate = TRUE;
       IF (ExistSLIPPMUser( Config._SLIPPM_File, providerid)) THEN
       DO
          'CLS';
          SAY;
          SAY 'Warnung: Einwahlinformation fr'
          SAY;
          SAY '   ' ProviderName;
          SAY;
          SAY 'existiert bereits in Konfiguration fr analoge Einwahl per Modem (SLIPPM).';
          SAY 'Wenn Sie fortfahren, werden alle Einstellungen dieser Einwahlinformation';
          SAY 'berschrieben.';
          fUpdate = ProceedWith( 'Soll diese Einwahlinformation berschrieben werden');
       END;
       IF (fUpdate) THEN
       DO
          'CLS';
          SAY;
          SAY 'Installiere';
          SAY;
          SAY '   ' providername;
          SAY;
          CALL CHAROUT, 'Einwahlinformationen fr analoge Einwahl per Modem (SLIPPM) ...'
          'IMPINI' New._SLIPPM_File Config._SLIPPM_File '/ENV'
          IF (rc \= ERROR.NO_ERROR) THEN
          DO
             SAY;
             SAY CmdName':';
             SAY 'Fehler bei Installation der';
             SAY;
             SAY '   ' providername;
             SAY;
             SAY 'Einwahlinformationen fr analoge Einwahl perModem (SLIPPM)';
             fError = TRUE;
             LEAVE;
          END;
          fInstalled = TRUE;
          SAY ' Ok.';
          SAY;
          SAY;
          SAY 'Hinweis:';
          SAY 'Bitte passen Sie gegebenenfalls die Einstellungen fr die Einwahlinformation'
          SAY '"'providerid'" ber das Programm zur analogen Einwahl per Modem (SLIPPM) an.';
          SAY 'Dies ist zum Beispiel notwendig, wenn:'
          SAY;
          SAY '- Ihr Modem spezielle Initialisierungskommandos bentigt   oder';
          SAY '- Ihr Modem an einer Telefonanlage an einem Nebenstellenanschluss betrieben';
          SAY '  wird und deshalb eine fhrende NULL in der Telefonnummer bentigt wird.';
          SAY;
          'PAUSE';
       END;
    END;


    /* Update fr ISDNPM V2.x durchfhren */
    'CLS';
    SAY;
    IF (ProceedWith( 'Einwahlinformationen fr digitale Einwahl (ISDNPM) installieren')) THEN
    DO
       fUpdate = TRUE;
       IF (ExistISDNPMUser( Config._ISDNPM_File, providername)) THEN
       DO
          'CLS'
          SAY;
          SAY 'Warnung: Einwahlinformation fr'
          SAY;
          SAY '   ' ProviderName;
          SAY;
          SAY 'existiert bereits in Konfiguration fr digitale Einwahl (ISDNPM).';
          SAY 'Wenn Sie fortfahren, werden alle Einstellungen dieser Einwahlinformation';
          SAY 'berschrieben.';
          fUpdate = ProceedWith( 'Soll diese Einwahlinformation berschrieben werden');
       END;

       IF (fUpdate) THEN
       DO
          'CLS'
          SAY;
          SAY 'Installiere';
          SAY;
          SAY '   ' providername;
          SAY;
          CALL CHAROUT, 'Einwahlinformationen fr digitale Einwahl (ISDNPM V2.9) ...'
          rc = UpdateISDNPMUser( Config._ISDNPM_File, providername, New._ISDNPM_File);

          IF (rc \= ERROR.NO_ERROR) THEN
          DO
             SAY;
             SAY CmdName':';
             SAY 'Fehler bei Installation der';
             SAY;
             SAY '   ' providername;
             SAY;
             SAY 'Einwahlinformationen fr digitale Einwahl (ISDNPM V2.9)';
             fError = TRUE;
             LEAVE;
          END;
          rc = SysFileDelete( TmpFile);
          fInstalled = TRUE;
          SAY ' Ok.';
       END;
    END;

 END;


 IF (fPause) THEN
 DO
    SAY;
    'PAUSE';
    'CLS';
    SAY;
    SAY 'Die Einwahlinformationen fr'
    SAY;
    SAY '   ' ProviderName;
    SAY;
    IF (fInstalled) THEN
    DO
       SAY 'wurden erfolgreich installiert und konfiguriert.';
       SAY 'und knnen nun verwendet werden.';
    END
    ELSE
    DO
       SAY 'wurden nicht konfiguriert.';
       SAY 'Bitte wiederholen Sie den Vorgang gegebenenfalls.';
    END
    SAY;
    'PAUSE';
 END;

 EXIT( rc);

/* ------------------------------------------------------------------------- */
HALT:
 SAY 'Abbruch durch Benutzer.';
 EXIT(ERROR.GEN_FAILURE);

/* ------------------------------------------------------------------------- */
ShowHelp: PROCEDURE EXPOSE (GlobalVars)

 /* Titel anzeigen */
 SAY Title;
 SAY;

 PARSE SOURCE . . ThisFile

 /* Anfang berspringen */
 DO i = 1 TO 3
    rc = LINEIN(ThisFile);
 END;

 /* Hilfe ausgeben */
 ThisLine = LINEIN(Thisfile);
 DO WHILE (ThisLine \= ' */')
    SAY SUBSTR(ThisLine, 7);
    ThisLine = LINEIN(Thisfile);
 END;

 /* Datei wieder schlieen */
 rc = LINEOUT(Thisfile);

 RETURN('');

/* ------------------------------------------------------------------------- */
FileExist: PROCEDURE
 PARSE ARG FileName

 RETURN(STREAM(Filename, 'C', 'QUERY EXISTS') > '');

/* ------------------------------------------------------------------------- */
GetCalldir: PROCEDURE
PARSE SOURCE . . CallName
 CallDir = FILESPEC('Drive', CallName)||FILESPEC('Path', CallName);
 RETURN(LEFT(CallDir, LENGTH(CallDir) - 1));

/* ------------------------------------------------------------------------- */
PullVariable: PROCEDURE
 PARSE ARG Default, Message, Echo

 fNoEcho = 0;

 IF (Echo \= '') THEN
 DO
    IF (Echo \= 'NOECHO') THEN
    DO
       PARSE SOURCE . . CallName
       SAY 'Syntax error running' CallName': Incorrect call to routine PullVariable [NOECHO]';
       EXIT(99);
    END;
    fNoEcho = 1;
 END;

 SAY;
 CALL CHAROUT, Message '['Default'] : ';
 IF (\fNoEcho) THEN
    PARSE PULL PullVar;
 ELSE
 DO
    PullVar = '';
    key     = ' ';
    DO WHILE (1)
       key = SysGetKey('NOECHO');

       SELECT
          WHEN (C2D(key) = 13) THEN LEAVE;

          WHEN (C2D(key) = 8)  THEN
          DO
             IF (LENGTH(PullVar) > 0) THEN
             DO
                PullVar = LEFT(PullVar, LENGTH(PullVar) - 1);
                /* do a backspace */
                CALL CHAROUT, "08"x;
                CALL CHAROUT, ' ';
                CALL CHAROUT, "08"x;
             END;
             ELSE
             DO
                /* do a beep */
                CALL CHAROUT, "07"x;
             END;
          END;

          OTHERWISE
          DO
             CALL CHAROUT, '*';
             PullVar = PullVar''key;
          END;

       END; /*select */
    END; /* while */
    SAY;

 END; /* if */

 IF (LENGTH(PullVar) > 0) THEN
    RETURN(PullVar);
 ELSE
    RETURN(Default);

/* ------------------------------------------------------------------------- */
ProceedWith: PROCEDURE
 PARSE ARG Prompt

 ResponseKeys  = 'J N A W I'; /* SysGetMessage(0); */
 Yes           = WORD(ResponseKeys, 1);
 No            = WORD(ResponseKeys, 2);
 ch            = ' ';
 ValidResponse = Yes||No;

 SAY;
 CALL CHAROUT ,Prompt '('Yes'/'No') '
 DO WHILE (POS(ch, ValidResponse) = 0)
    ch = SysGetKey('NOECHO');
    ch = TRANSLATE(ch);
    IF (POS(ch, ValidResponse) = 0) THEN BEEP(800, 200);
 END;
 SAY;
 SAY;
 RETURN(ch = Yes);

/* ------------------------------------------------------------------------- */
ParseLine: PROCEDURE EXPOSE env
 PARSE ARG ThisLine

 Delimiter = '%';

 ThisLineCopy = '';
 CurrentPos   = 1;

 /* Variable suchen */
 VarStart = POS(Delimiter, ThisLine);
 DO WHILE (VarStart > 0)

    VarEnd       = Pos(Delimiter, ThisLine, VarStart + 1);
    ThisVar      = SUBSTR(ThisLine, VarStart + 1, VarEnd - VarStart - 1);
    ThisVarValue = VALUE(ThisVar,,env);

    /* Kopie erweitern */
    ThisLineCopy = ThisLineCopy||,
                   SUBSTR(ThisLine, CurrentPos, VarStart - CurrentPos)||,
                   ThisVarValue;
    CurrentPos   = VarEnd + 1;

    /* nchste Variable suchen */
    VarStart = POS(Delimiter, ThisLine, CurrentPos);
 END;

 /* Rest der Zeile bernehmen */

 ThisLineCopy = ThisLineCopy||SUBSTR(ThisLine, CurrentPos);

 RETURN(ThisLineCopy);

/* ========================================================================= */
SelectRegisteredFile: PROCEDURE
 PARSE ARG fIsUserRegistered, FileRegistered, FileNotRegistered;

 IF ((fIsUserRegistered) & (FileRegistered \= '')) THEN
    RETURN( FileRegistered);
 ELSE
    RETURN( FileNotRegistered);

/* ========================================================================= */
ExistSLIPPMUser: PROCEDURE
 PARSE ARG IniFile, Providerid;

 /* Daten fr Provider holen */
 rc = SysIni( IniFile, Providerid, 'ALL:', 'dummy.');
 RETURN( rc = '');

/* ========================================================================= */
RemoveSLIPPMUser: PROCEDURE
 PARSE ARG Inifile, providerid;

 /* Daten fr Provider lschen */
 rc = SysIni( IniFile, Providerid, 'DELETE:');
 rc = SysIni( IniFile, 'CONNECTION', Providerid, 'DELETE:');
 RETURN( rc = '');

/* ========================================================================= */
ExistISDNPMUser: PROCEDURE EXPOSE (GlobalVars)
 PARSE ARG CfgFile, Providername;

 UserExists = FALSE;

 /* Datei durchsuchen */
 DO WHILE (LINES( CfgFile) > 0)
    ThisLine = STRIP( LINEIN( CfgFile));
    IF (ThisLine = '') THEN ITERATE;
    PARSE VAR ThisLine ThisKey':'ThisValue;
    ThisKey = TRANSLATE( STRIP( ThisKey));
    ThisValue = STRIP( ThisValue);
    IF (ThisValue = Providername) THEN
    DO
       UserExists = TRUE;
       LEAVE;
    END;
 END;
 rcx = STREAM( CfgFile, 'C', 'CLOSE');


 RETURN( UserExists);

/* ========================================================================= */
RemoveISDNPMUser: PROCEDURE EXPOSE (GlobalVars)
 PARSE ARG CfgFile, Providername;

 CrLf                = "0d0a"x;
 OutFile             = SysTempFilename( LEFT( CfgFile, LASTPOS( '.', CfgFile))'???');
 fDeleteCurrentBlock = FALSE;

 /* Datei durchsuchen */
 ThisEntry = '';
 DO WHILE (LINES( CfgFile) > 0)
    ThisLine = LINEIN( CfgFile);
    CheckLine = STRIP( ThisLine);

    /* Block schreiben */
    IF (TRANSLATE( CheckLine) = '[USER]') THEN
    DO
       IF (\fDeleteCurrentBlock) THEN
          rc = LINEOUT(  OutFile, ThisEntry);
       ThisEntry = '';
       fDeleteCurrentBlock = FALSE;
    END;

    /* Name des Eintrags prfen */
    PARSE VAR ThisLine ThisKey':'ThisValue;
    ThisKey = TRANSLATE( STRIP( ThisKey));
    ThisValue = STRIP( ThisValue);
    IF (ThisValue = Providername) THEN
       fDeleteCurrentBlock = TRUE;

    IF (ThisEntry = '') THEN
       ThisEntry = ThisLine;
    ELSE
       ThisEntry = ThisEntry''CrLf''ThisLine;
 END;

 /* Rest schreiben */
 IF (\fDeleteCurrentBlock) THEN
    rc = LINEOUT(  OutFile, ThisEntry);

 rcx = STREAM( CfgFile, 'C', 'CLOSE');
 rcx = STREAM( OutFile, 'C', 'CLOSE');

 'COPY' OutFile CfgFile Redirection;
 rcx = SysFileDelete( OutFile);

 RETURN( 0);

/* ========================================================================= */
UpdateISDNPMUser: PROCEDURE EXPOSE (GlobalVars)
 PARSE ARG ConfigFile, providername, NewFile;

 rc = ERROR.NO_ERROR;

 IF (FileExist( ConfigFile)) THEN
    rcx = RemoveISDNPMUser( ConfigFile, providername);

 DO WHILE (LINES( NewFile) > 0)
    ThisLine = ParseLine( LINEIN( NewFile));
    rcx = LINEOUT( ConfigFile, ThisLine);
 END;
 rcx = STREAM( ConfigFile, 'C', 'CLOSE');
 rcx = STREAM( NewFile, 'C', 'CLOSE');

 RETURN(rc);

/* ========================================================================= */
IsProgramActive: PROCEDURE EXPOSE (GlobalVars)
 PARSE ARG ProgramName, ProgramType;

 fProgramActive = FALSE;
 ProgramName    = TRANSLATE( ProgramName);

 DO WHILE (QUEUED() > 0)
    PULL ThisLine;
 END;

 'PSTAT | RXQUEUE';
 DO WHILE (QUEUED() > 0)
    PULL ThisLine;
    IF (POS( '\'ProgramName, ThisLine) > 0) THEN
       fProgramActive = TRUE;
 END;

 IF (fProgramActive) THEN
 DO
    'CLS';
    SAY;
    SAY 'FEHLER: Das Program fr';
    SAY;
    SAY '   ' ProgramType
    SAY;
    SAY 'ist aktiv.';
    SAY;
    SAY 'Die Einwahlinformationen wird aus Sicherheitsgrnden fr';
    SAY 'dieses Programm nicht entfernt. Beenden Sie ggfs. dieses';
    SAY 'Program und wiederholen Sie die Deinstallation.';
    SAY;
    'PAUSE';
 END;

 RETURN( fProgramActive);

/* ========================================================================= */
LoadEnvVars: PROCEDURE EXPOSE (GlobalVars)
 PARSE ARG VarFile;

 /* ggfs. Variablen laden */
 Var.        = '';
 Var.0       = 0;
 MaxDescrLen = 0;

 /* alle Variablen einlesen */
 DO WHILE (LINES( VarFile) > 0)
    ThisLine = STRIP(LINEIN( VarFile));
    IF (ThisLine = '') THEN ITERATE;
    PARSE VAR ThisLine ThisVarName'='ThisVarDescription','ThisVarPrompt;
    IF (ThisVarValue \= '') THEN
    DO

       /* Variable speichern */
       v             = Var.0 + 1;
       Var.v._Name   = ThisVarName;
       Var.v._Descr  = ThisVarDescription;
       Var.v._Prompt = ThisVarPrompt;
       Var.v._Value  = '';
       Var.0         = v;
       MaxDescrLen   = MAX( MaxDescrLen, LENGTH( ThisVarDescription));

       /* soll Variable verdeckt eingegeben werden ? */
       Var.v._hidden = LEFT( ThisVarName, 1) = '*';
       IF (Var.v._hidden) THEN
          Var.v._Name = SUBSTR( ThisVarName, 2);

    END;
 END;
 rcx = STREAM( VarFile, 'C', 'CLOSE');

 /* Werte abfragen */
 DO WHILE (TRUE)

    fCheckError = FALSE;
    DO v = 1 TO Var.0

       'CLS';
       SAY;
       IF (Var.v._hidden) THEN
          Var.v._Value = PullVariable( '', Var.v._Prompt, 'NOECHO');
       ELSE
          Var.v._Value = PullVariable( Var.v._Value, Var.v._Prompt);

       IF (Var.v._Value = '') THEN
       DO
          SAY;
          SAY 'Der Wert darf nicht leer sein';
          SAY 'Bitte wiederholen Sie die Eingabe !';
          'PAUSE';
          v = v - 1;
          ITERATE;
       END;

       /* ist es ein verdeckter Wert ? Dann nochmal eingeben lassen */
       IF (Var.v._hidden) THEN
       DO
          'CLS';
          SAY;
          SAY 'Zur Sicherheit folgenden Wert erneut eingeben:';
          TmpValue = PullVariable( '', Var.v._Prompt, 'NOECHO');
          IF (TmpValue \= Var.v._Value) THEN
          DO
             SAY;
             SAY 'Die eingegebenen Werte stimmten nicht berein.';
             SAY 'Bitte wiederholen Sie die Eingabe !';
             SAY;
             'PAUSE';
             v = v - 1;
             ITERATE;
          END;
       END;

    END;

    SAY;
    SAY;
    SAY 'Sie haben folgende Werte eingegeben:';
    SAY;
    DO v = 1 TO Var.0
       CALL CHAROUT, LEFT( Var.v._Descr, MaxDescrLen)': ';
       IF (Var.v._hidden) THEN
          SAY COPIES( '*', LENGTH( Var.v._Value));
       ELSE
          SAY Var.v._Value;
    END;
    SAY;
    IF (ProceedWith( 'Sind diese Werte richtig')) THEN
    DO
       DO v = 1 TO Var.0
          rcx = VALUE( Var.v._Name, Var.v._Value,env);
       END;
       LEAVE;
    END;
 END;

 RETURN('');


