/**/ 
/**
 This function returns process status information (like PSTAT).  In this version of RXU (v1.5), Library, 
 Shared-Memory and 16-Bit Semaphore information is stored differently than in the previous release (v1.4). In the 
 previous version, if you wanted the name of a module used by a process, for instance, you would have to 
 search through the Library array to match the module index value "stem.0p.n.0l.m", to get the module name 
 "stem.0l.n.2".  In this version, you simply get the module name by indexing into the Library array using the index 
 value in "stem.0p.n.0l.m". 

 
 Syntax:
 
   dosrc = RxQProcStatus(stemname [,flags])
 
 where:
 
   stemname = a Rexx stem variable name under which results are
              mapped as such:
**/ 

 
/**
 Note:
 
   Process/Thread information is always returned, whether or not semaphore,
   library or shared-memory information is requested.
 
   The reason such odd compound variable index values were chosen (such as "0P",
   "0S", etc.) is because too long a constant index value (such as "PROC")
   tended to increase processing time for the function call (actual size of
   variable name pool is larger).  The alternative, to use brief constant index
   values (such as "M") turned out to cause problems when I happened to be using
   one of these for a variable.  The solution was to choose a constant index name
   which begins with a digit ("0" - i.e. zero), which is an invalid variable name,
   thus ensuring that no variable could have the same name as the constant index.
   This made relatively brief names (e.g. - "0M") possible and prevents "collision"
   with variable names your program may be using.
   
**/
/*// System Global Information*/
stem.0G.1 = total number of threads in system
stem.0G.2 = undocumented value 1
stem.0G.3 = undocumented value 2
 
/*// Process Information*/
stem.0P.0 = number of processes
stem.0P.n.1 = process-id (hex)
stem.0P.n.2 = parent process-id (hex)
stem.0P.n.3 = process type (hex)
stem.0P.n.4 = process status (hex, followed by blank, followed
              by text description)
stem.0P.n.5 = process screen-group/session-id (hex)
stem.0P.n.6 = process module name (value of "SYSINIT" may
              indicate a DOS "process")
stem.0P.n.0S.0 = number of 16-bit semaphores used by process
stem.0P.n.0S.n = 16-bit semaphore index value (use to "hash"
                 into list of "stem.0S.index" values)
stem.0P.n.0L.0 = number of libraries statically linked by process
stem.0P.n.0L.n = linked library index value (use to "hash"
                 into list of "stem.0L.index" values)
stem.0P.n.0M.0 = number of shared memory objects used by process
stem.0P.n.0M.n = shared memory index value (use to "hash"
                 into list of "stem.0M.index" values)
stem.0P.n.0T.0 = number of threads in this process
stem.0P.n.0T.m.1 = thread-id within process (hex)
stem.0P.n.0T.m.2 = unique thread slot number (hex, system wide)
stem.0P.n.0T.m.3 = sleep-id thread is sleeping on (hex)
stem.0P.n.0T.m.4 = thread priority (hex)
stem.0P.n.0T.m.5 = system time (# ring 0 time slices)
stem.0P.n.0T.m.6 = user time (# ring 3 time slices)
stem.0P.n.0T.m.7 = thread state (hex followed by text string)
 
/*// 16-Bit Semaphore Information*/
stem.0S.0 = number of 16-bit semaphore records
stem.0S.0.1 = index of first semaphore (hex)
stem.0S.n = semaphore index (hex, hash into using "stem.0P.n.0S.n")
stem.0S.index.1 = owning slot-id (hex)
stem.0S.index.3 = semaphore flag
stem.0S.index.4 = reference count
stem.0S.index.5 = request count
stem.0S.index.6 = semaphore name
 
/*// Shared Memory Object Information*/
stem.0M.0 = number of shared memory objects
stem.0M.n = memory handle (hex, hash into using "stem.0P.n.0M.n")
stem.0M.index.1 = memory selector (hex)
stem.0M.index.2 = reference count
stem.0M.index.3 = memory name
 
/*// Statically Linked Library Information*/
stem.0L.0 = number of statically linked libraries/modules
stem.0L.n = module handle (hex, hash into using "stem.0P.n.0L.n")
stem.0L.index.1 = library name
stem.0L.index.0I.0 = number of imported modules
stem.0L.index.0I.n = imported module handle (hex, use to "hash"
                     into list of "stem.0L.index" values)
 
/**
   flags    = flags indicating what kind of information to return, may be
              any combination of:
                M - shared memory information
                S - 16-bit semaphore information
                L - linked library information
 
   dosrc    = return code from DosQProcStatus()
 
 Example:
**/ 
   /* rexx */
   /* Find out what modules each process has statically linked (1st level) */
/** 
   dosrc = rxqprocstatus('q.','l')
 
   Say 'There are' q.0p.0 'processes ('q.0g.1 'threads) running right now'
   do j=1 to q.0p.0
     say;say 'Process ('q.0p.j.1')'q.0p.j.6 'statically links the following libraries:'
     do r=1 to q.0p.j.0l.0
       idx = q.0p.j.0l.r
       say '   ' q.0l.idx.1
     end
   end
**/ 

   exit

