/***** KCG.CMD for OS/2:  "Keep-Connected" to Internet
Freeware  R.J.Holmgren  6/20/99

Please read KCG.TXT for full description and instructions!

The Keep-Connected Gimmick (KCG) is a flexible, diagnostic tool to
determine the maximum amount of inactive time that an ISP will allow, and
then to keep connected to the ISP with minimal load on both your CPU and
your Internet bandwidth.  KCG prevents dial-up ISPs from disconnecting
users for "idleness".

  Requirements:
  ------------
OS/2 Rexx
RXFTP.DLL v2.0(+) located in the LIBPATH
PING.EXE and RXQUEUE.EXE located in the PATH

  Command [nine optional arguments]:
  -------
kcg hostname|IPaddress
      user_ID
        password
          minimum_interval_between_hits (in seconds)
            maximum_interval_between_hits (in seconds)
              increment_amount (increase laziness, in seconds)
                L|m (progressive "L"aziness, or "M"aximum interval only)
                  F|p (use "F"TP or "P"ING method)
                    A|d (run as "A"ttached, or "D"etached, process)
  e.g.
kcg 152.163.212.93 anonymous mikhail@bakunin.org.ru 120 660 60 L F A  [defaults]
kcg ftp.aol.com anonymous mikhail@bakunin.org.ru  [as above but slower]
kcg ftp.microsoft.com
kcg 207.46.133.140  [same as "ftp.microsoft.com" above but faster]
detach kcg.cmd idt.net . . . 510 . . . D [override defaults 1,5,&9; Detach KCG]
kcg 192.20.225.4 . me@myisp.com  [override 1 ("ftp.research.att.com") & 3]

Arguments may be hard-coded in USER SETTINGS, below

*****/

/* BEGIN USER SETTINGS: Enter your personal or preferred settings below */
myISP = '152.163.212.93'   /* Default myISP = 'ftp.aol.com' */
myuserID = 'anonymous'
mypassword = 'mikhail@bakunin.org.ru'
myminwait = 120  /* specified in seconds */
mymaxwait = 660  /* seconds */
myincrement = 60 /* seconds */
mymaxint = 'L'   /* 'L'azy; or use 'M'aximum interval only */
mymethod = 'F'   /* 'F'TP; or 'P'ING only */
mydetach = 'A'   /* 'A'ttached; or 'D'etached (no screen output) */
retries = 20     /* If [my]method='P'ING but Host doesn't reply, number of
                    times to retry PING before giving up */
logfile = 'Y'    /* Write logfile KCG.LOG: 'Y'es or 'N'o */

rxftp=0
rxutl=RxFuncQuery("SysLoadFuncs")
if rxutl\=0 then do
  call RxFuncAdd "SysLoadFuncs","RexxUtil","SysLoadFuncs"
  call SysLoadFuncs
  end
parse arg host id pw minwait maxwait incrmnt maxint method detach
if minwait=''|minwait='.' then minwait=myminwait
if verify(minwait,'0123456789.')\=0 then minwait=120
minwait=trunc(minwait)
if maxwait=''|maxwait='.' then maxwait=mymaxwait
if verify(maxwait,'0123456789.')\=0 then maxwait=660
maxwait=trunc(maxwait)
if incrmnt=''|incrmnt='.' then incrmnt=myincrement
if verify(incrmnt,'0123456789.')\=0 then incrmnt=60
incrmnt=trunc(incrmnt)
perminc=incrmnt
if verify(retries,'0123456789.')\=0|retries<1 then retries=10
retries=trunc(retries)
if maxint=''|maxint='.' then maxint=mymaxint
if translate(maxint)='M' then do
  maxint='M'
  minwait=maxwait
  end
else maxint='L'
if method=''|method='.' then method=mymethod
if translate(method)='P' then method='PING'
else method='FTP'
if detach=''|detach='.' then detach=mydetach
if translate(detach)='D' then do
  detach='D'
  minwait=maxwait
  end
else detach='A'
if minwait>maxwait then minwait=maxwait
if minwait=maxwait then incrmnt=0
if host=''|host='.' then host=myISP
if id=''|id='.' then id=myuserID
if id=''|id='.' then id='anonymous'
if pw=''|pw='.' then pw=mypassword
if host=''|host='.'|host='?'|host='/?'|host='-?'|translate(host)='HELP' then call Help
if method='FTP' then do
  rxftp=RxFuncQuery("FtpLoadFuncs")
  if rxftp\=0 then do
    call RxFuncAdd "FtpLoadFuncs","rxFtp","FtpLoadFuncs"
    call FtpLoadFuncs
    end
  end

a=''
curwait=120
init=0
lastcon=0
lastincr=0
lastwait=0
lastwait2=0
logdel=-1
pmbegin=time('N');pmdate=date()
totmin=0
totwait=0

log=directory()
if length(log)>3 then log=log||'\'
log=log||'KCG.LOG'
r=stream(log,'C','query exists')
if length(r)>0 then logdel=SysFileDelete(log)

if method='FTP' then call FtpSetUser host,id,pw
if method='PING' then '@echo off'

do forever
  if detach='A' then call SysCls
  if init<2 then do
    if detach='A' then do
      call Charout ,d2c(255)||'Pinging to verify connection...		'
      call Posit
      end
    c=''
    conn=0
    bt=time('E')
    if method='PING' then do until c\=2
      c=0
      '@rxqueue.exe /CLEAR'
      '@ping.exe' host '8 1 | rxqueue.exe'
      do while queued()\=0
        parse pull line
        if pos('16 bytes from',line)>0 then do
          c=1  /* Connected */
          leave
          end
        if pos('ret=-1',line)>0 then leave  /* Disconnected */
        if pos('unknown host',line)>0 then do  /* Bad IPaddress */
          c=3
          leave
          end
        if pos('0 packets received',line)>0 then c=2  /* No response */
        end
      if c\=2 then leave
      conn=conn+1
      if detach='A' then do
        call SysCurPos l,r
        say 'Ping' conn '(of' retries||')'
        call SysCurState Off
        end
      if conn=retries then leave
      end
    else c=FtpPing(host,1)
    end
  if method='PING' then do
    '@rxqueue.exe /CLEAR'
    if c>0 then call Yes
    else do
      if init<2&detach='A' then do
        call SysCurPos l,r
        say copies(' ',31)
        call SysCurPos l,r
        say 'Not connected'
        end
      call No
      end
    end
  else do
    if left(c,4)='PING' then do
      if c\='PINGREPLY'&c\='PINGRECV' then do
        if init<2&detach='A' then say 'Not connected: "'||c||'"'
        call No
        end
      else call Yes
      end
    else call Yes
    end
  totwait=totwait+curwait
  if detach='A' then do
    tt=time('N');t=time('S')
    say d2c(255)
    say d2c(255)||'		KCG.CMD for OS/2  6/20/99'
    say d2c(255)
    call Charout ,d2c(255)||'Currently '||a||'CONNECTED by '||method||':			'
    text='"'||host||'" as "'||id||'"'
    call Format
    say d2c(255)||"Keep-Connected Gimmick launched at:		"||pmbegin "on" pmdate
    if init>0 then do
      call Charout ,d2c(255)||'  Connection detected at:			'||connect
      if begdate\=pmdate then call Charout ,' on' begdate
      say
      if init=2 then do
        call Charout ,d2c(255)||'  Disconnection detected at:			'||tt
        if enddate\=pmdate then call Charout ,' on' enddate
        say
        call Charout ,d2c(255)||'  Duration of connection:			'
        text='between '||trunc(totmin,1)-trunc(lastwait2/60,1)||' and '||trunc(totmin,1)||' minutes ['||trunc(totmin/60,1)-trunc(lastwait2/3600,1)||'-'||trunc(totmin/60,1)||' hours]'
        if pos('[0-',text)>0 then do
          t=pos('[0-',text)+1
          text=left(text,t)||'.0'||right(text,length(text)-t)
          end
        call Format
        end
      end
    if init<2 then do
      say d2c(255)||'Elapsed time of current '||a||'connection:		'||trunc(totmin/60,2) 'hours|'||totmin||' minutes'
      t=t+curwait
      d=0
      if t>86399 then do
        d=trunc(t/86400)
        t=t-d*86400
        end
      h=trunc(t/3600)
      m=trunc((t-h*3600)/60)
      s=t-h*3600-m*60
      if h<10 then h='0'||h
      if m<10 then m='0'||m
      if s<10 then s='0'||s
      call Charout ,d2c(255)||'Last attempt to contact Host at:		'
      text=tt||' (next at' h||':'||m||':'||s
      if d>0 then text=text||' +'||d2c(255)||d||d2c(255)||'day'
      if d>1 then text=text||'s'
      text=text||')'
      call Format
      if init=1 then do
        lastcon=trunc(et,2)
        say d2c(255)||'  Duration of last contact:			'||lastcon 'seconds'
        call Charout ,'1B'x'[1;37;40m'
        end
      call Charout ,d2c(255)||'  Current interval between contact attempts:	'
      text=trunc(curwait/60,2)||' min|'||curwait 'sec'
      if init=1 then do
        if maxint='L' then text=text||' (max='||maxwait||d2c(255)||'secs)'
        else text=text||' (constant interval)'
        end
      call Format
      if init=1 then call Charout ,'1B'x'[0;37;40m'
      if init=1&incrmnt>0 then say d2c(255)||'  Getting lazier (incrementing interval) in:	'||incrmnt 'second steps'
      say
      end
    end
  if init=2 then do
    call Charout ,'1B'x'[1;37;40m'||d2c(255)||'  Last successful interval between hits:	'||lastwait 'seconds|'||trunc(lastwait/60,1) 'minutes'
    say '1B'x'[0;37;40m'
    say d2c(255)||'  Final [failed]  interval between hits:	'||lastwait2 'seconds|'||trunc(lastwait2/60,1) 'minutes'
    say d2c(255)||'  Duration of last successful contact:		'||lastcon 'seconds'
    say d2c(255)||'  Duration of final contact:			'||trunc(et,2) 'seconds'
    call Charout ,d2c(255)||'  When disconnected, incremental step was:	'
    if lastwait2>lastwait|maxint='L'&lastwait2=minwait&lastincr>0 then text=lastincr||' seconds'
    else do
      if maxint='L' then text='Not in effect [was '||perminc||' secs]'
      else text='N/A [constant interval]'
      end
    call Format
    call Charout ,d2c(255)
    if detach='A'&translate(logfile)='Y' then do
      if logdel>2 then do
        call Charout ,'1B'x'[1;37;40m'||'ERROR writing' log||d2c(13)||d2c(10)||' '
        call Charout ,'1B'x'[0;37;40m'
        end
      if logdel>2 then leave
      text=SysTextScreenRead(0,0,1360)
      r=' '||d2c(255)
      t=pos(r,text)
      do while t>0
        text=left(text,t-1)||right(text,length(text)-t)
        t=pos(r,text)
        end
      do until r=''
        t=pos(d2c(255),text)
        r=right(text,length(text)-t)
        if pos(d2c(255),r)<1 then r=''
        text=left(text,t-1)||d2c(13)||d2c(10)||r
        end
      text=right(text,length(text)-4)
      text=left(text,length(text)-2)
      call stream log,'C','open write'
      call lineout log,text,1
      call stream log,'C','close'
      end
    end
  if init=2 then leave
  if detach='A' then call SysCurState Off
  call SysSleep curwait
  totmin=trunc(totwait/60,2)
  if init=1 then do
    if lastwait2>0 then lastwait=lastwait2
    else lastwait=minwait
    lastwait2=curwait
    if curwait<maxwait then do
      curwait=curwait+incrmnt
      lastincr=incrmnt
      end
    if curwait=maxwait|curwait>maxwait then curwait=maxwait
    if curwait=maxwait then incrmnt=0
    end
  end
say 'Exit KCG.CMD'
call Ex

EX:
if rxftp\=0 then call FtpDropFuncs
if rxutl\=0 then call RxFuncDrop 'SysLoadFuncs'
exit
RETURN

FORMAT:
  if length(text)>31 then do
    tab=''
    sep=' '
    do until length(text)<32
      lt=lastpos(sep,text,32)-1
      if lt<0 then do
        if sep=' ' then do
          sep='.'
          lt=lastpos(sep,text,32)-1
            if lt<0 then do
            say tab||text
            RETURN
            end
          end
        else do
          say tab||text
          RETURN
          end
        end
      say tab||left(text,lt)
      text=right(text,length(text)-lt)
      tab=d2c(255)||'						'
      end
    say tab||text
    end
  else say text
RETURN

POSIT:
clr=SysCurPos()
r=pos(' ',clr)
l=left(clr,r-1)
r=right(clr,length(clr)-r)
RETURN

NO:
a='DIS'
if init=1 then do
  et=time('E')-bt;enddate=date()
  call Beep 400,200
  call Beep 300,200
  if detach='D' then call Ex
  call SysCls
  init=2
  end
RETURN

YES:
if method='PING' then et=time('E')-bt
if detach='A' then do
  call SysCurPos l,r
  say copies(' ',31)
  call SysCurPos l,r
  text='Connected'
  if method='FTP' then text=text||':  "'||c||'"'
  if method='PING' then do
    if c>1 then text=text||' (WARNING: Host '
    if c=2 then text=text||'not responding)'
    if c=3 then text=text||'unknown [invalid IPaddress])'
    end
  call Format
  end
if init=0 then call Beep 3000,100
if init=1&method='PING'&c>1 then do
  call Beep 3000,200
  call Beep 400,200
  end
if method='FTP' then do
  if detach='A' then do
    call Charout ,d2c(255)||'Querying Host to keep active...		'
    call Posit
    end
  b=''
  b=FtpSys(d)
  et=time('E')-bt
  if b='-1' then do
    if detach='A' then do
      call Beep 400,200
      call Beep 300,200
      call SysCurPos l,r
      text='FTP '||host||' declines connection, or invalid IPaddress: KCG.CMD aborting'
      call Format
      end
    call Help
    end
  if detach='A' then do
    call SysCurPos l,r
    text='Host OpSys: "'||b||'"'
    call Format
    end
  end
if init=0 then do
  connect=time('N');begdate=date()
  call Beep 3150,40
  a=''
  curwait=minwait
  init=1
  lastincr=incrmnt
  totmin=0
  totwait=0
  end
RETURN

HELP:
if detach='A' then do
  say
  say 'KCG.CMD for OS/2:  "Keep-Connected" to Internet'
  say '	R.J.Holmgren  6/20/99  Freeware'
  say
  say 'kcg.cmd [arguments (9)]'
  say '	hostname|IPaddress'
  say '	  user_ID'
  say '	    password'
  say '	      minimum_interval_between_hits (in seconds)'
  say '		maximum_interval_between_hits (in seconds)'
  say '		  increment_amount (increase laziness, in seconds)'
  say '		    L|M (progressive "L"aziness, or "M"aximum interval only)'
  say '		      F|P (use "F"TP, or "P"ING only)'
  say '			A|D (run as "A"ttached, or "D"etached, process)'
  say 'kcg ?|/?|-?|help  command summary (this screen)'
  say 
  say '  e.g.:'
  say 'kcg 152.163.212.93 anonymous mikhail@bakunin.org.ru 120 660 60 L F A [default]'
  say 'detach kcg.cmd idt.net . . . 510 . . . D [override defaults 1,5,&9; Detach KCG]'
  say 'kcg . . . . 750 . M  [override 5&7; use Maximum interval only, of 750 seconds]'
  end
call Ex
RETURN
