/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       vipframe.c
**     SYSTEM   NAME:       VIP
**     ORIGINAL AUTHOR(S):  Alfred Kayser
**     VERSION  NUMBER:     1.00
**     CREATION DATE:       1992/5/29
**
** DESCRIPTION: Frame Module.
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision$
** WORKFILE:    $Workfile$
** LOGINFO:     $Log$
*************************************************************************/
#define LIBRARY
#include "vipinc.h"

PRIVAT LONG VipFrameHandler(VIPINFO *, USHORT, MPARAM, MPARAM);
PRIVAT void FrameAdjust(VIPINFO *wip);


/**************************************************************
** NAME:        VipOpenFrame                              [API]
** SYNOPSIS:    VIPINFO *VipOpenFrame(VIPINFO *parent,
**                  int x, int y, int w, int h)
** DESCRIPTION: Opens a framing window.
** RETURNS:     void
**************************************************************/
EXPORT VIPINFO *
VipOpenFrame(VIPINFO *parent, int x, int y, int w, int h)
{
    VIPINFO *wip;
    struct _framedata *data;    
    if (!(data = VipMalloc(sizeof(struct _graphdata))))
        return NULL;
    if ( !(wip = VipOpenSimple(parent, x,y,w,h)))
    {
        VipFree(data);
        return NULL;
    }
    wip->framedata = data;
    wip->type=T_FRAME;
    data->flags = 0;
    data->fix = 0;
    return wip;
}


/**************************************************************
** NAME:        VipSetFrameSplit
** SYNOPSIS:    EXPORT void
**              VipSetFrameSplit(VIPINFO *parent,
**                    VIPINFO *fix, int flags)
** DESCRIPTION: Sets a fix window in a frame.
**              All other childs are sized to the size of the
**              frame decremented with the size of the <fix>
**              window.
**              The <fix> window determines the position of
**              the split. The size of the other child windows
**              are adjusted so that they use the remainder.
**              <flags> can be VIP_HSPLIT or VIP_VSPLIT evt.
**              ored with VIP_FIXTOP, resp. VIP_FIXLEFT.
**              I.e. with the <fix> window is a horizontal
**              menu, and the the other child window a graph,
**              and <flags> is VIP_HSPLIT|VIP_FIXTOP, the menu
**              is placed at the top, and the graph beneath it
**              adjusted to the size of the menu.
**              If flags is 0, any previous splitting is
**              disabled.
** RETURNS:     void
**************************************************************/
EXPORT void
VipSetFrameSplit(VIPINFO *wip, VIPINFO *fix, int flags)
{
    TYPETEST(wip,T_FRAME,return);

    if (flags&(VIP_HSPLIT|VIP_VSPLIT))
    {
        wip->handler = VipFrameHandler;
        FRAMEDATA(wip,flags) = flags;
        FRAMEDATA(wip,fix)   = fix;
        FrameAdjust(wip); 
    }
    else
        wip->handler = VipSimpleHandler;
}


#define FIX(w)        FRAMEDATA(w,fix)
#define FIXTOP(w)     (FRAMEDATA(w,flags)&VIP_FIXTOP)
#define FIXLEFT(w)    (FRAMEDATA(w,flags)&VIP_FIXLEFT)
#define VSPLIT(w)     (FRAMEDATA(w,flags)&VIP_VSPLIT)
#define HSPLIT(w)     (FRAMEDATA(w,flags)&VIP_HSPLIT)

PRIVAT LONG
VipFrameHandler(VIPINFO *wip, USHORT msg, MPARAM mp1, MPARAM mp2)
{
    switch(msg)
    {
    case WM_SHOW:
        if (wip->flags&F_ICONIZED) break;
        if (SHORT1FROMMP(mp1)) FrameAdjust(wip); 
        break;

    case WM_SIZE:
        if (wip->flags&F_ICONIZED) break;
        wip->cx=SHORT1FROMMP(mp2);
        wip->cy=SHORT2FROMMP(mp2);
        FrameAdjust(wip);
        return 0L;
    }
	return VipSimpleHandler(wip, msg, mp1, mp2);
}


PRIVAT void
FrameAdjust(VIPINFO *wip)
{
	VIPINFO *child;
    LONG offset, w, h, fixH;

    offset=0;
    w=wip->cx-2*wip->border;
    h=wip->cy-2*wip->border;
    if (HSPLIT(wip))
    {
        if (FIX(wip) && FIX(wip)->win)
        {
            /* Scale the fixed window (menu, or label) */
            WinSendMsg(FIX(wip)->win, UM_SCALE, (MPARAM)TRUE, NULL);

            /* Get new size of fixed window */
            fixH = FIX(wip)->cy;

            /* Adjust size of the other window */
            h -= fixH;
            if (FIXTOP(wip))
            {
                VipMoveWindow(FIX(wip), wip->border, wip->border+h);
                offset = wip->border;
            }
            else
            {
                VipMoveWindow(FIX(wip), wip->border, wip->border);
                offset = fixH+wip->border;
            }
            VipSizeWindow(FIX(wip), w, fixH);

            for (child=wip->child; child ; child = child->sibling)
                if (child!=FIX(wip))
                    VipAdjustChild(child, w, h, wip->border, offset);
        }
    }
    else if (VSPLIT(wip))
    {
        if (FIX(wip)->win)
        {
            /* Scale the fixed window (menu, or label) */
            WinSendMsg(FIX(wip)->win, UM_SCALE, (MPARAM)TRUE, NULL);

            /* Get new size of fixed window */
            fixH = FIX(wip)->cx;

            /* Adjust size of the other window */
            w-= fixH;

            if (FIXLEFT(wip))
            {
                VipMoveWindow(FIX(wip), wip->border, wip->border);
                offset = fixH+wip->border;
            }
            else
            {
                VipMoveWindow(FIX(wip), wip->border+w, wip->border);
                offset = wip->border;
            }
            VipSizeWindow(FIX(wip), fixH, h);

            for (child=wip->child; child; child = child->sibling)
                if (child!=FIX(wip))
                    VipAdjustChild(child, w, h, offset, wip->border);
        }
    }
    else
    {
        for (child=wip->child; child ; child = child->sibling)
            VipAdjustChild(child, w, h, wip->border, wip->border);
    }
}
