#include <dnpap.h>
#include <config.h>
#include <message.h>
#include <vip.h>
#include <string.h>

VIPINFO *frameWin;  /* Frame window is useally global, because it is used
                       in many places */

PRIVAT void Okay(VIPINFO *, VOID *, BOOLEAN);
PRIVAT void Cancel(VIPINFO *, VOID *, BOOLEAN);
PRIVAT void Help(VIPINFO *, VOID *, BOOLEAN);

void main(int argc, char **argv)
{
    VIPINFO *titleWin[2];
    VIPINFO *inputWin[2];
    VIPINFO *button;
    char hostname[80];
    char ipnumber[18];
    int i;

    /* Initialize Config System */
    ConfigInit(argc,argv);
    ConfigLoad();

    /* Initialize Message System, with FILE and VIP device */
    MessageInit("viptest", MSGFILE, MSGVIP, NULL);

    /* Initialize the VIP System! */
    if (!VipInit(argc,argv))
        DnpapMessage(DMC_ERROR,1,"Failed to initialize VIP!");

    /* First open a toplevel window, ie without parent */
    frameWin = VipOpenSimple(NULL, 250, 250, 500, 500);

    for (i=0;i<2;i++)
    {
        titleWin[i] = VipOpenText(frameWin, 50, 900-i*100, 400, 50);
        VipSetBorder(titleWin[i], 0, 0);
        VipSetBackground(titleWin[i], VIP_GREY);
        inputWin[i] = VipOpenInput(frameWin, 500, 880-i*100, 450, 100);
        VipSetBorder(inputWin[i], 2, VIP_DEPTH);
    }

    VipSetTextLine(titleWin[0], "HostName:",0,VIP_RIGHT);
    strcpy(hostname,"dutepp33");
    VipSetInputBuffer(inputWin[0], hostname, sizeof(hostname));

    VipSetTextLine(titleWin[1], "IP Number:",0,VIP_RIGHT);
    strcpy(ipnumber,"130.161.145.229");
    VipSetInputBuffer(inputWin[1], ipnumber, sizeof(ipnumber));
    
    /* Install a set of buttons... */

    button=VipOpenButton(frameWin, 100, 50, 200, 100);
    VipSetTitle(button, "Okay");
    VipSetButtonKey(button, VIPKEY_ENTER);
    VipSetButtonCallBack(button, Okay, NULL);

    button=VipOpenButton(frameWin, 400, 50, 200, 100);
    VipSetTitle(button, "Cancel");
    VipSetButtonKey(button, VIPKEY_ESC);
    VipSetButtonCallBack(button, Cancel, NULL);

    button=VipOpenButton(frameWin, 700, 50, 200, 100);
    VipSetTitle(button, "Help");
    VipSetButtonKey(button, VIPKEY_F1);
    VipSetButtonCallBack(button, Help, NULL);


    /* Set the title of the window */
    VipSetTitle(frameWin, "Config Editor");

    /* Show it */
    VipShow(frameWin);

    /* Check the message loop, and block until exit */
    VipCheck(TRUE);

    DnpapExit(0);
}

PRIVAT void Okay(VIPINFO *win, VOID *p, BOOLEAN f)
{
    if (!f)
        VipClose(frameWin);
}


PRIVAT void Cancel(VIPINFO *win, VOID *p, BOOLEAN f)
{
    if (!f)
        VipClose(frameWin);
}

PRIVAT void Help(VIPINFO *win, VOID *p, BOOLEAN f)
{
    if (!f)
        VipMessage(frameWin, "Help",
            "Fill in the fields and press enter to confirm!");
}


