#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <dnpap.h>
#include <snmp.h>
#include "protocol.h"
#include "prot.h"
#include "prototyp.h"

BYTE *protDECString[] =
{
 "OPTIONAL_PADDING",
 "VERSION",
 "ECO",
 "USER_ECO",
 "DEC_SOURCE_ADDRESS",
 "INFO",
 "BLOCK_SIZE",
 "AREA",
 "SEED",
 "NEIGHBOR",
 "TIMER",
 "MPD",
 "DATA_LENGTH",
 "TEST_DATA",
 "PRIORITY",
 "E_LIST_LENGTH",
 "R/S_LIST_LENGTH",
 "NAME",
 "COUNT",
 "DESTINATION_ADDRESS",
 "SOURCE_ADDRESS",
 "VISIT_COUNT"
};

/*****************************************************************
** NAME:        ProtDECHeader(PROT_PKT *Pkt)
** SYNOPSIS:    BOOLEAN ProtDECHeader(PROT_PKT *Pkt)
** PARAMETERS:  - Pkt - pointer to the packet
** DESCRIPTION: - reads the Decnet Header
** REMARKS:     
** RETURNS:     FALSE - if the allocations were not successful
**              TRUE  - otherwise
*******************************************************************/


BOOLEAN ProtDECHeader(PROT_PKT *Pkt)
{
  BYTE buffer[3];
  BYTE LongDataBuf[30];
  int type;

  if((Pkt->Frame = DnpapMalloc(sizeof(PROT_DEC))) != NULL)
  {
   Pkt->Frame->Dec.Len =   Pkt->Ptr;
   Pkt->Frame->Dec.Type =  Pkt->Ptr + 2;

   memcpy(buffer,Pkt->Frame->Dec.Len,3);
   memcpy(buffer,Pkt->Frame->Dec.Type,2);

   if((Pkt->Frame->Dec.Data = DnpapMalloc(sizeof(DEC_PROT))) == NULL)
   {
    DnpapMessage(DMC_FATAL,1,"OUT OF MEMORY");
    return(FALSE);
   }   
   else
    {
     type = (int) buffer[0];
     if(type == 129)
       {
        type = (int) buffer[1];
        DEC_FLAGS[0] = 1;
       }   
     switch(type)
        {
         case 13:
                 Pkt->Frame->Dec.Data->Dec_EEH.Data = Pkt->Ptr + 3;
                   EtherEndNode(Pkt);
                 break;
         case 11:
                 Pkt->Frame->Dec.Data->Dec_ERH.Data = Pkt->Ptr + 3;
                 EtherRouterHello(Pkt);
                 break;
         case 7:
                 Pkt->Frame->Dec.Data->Dec_LOR.Data = Pkt->Ptr + 3;
                 LevelOneRouting(Pkt);
                 break;
         case 129:
                 Pkt->Frame->Dec.Data->Dec_LDP.Data = Pkt->Ptr + 3;
                 LongDataPacket(Pkt);
                 break;
         default:
                 Pkt->Frame->Dec.Data->Dec_LDP.Data = Pkt->Ptr + 3;
                 LongDataPacket(Pkt);
                 memcpy(LongDataBuf,Pkt->Frame->Dec.Data->Dec_LDP.Data,22);
                 Pkt->Frame->Dec.nsp = LongDataBuf[21];
                 Pkt->ChildProt = PROT_PKTUNKNOWN;
        }
    }
   Pkt->ChildProt = PROT_PKTUNKNOWN;
   return(TRUE);                 
  }
  return(FALSE);
}

/*****************************************************************
** NAME:        LevelOneRouting
** SYNOPSIS:    BOOLEAN LevelOneRouting(PROT_PKT *Ptr)
** PARAMETERS:  - Ptr - pointer to the packet
** DESCRIPTION: - Fills the data structure representing the Decnet
**                packet LevelOneRouting
** REMARKS:     
** RETURNS:     FALSE - if the allocation was not successful
**              TRUE  - otherwise
*******************************************************************/

BOOLEAN LevelOneRouting(PROT_PKT *Ptr)
{
 BYTE EndNodeBuf[1500];
 BYTE RetStr[20];

 memcpy(EndNodeBuf,Ptr->Frame->Dec.Data->Dec_LOR.Data,1500);
 GetAddress(&EndNodeBuf[0],RetStr);
 strcpy(Ptr->Frame->Dec.Data->Dec_LOR.SrcAdr, RetStr);
 if((Ptr->Frame->Dec.Data->Dec_LOR.Seg = DnpapMalloc(sizeof(LOR_SEGMENT))) == NULL)
  {
    DnpapMessage(DMC_FATAL,1,"Out of memory");
    return(FALSE);
  }  
 else
 { 
  Ptr->Frame->Dec.Data->Dec_LOR.Seg->Count = GetDecNumber(&EndNodeBuf[3]);
  GetAddress(&EndNodeBuf[6],RetStr);
  strcpy(Ptr->Frame->Dec.Data->Dec_LOR.Seg->StartId,RetStr);
 }
 Ptr->Frame->Dec.NextData = Ptr->Frame->Dec.Data->Dec_LOR.Data + 3;
 return(TRUE);
}

/*****************************************************************
** NAME:        LongDataPacket
** SYNOPSIS:    VOID LongDataPacket(PROT_PKT *Ptr)
** PARAMETERS:  - Ptr - pointer to the packet
** DESCRIPTION: - Fills the data structure representing the Decnet
**                packet LongDataPacket
** REMARKS:     
** RETURNS:     no value
*******************************************************************/

VOID LongDataPacket(PROT_PKT *Ptr)
{
 BYTE LongDataBuf[200];
 BYTE RetStr[20];
 
 memcpy(LongDataBuf,Ptr->Frame->Dec.Data->Dec_LDP.Data,200);
 GetAddress(&LongDataBuf[7],RetStr);
 strcpy(Ptr->Frame->Dec.Data->Dec_LDP.SrcAdr,RetStr);
 GetAddress(&LongDataBuf[15],RetStr);
 strcpy(Ptr->Frame->Dec.Data->Dec_LDP.SrcAdr,RetStr);
 Ptr->Frame->Dec.Data->Dec_LDP.VisitCount = (WORD) LongDataBuf[18];
 Ptr->Frame->Dec.NextData = Ptr->Frame->Dec.Data->Dec_LDP.Data + 21;
}

/*****************************************************************
** NAME:        EtherEndNode
** SYNOPSIS:    VOID EtherEndNode(PROT_PKT *Ptr)
** PARAMETERS:  - Ptr - pointer to the packet
** DESCRIPTION: - Fills the data structure representing the Decnet
**                packet EtherEndNode
** REMARKS:     
** RETURNS:     no value
*******************************************************************/

VOID EtherEndNode(PROT_PKT *Ptr)
{
 BYTE EndNodeBuf[100];
 BYTE RetStr[20];
 int testdata;
 
 memcpy(EndNodeBuf,Ptr->Frame->Dec.Data->Dec_EEH.Data,100);
 Ptr->Frame->Dec.Data->Dec_EEH.Vers = Ptr->Frame->Dec.Data->Dec_EEH.Data;
 Ptr->Frame->Dec.Data->Dec_EEH.Eco = Ptr->Frame->Dec.Data->Dec_EEH.Data + 1;
 Ptr->Frame->Dec.Data->Dec_EEH.UserEco = Ptr->Frame->Dec.Data->Dec_EEH.Data + 2;
 GetAddress(&EndNodeBuf[7],RetStr);
 strcpy(Ptr->Frame->Dec.Data->Dec_EEH.SrcAdr, RetStr);
 Ptr->Frame->Dec.Data->Dec_EEH.Info = Ptr->Frame->Dec.Data->Dec_EEH.Data + 9;
 Ptr->Frame->Dec.Data->Dec_EEH.BlkSize = GetDecNumber(&EndNodeBuf[10]);
 GetAddress(&EndNodeBuf[25],RetStr);
 strcpy(Ptr->Frame->Dec.Data->Dec_EEH.DestRtr, RetStr);
 Ptr->Frame->Dec.Data->Dec_EEH.Timer = GetDecNumber(&EndNodeBuf[27]);
 Ptr->Frame->Dec.Data->Dec_EEH.TestData = Ptr->Frame->Dec.Data->Dec_EEH.Data + 30;
 testdata = (int) EndNodeBuf[30];
 Ptr->Frame->Dec.NextData = Ptr->Frame->Dec.Data->Dec_EEH.Data +  30 + 2*testdata;
}

/*****************************************************************
** NAME:        EtherRouterHello
** SYNOPSIS:    VOID EtherRouterHello(PROT_PKT *Ptr)
** PARAMETERS:  - Ptr - pointer to the packet
** DESCRIPTION: - Fills the data structure representing the Decnet
**                packet EtherRouterHello
** REMARKS:     
** RETURNS:     no value
*******************************************************************/

VOID EtherRouterHello(PROT_PKT *Ptr)
{
 BYTE EndNodeBuf[100];
 BYTE RetStr[20];

 memcpy(EndNodeBuf,Ptr->Frame->Dec.Data->Dec_ERH.Data,100);
 Ptr->Frame->Dec.Data->Dec_ERH.Vers = Ptr->Frame->Dec.Data->Dec_ERH.Data;
 Ptr->Frame->Dec.Data->Dec_ERH.Eco = Ptr->Frame->Dec.Data->Dec_ERH.Data + 1;
 Ptr->Frame->Dec.Data->Dec_ERH.UserEco = Ptr->Frame->Dec.Data->Dec_ERH.Data + 2;
 GetAddress(&EndNodeBuf[7],RetStr);
 strcpy(Ptr->Frame->Dec.Data->Dec_ERH.SrcAdr, RetStr);
 Ptr->Frame->Dec.Data->Dec_ERH.Info = Ptr->Frame->Dec.Data->Dec_EEH.Data + 9;
 Ptr->Frame->Dec.Data->Dec_ERH.BlkSize = GetDecNumber(&EndNodeBuf[10]);
 Ptr->Frame->Dec.Data->Dec_ERH.Priority = Ptr->Frame->Dec.Data->Dec_EEH.Data + 12;
 Ptr->Frame->Dec.Data->Dec_ERH.Timer = GetDecNumber(&EndNodeBuf[14]);
 Ptr->Frame->Dec.Data->Dec_ERH.RSListLen = EndNodeBuf[25];
 Ptr->Frame->Dec.NextData = Ptr->Frame->Dec.Data->Dec_ERH.Data + 26;
}

/*****************************************************************
** NAME:        GetDecNumber
** SYNOPSIS:    char *GetDecNumber(BYTE *Ptr)
** PARAMETERS:  - RetStr - character string returnung the result
** DESCRIPTION: - converts to bytes to a decimal number
** REMARKS:     
** RETURNS:     returns a word representing decimal number
*******************************************************************/

WORD GetDecNumber(BYTE *Ptr)
{
 WORD Word1;
 WORD Word2;

 Word1 = Ptr[0];
 Word2 = Ptr[1];
 Word2 = Word2 << 8;
 return(Word1+Word2);
}

/*****************************************************************
** NAME:        GetAddress(BYTE *Ptr, BYTE *RetStr)
** SYNOPSIS:    char *GetAddress(BYTE *Ptr, BYTE *RetStr)
** PARAMETERS:  - Ptr - pointer to the field of two bytes
**              - RetStr - character string returning the result
** DESCRIPTION: - converts two bytes to the format of the Decnet 
**                address
** REMARKS:     
** RETURNS:     returns string representing address
*******************************************************************/


BOOLEAN GetAddress(BYTE *Ptr, BYTE *RetStr)
{
 WORD Word1;
 WORD Word2;

 Word2 = Ptr[1]*256 +Ptr[0];
 Word1 = Word2 & (WORD) 1023;
 Word2 = Word2 & (WORD) 64512;
 Word2 = Word2 >> 10;
 sprintf(RetStr,"%d.%d",Word2,Word1);
 return(TRUE);
}


/*****************************************************************
** NAME:        GetHopsCost
** SYNOPSIS:    char *GetHopsCost(BYTE *Ptr, BYTE *RetStr)
** PARAMETERS:  - Ptr - pointer to the field of two bytes
**              - RetStr - character string returning the result
** DESCRIPTION: - gets the first 6 bits - hops
**                and the last 10 bits  - cost
** REMARKS:     
** RETURNS:     returns string representing hops and costs
*******************************************************************/

char *GetHopsCost(BYTE *Ptr, BYTE *RetStr)
{
  WORD Word1=0;
  WORD Word2=0;

  Word2 = Ptr[1]*256 + Ptr[0];
  Word1 = Word2 & 768;
  Word1 = Word1 + Ptr[0];
  Word2 = Ptr[1];
  Word2 = Word2 >> 2;
  sprintf(RetStr,"%d %d %d",Word2&32,Word2,Word1);
  return(RetStr);
}
