#include <stdlib.h>
#include <ctype.h>
#include <memory.h>
#include <string.h>
#include <stdio.h>
#include <dnpap.h>
#include <snmp.h>
#include <mibdf.h>
#include "exec.h"
#include "parse.h"



int GetList(char *line, SNMP_OBJECT *list, int listSize, int *listLength) 
{
	int i=0,r=0,n=0;
	char *name;
	SNMP_OBJECT *object;

	if((r=GetObject(line+i,list+n))<0)
		return -1;
	i+=r;
	n++;
	while(line[i]==' ' || line[i]=='\t')
		i++;
	while(line[i]==';')
	{
		if (n>=listSize)
			return -2;
		i++;
		if((r=GetObject(line+i,list+n))<0)
			return -1;
		i+=r;
		n++;
		while(line[i]==' ' || line[i]=='\t')
			i++;
	}
	if(line[i]=='.' && line[i+1]=='.' && line[i+2]=='.')
	{
		i+=3;
		object=list+n-1;
		name=MibID2Name2(object->Id,object->IdLen,&r);
		while((name=MibGetNextChild(name))!=NULL && n<listSize)
		{
			memcpy(list+n,object,sizeof(*object));
			MibName2ID(list[n].Id,name);	
			n++;
		}
	}
	*listLength=n;
	return i;
}	

int GetObject(char *line, SNMP_OBJECT *object)
{
	int i=0,r=0,n=0;
	char name[80];

	while(line[i]==' ' || line[i]=='\t')
		i++;
	if((r=GetName(line+i,name,sizeof(name)))<0)
		return -1;
	n=MibName2ID(object->Id, name);
	if ( n<0 )
		return -1;
    object->IdLen = n;
	i+=r;
	while(line[i]==' ' || line[i]=='\t')
		i++;
	if (line[i]=='[')
	{
		if((r=GetIndex(line+i, object->Id+object->IdLen,
			SNMP_SIZE_OBJECTID-object->IdLen,&n))<0)
			return -1;
		object->IdLen+=n;
		i+=r;
	}
	else
	{
		object->Id[object->IdLen]=0;
		object->IdLen++;
	}
	while(line[i]==' ' || line[i]=='\t')
		i++;
	if (line[i]=='=')
	{
		i++;	
		object->Type=MibNameType(name);
		if((r=GetValue(line+i,object))<0)
			return -1;
		i+=r;
	}
	else
	{
		object->Type=SNMP_NULL;
		object->Syntax.LngUns=0L;
	}
	return i;
}

int GetName(char *line, char *name, int nameSize)
{
	int i=0,r=0,n=0;
	
	while(line[i]==' ' || line[i]=='\t')
		i++;
	while(isalnum(line[i]) || line[i] == '.' || line[i] == '-')
	{
		name[n++]=line[i++];
	}
	name[n]=0;
	return i;
}

int GetValue(char *line, SNMP_OBJECT *object)
{
	int     i=0,r=0,n=0,u;
    ULONG   lu;
	char    c;

	while(line[i]==' ' || line[i]=='\t')
		i++;
	switch(object->Type)
	{
		case SNMP_NULL:
			break;
		case SNMP_INTEGER:
			sscanf(line+i,"%ld%n",&object->Syntax.LngInt,&r);
			i+=r;
			break;
		case SNMP_OCTETSTR:
			if (line[i]=='"')
			{
				i++;
				while(line[i]!='"' && line[i]!='\0')
				{
					object->Syntax.BufChr[n++]=line[i++];
				}
				if (line[i]=='"')
					i++;
				object->SyntaxLen=n;
			}
			else
			{
				if (sscanf(line+i, "%x%n", &u, &r) < 1)
					return (-1);
				object->Syntax.BufChr[n++]=(BYTE)u;
				i += r;
				while (sscanf(line+i, "%1[.:-]%x%n",&c, &u, &r) > 0)
				{
					object->Syntax.BufChr[n++]=(BYTE)u;
					i += r;
				}
				object->SyntaxLen=n;
			}
			break;
		case SNMP_OBJECTID:
			if (sscanf(line+i, "%lu%n", &lu, &r) < 1)
                		return (-1);
			object->Syntax.BufInt[n++]=lu;
			i += r;
            		while (sscanf(line+i, ".%lu%n", &lu, &r) > 0)
            		{
				object->Syntax.BufInt[n++]=lu;
				i += r;
            		}
			object->SyntaxLen=n;
			break;
		case SNMP_IPADDR:
			if (sscanf(line+i, "%u%n", &u, &r) < 1)
                		return (-1);
			object->Syntax.BufChr[n++]=(BYTE)u;
			i += r;
            		while (sscanf(line+i, ".%u%n", &u, &r) > 0)
            		{
				object->Syntax.BufChr[n++]=(BYTE)u;
				i += r;
            		}
			object->SyntaxLen=n;
			break;
		case SNMP_COUNTER:
        	case SNMP_GAUGE:
        	case SNMP_TIMETICKS:
            		sscanf (line+i, "%lu%n", &object->Syntax.LngUns,&r);
			i +=r;
            		break;
		case SNMP_OPAQUE:
            		break;
	}	
	return i;
}

	


int GetIndex(char *line, ULONG *index, int indexSize, int *indexLength)
{	
	int     i=0,r=0,n=0;
    ULONG   lu;

	if(line[i]!='[')
		return -1;
	i++;
	while(line[i]==' ' || line[i]=='\t')
		i++;
	if(line[i]==']')
	{	
		i++;
		*indexLength=0;
		return i;
	}
 	if (sscanf(line+i, "%lu%n", &lu, &r) < 1)
		return (-1);
	i+=r;
	index[n++]=lu;
	while(line[i]=='.' || line[i]==',')
	{
		i++;
	 	if (sscanf(line+i, "%lu%n", &lu, &r) > 0)
			return (-1);
		i+=r;
		index[n++]=lu;
		while(line[i]==' ' || line[i]=='\t')
			i++;
	}
	while(line[i]==' ' || line[i]=='\t')
		i++;
	if(line[i]!=']')
		return -1;
	i++;
	*indexLength=n;
	return i;
}
		
int PutList(SNMP_OBJECT *list, int listLength, char *line, int lineSize)
{
	int i=0,r=0,n=0;

	if((r=PutObject(list+n,line+i,lineSize-i))<0)
		return -1;
	i+=r;
	for(n=1;n<listLength;n++)
	{
		line[i]=';';
		i++;
		line[i]=' ';
		i++;
		if((r=PutObject(list+n,line+i,lineSize-i))<0)
			return -1;
		i+=r;
	}
	line[i]='\0';
	i++;
	return i;
}

int PutObject(SNMP_OBJECT *object, char *line, int lineSize)
{
	int i=0,r=0,n=0;
	char *name;

	name=MibID2Name2(object->Id,object->IdLen,&n);
	if((r=PutName(name,line+i,lineSize-i))<0)
		return -1;
	i+=r;
	if((r=PutIndex(object->Id+n,object->IdLen-n,line+i,lineSize-i))<0)
		return -1;
	i+=r; 
	line[i]='=';
	i++;
	if((r=PutValue(object,line+i,lineSize-i))<0)
		return -1;
	i+=r;
	return i;
}

int PutIdentifier(SNMP_OBJECT *object, char *line, int lineSize)
{
	int i=0,r=0,n=0;
	char *name;

	name=MibID2Name2(object->Id,object->IdLen,&n);
	if((r=PutName(name,line+i,lineSize-i))<0)
		return -1;
	i+=r;
	if((r=PutIndex(object->Id+n,object->IdLen-n,line+i,lineSize-i))<0)
		return -1;
	i+=r; 
	return i;
}



int PutName(char *name, char *line, int lineSize)
{
	int i=0;

	strcpy(line+i,name);
	i=strlen(name);
	return i;
}

int PutValue(SNMP_OBJECT *object, char *line, int lineSize)
{
	int     i=0,r=0,u;
    ULONG   lu;
    USHORT  n=0;

	switch(object->Type)
	{
		case SNMP_NULL:   
			sprintf(line+i,"NULL");
			i+=4;
		case SNMP_INTEGER:
			sprintf(line+i,"%ld%n",object->Syntax.LngInt,&r);
			i+=r;
			break;
		case SNMP_OCTETSTR:
			if (IsVisible((BYTE *) object->Syntax.BufChr,object->SyntaxLen))
			{
				object->Syntax.BufChr[object->SyntaxLen]='\0';
				line[i]='"';
				i++;
				strcpy(line+i,object->Syntax.BufChr);
				i+=object->SyntaxLen;
				line[i]='"';
				i++;
			}
			else
			{		
				u=(BYTE)object->Syntax.BufChr[0];
				if(sprintf(line+i, "%02x%n", u, &r) == 0)
					return (-1);
				i+=r;
				for(n=1;n<object->SyntaxLen;n++)
				{
					u=(BYTE)object->Syntax.BufChr[n];
					if (sprintf(line+i, ":%02x%n", u, &r) == 0)
						return (-1);
					i+=r;
				}
			}
			break;
		case SNMP_OBJECTID:
			lu=object->Syntax.BufInt[0];
			if(sprintf(line+i, "%lu%n", lu, &r) == 0)
                		return (-1);
			i+=r;
			for(n=1;n<object->SyntaxLen;n++)
			{
				lu=object->Syntax.BufInt[n];
				if (sprintf(line+i, ".%lu%n", lu, &r) == 0)
                			return (-1);
				i+=r;
			}
			break;
		case SNMP_IPADDR:
			u=(BYTE)object->Syntax.BufChr[0];
			if (sprintf(line+i, "%u%n", u, &r) == 0)
                		return (-1);
			i+=r;
			for(n=1;n<4;n++)
			{
				u=(BYTE)object->Syntax.BufChr[n];
				if (sprintf(line+i, ".%u%n", u, &r) == 0)
                			return (-1);
				i+=r;
			}
			break;
		case SNMP_COUNTER:
        	case SNMP_GAUGE:
        	case SNMP_TIMETICKS:
            		sprintf (line+i, "%lu%n", object->Syntax.LngUns,&r);
			i +=r;
            		break;
		case SNMP_OPAQUE:
            		break;
	}	
	return i;
}
       
		
		
int PutIndex(ULONG *index, int indexLength, char *line, int lineSize)
{	
	int     i=0,r=0,n=0;
    ULONG   lu;
	
	line[i]='[';
	i++;
	if(indexLength==0)
	{
		line[i]=']';
		i++;
		return i;
	}
	lu=index[0];
	if(sprintf(line+i, "%lu%n", lu, &r) == 0)
		return (-1);
	i+=r;
	for(n=1;n<indexLength;n++)
	{
		lu=index[n];
		if (sprintf(line+i, ".%lu%n", lu, &r) == 0)
			return (-1);
		i+=r;
	}
	line[i]=']';
	i++;
	return i;
}

int IsVisible(BYTE *s, int n)
{
	BYTE c;

	while(n-->0)
	{
		c=*s++;
		if(c>126 || (c<32 && c!=10 && c!=13) )
			return 0;
	}
	return 1;
}
