#!/usr/local/bin/perl

# this program is a demonstration of the Tricklet 
# perl interface made by the DNPAP group of
# the Technical University Delft, The Netherlands.
# 
require "spook.pl";
#
# handle the arguments
#
if( @ARGV != 3 )
{
	die "call as:  demo.pl <host> <community> <medium>\n";
}
($iniHost , $iniComm , $iniMed , @rest) = @ARGV;
printf("Communicating with %s through medium %s, community %s\n",
	$iniHost,
	$iniComm,
	$iniMed);
#
# open a SNMP connection 
#
&snmp_open(1) || die "cant open\n";
&snmp_host(1,$iniHost);
&snmp_medium(1,$iniMed);
&snmp_community(1,$iniComm);
&snmp_connect(1) || die "could't connect";
#
#collect and print some SNMP variables
#
printf("sysDescr=%s\n",&snmp_get(1,"sysDescr"));
printf("sysObjectID=%s\n",&snmp_get(1,"sysObjectID"));
printf("sysUpTime=%s\n",&snmp_get(1,"sysUpTime"));
printf("sysContact=%s\n",&snmp_get(1,"sysContact"));
printf("sysName=%s\n",&snmp_get(1,"sysName"));
printf("sysLocation=%s\n",&snmp_get(1,"sysLocation"));
printf("sysServices=%s\n",&snmp_get(1,"sysServices"));
#
# close the SNMP connection
#
&snmp_disconnect(1);
&snmp_close(1);
