/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       slurf.h
**     SYSTEM   NAME:       
**     ORIGINAL AUTHOR(S):  Paul Lemmers
**     VERSION  NUMBER:     
**     CREATION DATE:       1992/7/31
**
** DESCRIPTION: Definitions of structures and macros for SLURF driver.
**              This file contains all the common definitions for the
**              driver and the ring 3 application
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision$
** WORKFILE:    $Workfile$
** LOGINFO:     $Log$
*************************************************************************/

#define	SLURF_CATEGORY       0x83        /* .....invented..... */

typedef struct _iocparm {
	unsigned short	usSub;
	unsigned short	usHandle;
	unsigned short	usDatLen;
	unsigned short	usParam1;
	unsigned long	ulParam2;
	unsigned char	abData[16];
	} IOCPARM;

/* SLURF IOCtl function codes */
#define FUNCTION_MASK       0x40
#define	SLURF_MOTOR          (FUNCTION_MASK)
#define	SLURF_GIVE           (1 | FUNCTION_MASK)
#define	SLURF_GET_CONFIG     (2 | FUNCTION_MASK)
#define	SLURF_GENREQ         (5 | FUNCTION_MASK)
#define	SLURF_SEND           (6 | FUNCTION_MASK)
#define	SLURF_MULTI_SEND     (7 | FUNCTION_MASK)
#define	SLURF_HIGHRES_TIME   (10 | FUNCTION_MASK)

/* SLURF IOCtl error codes (returned DosIOCtl as 0xFFxx) */
#define	NER_NO_GIVE         0x81
#define	NER_TOO_MANY        0x82
#define	NER_INVALID_PARM    0x83
#define NER_INVALID_TXSEG   0x84
#define NER_INVALID_RXSEG   0x85
#define NER_TOO_MANY_RXSEG  0x86
#define	NER_DUP_GIVE        0x87
#define NER_INVALID_SEG     0x88
#define NER_OUT_OF_MEM      0x89
#define NER_NOT_BOUND       0x8A
#define NER_NO_TIMER        0x8B

typedef struct _EVENT far *PEVENT;
typedef struct _EVENT {
	PEVENT          pxNextEvent;
	unsigned short	usEventType;
	unsigned short	usHandle;
	unsigned short	usRet1;
	unsigned short	usRet2;
	unsigned long	ulTime;
	unsigned char	abData[16];
	};

/* SLURF Event Types */
#define EVENT_GET_CONFIG    2
#define EVENT_GENREQ        5
#define EVENT_SEND          6
#define	EVENT_MULTI_SEND    7
#define EVENT_STATUS        10
#define EVENT_FRAME         11
#define EVENT_LOST_FRAMES   12
#define EVENT_DUMMY         13


typedef struct _txseg {
	PEVENT		pxFirst;	/* pointer to first event; only valid
					   when sem released!! */
	unsigned long	semRecsAvail;	/* RAM semaphore.... */
	unsigned short	usRecsAvail;	/* # of event records available */
	unsigned short	usTxSize;	/* Size of this Tx segment (0=64K) */
	unsigned short  usRes;		/* Reserved */
	unsigned short  selRcv;		/* Rcv segment selector */
	} TXSEG;

/* multisend structures */
#define MAX_TX_WIN  4
typedef struct _ONE_TX _far *PONE_TX;
typedef struct _ONE_TX {
	unsigned short  usRet1;
	unsigned short  usRet2;
	unsigned long   ulTime0;
	unsigned long   ulTime1;
	unsigned long   ulTime2;
	} ONE_TX;

typedef unsigned char _far *PMACFRAME;
typedef struct _msend _far *PMSEND;
typedef struct _msend {
	unsigned short	usLen;       /* Frame length */
	unsigned short	usSeqOffs;   /* Offset in frame for sequence # */
	unsigned short	usWindow;    /* Simultaneous send window size */
	unsigned short	usCnt;       /* Total number of frames to send */
	unsigned short	usDescSize;  /* Offset between frame and desc. */
	unsigned short	usRes;       /* reserved */
	unsigned long	ulTime1;     /* Just before first send */
	unsigned long	ulTime2;     /* Return to kernel */
	PMACFRAME       aFramePtrs[MAX_TX_WIN]; /* frame pointers */
	ONE_TX          aTxTime[1];  /* Timestamps array */
	} MSEND;


/*
** All SLURF command codes in the frames have a major and minor key.
** The Minor key describes the test and the majore key describes the
** fase in which the test is supposed to be.
**
** Normally there are three stations: Master, Active and Passive. (In
** some tests the Master station can be the Active station, i.e. only
** two stations.)
** The table below describes the major key with source and destinations
** for the major key messages.
**
**  MAJOR     DST   SRC   Remarks
**
**  PREP       P     M    Prepare Passive station for specified test
**  READY      M     P    Passive says that it is ready for the test
**
**  EXEC       A     M    Master tells Active to start test
**  DONE       M     A    Active notifies Master of test completion
**
**   -         P     A    The real test frame
**  RSP        A     P    Reply to test (echo test)
**
**  STOP       P     M    Master tells Passive that test is over
**  REPLY      M     P    Passive reports its results
**
** 
*/

/* Major key values */
#define SLURF_CMD_MAJOR        0xff00
#define SLURF_CMD_PREP         0x0100
#define SLURF_CMD_READY        0x8100

#define SLURF_CMD_EXEC         0x0200
#define SLURF_CMD_DONE         0x8200

#define SLURF_CMD_RSP          0x8000

#define SLURF_CMD_STOP         0x0300
#define SLURF_CMD_REPLY        0x8300

/* Major key values */
#define SLURF_CMD_MINOR        0x00ff
#define SLURF_CMD_WHO            0x01
#define SLURF_CMD_TIME           0x02
#define SLURF_CMD_BURST          0x03
#define SLURF_CMD_ECHO           0x04
