/**********************************************************************
** MODULE INFORMATION*
**********************
**      FILE     NAME:       message.h
**      SYSTEM   NAME:       message
**      ORIGINAL AUTHOR(S):  Alfred Kayser
**      VERSION  NUMBER:     1.0
**      CREATION DATE:       91/09/16
**
** DESCRIPTION: Include file for the message library
***********************************************************************
** CHANGES INFORMATION **
*************************
** REVISION: $Revision: 1.1 $
** AUTHOR:   $Author: alfred $
** DATE:     $Date: 1991/12/13 15:34:30 $
** LOG:      $Log: filedev,v $
**        Revision 1.1  1991/12/13  15:34:30  alfred
**        First check in.
**
**********************************************************************/
#ifndef MESSAGE_H
#define MESSAGE_H

typedef struct _trans TRANSCRIPT;

typedef void *(* TRANSDOPEN)  __((CONST char *));  
typedef void  (* TRANSDPUT)   __((void *, CONST char *));
typedef void  (* TRANSDCLOSE) __((void *));
typedef void  (* TRANSDFLUSH) __((void *));

typedef struct _transdevice TRANSDEVICE;
	struct _transdevice
	{
		CONST char *name;
		TRANSDOPEN  open;
		TRANSDPUT   put;
		TRANSDFLUSH flush;
		TRANSDCLOSE close;
	};
	
IMPORT TRANSDEVICE messageFileDev, messageStdioDev;
IMPORT TRANSDEVICE messageNullDev;
#define MSGFILE  &messageFileDev
#define MSGSTDIO &messageStdioDev
#define MSGNULL  &messageNullDev

#ifdef OS2
#ifdef GCC
IMPORT TRANSDEVICE messageVioDev;
#define MSGVIO   &messageVioDev
#endif
#endif


typedef int MESSAGECODE;
/* ** Already defined in DNPAP.H **
#define DMC_FATAL    0
#define DMC_ERROR    1
#define DMC_WARNING  2
#define DMC_MESSAGE  3
#define DMC_DEBUG    4
#define DMC_TRACE    5
#define DMC_LOG      6
#define DMC_MAX		16
*/

/* message.c */
void MessageInit     __((CONST char *appName VAR_PROTO));
void MessageConfig   __((LONG base, CONST char *moduleName));
void MessageEnable   __((LONG base, MESSAGECODE dmc, BOOLEAN flag));
void MessageSetTrans __((LONG base, MESSAGECODE dmc, TRANSCRIPT *transid));

/* trans.c */
TRANSCRIPT *TransOpen  __((CONST char *mediaList));
void TransMessage 	   __((TRANSCRIPT *, CONST char * VAR_PROTO));
void TransFlush 	   __((TRANSCRIPT *));
void TransClose        __((TRANSCRIPT *));
void TransCreateMedium __((CONST char *name, CONST char *devArgs));
void TransAddDevice    __((TRANSDEVICE *));
#endif


