/**********************************************************************
** MODULE INFORMATION*
**********************
**      FILE     NAME:       dnpap.c
**      SYSTEM   NAME:       dnpap
**      ORIGINAL AUTHOR(S):  Alfred Kayser
**      VERSION  NUMBER:     1.0
**      CREATION DATE:       91/09/16
**
** DESCRIPTION: The Dnpap functions.
**              Don't modify these!!. If you really want to
**              modify these, create a new function and install it 
**				with a DnpapSet!!
***********************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:   $Revision: $  
** AUTHOR:     $Author: $ 
** DATE:       $Date: $
** LOG:        $Log: $
**********************************************************************/
#define LIBRARY

#include <signal.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <stdarg.h>

#include "dnpap.h"
#include <memory.h>
	
/* Prototypes for privat functions */
PRIVAT VOID  *_Malloc(ULONG size);
PRIVAT VOID  *_Realloc(VOID *memblock, ULONG size);
PRIVAT VOID   _Free(VOID *memblock);
PRIVAT VOID   _AtExit(VOID(*func)(VOID));
PRIVAT VOID   _Exit(INT status);
PRIVAT VOID   _Message(INT code, LONG ec, CONST CHAR *format, VOID * vp);
PRIVAT VOID (*_Signal(INT signum, VOID (*func)(INT)))(INT);

PRIVAT DNPAPMALLOCFUN  dnpapMalloc  = _Malloc;
PRIVAT DNPAPREALLOCFUN dnpapRealloc = _Realloc;
PRIVAT DNPAPFREEFUN    dnpapFree    = _Free;
PRIVAT DNPAPEXITFUN    dnpapExit    = _Exit;
PRIVAT DNPAPATEXITFUN  dnpapAtExit  = _AtExit;
PRIVAT DNPAPMESSAGEFUN dnpapMessage = _Message;
PRIVAT DNPAPSIGNALFUN  dnpapSignal  = _Signal;
				 
/**************************************************************
** NAME:        DnpapMessage
** SYNOPSIS:    VOID DnpapMessage (INT code, LONG ec,
**                      CONST CHAR *format VAR_PROTO)
** DESCRIPTION: Displays an message on stdout.
** RETURNS:     VOID
**************************************************************/
EXPORT VOID 
DnpapMessage (INT code, LONG ec, CONST CHAR *format VAR_PROTO)
{
    va_list vp;
	
    va_start(vp, format);
	dnpapMessage(code,ec,format,vp);
    va_end(vp);
}									

/**************************************************************
** NAME:        DnpapMalloc
** SYNOPSIS:    VOID * DnpapMalloc(ULONG size)
** DESCRIPTION: Allocates a piece of memory (=malloc).
** RETURNS:     Pointer to fresh memory.
**************************************************************/
EXPORT VOID *
DnpapMalloc(ULONG size)
{			   
    return dnpapMalloc(size);
}			    
			    
/**************************************************************
** NAME:        DnpapRealloc 
** SYNOPSIS:    VOID * DnpapRealloc (VOID *memblock, ULONG size)
** DESCRIPTION: Resizes a piece of memory (=realloc).
** RETURNS:     Pointer to resized memory.
**************************************************************/
EXPORT VOID *
DnpapRealloc (VOID *memblock, ULONG size)
{			    
    return dnpapRealloc(memblock, (size_t)size);
}

/**************************************************************
** NAME:        DnpapFree 
** SYNOPSIS:    VOID DnpapFree (VOID *memblock)                
** DESCRIPTION: Releases a piece of memory (=free).
** RETURNS:     VOID
**************************************************************/
EXPORT VOID  
DnpapFree (VOID *memblock)                
{
    dnpapFree(memblock);
}

/**************************************************************
** NAME:        DnpapAtExit 
** SYNOPSIS:    VOID DnpapAtExit ( VOID(*func)(VOID) )
** DESCRIPTION: Installs an exit function (=atexit).
** RETURNS:     VOID
**************************************************************/
EXPORT VOID  
DnpapAtExit ( VOID(*func)(VOID) )
{
    dnpapAtExit(func);
}

/**************************************************************
** NAME:        DnpapExit 
** SYNOPSIS:    VOID DnpapExit (INT status)
** DESCRIPTION: Must be called to quit the program (=exit).
** RETURNS:     VOID
**************************************************************/
EXPORT VOID 
DnpapExit (INT status)
{
    dnpapExit(status);
}

/**************************************************************
** NAME:        DnpapSignal
** SYNOPSIS:    VOID (*DnpapSignal
**                         (INT signum, VOID (*func)(VOID)))(INT)
** DESCRIPTION: Must be called to set a signal handler.
** RETURNS:     VOID (*func)(INT) or SIG_ERR on error
**************************************************************/
EXPORT VOID 
(*DnpapSignal (INT signum, VOID (*func)(INT)))(INT)
{
    return dnpapSignal(signum, func);
}


/**************************************************************
** NAME:        DnpapSetMallocFun 
** SYNOPSIS:    DNPAPMALLOCFUN  DnpapSetMallocFun
**                                      (DNPAPMALLOCFUN dmf) 
** DESCRIPTION: Installs a new DnpapSetMalloc function.
** RETURNS:     VOID
** SEE ALSO:    DnpapSetMalloc
**************************************************************/
EXPORT DNPAPMALLOCFUN  
DnpapSetMallocFun (DNPAPMALLOCFUN dmf) 
{			
	DNPAPMALLOCFUN ret;
	ret=dnpapMalloc;
	if (dmf) dnpapMalloc=dmf;
	return ret;
}							 

/**************************************************************
** NAME:        DnpapSetReallocFun 
** SYNOPSIS:    DNPAPREALLOCFUN DnpapSetReallocFun
**                                  (DNPAPREALLOCFUN drf)
** DESCRIPTION: Installs a new DnpapSetRealloc function.
** RETURNS:     Previous used function.
** SEE ALSO:    DnpapSetRealloc
**************************************************************/
EXPORT DNPAPREALLOCFUN 
DnpapSetReallocFun (DNPAPREALLOCFUN drf)
{					  
	DNPAPREALLOCFUN ret;
	ret=dnpapRealloc;
	if (drf) dnpapRealloc=drf;
	return ret;
}

/**************************************************************
** NAME:        DnpapSetFreeFun 
** SYNOPSIS:    DNPAPFREEFUN    DnpapSetFreeFun
**                                  (DNPAPFREEFUN dff)
** DESCRIPTION: Installs a new DnpapSetFree function.
** RETURNS:     Previous used function.
** SEE ALSO:    DnpapSetFree
**************************************************************/
EXPORT DNPAPFREEFUN    
DnpapSetFreeFun (DNPAPFREEFUN dff)
{					  
	DNPAPFREEFUN ret;
	ret=dnpapFree;
	if (dff) dnpapFree=dff;
	return ret;
}

/**************************************************************
** NAME:        DnpapSetExitFun 
** SYNOPSIS:    DNPAPEXITFUN    DnpapSetExitFun
**                                  (DNPAPEXITFUN def)
** DESCRIPTION: Installs a new DnpapSetExit function.
** RETURNS:     Previous used function.
** SEE ALSO:    DnpapSetExit
**************************************************************/
EXPORT DNPAPEXITFUN    
DnpapSetExitFun (DNPAPEXITFUN def)
{					  
	DNPAPEXITFUN ret;
	ret=dnpapExit;
	if (def) dnpapExit=def;
	return ret;
}

/**************************************************************
** NAME:        DnpapSetAtExitFun 
** SYNOPSIS:    DNPAPATEXITFUN  DnpapSetAtExitFun
**                                  (DNPAPATEXITFUN  daef)
** DESCRIPTION: Installs a new DnpapSetAtExit function. 
** RETURNS:     Previous used function.
** SEE ALSO:    DnpapSetAtExit
**************************************************************/
EXPORT DNPAPATEXITFUN  
DnpapSetAtExitFun (DNPAPATEXITFUN  daef)
{					  
	DNPAPATEXITFUN ret;
	ret=dnpapAtExit;
	if (daef) dnpapAtExit=daef;
	return ret;
}

/**************************************************************
** NAME:        DnpapSetMessageFun 
** SYNOPSIS:    DNPAPMESSAGEFUN DnpapSetMessageFun
**                                  (DNPAPMESSAGEFUN dmf)
** DESCRIPTION: Installs a new DnpapSetMessage function.
** RETURNS:     Previous used function.
** SEE ALSO:    DnpapSetMessage
**************************************************************/
EXPORT DNPAPMESSAGEFUN 
DnpapSetMessageFun (DNPAPMESSAGEFUN dmf)
{					  
	DNPAPMESSAGEFUN ret;
	ret=dnpapMessage;
	if (dmf) dnpapMessage=dmf;
	return ret;
}

/**************************************************************
** NAME:        DnpapSetSignalFun 
** SYNOPSIS:    DNPAPSIGNALFUN DnpapSetSignalFun
**                                 (DNPAPSIGNALFUN dsf)
** DESCRIPTION: Installs a new DnpapSetSignal function.
** RETURNS:     Previous used function.
** SEE ALSO:    DnpapSetSignal
**************************************************************/
EXPORT DNPAPSIGNALFUN 
DnpapSetSignalFun (DNPAPSIGNALFUN dsf)
{					  
	DNPAPSIGNALFUN ret;
	ret=dnpapSignal;
	if (dsf) dnpapSignal=dsf;
	return ret;
}



/* Private parts, don't modify them ever. If you really want to
   modify these, create a new function and install it with a DnpapSet!! */

PRIVAT VOID *_Malloc(ULONG size)
{			   
    return malloc((size_t)size);
}			    
			    
PRIVAT VOID *_Realloc(VOID *memblock, ULONG size)
{			    
    return realloc(memblock, (size_t)size);
}

PRIVAT VOID _Free(VOID *memblock)                
{
    return free(memblock);
}

PRIVAT VOID _AtExit(VOID(*func)(VOID))
{
#ifdef UNIX
	on_exit(func);
#else
    atexit(func);
#endif 
}

PRIVAT VOID _Exit(INT status)
{
    exit(status);
}

PRIVAT VOID (*_Signal(INT signum, VOID (*func)(INT)))(INT)
{
    return signal(signum, func);
}

PRIVAT VOID _Message(INT code, LONG ec, CONST CHAR *format, VOID * vp)
{
    CHAR title='?';
    if (code>=0 && code<7) title="FEWMDTL"[code];
    fprintf(stderr,"%c%06ld: ",title,ec);
    vfprintf(stderr, format, (va_list)vp);
}
